@extends('layouts.admin')
@section('content')

</style>
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{ route('admin.user.index') }}">user management</a>
            <a class="active">Add User</a>
        </div>
    </div>


    <div class="add-user-form">
        <h3>Add User</h3>
        <form class="row g-3" method="POST" action="{{ route('admin.add.user') }}" id="userForm">
            @csrf
        
            <div class="col-md-1">
                <div class="comn-input-select">
                    <label for="inputtitle" class="form-label">Title</label>
                    <select id="inputtitle" class="form-select" name="title">
                        <option value="Mr." {{ old('title') == 'Mr.' ? 'selected' : '' }}>{{ __('messages.title_mr') }}</option>
                        <option value="Mrs." {{ old('title') == 'Mrs.' ? 'selected' : '' }}> {{ __('messages.title_mrs') }}</option>
                    </select>
                    @error('title') <div class="error-message text-danger">{{ $message }}</div> @enderror
                    <div class="error-message" id="title-error"></div>
                </div>
            </div>
        
            <div class="col-md-5">
                <div class="comn-input-select">
                    <label for="first-name" class="form-label">First Name</label>
                    <input type="text" class="form-control" id="first-name"  placeholder="Enter first name" name="first_name" value="{{ old('first_name') }}">
                    @error('first_name') <div class="error-message text-danger">{{ $message }}</div> @enderror
                    <div class="error-message" id="first_name-error"></div>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="last-name" class="form-label">Last Name</label>
                    <input type="text" class="form-control" id="last-name" placeholder="Enter last name"  name="last_name" value="{{ old('last_name') }}">
                    @error('last_name') <div class="error-message text-danger">{{ $message }}</div> @enderror
                    <div class="error-message" id="last_name-error"></div>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputAddress" class="form-label">Street, House Number</label>
                    <input type="text" class="form-control" id="inputAddress" name="street" value="{{ old('street') }}" placeholder="Enter Your Address">
                    @error('street') <div class="error-message text-danger">{{ $message }}</div> @enderror
                    <div class="error-message" id="street-error"></div>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputZip" class="form-label">Zip Code</label>
                    <input type="text" class="form-control" id="inputZip" name="zip_code" value="{{ old('zip_code') }}" placeholder="Enter Zip Code">
                    @error('zip_code') <div class="error-message text-danger">{{ $message }}</div> @enderror
                    <div class="error-message" id="zip_code-error"></div>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputCity" class="form-label">City</label>
                    <input type="text" class="form-control" id="inputCity" name="city" value="{{ old('city') }}" placeholder="Enter City">
                    @error('city') <div class="error-message text-danger">{{ $message }}</div> @enderror
                    <div class="error-message" id="city-error"></div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="inner-main-input inner-main-input2">
                    <label for="inputState" class="form-label">Region/State</label>
                    <select class="form-select" name="region">
                        <option value="">{{ __('messages.select_region') }}</option>

                        @foreach(__('messages.region') as $key => $value)
                            <option value="{{ $key }}" {{ old('region') == $key ? 'selected' : '' }}>
                                {{ $value }}
                            </option>
                        @endforeach
                    </select>
                    @error('region') <div class="error-message text-danger">{{ $message }}</div> @enderror
                    <span class="error-message" id="region-error"></span>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="inputState" class="form-label">Country</label>
                    <select id="inputState" class="form-select" name="country">
                        <option value="" hidden>{{ __('messages.choose_country') }}</option>

                        @foreach(__('messages.countries') as $key => $label)
                            <option value="{{ $label }}" {{ old('country') === $label ? 'selected' : '' }}>
                                {{ $label }}
                            </option>
                        @endforeach
                    </select>
                    @error('country') <div class="error-message text-danger">{{ $message }}</div> @enderror
                    <div class="error-message" id="country-error"></div>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="email-address" class="form-label">Email Address</label>
                    <input type="email" class="form-control" id="email-address" name="email" value="{{ old('email') }}" placeholder="Enter Email Address">
                    @error('email') <div class="error-message text-danger">{{ $message }}</div> @enderror
                    <div class="error-message" id="email-error"></div>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="phone" class="form-label">Phone Number</label>
                    <div class="numer-input d-flex">
                        
                        <select id="country_code" class="form-select country_code_custom" name="country_code">
                            <option value="+49" data-image="https://flagcdn.com/16x12/de.png" {{ old('country_code') == '+49' ? 'selected' : '' }}>+49</option>
                            <option value="+41" data-image="https://flagcdn.com/16x12/ch.png" {{ old('country_code') == '+41' ? 'selected' : '' }}>+41</option>
                            <option value="+43" data-image="https://flagcdn.com/16x12/at.png" {{ old('country_code') == '+43' ? 'selected' : '' }}>+43</option>
                        </select>
                        <input type="text" class="form-control" id="phone" name="phone_number" placeholder="Enter phone number" value="{{ old('phone_number') }}">
                    </div>
                    @error('phone_number') <div class="error-message text-danger">{{ $message }}</div> @enderror
                    <div class="error-message" id="phone_number-error"></div>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="password" class="form-label">Password</label>
                    <div class="main-show-eye">
                    <input type="password" class="form-control" id="password" name="password" placeholder="Enter Password">
                    <span class="toggle-password" toggle="#password">
                        <i class="fas fa-eye"></i>
                    </span>
                </div>
                    <div id="password-strength-message" class="text-muted small error mt-1"></div>
                    @error('password') <div class="error-message text-danger">{{ $message }}</div> @enderror
                    <div class="error-message" id="password-error"></div>
                </div>
            </div>
        
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="password_confirmation" class="form-label">Confirm Password</label>
                    <div class="main-show-eye">
                    <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="Enter confirm password">
                    <div class="error-message" id="password_confirmation-error"></div>
                    <span class="toggle-password" toggle="#password_confirmation">
                        <i class="fas fa-eye"></i>
                    </span>
                    </div>
                </div>
            </div>
        
            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user">Add User</button>
                    <button class="cancel-btn"><a href="{{route('admin.user.index')}}">Cancel</a></button>

                </div>
            </div>
        </form>
        


    </div>
</div>



<script>
    document.addEventListener('DOMContentLoaded', function (e) {
    const form = document.getElementById('userForm');
    const inputs = form.querySelectorAll('input, select');

    // Real-time Validation on Input
    inputs.forEach(input => {
        input.addEventListener('input', function () {
            validateField(input);
        });
    });

    // Validate Fields
    function validateField(input) {
        const value = input.value.trim();
        const name = input.name;
        let errorMessage = '';

        // Empty field
        if (value === '') {
            switch (name) {
                case 'first_name':
                    errorMessage = 'Please enter first name.';
                    break;
                case 'last_name':
                    errorMessage = 'Please enter last name.';
                    break;
                case 'street':
                    errorMessage = 'Please enter your street and house number.';
                    break;
                case 'zip_code':
                    errorMessage = 'Please enter your zip code.';
                    break;
                case 'city':
                    errorMessage = 'Please enter your city.';
                    break;
                case 'region':
                    errorMessage = 'Please select a region.';
                    break;
                case 'country':
                    errorMessage = 'Please select a country.';
                    break;
                case 'email':
                    errorMessage = 'Please enter your email address.';
                    break;
                case 'phone_number':
                    errorMessage = 'Please enter phone number.';
                    break;
                case 'password':
                    errorMessage = 'Please enter password.';
                    break;
                 case 'password_confirmation':
                    errorMessage = 'Please enter confirm password.'
            }
        }

        // Field-specific rules
        if (name === 'first_name' || name === 'last_name') {
            if (value && value.length > 50) {
                errorMessage = 'Maximum length is 50 characters.';
            }
        }

        if (name === 'zip_code') {
            if (value && value.length > 20) {
                errorMessage = 'Zip code must not exceed 20 characters.';
            }
        }

        if (name === 'phone_number') {
            if (value && !/^[0-9+]*$/.test(value)) {
                errorMessage = 'Only digits and plus symbol are allowed.';
            } else if (value.length > 15 || value.length < 8) {
                errorMessage = 'Phone number should be between 8 to 15 digits.';
            }else if(value.length == 0){
                errorMessage = 'Please enter phone number.';
            }
        }

        if (name === 'email') {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (value && !emailRegex.test(value)) {
                errorMessage = 'Please enter a valid email address.';
            }
        }

        // Set error message
        const errorElement = document.getElementById(`${name}-error`);
        errorElement.textContent = errorMessage;
        input.classList.toggle('is-invalid', !!errorMessage);
    }


    // Validate on Submit
    form.addEventListener('submit', function (e) {
        let valid = true;
        // Prevent form submission initially, but only if fields are invalid
        e.preventDefault();

        inputs.forEach(input => {
            if (!input.value.trim()) {
                valid = false;
                validateField(input); // Validate field on submit if empty
            }
        });

        // Prevent form submission if any field is invalid
        if (valid) {
            form.submit(); // Allow the form to be submitted if all fields are valid
        }
    });
});

    </script>
<script>
   document.addEventListener("DOMContentLoaded", function () {
    // Toggle password visibility
    document.querySelectorAll(".toggle-password").forEach(function (toggle) {
        toggle.addEventListener("click", function () {
            const input = document.querySelector(this.getAttribute("toggle"));
            const icon = this.querySelector("i");
            if (input.type === "password") {
                input.type = "text";
                icon.classList.remove("fa-eye");
                icon.classList.add("fa-eye-slash");
            } else {
                input.type = "password";
                icon.classList.remove("fa-eye-slash");
                icon.classList.add("fa-eye");
            }
        });
    });

    const passwordInput = document.getElementById("password");
    const confirmInput = document.getElementById("password_confirmation");
    const errorDiv = document.getElementById("password-error");
    const confirmErrorDiv = document.getElementById("password_confirmation-error");
    const suggestionDiv = document.getElementById("password-strength-message");

    passwordInput.addEventListener("input", function () {
        const password = passwordInput.value;

        // Max length check
        if (password.length > 10) {
            errorDiv.textContent = "Password cannot be more than 10 characters.";
        } else {
            errorDiv.textContent = "";
        }

        // Strength logic
        const strongPattern = /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[\W_]).{6,10}$/;
        const mediumPattern = /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d).{6,10}$/;

        if (strongPattern.test(password)) {
            suggestionDiv.textContent = "Strong password ✅";
            suggestionDiv.style.color = "green";
        } else if (mediumPattern.test(password)) {
            suggestionDiv.innerHTML = "Decent password. Add a symbol like <code>!</code> or <code>@</code> for a stronger password.";
            suggestionDiv.style.color = "orange";
        } else if (password.length >= 6) {
            suggestionDiv.innerHTML = `Weak password. Try something like <code>Ex@mple1!</code>`;
            suggestionDiv.style.color = "red";
        } else {
            suggestionDiv.textContent = "";
        }
        validateConfirmPassword();


    });

    confirmInput.addEventListener("input", validateConfirmPassword);

    function validateConfirmPassword() {
            const password = passwordInput.value;
            const confirm = confirmInput.value;

            if (confirm.length === 0) {
                confirmErrorDiv.textContent = "Please enter confirm password.";
                confirmInput.classList.add("is-invalid");
            } else if (password !== confirm) {
                confirmErrorDiv.textContent = "New password and confirm new password does not match.";
                confirmInput.classList.add("is-invalid");
            } else {
                confirmErrorDiv.textContent = "";
                confirmInput.classList.remove("is-invalid");
            }
        }
});
</script>
<script>
    function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function () {
        $('#country_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });
    });
</script>

    <style>
    .error-message {
        color: red;
        font-size: 1.2rem;
        margin-top: 5px;
    }
    
    .is-invalid {
        border-color: red;
    }
    </style>
@endsection