<!DOCTYPE html>
<html>
<head>
    <title>Users Report</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; /* Reduce font size for fitting */
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; /* Reduce padding */
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; /* Set the page size to landscape */
            margin: 10mm; /* Adjust margin if needed */
        }
    </style>
</head>
<body>
    <h1>Users Report</h1>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Address</th>
                <th>Confirmed + Completed Bookings</th>
                <th>Cancelled Bookings</th>
                <th>Marketing Agreement </th>
                <th>Status</th>
                <th>Created At</th>
            </tr>
        </thead>
        <tbody>
            @foreach($users as $user)
            <tr>
                <td>#{{ $user->id }}</td>
                <td>{{ $user->first_name }} {{ $user->last_name }}</td>
                <td>{{ $user->email }}</td>
                <td>{{ $user->country_code }} {{ $user->number }}</td>
                <td>{{ $user->street }}, {{ $user->zip_code }} ,{{ $user->city }}, {{ $user->region }}, {{$user->country}} </td>
                <td>{{ $user->bookings()->whereIn('status', ['confirmed', 'completed'])->count() }}</td>
                <td>{{ $user->bookings()->where('status', 'cancelled')->count() }}</td>
                <td>{{$user->marketing_aggrement == 1 ? 'Yes' : 'No'}}</td>
                <td>{{$user->status ? 'Active' : 'Blocked'}}</td>
                <td>{{ $user->created_at->format('d.m.Y') }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>