@extends('layouts.admin')
@section('content')
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{ route('admin.voucher.index') }}">Voucher management</a>
            <a class="active" href="">Create Voucher</a>
        </div>
    </div>

    <div class="add-user-form">
        <h3>Create Voucher</h3>
        
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form id="voucherForm" class="row" method="POST" action="{{route('admin.store.voucher')}}">
            @csrf

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="name" class="form-label">Voucher Name *</label>
                    <input type="text" placeholder="Enter Voucher Name" class="form-control"
                        id="name" name="name" value="{{ old('name') }}">
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="code" class="form-label">Voucher Code *</label>
                    <input type="text" placeholder="Voucher Code" class="form-control" 
                        id="code" name="code" value="{{ old('code') }}">
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <medium class="text-muted ">A voucher always applies either to the location of the admin or to one or more location of vendors</medium>
            <medium class="text-muted mb-4">Ensure that the voucher name includes the name of the city/cities it is applied to so users can clearly see in their account which voucher is valid for which location</medium>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="min_order_value" class="form-label">Min. Order Value *</label>
                    <input type="number" step="0.01" class="form-control" 
                        id="min_order_value" name="min_order_value" 
                        placeholder="Enter Minimum Order Value" value="{{ old('min_order_value') }}">
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="max_discount" class="form-label">Max. Discount *</label>
                    <input type="number" step="0.01" class="form-control" 
                        id="max_discount" name="max_discount" 
                        placeholder="Enter Maximum Discount" value="{{ old('max_discount') }}">
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="start_date" class="form-label">Start Date *</label>
                    <input type="text" class="form-control datepicker" 
                        id="start_date" name="start_date" value="{{ old('start_date') }}"
                        autocomplete="off" readonly>
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="expiration_date" class="form-label">Expiration Date *</label>
                    <input type="text" class="form-control datepicker" 
                        id="expiration_date" name="expiration_date" value="{{ old('expiration_date') }}"
                        autocomplete="off" readonly>
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select main-all-select-2">
                    <label for="applied_to" class="form-label">Applied to Product Group</label>
                    <select id="applied_to" name="applied_to[]" class="form-select" multiple>
                        @foreach ($products as $product)
                            <option value="{{ $product->id }}"
                                {{ collect(old('applied_to'))->contains($product->id) ? 'selected' : '' }}>
                                {{ $product->name }}
                            </option>
                        @endforeach
                    </select>
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select main-all-select-2">
                    <label for="applied_to_spo" class="form-label">Applied to SPO</label>
                    <select id="applied_to_spo" name="applied_to_spo[]" class="form-select fav_clr" multiple>
                        <option value="all">All</option>
                        <option value="remove_all">Remove All</option>
                        @foreach ($spos as $spo)
                            <option value="{{ $spo->id }}"
                                {{ collect(old('applied_to_spo'))->contains($spo->id) ? 'selected' : '' }}>
                                {{ $spo->first_name . ' ' . $spo->last_name . ' (#' . $spo->id . ')' }}
                            </option>
                        @endforeach
                    </select>
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="type" class="form-label">Select Type *</label>
                    <select id="type" class="form-select" name="type">
                        <option value="1" {{ old('type') == '1' ? 'selected' : '' }}>Fixed</option>
                        <option value="2" {{ old('type') == '2' ? 'selected' : '' }}>Percentage</option>
                    </select>
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="customer_type" class="form-label">Select Customer Type *</label>
                    <select id="customer_type" class="form-select" name="customer_type">
                        <option value="" disabled selected>Select customer type</option>
                        <option value="all" {{ old('customer_type') == 'all' ? 'selected' : '' }}>All</option>
                        <option value="new" {{ old('customer_type') == 'new' ? 'selected' : '' }}>New Customers</option>
                        <option value="existing" {{ old('customer_type') == 'existing' ? 'selected' : '' }}>Existing Customers</option>
                    </select>
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="voucher_value" class="form-label">Voucher Value*</label>
                    <input type="number" step="1.00" min="1" class="form-control" 
                        id="voucher_value" name="voucher_value" 
                        placeholder="Enter Voucher Value" value="{{ old('voucher_value') }}">
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="combine_with_other_vouchers" class="form-label">Combination with other Voucher *</label>
                    <select id="combine_with_other_vouchers" class="form-select" name="combine_with_other_vouchers">
                        <option value="0" >No</option>
                        <option value="1" >YES</option>
                    </select>
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="redemption_limit" class="form-label">Set Limit for voucher Redemption</label>
                    <input 
                    type="number" 
                    class="form-control" 
                    id="redemption_limit" 
                    name="redemption_limit" 
                    placeholder="Set Limit (leave empty for no limit)" 
                    min="1" 
                    max="50" 
                    oninput="if(this.value.length > 2) this.value = this.value.slice(0,2);" 
                    value="{{ old('redemption_limit') }}">
                
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user">Create Voucher</button>
                    <a href="{{ route('admin.voucher.index') }}" class="cancel-btn">Cancel</a>
                </div>
            </div>
        </form>
    </div>
</div>
@push('script')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    // Initialize Select2
    $('#applied_to').select2({
        placeholder: "Select products",
        allowClear: true,
        width: '100%'
    });

    $('#applied_to_spo').select2({
        placeholder: "Select SPO",
        allowClear: true,
        width: '100%'
    });
    $('.fav_clr').on("select2:select", function (e) { 
         const $select = $(this);
           var data = e.params.data.text;
           console.log(data)
           if(data=='All'){
            $(".fav_clr > option").prop("selected","selected");
            $select.find('option[value="all"],option[value="remove_all"]').prop("selected", false);
            $(".fav_clr").trigger("change");
           }
           if (data == 'Remove All') {
                $select.find('option').prop("selected", false);
                $select.trigger("change");
            }
      });

    // Datepicker initialization with proper date format handling
    $('.datepicker').datepicker({
        autoclose: true,
        todayHighlight: true,
        dateFormat: 'dd.mm.yy',  // This is the format jQuery UI uses internally
        minDate: 0,
        weekStart: 1,
        beforeShowDay: function(date) {
            const day = date.getDay();
            return [(day !== 0 && day !== 6), ''];
        },
        onSelect: function(dateText, inst) {
            // Convert to proper format when selected
            const date = $(this).datepicker('getDate');
            const formattedDate = $.datepicker.formatDate('dd.mm.yy', date);
            $(this).val(formattedDate).trigger('change');
            $(this).valid();
        }
    });

    // Set expiration date min date based on start date
    $('#start_date').on('change', function() {
        if ($(this).val()) {
            const dateParts = $(this).val().split('.');
            const minDate = new Date(dateParts[2], dateParts[1]-1, dateParts[0]);
            $('#expiration_date').datepicker('option', 'minDate', minDate);
        }
    });

    // CSRF setup
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // Custom date validation method for German format (dd.mm.yyyy)
    $.validator.addMethod("germanDate", function(value, element) {
        // Check the format first
        if (!/^\d{2}\.\d{2}\.\d{4}$/.test(value)) {
            return false;
        }
        
        // Check if it's a valid date
        const parts = value.split('.');
        const day = parseInt(parts[0], 10);
        const month = parseInt(parts[1], 10);
        const year = parseInt(parts[2], 10);
        
        // Check the ranges
        if (year < 1000 || year > 3000 || month == 0 || month > 12) {
            return false;
        }
        
        const monthLength = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        
        // Adjust for leap years
        if (year % 400 == 0 || (year % 100 != 0 && year % 4 == 0)) {
            monthLength[1] = 29;
        }
        
        return day > 0 && day <= monthLength[month - 1];
    }, "Please enter a valid date in format dd.mm.yyyy");

    // Custom method to check if expiration date is after start date
    $.validator.addMethod("greaterThanStart", function(value, element) {
        if (!value || !$('#start_date').val()) return true;
        
        // Parse dates in dd.mm.yyyy format
        const startParts = $('#start_date').val().split('.');
        const endParts = value.split('.');
        
        const startDate = new Date(startParts[2], startParts[1]-1, startParts[0]);
        const endDate = new Date(endParts[2], endParts[1]-1, endParts[0]);
        
        return endDate > startDate;
    }, "Expiration date must be after start date");

    // Custom validation method for voucher code format
    $.validator.addMethod("pattern", function(value, element, param) {
        return this.optional(element) || param.test(value);
    }, "Invalid format");

    // Validation rules
    const validationRules = {
        name: {
            required: true,
            minlength: 3,
            maxlength: 255
        },
        code: {
            required: true,
            minlength: 5,
            maxlength: 50,
            pattern: /^[A-Za-z0-9\-_]+$/
        },
        min_order_value: {
            required: true,
            min: 0
        },
        max_discount: {
            required: true,
            min: 0
        },
        voucher_value: {
            required: true,
            min: 1
        },
        start_date: {
            required: true,
            germanDate: true
        },
        expiration_date: {
            required: true,
            germanDate: true,
            greaterThanStart: true
        },
        customer_type: {
            required: true
        },
        combine_with_other_vouchers: {
            required: true
        },
        redemption_limit: {
            min: 1
        }
    };

    // Initialize validation
    $('#voucherForm').validate({
        rules: validationRules,
        messages: {
            name: {
                required: "Please enter voucher name",
                minlength: "Voucher name must be at least 3 characters",
                maxlength: "Voucher name cannot exceed 255 characters"
            },
            code: {
                required: "Please enter Voucher code",
                minlength: "Voucher code must be at least 5 characters",
                maxlength: "Voucher code cannot exceed 50 characters",
                pattern: "Voucher code can only contain letters, numbers, hyphens, and underscores"
            },
            min_order_value: {
                required: "Please enter Minimum order value",
                min: "Minimum order value must be a positive number"
            },
            max_discount: {
                required: "Please enter Maximum discount",
                min: "Maximum discount must be a positive number"
            },
            start_date: {
                required: "Please select a start date",
                germanDate: "Please enter a valid date in format dd.mm.yyyy"
            },
            expiration_date: {
                required: "Please select an expiration date",
                germanDate: "Please enter a valid date in format dd.mm.yyyy",
                greaterThanStart: "Expiration date must be after start date"
            },
            customer_type: {
                required: "Please select customer type"
            },
            combine_with_other_vouchers: {
                required: "Please specify if this voucher can be combined with others"
            },
            redemption_limit: {
                min: "Redemption limit must be at least 1 if specified"
            }
        },
        errorElement: "div",
        errorClass: "error-message",
        errorPlacement: function(error, element) {
            error.insertAfter(element);
        },
        highlight: function(element, errorClass) {
            $(element).addClass('is-invalid').removeClass('is-valid');
        },
        unhighlight: function(element, errorClass) {
            $(element).removeClass('is-invalid').addClass('is-valid');
        },
        submitHandler: function(form) {
            // Check if voucher code is unique before submission
            checkVoucherCodeUniqueness().then(function(isUnique) {
                if (isUnique) {
                    form.submit();
                } else {
                    $('#code').addClass('is-invalid');
                    $('#code').next('.error-message').text('This voucher code already exists');
                }
            });
            return false;
        }
    });

    // Real-time validation on blur
    $('input, select').blur(function() {
        $(this).valid();
    });

    // Check voucher code uniqueness via AJAX
    $('#code').on('blur', function() {
        if ($('#code').valid()) {
            checkVoucherCodeUniqueness().then(function(isUnique) {
                $('#code').addClass('is-valid');
                $('#code').next('.error-message').text('');
                if (!isUnique) {
                    $('#code').addClass('is-invalid');
                    $('#code').next('.error-message').text('This voucher code already exists');
                }
            });
        }
    });

    function checkVoucherCodeUniqueness() {
        return new Promise(function(resolve) {
            if ($('#code').val().length >= 5) {
                $.ajax({
                    url: '{{route("admin.vouchers.check.code")}}',
                    method: 'POST',
                    data: {
                        code: $('#code').val()
                    },
                    success: function(response) {
                        resolve(!response.exists);
                    },
                    error: function() {
                        resolve(true); 
                    }
                });
            } else {
                resolve(true); // Assume unique if code is too short
            }
        });
    }
});
</script>
@endpush
<style>
    .datepicker {
        z-index: 9999 !important;
    }
    /* Your existing validation styles */
    .is-invalid {
        border-color: #dc3545 !important;
    }
    /* .is-valid {
        border-color: #28a745 !important;
    } */
    .error-message {
        color: #dc3545;
        font-size: 1.4em;
        margin-top: 0.25rem;
    }
    </style>
@endsection

