@extends('layouts.admin')
@section('content')
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{ route('admin.voucher.index') }}">Voucher management</a>
            <a class="active" href="">Edit Voucher</a>
        </div>
    </div>
    <div class="add-user-form">
        <h3>Edit Voucher</h3>
        <form class="row" method="POST" action="{{ route('admin.voucher.update', $voucher->id) }}" id="voucherForm">
            @csrf
            @method('PUT')

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="name" class="form-label">Voucher Name</label>
                    <input type="text" placeholder="Enter Voucher Name" class="form-control"
                        id="name" name="name" value="{{ old('name', $voucher->name) }}">
                    @error('name')<small class="text-danger">{{ $message }}</small>@enderror
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="code" class="form-label">Voucher Code</label>
                    <input type="text" placeholder="Voucher Code" class="form-control" id="code" name="code" value="{{ old('code', $voucher->code) }}">
                    @error('code')<small class="text-danger">{{ $message }}</small>@enderror
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <medium class="text-muted ">A voucher always applies either to the location of the admin or to one or more location of vendors</medium>
            <medium class="text-muted mb-4">Ensure that the voucher name includes the name of the city/cities it is applied to so users can clearly see in their account which voucher is valid for which location</medium>


            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="min_order_value" class="form-label">Min. Order Value</label>
                    <input type="text" class="form-control" id="min_order_value" name="min_order_value" placeholder="Enter Discount" value="{{ old('min_order_value', $voucher->min_order_value) }}">
                    @error('min_order_value')<small class="text-danger">{{ $message }}</small>@enderror
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="max_discount" class="form-label">Max. Discount</label>
                    <input type="text" class="form-control" id="max_discount" name="max_discount" placeholder="Enter Discount" value="{{ old('max_discount', $voucher->max_discount) }}">
                    @error('max_discount')<small class="text-danger">{{ $message }}</small>@enderror
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="start_date" class="form-label">Start Date</label>
                    <input class="form-control datepicker" id="start_date" name="start_date" value="{{ old('start_date', $voucher->start_date ? $voucher->start_date->format('d.m.Y') : '') }}">
                    @error('start_date')<small class="text-danger">{{ $message }}</small>@enderror
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="expiration_date" class="form-label">Expiration Date</label>
                    <input class="form-control datepicker" id="expiration_date" name="expiration_date" value="{{ old('expiration_date', $voucher->expiration_date ? $voucher->expiration_date->format('d.m.Y') : '') }}">
                    @error('expiration_date')<small class="text-danger">{{ $message }}</small>@enderror
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select main-all-select-2">
                    <label for="applied_to" class="form-label">Applied to Product Group</label>
                    <select id="applied_to" name="applied_to[]" class="form-select" multiple>
                   
                        @foreach ($allProducts as $product)
                            
                            <option value="{{ $product->id }}"
                                {{ in_array($product->id, $selectedProductIds) ? 'selected' : '' }}>
                                {{ $product->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('applied_to')<small class="text-danger">{{ $message }}</small>@enderror
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select main-all-select-2">
                    <label for="applied_to_spo" class="form-label">Applied to</label>
                    <select id="applied_to_spo" name="applied_to_spo[]" class="form-select fav_clr" multiple>
                        <option value="all">All</option>
                        <option value="remove_all">Remove All</option>

                        @foreach ($spos as $spo)
                            
                            <option value="{{ $spo->id }}"
                                {{ in_array($spo->id, $selectedSpoIds) ? 'selected' : '' }}>
                                {{ $spo->first_name . ' ' . $spo->last_name . ' (#' . $spo->id . ')' }}
                            </option>
                        @endforeach
                    </select>
                    @error('applied_to_spo')<small class="text-danger">{{ $message }}</small>@enderror
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="type" class="form-label">Select Type *</label>
                    <select id="type" class="form-select" name="type">
                        <option value="1" {{ old('type', $voucher->type) == '1' ? 'selected' : '' }}>Fixed</option>
                        <option value="2" {{ old('type', $voucher->type) == '2' ? 'selected' : '' }}>Percentage</option>
                    </select>
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="customer_type" class="form-label">Select Customer Type</label>
                    <select id="customer_type" name="customer_type" class="form-select">
                        <option value="all" {{ old('customer_type', $voucher->customer_type) == 'all' ? 'selected' : '' }}>All</option>
                        <option value="new" {{ old('customer_type', $voucher->customer_type) == 'new' ? 'selected' : '' }}>New Customers</option>
                        <option value="existing" {{ old('customer_type', $voucher->customer_type) == 'existing' ? 'selected' : '' }}>Existing Customers</option>
                    </select>
                    @error('customer_type')<small class="text-danger">{{ $message }}</small>@enderror
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="voucher_value" class="form-label">Voucher Value*</label>
                    <input type="number" step="0.01" class="form-control" 
                        id="voucher_value" name="voucher_value" 
                        placeholder="Enter Voucher Value" value="{{ old('voucher_value',$voucher->voucher_value) }}">
                    <div class="error-message text-danger"></div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="combination_with_other" class="form-label">Combination with other Voucher</label>
                    <select id="combination_with_other" name="combination_with_other" class="form-select">
                        <option value="NO" {{ old('combination_with_other', $voucher->combination_with_other) == 0 ? 'selected' : '' }}>NO</option>
                        <option value="YES" {{ old('combination_with_other', $voucher->combination_with_other) == 1 ? 'selected' : '' }}>YES</option>
                    </select>
                    @error('combination_with_other')<small class="text-danger">{{ $message }}</small>@enderror
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="redemption_limit" class="form-label">Set Limit for voucher Redemption</label>
                    <input 
                        type="number" 
                        class="form-control" 
                        id="redemption_limit" 
                        name="redemption_limit" 
                        placeholder="Set Limit (leave empty for no limit)" 
                        min="1" 
                        max="50" 
                        oninput="if(this.value.length > 2) this.value = this.value.slice(0,2);" 
                        value="{{ old('redemption_limit', $voucher->redemption_limit) }}">

                    @error('redemption_limit')<small class="text-danger">{{ $message }}</small>@enderror
                    <div class="error-message text-danger"></div>
                </div>
            </div>

            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user">Update Voucher</button>
                    <a href="{{ route('admin.voucher.index') }}" class="cancel-btn">Cancel</a>
                </div>
            </div>
        </form>
    </div>
</div>

@push('script')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('#applied_to').select2({
            placeholder: "Select products",
            allowClear: true,
            width: '100%'
        });
        $('#applied_to_spo').select2({
            placeholder: "Select SPO",
            allowClear: true,
            width: '100%'
        });

        $('.fav_clr').on("select2:select", function (e) { 
         const $select = $(this);
           var data = e.params.data.text;
           console.log(data)
           if(data=='All'){
            $(".fav_clr > option").prop("selected","selected");
            $select.find('option[value="all"],option[value="remove_all"]').prop("selected", false);
            $(".fav_clr").trigger("change");
           }
           if (data == 'Remove All') {
                $select.find('option').prop("selected", false);
                $select.trigger("change");
            }
      });

        $('.datepicker').datepicker({
        
        autoclose: true,
        todayHighlight: true,
        dateFormat: 'dd.mm.yy',
                minDate: 0,
                beforeShowDay: function(date) {
                    const day = date.getDay();
                    return [(day !== 0 && day !== 6), ''];
                },
    });

     // Set expiration date min date based on start date
$('#start_date').on('changeDate', function(e) {
    var startDate = e.date;
    var endDatePicker = $('#expiration_date').datepicker('getDate');
    
    // Set the start date for expiration date picker
    $('#expiration_date').datepicker('setStartDate', startDate);
    
    // Clear expiration date if it's before the new start date
    if (endDatePicker && endDatePicker < startDate) {
        $('#expiration_date').datepicker('clearDates');
    }
});




        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Validation rules
        const validationRules = {
            name: {
                required: true,
                minlength: 3,
                maxlength: 255
            },
            code: {
                required: true,
                minlength: 5,
                maxlength: 50,
                pattern: /^[A-Za-z0-9\-_]+$/
            },
            min_order_value: {
                required: true,
                min: 0
            },
            max_discount: {
                required: true,
                min: 0
            },
            voucher_value: {
            required: true,
            min: 1
        },
            start_date: {
                required: true,
                
            },
            expiration_date: {
                required: true,
               
                greaterThanStart: true
            },
            customer_type: {
                required: true
            },
            combine_with_other_vouchers: {
                required: true
            },
            redemption_limit: {
                required: true,
                min: 1
            }
        };

        $.validator.addMethod("greaterThanStart", function(value, element) {
            if (!value) return true;

            // Helper function to parse dd.mm.yy to Date
            function parseDate(input) {
                const parts = input.split('.');
                if (parts.length !== 3) return null;
                // yy to yyyy — assuming 20xx
                const year = parseInt(parts[2], 10) < 100 ? 2000 + parseInt(parts[2], 10) : parseInt(parts[2], 10);
                return new Date(year, parseInt(parts[1], 10) - 1, parseInt(parts[0], 10));
            }

            const startDate = parseDate($('#start_date').val());
            const endDate = parseDate(value);

            if (!startDate || !endDate) return false;

            return endDate > startDate;
        }, "Expiration date must be after start date");

        // Custom validation method for voucher code format
        $.validator.addMethod("pattern", function(value, element, param) {
            return this.optional(element) || param.test(value);
        }, "Invalid format");

        // Initialize validation
        $('#voucherForm').validate({
            rules: validationRules,
            messages: {
            name: {
                required: "Please enter voucher name",
                minlength: "Voucher name must be at least 3 characters",
                maxlength: "Voucher name cannot exceed 255 characters"
            },
            code: {
                required: "Please enter Voucher code",
                minlength: "Voucher code must be at least 5 characters",
                maxlength: "Voucher code cannot exceed 50 characters",
                pattern: "Voucher code can only contain letters, numbers, hyphens, and underscores"
            },
            min_order_value: {
                required: "Please enter Minimum order value",
                min: "Minimum order value must be a positive number"
            },
            max_discount: {
                required: "Please enter Maximum discount",
                min: "Maximum discount must be a positive number"
            },
            voucher_value: {
                required: "Voucher value is required",
                min: "voucher value must be a positive number"
            },
            start_date: {
                required: "Please enter Start date",
               
            },
            expiration_date: {
                required: "Please enter Expiration date",
                
             
            },
            customer_type: {
                required: "Please enter Customer type"
            },
            combine_with_other_vouchers: {
                required: "Please specify if this voucher can be combined with others"
            },
            redemption_limit: {
                min: "Redemption limit must be at least 1 if specified"
            }
        },
            errorElement: "div",
            errorClass: "error-message",
            errorPlacement: function(error, element) {
                error.insertAfter(element);
            },
            highlight: function(element, errorClass) {
                $(element).addClass('is-invalid').removeClass('is-valid');
            },
            unhighlight: function(element, errorClass) {
                $(element).removeClass('is-invalid').addClass('is-valid');
            },
            submitHandler: function(form) {
                // Check if voucher code is unique (excluding current voucher) before submission
                checkVoucherCodeUniqueness().then(function(isUnique) {
                    
                    
                    
                    if (isUnique) {
                        form.submit();
                    } else {
                        $('#code').removeClass('is-valid');
                        $('#code').addClass('is-invalid');
                        $('#code').next('.error-message').css('display','block');
                        $('#code').next('.error-message').text('This voucher code already exists');
                    }
                });
                return false;
            }
        });

        // Real-time validation on blur
        $('input, select').blur(function() {
            $(this).valid();
        });
        $('.datepicker').on('changeDate', function() {
            $(this).valid();
        });

        // Check voucher code uniqueness via AJAX (excluding current voucher)
        $('#code').on('blur', function() {
            console.log('dsadasddasasd');
            
            if ($('#code').valid()) {
                
                checkVoucherCodeUniqueness().then(function(isUnique) {
                    $('#code').addClass('is-valid');
                    $('#code').next('.error-message').text('');
                    if (!isUnique) {
                        $('#code').addClass('is-invalid');
                        $('#code').next('.error-message').text('This voucher code already exists');
                    }
                });
            }
        });

        // Function to check voucher code uniqueness (excluding current voucher)
        function checkVoucherCodeUniqueness() {
            return new Promise(function(resolve) {
                if ($('#code').val().length >= 5) {
                    $.ajax({
                        url: '{{ route("admin.vouchers.check.code") }}',
                        method: 'POST',
                        data: {
                            code: $('#code').val(),
                            exclude_id: '{{ $voucher->id }}'
                        },
                        success: function(response) {
                            resolve(!response.exists);
                        },
                        error: function() {
                            resolve(true); // Assume unique if error occurs
                        }
                    });
                } else {
                    resolve(true); // Assume unique if code is too short
                }
            });
        }
    });
</script>
@endpush
<style>
    .datepicker {
        z-index: 9999 !important;
    }
    /* Your existing validation styles */
    .is-invalid {
        border-color: #dc3545 !important;
    }
    .error-message {
        color: #dc3545;
        font-size: 1.4em;
        margin-top: 0.25rem;
    }
</style>

@endsection
