@extends('layouts.admin')
@section('content')
<div class="col-9 main-dash-left">
    <div class="analytics">
        <!-- download-btns ------------------ -->
        <div class="sownload-cv-pdf">
            <button class="download-pdf" onclick="downloadPdf()">Download PDF</button>
            <button class="download-pdf" onclick="downloadCsv()">Download CSV</button>
        </div>
        <div class="main-notification-messege">
            <div class="notifi-list d-flex">
                <h6>Voucher Management</h6>
                <div class="dropdowns-inner-list d-flex">
                    <div class="dropdowns-inner-list">
                        <div class="icon-search-main white_bg">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <input aria-describedby="passwordHelpBlock" placeholder="Search For Voucher Code/Name"
                                type="text" id="voucher_search" class="form-control" value="">
                        </div>
                    </div>
                    <div class="filter-main-div">
                        <p class="lable-filt">Filter:</p>
                        <div class="dropdown">
                            <button class="filter-btn dropdown-toggle" type="button" id="statusFilterDropdown" 
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-filter"></i> Filter
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="statusFilterDropdown">
                                <li><a class="dropdown-item filter-status active" href="#" data-status="all">All Vouchers</a></li>
                                <li><a class="dropdown-item filter-status" href="#" data-status="new">Upcoming</a></li>
                                <li><a class="dropdown-item filter-status" href="#" data-status="in_progress">In Progress</a></li>
                                <li><a class="dropdown-item filter-status" href="#" data-status="expired">Expired</a></li>
                            </ul>
                        </div>
                    </div>
                    <a class="add-notification-btn" href="{{route('admin.create.voucher')}}">Create Voucher</a>
                </div>
            </div>
            <div class="notification-table pt-0">
                <table class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th>Voucher ID</th>
                            <th>Voucher Name</th>
                            <th>Voucher Code</th>
                            <th>Start Date</th>
                            <th>Expiration Date</th>
                            <th>Min. Order Value</th>
                            <th>Max. Discount</th>
                            <th>Voucher Value</th>
                            <th>Voucher Type</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="voucherbody">
                        @forelse($vouchers as $voucher)
                        @php
                            $now = now();
                            $startDate = \Carbon\Carbon::parse($voucher->start_date);
                            $expirationDate = \Carbon\Carbon::parse($voucher->expiration_date);
                            
                            if ($now->lt($startDate)) {
                                $status = 'new';
                                $statusText = 'Upcoming';
                            } elseif ($now->gt($expirationDate)) {
                                $status = 'expired';
                                $statusText = 'Expired';
                            } else {
                                $status = 'in_progress';
                                $statusText = 'In Progress';
                            }
                        @endphp
                        <tr data-status="{{ $status }}">
                            <td>#{{ $voucher->id }}</td>
                            <td>{{ $voucher->name }}</td>
                            <td>{{ $voucher->code }}</td>
                            <td>{{ $startDate->format('d.m.Y') }}</td>
                            <td>{{ $expirationDate->format('d.m.Y') }}</td>
                            <td>{{ number_format($voucher->min_order_value, 2, ',', '.') }} €</td>
                            <td>{{ number_format($voucher->max_discount, 2, ',', '.') }} €</td>
                            <td>
                                @if ($voucher->type == '1') 
                                    {{ number_format($voucher->voucher_value, 2, ',', '.') }} €
                                @else 
                                    {{ rtrim(rtrim(number_format($voucher->voucher_value, 2, ',', '.'), '0'), ',') }}%
                                @endif
                            </td>
                            <td>
                                {{ $voucher->type == '1' ? 'Fixed' : 'Percentage' }}
                            </td>
                            <td>
                                <div class="upper-delete-btns d-flex">
                                    <a class="view-btn-eye" href="{{ route('admin.view.voucher', $voucher->id) }}">
                                        <i class="fa-solid fa-eye"></i>
                                    </a>
                                    <a class="edit-btn-eye" href="{{ route('admin.edit.voucher', $voucher->id) }}">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a>
                                    <a class="delete-btn-eye" href="javascript:void(0);" onclick="openDeleteModal('{{ $voucher->id }}')">
                                        <i class="fa-solid fa-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="9" class="text-center">No vouchers found.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade modal-delete-logout" id="deleteVoucher" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="delete-text">Are you sure you want to delete?</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">No</button>
                        <form id="delete-user-form" method="POST">
                            @csrf
                            <input type="hidden" name="voucher_id" id="delete_voucher_id">
                            <button type="submit" class="comn-modal-btns-blue btn add-user">Yes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('script')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        let activeStatus = 'all';
        let activeSearch = '';
        
        // Status filter functionality
        const statusFilterItems = document.querySelectorAll('.filter-status');
        const dropdownButton = document.querySelector('#statusFilterDropdown');
        
        statusFilterItems.forEach(item => {
            item.addEventListener('click', function(e) {
                e.preventDefault();
                
                // Update active status
                statusFilterItems.forEach(el => el.classList.remove('active'));
                this.classList.add('active');
                activeStatus = this.dataset.status;
                
                // Update dropdown button text
                dropdownButton.innerHTML = `<i class="fa-solid fa-filter"></i> ${this.textContent.trim()}`;
                
                // Filter the table
                filterVoucherTable();
            });
        });
        
        // Search functionality
        const searchInput = document.getElementById('voucher_search');
        searchInput.addEventListener('input', function() {
            activeSearch = this.value.trim().toLowerCase();
            filterVoucherTable();
        });
        
        // Filter function
        function filterVoucherTable() {
            const rows = document.querySelectorAll('#voucherbody tr');
            let hasVisibleRows = false;
            
            rows.forEach(row => {
                if (row.textContent.trim() === 'No vouchers found.') {
                    return; // Skip the "no results" row
                }
                
                const statusMatch = activeStatus === 'all' || 
                                  row.dataset.status === activeStatus;
                const searchMatch = activeSearch === '' || 
                                  row.textContent.toLowerCase().includes(activeSearch);
                
                if (statusMatch && searchMatch) {
                    row.style.display = '';
                    hasVisibleRows = true;
                } else {
                    row.style.display = 'none';
                }
            });
            
            // Show "no results" message if needed
            const noResultsRow = document.querySelector('#voucherbody tr.text-center');
            if (noResultsRow) {
                noResultsRow.style.display = hasVisibleRows ? 'none' : '';
            }
        }
        
        // Initialize the table filtering
        filterVoucherTable();
    });

    function openDeleteModal(voucherId) {
        document.getElementById('delete_voucher_id').value = voucherId;
        var myModal = new bootstrap.Modal(document.getElementById('deleteVoucher'));
        myModal.show();

        $('#delete-user-form').off('submit').on('submit', function (e) {
            e.preventDefault(); 
            var voucherId = $('#delete_voucher_id').val();
            var formData = {
                _token: $('meta[name="csrf-token"]').attr('content'),
                voucher_id: voucherId
            };

            $.ajax({
                url: "{{route('admin.delete.voucher')}}",
                type: 'POST',
                data: formData,
                success: function(response) {
                    myModal.hide();
                    location.reload(); 
                },
                error: function(xhr, status, error) {
                    alert('Something went wrong! Please try again later.');
                }
            });
        });
    }

    function downloadCsv(){
        window.location.href = "{{route('admin.voucher.export.csv')}}"
    }
    function downloadPdf(){
        window.location.href = "{{route('admin.voucher.export.pdf')}}"
    }
</script>
@endpush
@endsection