@forelse($vouchers as $voucher)
                        <tr>
                            <td>#{{ $voucher->id }}</td>
                            <td>{{ $voucher->name }}</td>
                            <td>{{ $voucher->code }}</td>
                            <td>{{ \Carbon\Carbon::parse($voucher->start_date)->format('d.m.Y') }}</td>
                            <td>{{ \Carbon\Carbon::parse($voucher->expiration_date)->format('d.m.Y') }}</td>
                            <td>{{ number_format($voucher->min_order_value, 2) }} €</td>
                            <td>{{ number_format($voucher->max_discount, 2) }} €</td>
                            <td>
                                <div class="upper-delete-btns d-flex">
                                    <a class="view-btn-eye" href="{{ route('admin.view.voucher', $voucher->id) }}">
                                        <i class="fa-solid fa-eye"></i>
                                    </a>
                                    <a class="edit-btn-eye" href="{{ route('admin.edit.voucher', $voucher->id) }}">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a>
                                    <form action="{{ route('admin.delete.voucher', $voucher->id) }}" method="POST" onsubmit="return confirm('Are you sure?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="delete-btn-eye">
                                            <i class="fa-solid fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center">No vouchers found.</td>
                        </tr>
                    @endforelse