@extends('layouts.admin')
@section('content')
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{ route('admin.voucher.index') }}">Voucher Management</a>
            <a class="active" href="#">View Voucher</a>
        </div>
    </div>

    <div class="add-user-form">
        <h3>View Voucher</h3>
        <div class="main-show-detail-viwe">
            <h6 class="voucher-detail">Voucher Details:</h6>
            <div class="patient-age-name d-flex">
                <div class="patient-anme-view">
                    <h5>Voucher ID</h5>
                    <p>#{{ $voucher->id }}</p>
                </div>
                <div class="patient-anme-view">
                    <h5>Voucher Name</h5>
                    <p>{{ $voucher->name }}</p>
                </div>
                <div class="patient-anme-view">
                    <h5>Voucher Code</h5>
                    <p>{{ $voucher->code }}</p>
                </div>
                <div class="patient-anme-view">
                    <h5>Min. Order Value</h5>
                    <p>{{ number_format($voucher->min_order_value, 2) }} €</p>
                </div>
                <div class="patient-anme-view">
                    <h5>Max. Discount</h5>
                    <p>{{ number_format($voucher->max_discount, 2) }} €</p>
                </div>
                <div class="patient-anme-view">
                    <h5>Start Date</h5>
                    <p>{{ \Carbon\Carbon::parse($voucher->start_date)->format('d.m.Y') }}</p>
                </div>
                <div class="patient-anme-view">
                    <h5>Expiration Date</h5>
                    <p>{{ \Carbon\Carbon::parse($voucher->expiration_date)->format('d.m.Y') }}</p>
                </div>
            </div>

            <div class="patient-age-name d-flex">
                <div class="patient-anme-view">
                    <h5>Applied to</h5>
                    <p>@if (!empty($products))
                        {{ implode(', ', $products) }}
                    @else
                        N/A
                    @endif</p>
                </div>
                <div class="patient-anme-view">
                    <h5>Applied to SPOS</h5>
                    <p>@if (!empty($spos))
                        {{ implode(', ', $spos) }}
                    @else
                        N/A
                    @endif</p>
                </div>
                <div class="patient-anme-view">
                    <h5>Customer Type</h5>
                    <p>{{ $voucher->customer_type ?? 'All' }}</p>
                </div>
                <div class="patient-anme-view">
                    <h5>Combination with other Voucher</h5>
                    <p>{{ $voucher->combine_with_others ? 'Yes' : 'No' }}</p>
                </div>
                <div class="patient-anme-view">
                    <h5>Redemption Limit</h5>
                    <p>{{ $voucher->redemption_limit ?? '-' }}</p>
                </div>
                <div class="patient-anme-view">
                    <h5>Applied by Customers</h5>
                    <p>{{ $voucher->applied_count ?? '0' }}</p>
                </div>
            </div>

            <div class="upper-main-btn-last-comn d-flex">
                <a href="{{ route('admin.edit.voucher', $voucher->id) }}" class="add-user">Edit Details</a>

           
                    <a href="{{route('admin.voucher.index')}}" class="delete-cancel-btn">Back To List</a>
                
            </div>
        </div>
    </div>
</div>
</div>
</div>
@endsection
