@extends('frontend.include.app')

<div class="inner-login">
    <div class="row">
        <div class="col-md-6">
            <div class="inner-login-img">
                <figure>
                    <img src="{{ asset('frontend/images/forget.png') }}" alt="">
                </figure>
            </div>
        </div>
        <div class="col-md-6">
            <div class="upper-high-main">
                <div class="inner-login-input-form">
                    <div class="inner-login-page">
                        <div class="inner-login-wrapper">
                            <div class="logo-login">
                                <img src="{{ asset('frontend/images/login-logo.png') }}" alt="">
                            </div>
                            <h2>{{ __('messages.forget_your_password') }}                            </h2>
                            <p class="pls-enter">{{ __('messages.please_enter_email') }}</p>
                        </div>
                        <form class="email-login" id="login-form" method="Post" action="{{route('forgot.password')}}">
                            @csrf
                            <div class="row">
                                <div class="col-md-12 inner-main-input">
                                    <label for="inputEmail4" class="form-label">{{ __('messages.email_address') }}</label>
                                    <input type="email" class="form-control" name="email" placeholder={{__('messages.enter_email_address')}} id="inputEmail4">
                                </div>
                            </div>
                            <button type="submit" class="btn primary-btn w-100">
                                {{ __('messages.reset_password') }}
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- jQuery and Plugins -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

<!-- Form Validation -->
<script>
    $(document).ready(function() {
        if (typeof $.fn.validate !== "undefined") {
            $("#login-form").validate({
                rules: {
                    email: {
                        required: true,
                        email: true,
                        remote: {
                            url: "{{ route('check.email') }}",
                            type: "GET",
                            data: {
                                email: function() {
                                    return $("input[name='email']").val();
                                }
                            }
                        }
                    }
                },
                messages: {
                    email: {
                        required: "{{ __('messages.email_validation.required') }}",
                        email: "{{ __('messages.email_validation.email') }}",
                        remote: "{{ __('messages.email_validation.remote') }}"
                    }
                },
                errorElement: "div",
                errorPlacement: function(error, element) {
                    error.addClass("invalid-feedback");
                    element.closest(".inner-main-input").append(error);
                },
                highlight: function(element) {
                    $(element).addClass("is-invalid");
                },
                unhighlight: function(element) {
                    $(element).removeClass("is-invalid");
                }
            });
        } else {
            console.error("jQuery Validation Plugin is not loaded!");
        }

        // Initialize Owl Carousel if present
        if ($.fn.owlCarousel) {
            $(".owl-carousel").owlCarousel({
                loop: true,
                margin: 10,
                nav: true,
                items: 1
            });
        } else {
            console.error("Owl Carousel is not loaded!");
        }
    });
</script>
