@extends('frontend.include.app')

<div class="inner-login">
    <div class="row">
        <div class="col-md-6">
            <div class="inner-login-img">
                <figure>
                    <img src="{{ asset('frontend/images/login.png') }}" alt="">
                </figure>
            </div>
        </div>
        <div class="col-md-6">
            <div class="upper-high-main">
                <div class="inner-login-input-form">
                    <div class="inner-login-page">
                        <div class="inner-login-wrapper">
                            <div class="logo-login">
                                <img src="{{ asset('frontend/images/login-logo.png') }}" alt="">
                            </div>
                            <h2>{{ __('messages.login_to_your_account') }}</h2>

                            <div class="google-face d-flex">
                                <button type="button" onclick="window.location.href='{{ route('user.auth.google') }}'">
                                    <img src="{{ asset('frontend/images/goog.png') }}" alt="">  {{ __('messages.continue_with_google') }}
                                </button>
                            </div>

                            <div class="or-continue">
                                <p>{{ __('messages.or_continue_with') }}</p>
                            </div>
                        </div>

                        <form method="POST" action="{{ route('login') }}" class="email-login" id="login-form">
                            @csrf
                            <div class="row">
                                <div class="col-md-12 inner-main-input">
                                    <label for="email" class="form-label">{{ __('messages.email_address') }}</label>
                                    <input id="email" type="text" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}"  placeholder="{{ __('messages.email_placeholder') }}" >
                                    <div class="invalid-feedback">
                                        @error('email') {{ $message }} @else  {{ __('messages.email_error') }} @enderror
                                    </div>
                                </div>

                           

                                <div class="col-md-12 inner-main-input mb-3 position-relative">
                                    <label for="password" class="form-label">{{ __('messages.password') }}</label>
                                    <div class="input-pass-show">
                                        <input 
                                            id="password" 
                                            type="password" 
                                            class="form-control @error('password') is-invalid @enderror" 
                                            name="password" 
                                            placeholder="{{ __('messages.enter_password') }}"
                                        >
                                        <span class="toggle-password" toggle="#password">
                                            <i class="fa fa-eye-slash"></i>
                                        </span>
                                        <div class="invalid-feedback">
                                            @error('password')
                                                {{ $message }}
                                            @else
                                                {{ __('messages.please_enter_password') }}
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="remember-main-marg d-flex">
                                <div class="form-check">
                                    <input 
                                        class="form-check-input" 
                                        type="checkbox" 
                                        name="remember" 
                                        id="remember" 
                                        {{ old('remember') ? 'checked' : '' }}
                                    >
                                    <label class="form-check-label" for="remember">
                                        {{ __('messages.remember_me') }}
                                    </label>
                                </div>
                                <div>
                                    <a class="forgot-pass" href="{{ route('forgot.view') }}">
                                        {{ __('messages.forgot_password') }}
                                    </a>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn primary-btn w-100">
                                {{ __('messages.login') }}
                            </button>
                            
                            <p class="not-yet">
                                {{ __('messages.not_registered_yet') }}
                                <a href="{{ route('register.view') }}">
                                    {{ __('messages.create_an_account') }}
                                </a>
                            </p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('login-form');
        const emailInput = document.getElementById('email');
        const passwordInput = document.getElementById('password');
    
        // Toggle password visibility
        document.querySelector('.toggle-password').addEventListener('click', function () {
            const input = document.querySelector(this.getAttribute('toggle'));
            const icon = this.querySelector('i');
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            }
        });
    
        // Simple email format check
        function validateEmail(email) {
            const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return re.test(email);
        }
    
        form.addEventListener('submit', function (e) {
    e.preventDefault();
    let isValid = true;

    emailInput.classList.remove('is-invalid');
    passwordInput.classList.remove('is-invalid');

    // Get feedback elements correctly
    const emailError = emailInput.closest('.inner-main-input').querySelector('.invalid-feedback');
    const passwordError = passwordInput.closest('.input-pass-show').querySelector('.invalid-feedback');

    // Validate email
    if (!emailInput.value.trim()) {
        emailError.textContent =  "{{ __('messages.enter_email') }}";
        emailInput.classList.add('is-invalid');
        isValid = false;
    } else if (!validateEmail(emailInput.value.trim())) {
        emailError.textContent = "{{ __('messages.enter_valid_email') }}";
        emailInput.classList.add('is-invalid');
        isValid = false;
    }

    // Validate password
    if (!passwordInput.value.trim()) {
        passwordError.textContent = "{{ __('messages.enter_password') }}";
        passwordInput.classList.add('is-invalid');
        isValid = false;
    }

    if (isValid) {
        form.submit();
    } else {
        const firstInvalid = document.querySelector('.is-invalid');
        if (firstInvalid) {
            firstInvalid.scrollIntoView({ behavior: 'smooth', block: 'center' });
            firstInvalid.focus();
        }
    }
});
    
        // Blur event (email)
        emailInput.addEventListener('blur', function () {
    const emailError = this.closest('.inner-main-input').querySelector('.invalid-feedback');
    if (!this.value.trim()) {
        emailError.textContent = "{{ __('messages.enter_email') }}";
        this.classList.add('is-invalid');
    } else if (!validateEmail(this.value.trim())) {
        emailError.textContent = "{{ __('messages.enter_valid_email') }}";
        this.classList.add('is-invalid');
    } else {
        this.classList.remove('is-invalid');
    }
});

passwordInput.addEventListener('blur', function () {
    const passwordError = this.closest('.input-pass-show').querySelector('.invalid-feedback');
    if (!this.value.trim()) {
        passwordError.textContent = "{{ __('messages.enter_password') }}";
        this.classList.add('is-invalid');
    } else {
        this.classList.remove('is-invalid');
    }
});
    });
</script>

<style>
    .is-invalid {
        border-color: #dc3545 !important;
    }
    .invalid-feedback {
        display: none;
        color: #dc3545;
        font-size: 0.875em;
        margin-top: 0.25rem;
    }
    .is-invalid ~ .invalid-feedback {
        display: block;
    }
    .alert-danger {
        color: #721c24;
        background-color: #f8d7da;
        border-color: #f5c6cb;
        padding: 0.75rem 1.25rem;
        margin-bottom: 1rem;
        border: 1px solid transparent;
        border-radius: 0.25rem;
    }
    .alert-danger p {
        margin: 0;
    }
</style>