@extends('frontend.include.app')
<style>
    .error {
        color: red !important;
    }
    .alert-danger {
        color: #721c24;
        background-color: #f8d7da;
        border-color: #f5c6cb;
        padding: 0.75rem 1.25rem;
        margin-bottom: 1rem;
        border: 1px solid transparent;
        border-radius: 0.25rem;
    }
    .alert-danger ul {
        margin: 0;
        padding-left: 20px;
    }
    .is-invalid {
        border-color: #dc3545 !important;
    }
    .invalid-feedback {
        display: none;
        color: #dc3545;
        font-size: 0.875em;
        margin-top: 0.25rem;
    }
    .is-invalid ~ .invalid-feedback {
        display: block;
    }
    .toggle-password {
        position: absolute;
        top: 50%;
        right: 15px;
        transform: translateY(-50%);
        cursor: pointer;
        color: #999;
        z-index: 10;
    }
    .inner-login-page .inner-main-input label {
        text-transform: none !important;
    }
    .profile_title_input .inner-main-input.title_inpt {
        max-width: 11.1rem !important;
    }
    .profile_title_input .inner-main-input.title_inpt select {
        width: 11rem !important;
        margin: 0;
    }
</style>

<section>
    <div class="inner-login">
        <div class="row">
            <div class="col-lg-6">
                <div class="inner-login-img">
                    <figure>
                        <img src="{{ asset('frontend/images/signup.png') }}" alt="">
                    </figure>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="upper-high-main">
                    <div class="inner-login-input-form register-main-wrapper">
                        <div class="inner-login-page">
                            <div class="inner-login-wrapper">
                                <div class="logo-login register-logo">
                                    <img src="{{ asset('frontend/images/login-logo.png') }}" alt="">
                                </div>
                                <h2>{{ __('messages.register_new_account') }}</h2>
                            </div>
                            @if(session('success'))
                                <div class="alert alert-success">{{ session('success') }}</div>
                            @endif
                            @if($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <form id="registerForm" method="POST" action="{{ route('register') }}" class="email-login">
                                @csrf
                                <div class="row">
                                    <div class="col-md-12 inner-main-input">
                                        <label for="title" class="form-label">{{ __('messages.title') }}</label>
                                        <select class="form-select @error('title') is-invalid @enderror" name="title" required>
                                            <option value="">{{ __('messages.select_title') }}</option>
                                            <option value="Mr." {{ old('title') == 'Mr.' ? 'selected' : '' }}>{{ __('messages.title_mr') }}</option>
                                            <option value="Mrs." {{ old('title') == 'Mrs.' ? 'selected' : '' }}>{{ __('messages.title_mrs') }}</option>
                                        </select>
                                        @error('title')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                   

                                    <div class="col-md-6 inner-main-input">
                                        <label for="first_name" class="form-label">{{ __('messages.first_name') }}</label>
                                        <input 
                                            type="text" 
                                            class="form-control @error('first_name') is-invalid @enderror" 
                                            name="first_name" 
                                            value="{{ old('first_name') }}" 
                                            placeholder="{{ __('messages.enter_first_name') }}" 
                                            required
                                        >
                                        @error('first_name')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @else
                                            <div class="invalid-feedback">{{ __('messages.please_enter_first_name') }}</div>
                                        @enderror
                                    </div>
                                    
                                
                                    <div class="col-md-6 inner-main-input">
                                        <label for="last_name" class="form-label">{{ __('messages.surname') }}*</label>
                                        <input type="text" 
                                               class="form-control @error('last_name') is-invalid @enderror" 
                                               name="last_name" 
                                               value="{{ old('last_name') }}" 
                                               placeholder="{{ __('messages.enter_surname') }}" 
                                               required>
                                        @error('last_name')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-12 inner-main-input">
                                        <label for="street" class="form-label">{{ __('messages.street_house_number') }}*</label>
                                        <input type="text" 
                                               class="form-control @error('street') is-invalid @enderror" 
                                               name="street" 
                                               value="{{ old('street') }}" 
                                               placeholder="{{ __('messages.enter_street_house_number') }}" 
                                               required>
                                        @error('street')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 inner-main-input">
                                        <label for="zip_code" class="form-label">{{ __('messages.zip_code') }}*</label>
                                        <input type="text" 
                                               class="form-control @error('zip_code') is-invalid @enderror" 
                                               name="zip_code" 
                                               value="{{ old('zip_code') }}" 
                                               placeholder="{{ __('messages.enter_zip_code') }}" 
                                               required>
                                        @error('zip_code')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-6 inner-main-input">
                                        <label for="city" class="form-label">{{ __('messages.city') }}*</label>
                                        <input type="text" 
                                               class="form-control @error('city') is-invalid @enderror" 
                                               name="city" 
                                               value="{{ old('city') }}" 
                                               placeholder="{{ __('messages.enter_city') }}" 
                                               required>
                                        @error('city')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                  
                                  
                                    
                                  
                                    
                                    <div class="col-md-12 inner-main-input">
                                        <label for="region" class="form-label">{{__('messages.state_region')}}*</label>
                                        <select id="region" class="form-select @error('region') is-invalid @enderror" name="region" required>
                                            <option value="">{{ __('messages.select_option') }}</option>

                                            @foreach(__('messages.regions') as $key => $value)
                                                <option value="{{ $key }}" {{ old('region', $user->region ?? '') == $key ? 'selected' : '' }}>
                                                    {{ $value }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('region')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-12 inner-main-input">
                                        <label for="email" class="form-label">{{ __('messages.email') }}*</label>
                                        <input type="email" 
                                               class="form-control @error('email') is-invalid @enderror" 
                                               name="email" 
                                               value="{{ old('email') }}" 
                                               placeholder="{{ __('messages.enter_email_address') }}" 
                                               required>
                                        @error('email')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    
                                    <div class="col-md-12 inner-main-input">
                                        <div class="d-flex profile_title_input">
                                            <div class="inner-main-input inner-main-input2 title_inpt">
                                                <label class="form-label">{{ __('messages.phone_code') }}*</label>
                                                <select class="form-select country_code_custom @error('phone_code') is-invalid @enderror" name="phone_code" required id="phone_code">
                                                    <option data-image="https://flagcdn.com/16x12/de.png"  value="+49" {{ old('phone_code') == '+49' ? 'selected' : '' }}>+49</option>
                                                    <option value="+43" data-image="https://flagcdn.com/16x12/at.png"  {{ old('phone_code') == '+43' ? 'selected' : '' }}> +43</option>
                                                    <option value="+41" data-image="https://flagcdn.com/16x12/ch.png"  {{ old('phone_code') == '+41' ? 'selected' : '' }}>+41</option>
                                                </select>
                                                @error('phone_code')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                            </div>
                                            <div class="inner-main-input inner-main-input2">
                                                <label class="form-label">{{ __('messages.phone_number') }}*</label>
                                                <input type="tel" name="phone_number" class="form-control @error('phone_number') is-invalid @enderror" value="{{ old('phone_number') }}" placeholder="{{ __('messages.enter_phone_number') }}"  required>
                                                @error('phone_number')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                            </div>
                                        </div>
                                    </div>
                                   
                                    <div class="col-md-12 inner-main-input position-relative">
                                        <label for="password" class="form-label">{{ __('messages.password') }}*</label>
                                        <div class="input-pass-show">
                                            <input type="password" 
                                                   class="form-control @error('password') is-invalid @enderror" 
                                                   name="password" 
                                                   id="password" 
                                                   placeholder="{{ __('messages.enter_password') }}" 
                                                   required>
                                            <span class="toggle-password" toggle="#password">
                                                <i class="fa fa-eye-slash"></i>
                                            </span>
                                            @error('password')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-12 inner-main-input position-relative">
                                        <label for="password_confirmation" class="form-label">{{ __('messages.confirm_password') }}*</label>
                                        <div class="input-pass-show">
                                            <input type="password" 
                                                   class="form-control @error('password_confirmation') is-invalid @enderror" 
                                                   name="password_confirmation" 
                                                   id="password_confirmation" 
                                                   placeholder="{{ __('messages.confirm_your_password') }}" 
                                                   required>
                                            <span class="toggle-password" toggle="#password_confirmation">
                                                <i class="fa fa-eye-slash"></i>
                                            </span>
                                            @error('password_confirmation')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>


                                <button type="submit" class="btn primary-btn w-100">
                                    {{ __('messages.register') }}
                                </button>
                                
                                <p class="not-yet">
                                    {{ __('messages.already_have_account') }}
                                    <a href="{{ route('login') }}">{{ __('messages.login') }}</a>
                                </p>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<script>
    function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function () {
        $('#phone_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });
    });
</script>
<script>
    $(document).ready(function() {
        $.validator.addMethod("strongPassword", function(value, element) {
            return this.optional(element) || /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[^\w\s])([^\s]){8,}$/.test(value);
        }, "{{ __('messages.strong_password_rule') }}");

        $.validator.addMethod("numericOnly", function(value, element) {
            return this.optional(element) || /^[0-9]+$/.test(value);
        }, "{{ __('messages.valid_phone_number') }}");
        $("#registerForm").validate({
            rules: {
                title: { required: true },
                first_name: { 
                    required: true, 
                    minlength: 2, 
                    maxlength: 50 
                },
                last_name: { 
                    required: true, 
                    minlength: 2, 
                    maxlength: 50 
                },
                email: {
                    required: true,
                    email: true,
                    remote: {
                        url: "{{ route('check.email') }}",
                        type: "GET",
                        data: {
                            email: function() {
                                return $("input[name='email']").val();
                            }
                        },
                        dataFilter: function(response) {
                            return response === 'false';
                        }
                    }
                },
                password: {
                    required: true,
                    strongPassword: true
                },
                password_confirmation: {
                    required: true,
                    equalTo: "#password"
                },
                phone_code: { required: true },
                phone_number: {
                    required: true,
                    numericOnly: true,
                    minlength: 8, 
                    maxlength: 15
                },
                street: { required: true },
                zip_code: { required: true },
                city: { required: true },
                region: { required: true }
            },
            messages: {
                title: "{{ __('messages.select_title_error') }}",
                first_name: {
                    required: "{{ __('messages.enter_first_name') }}",
                    minlength: "{{ __('messages.first_name_min') }}",
                    maxlength: "{{ __('messages.first_name_max') }}"
                },
                last_name: {
                    required: "{{ __('messages.enter_surname_error') }}",
                    minlength: "{{ __('messages.surname_min') }}",
                    maxlength: "{{ __('messages.surname_max') }}"
                },
                email: {
                    required: "{{ __('messages.enter_email_address_error') }}",
                    email: "{{ __('messages.enter_valid_email_address') }}",
                    remote: "{{ __('messages.email_already_taken') }}"
                },
                password: { required: "{{ __('messages.enter_password_error') }}" },
                password_confirmation: {
                    required: "{{ __('messages.enter_confirm_password') }}",
                    equalTo: "{{ __('messages.passwords_must_match') }}"
                },
                phone_code: "{{ __('messages.select_phone_code') }}",
                phone_number: {
                    required: "{{ __('messages.enter_phone_number_error') }}",
                    numericOnly: "{{ __('messages.valid_phone_number') }}",
                    minlength: "{{ __('messages.phone_number_length') }}",
                    maxlength: "{{ __('messages.phone_number_length') }}"
                },
                street: "{{ __('messages.enter_street_house_number_error') }}",
                zip_code: "{{ __('messages.enter_zip_code_error') }}",
                city: "{{ __('messages.enter_city_error') }}",
                region: "{{ __('messages.enter_region_state_error') }}"
            },
            errorElement: "div",
            errorClass: "invalid-feedback",
            highlight: function(element) {
                $(element).addClass('is-invalid').removeClass('is-valid');
            },
            unhighlight: function(element) {
                $(element).removeClass('is-invalid').addClass('is-valid');
            },
            errorPlacement: function(error, element) {
                if (element.parent().hasClass('input-pass-show')) {
                    error.insertAfter(element.parent());
                } else if (element.attr("name") === "phone_number") {
                    error.insertAfter(element);
                } else {
                    error.insertAfter(element);
                }
            }
        });
    });

    $(document).on('click', '.toggle-password', function () {
        let input = $($(this).attr('toggle'));
        let icon = $(this).find('i');

        if (input.attr('type') === 'password') {
            input.attr('type', 'text');
            icon.removeClass('fa-eye-slash').addClass('fa-eye');
        } else {
            input.attr('type', 'password');
            icon.removeClass('fa-eye').addClass('fa-eye-slash');
        }
    });
</script>