@extends('layouts.frontend')

@section('content')
<section class="detail-show-all comn-padd-100">
  <div class="container">
    <div class="row row-gap-3">
      <div class="col-md-6">
        <div class="cst_calender booking-main-page">
          <div id="calendar-box"></div>
        </div>
      </div>

      <div class="col-md-6">
        <div class="row my_appiont_date_row mt-0">
          <div class="col-md-6">
            <h6 class="sub_heading_18">pickup date</h6>
            <div class="my_appiont_date_col">
              <div class="inner-main-input">
                <label class="form-label">Pick-up Date</label>
                <input class="form-control date-input" type="date" value="{{ \Carbon\Carbon::parse($pickupDate)->format('Y-m-d') }}" readonly>
              </div>
              <p class="avail_slots_text">available slot</p>
              <ul id="from-slots" class="available_slots_row"></ul>
            </div>
          </div>

          <div class="col-md-6">
            <h6 class="sub_heading_18">drop-off date</h6>
            <div class="my_appiont_date_col">
              <div class="inner-main-input">
                <label class="form-label">Drop-off Date</label>
                <input class="form-control date-input" type="date" value="{{ \Carbon\Carbon::parse($dropoffDate)->format('Y-m-d') }}" readonly>
              </div>
              <p class="avail_slots_text">available slot</p>
              <ul id="to-slots" class="available_slots_row"></ul>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="text-end mt-4">
      <button id="confirmBookingBtn" class="btn primary-btn primary-btn2">Confirm Booking</button>
    </div>
  </div>
</section>




<script src="https://npmcdn.com/flatpickr/dist/flatpickr.min.js"></script>
<script src="https://npmcdn.com/flatpickr/dist/l10n/de.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const rentalFrom = "{{ $pickupDate}}";
    const rentalTo = "{{ \Carbon\Carbon::parse($dropoffDate)->format('Y-m-d') }}";
flatpickr.localize(flatpickr.l10ns.de);
    
    flatpickr("#calendar-box", {
        inline: true,
        mode: "range",
        defaultDate: [rentalFrom, rentalTo],
        locale: "de", // Set locale to German
        firstDayOfWeek: 1, // Monday first
        disable: [
            function(date) {
                const start = new Date(rentalFrom);
                const end = new Date(rentalTo);
                return !(date >= start && date <= end);
            }
        ]
    });

    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('time-slot') && !e.target.classList.contains('disabled')) {
            e.target.parentElement.querySelectorAll('.time-slot').forEach(slot => {
                slot.classList.remove('active');
            });
            e.target.classList.add('active');
        }
    });

    document.getElementById('confirmBookingBtn').addEventListener('click', function () {
        const fromSlot = document.querySelector('#from-slots .time-slot.active');
        const toSlot = document.querySelector('#to-slots .time-slot.active');

        if (!fromSlot || !toSlot) {
            return window.location.href = '/cart';
        }
        
        const payload = {
          pickup_time: fromSlot.dataset.label,
          dropoff_time: toSlot.dataset.label
        };
       

        

        fetch(`/cart/guest/time-selection`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify(payload)
        }).then(response => {
            if (response.ok) {
                window.location.href = '/checkout/guest';
            } else {
                alert('Failed to confirm booking.');
            }
        });
    });
});

$(document).ready(function() {
    loadTimeSlots('{{ $pickupDate }}', 'pickup', '#from-slots');
    
    loadTimeSlots('{{ $dropoffDate }}', 'dropoff', '#to-slots');
    
    function loadTimeSlots(date, type, container) {
        $.get('/cart/guest/time-slots', {
            date: date,
            type: type
        }, function(data) {
            let html = '';
            data.slots.forEach(slot => {
                html += `
                    <div class="time-slot ${slot.disabled ? 'disabled' : ''}" 
                         data-type="${type}"
                         data-start="${slot.start}"
                         data-end="${slot.end}"
                         data-label="${slot.label}">
                        ${slot.label}
                    </div>
                `;
            });
            $(container).html(html);
        });
    }
    
    $(document).on('click', '.time-slot:not(.disabled)', function() {
        const type = $(this).data('type');
        const label = $(this).data('label');
        
        $(`.time-slot[data-type="${type}"]`).removeClass('selected');
        
        $(this).addClass('selected');
        
        $(`#${type}_time`).val(label);
        
        if ($('#pickup_time').val() && $('#dropoff_time').val()) {
            $('#confirmTimesBtn').prop('disabled', false);
        }
    });
});
</script>


<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<style>
.time-slot {
    padding: 6px 10px;
    margin: 4px;
    border: 1px solid #ccc;
    cursor: pointer;
    display: inline-block;
    border-radius: 5px;
    background-color: #f7f7f7;
    font-size: 14px;
}

.time-slot.active {
    background-color: #007bff;
    color: white;
    border-color: #007bff;
}

.time-slot.disabled {
    background-color: #e0e0e0;
    color: #999;
    cursor: not-allowed;
    pointer-events: none;
}
</style>
@endsection