@extends('layouts.frontend')
@section('content')
<style>
.coupon_management_outer .remove-coupon-btn {
    font-size: 10px;
    position: absolute;
    bottom: 0;
    top: auto;
    right: 10px;
    width: unset;
    height: unset;
    background: #fff;
    color: #5bc0de;
    font-weight: 700;
    padding: 5px 5px;
    border: 1px solid;
    line-height: 1;
    border-radius: 4px;
}
.rm-cart-item {
    float: right;
    width: unset;
    height: unset;
    background: #fff;
    color: #5bc0de;
    font-weight: 500;
    padding: 10px 15px;
    border: 1px solid;
    line-height: 1;
    border-radius: 4px;
}
.comm_product_cstom_row {
    justify-content: space-between;
}
.pr-wrap {
    display: flex;
    align-items: center;
    gap: 15px;
}

</style>
    <main>

        <div class="navigation-main">
            <div class="container">
                <div class="navigat">
                    <a href="{{ route('home') }}">{{ __('messages.nav_home') }}</a>
                    <a href="{{ route('product') }}">{{ __('messages.nav_products') }}</a>
                    <a class="prod-name active" href="">{{ __('messages.nav_rental_cart') }}</a>
                </div>
            </div>
        </div>

        <section class="detail-show-all comn-padd-100">
            <div class="container">
                <h3 class="sub_heading_16">{{ __('messages.rent_cart_heading') }}</h3>

                <div class="row row-gap-3 rent_cart_page_row">
                    <div class="col-lg-9">
                        @if ($cartItems->isEmpty())
                            <div class="alert alert-info">
                                {{ __('messages.cart_empty_message') }} <a href="{{ route('product') }}">{{ __('messages.cart_browse_products') }}</a>   {{ __('messages.cart_browse_suffix') }}
                            </div>
                        @else
                        @php
        $firstItem = $cartItems->first();
    @endphp
    <input type="hidden" id="cart_userId" value="{{ $firstItem->user_id }}">
                            @foreach ($cartItems as $item)
                                <div class="comm_border_box_outer mb-4">
                                    <div class="comm_border_box">
                                        <div class="comm_booking_detail_col">
                                            <div class="d-flex comm_product_cstom_row">
                                                <div class="pr-wrap">
                                                <figure class="booking-dt-img">
                                                    <img src="{{ $item->product->images->first() ? asset('storage/' . $item->product->images->where('type','main')->first()->image_path) : asset('frontend/images/placeholder.jpg') }}"
                                                        alt="{{ $item->product_name }}" class="img-fluid" />
                                                </figure>
                                                <div class="booking_cs_detail">
                                                    <h3 class="name">{{ $item->product_name }} | {{$item->size}} | {{$item->color}} </h3>
                                                    <div class="d-flex book_loctn_wrap">
                                                        <i class="fa-solid fa-location-dot"></i>
                                                        <p> {{ $item->vendor_address }}</p>
                                                        <input type="hidden" class="cart-address" value="{{ $item->vendor_address }}">
                                                        <input type="hidden" class="cart-pickup-date" value="{{ \Carbon\Carbon::parse($item->pickup_date)->format('Y-m-d') }}">
                                                        <input type="hidden" class="cart-dropoff-date" value="{{ \Carbon\Carbon::parse($item->dropoff_date)->format('Y-m-d') }}">
                                                        <input type="hidden" class="cart-pickup-time" value="{{ $item->pickup_time }}">
                                                        <input type="hidden" class="cart-dropoff-time" value="{{ $item->dropoff_time }}">


                                                    </div>
                                                   
                                                </div>
                                                </div>


                                                @if ($item->coupon_code)
                                                {{-- <div class="applied-coupon-badge mt-2">

                                                    Coupon Applied: {{ $item->coupon_code }}
                                                    <button class="btn-remove-coupon" data-id="{{ $item->id }}"
                                                        title="Remove coupon">
                                                        <i class="fas fa-times ms-2"></i>
                                                    </button>

                                                    <div class="coupon-discount-amount text-success small mt-1">
                                                        -{{ number_format($item->discount, 2) }}€ discount
                                                    </div>
                                                </div> --}}




                                                <div class="comm_border_box_outer main-product-vouch" bis_skin_checked="1">

                                                    <div class="d-flex voucher_coupan_row" bis_skin_checked="1">
                                                        <div class="d-flex coupon_management_outer  " bis_skin_checked="1">
                                                            <figure class="coupon_manage_shape">
                                                                <img src="http://49.249.236.30:3131/dachboxmiete-phase-2/public/frontend/images/coup_shape.png"
                                                                alt="" class="img-fluid">
                                                            </figure>
                                                            <figure class="coupon_management_img">
                                                                <img src="http://49.249.236.30:3131/dachboxmiete-phase-2/public/frontend/images/coup-left.png"
                                                                alt="" class="img-fluid">
                                                            </figure>
                                                            <div class="coupon_mange_content">
                                                                
                                                                <h5 class="coupon_txt">
                                                                    {{ __('messages.coupon_applied') }} {{ strtoupper(trim($item->coupon_code, '[]" ')) }}
                                                                </h5>
                                                                
                                                                <h6 class="valid text-success">
                                                                    
                                                                    - {{ number_format($item->discount, 2, ',', '') }} € </h6>
                                                                </div>
                                                                <button class="btn-remove-coupon remove-coupon-btn" data-item_id="{{ $item->id }}"
                                                                    title="Remove coupon">
                                                                   X
                                                                </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif


                                            </div>
                                           
                                            <div class="comm_renting_dt_row_outer">
                                                <div class="comm_renting_dt_row">
                                                    <h3 class="rnt_head">{{ __('messages.car_information') }}:</h3>
                                                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.brand') }} :</h5>
                                                            <h6>{{ $item->car_name ?? 'N/A' }}</h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.model') }} :</h5>
                                                            <h6>{{ $item->model ?? 'N/A' }}</h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.year') }} :</h5>
                                                            <h6>{{ $item->car_year ?? 'N/A' }}</h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.railing_type') }} :</h5>
                                                            <h6>{{ $item->roof_type ?? 'N/A' }}</h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.trailer_hitch') }} :</h5>
                                                            <h6>{{ $item->trailer_hitch ? __('messages.yes') : __('messages.no') }}</h6>

                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="comm_renting_dt_row">
                                                    <h3 class="rnt_head">{{ __('messages.renting_details') }}:</h3>
                                                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.from') }}:</h5>
                                                            <h6>{{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }}
                                                            </h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.to') }}:</h5>
                                                            <h6>{{ \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') }}
                                                            </h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.pickup_date_time') }}:</h5>
                                                            <h6>
                                                                {{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }} |
                                                                {!! $item->pickup_time
                                                                    ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i')
                                                                    : '<span style="color: red; font-weight: bold;">Not set</span>' !!}
                                                            </h6>
                                                        </div>
                                                        
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.dropoff_date_time') }}:</h5>
                                                            <h6>
                                                                {{ \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') }} |
                                                                {!! $item->dropoff_time
                                                                    ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i')
                                                                    : '<span style="color: red; font-weight: bold;">Not set</span>' !!}
                                                            </h6>
                                                        </div>
                                                        
                                                    </div>
                                                </div>

                                                <div class="comm_renting_dt_row">
                                                    <h3 class="rnt_head">{{ __('messages.rent_information') }}:</h3>
                                                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.quantity') }}:</h5>
                                                            <h6>01</h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.rental_days') }}:</h5>
                                                            <h6>{{ $item->days }}</h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.for_days', ['days' => $item->days]) }}:</h5>
                                                            <h6>{{ __('messages.total') }} {{ number_format($item->calculated_rent, 2) }}€</h6>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="booking_modal_carrier_sec">
                                                @if ($item->is_carrier_included)
                                                    <div class="d-flex booking_modal_carrier_row">
                                                        <div class="cr_box"></div>
                                                        <h6>{{ __('messages.carrier_included') }}</h6>
                                                    </div>
                                                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.length') }}:</h5>
                                                            <h6>{{ $item->carrier_length ?? 'N/A' }}</h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.foot_kit') }}:</h5>
                                                            <h6>{{ $item->footkit_sku ?? 'N/A' }}</h6>
                                                        </div>
                                                        <div class="comm_detail_list_col">
                                                            <h5>{{ __('messages.foot') }}:</h5>
                                                            <h6>{{ $item->foot_sku ?? 'N/A' }}</h6>
                                                        </div>
                                                    </div>
                                                  
                                                @endif

                                                @if ($item->is_insured)
                                                    <div class="d-flex booking_modal_carrier_row vkassko_rw">
                                                        <div class="cr_box"></div>
                                                        <h6>{{ __('messages.volkasko_insurance') }} 25 €</h6>
                                                    </div>
                                                @endif
                                            </div>
                                            @if (is_null($item->related_item))
                                            <button class="btn btn-sm remove-item rm-cart-item" data-id="{{ $item->id }}">
                                                {{ __('messages.remove_cart_item') }}
                                            </button>
                                        @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                            <div class="have_coupon_sec">
                                <div class="sub_heading_16">{{ __('messages.have_voucher') }}</div>
                                <div class="inner-main-input inner-main-input2">
                                    <label for="contact-number" class="form-label">{{ __('messages.add_voucher_here') }}</label>

                                    <!-- Initially hidden applied coupon section -->
                                    <div id="applied_coupon_section" class="applied-coupon-wrap mb-3"
                                        style="display: none;">
                                        <div class="d-flex align-items-center justify-content-between bg-light p-2 rounded">
                                            <span class="applied-coupon-code font-weight-bold"></span>

                                            <button class="btn btn-sm btn-outline-danger remove-coupon-btn">
                                                {{ __('messages.remove_coupon') }}
                                            </button>                                        </div>
                                    </div>

                                    <div class="d-flex coupn_input_wrap">
                                        <input type="text" class="form-control" placeholder="{{ __('messages.enter_code_here') }}"
                                            id="coupon_code">
                                            <button class="btn primary-btn primary-btn2" id="apply_coupon">
                                                {{ __('messages.apply_coupon') }}
                                            </button>
                                    </div>
                                    <div id="coupon_message" class="mt-2"></div>
                                </div>
                            </div>
                        @endif
                    </div>

                    @if (!$cartItems->isEmpty())
                        <div class="col-lg-3">
                            <div class="cart_total_right_col">
                                <div class="sub_heading_18">{{ __('messages.cart_totals') }}</div>
                                <div class="d-flex comm_detail_list_view cart_total_list">
                                    <div class="comm_detail_list_col">
                                        <h5>{{ __('messages.subtotal') }}:</h5>
                                        <h6 id="cart_sub_total">{{ number_format($subtotal, 2, ',', '') }}€</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5>{{ __('messages.discount') }}:</h5>
                                        <h6>{{ number_format($discount, 2, ',', '') }}€</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5>{{ __('messages.net_price') }}:</h5>
                                        <h6>{{ number_format($netPrice, 2, ',', '') }}€</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5>{{ __('messages.net_price_insurance') }}:</h5>
                                        <h6>{{ number_format($insuranceTotal, 2, ',', '') }}€</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5>{{ __('messages.tax_19') }}:</h5>
                                        <h6>{{ number_format($tax, 2, ',', '') }}€</h6>
                                    </div>
                                    <div class="comm_detail_list_col bott_total_row">
                                        <h5>{{ __('messages.total') }}:</h5>
                                        <h6>{{ number_format($total, 2, ',', '') }}€</h6>
                                    </div>
                                </div>

                                <div class="d-flex flex-column gap-4 mt-4">
                                    <div class="d-flex form-check">
                                        <input class="form-check-input" type="checkbox" id="terms_checkbox">
                                        <label class="form-check-label" for="terms_checkbox">
                                            <p class="default_text">{{ __('messages.accept_terms') }}</p>
                                        </label>
                                    </div>
                                    <div class="d-flex form-check">
                                        <input class="form-check-input" type="checkbox" id="marketing_checkbox" name="marketing_checkbox"  value="1"
                                        {{ $marketingAgreement == 1 ? 'checked' : '' }}>
                                        <label class="form-check-label" for="marketing_checkbox">
                                            <p class="default_text">{{ __('messages.marketing_consent') }}</p>
                                        </label>
                                    </div>
                                </div>
                                @php
                                    $hasMissingTimes = false;
                                    foreach ($cartItems as $item) {
                                        if (empty($item->pickup_time) || empty($item->dropoff_time)) {
                                            $hasMissingTimes = true;
                                            $itemWithMissingTime = $item;
                                            break;
                                        }
                                    }
                                    
                                    $href = $hasMissingTimes 
                                        ? route('cart.confirm', ['cartItem' => $itemWithMissingTime->id])
                                        : route('user.checkout.index');
                                @endphp
                                <form id="checkout_form" method="GET" action="{{ $href }}">
                                    <input type="hidden" name="marketing_checkbox" id="marketing_checkbox_hidden" value="{{ $marketingAgreement == 1 ? 1 : 0 }}">

                                    <button type="submit" id="checkout_btn"
                                        class="btn primary-btn primary-btn2 w-100 mt-3 disabled {{ $cartItems->isEmpty() ? 'disabled' : '' }}">
                                        {{ __('messages.checkout') }}
                                    </button>
                                </form>




                                <a href="{{ route('product') }}" class="default_text cart_back_rent_btn">
                                    <img src="{{ asset('frontend/images/back-rent.png') }}" alt=""
                                        class="back_rent img-fluid" />
                                      {{ __('messages.add_more_rental_products') }}
                                </a>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </section>
    </main>
    <div class="modal fade comm-modal " id="removeItemModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
            <div class="modal-body text-center">
                <h4 class="mb-4 modal_heading">{{ __('messages.remove_item_confirmation') }}</h4>
                <input type="hidden" id="remove-item-id" />
                <div class="d-flex justify-content-center gap-3">
              

                <div class="modal_two_btns d-flex justify-content-center">
                       <button type="button" class="primary-outline-btn" data-bs-dismiss="modal">  {{ __('messages.no') }}</button>
                <button type="button" class="primary-btn comn-btn-logout" id="confirm-remove-item">  {{ __('messages.yes') }}</button>

                    </div>
                </div>
            </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="addressMismatchModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content text-center p-4">
                <h4 class="modal_heading mb-3">{{ __('messages.pickup_location_mismatch_title') }}</h4>
                <p class="mb-4">
                    {{ __('messages.pickup_location_mismatch_text') }}
                </p>
                <button type="button" class="primary-btn w-100" data-bs-dismiss="modal">
                    {{ __('messages.okay') }}
                </button>
            </div>
        </div>
    </div>
    <div class="modal fade" id="pickupDateMismatchModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content text-center p-4">
                <h4 class="modal_heading mb-3">{{ __('messages.different_pickup_dates_title') }}</h4>
                <p class="mb-4">
                    {{ __('messages.different_pickup_dates_text') }}
                </p>
                <button type="button" class="primary-btn w-100" data-bs-dismiss="modal">{{ __('messages.okay') }}</button>
            </div>
        </div>
    </div>
    

    <!-- Drop-off Date Mismatch Modal -->
    <div class="modal fade" id="dropoffDateMismatchModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content text-center p-4">
                <h4 class="modal_heading mb-3">{{ __('messages.dropoff_date_mismatch_title') }}</h4>
                <p class="mb-4">
                    {{ __('messages.dropoff_date_mismatch_text') }}
                </p>
                <button type="button" class="primary-btn w-100" data-bs-dismiss="modal">
                    {{ __('messages.okay') }}
                </button>
            </div>
        </div>
    </div>

    <!-- Same Time Conflict Modal -->
    <div class="modal fade" id="sameTimeMismatchModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content text-center p-4">
                <h4 class="modal_heading mb-3">{{ __('messages.same_time_conflict_title') }}</h4>
                <p class="mb-4">
                    {{ __('messages.same_time_conflict_text') }}
                </p>
                <button type="button" class="primary-btn w-100" data-bs-dismiss="modal">
                    {{ __('messages.okay') }}
                </button>
            </div>
        </div>
    </div>


    <script>
        $(document).ready(function() {

            $('#marketing_checkbox').on('change', function () {
                $('#marketing_checkbox_hidden').val($(this).is(':checked') ? 1 : 0);
            });

            $('#checkout_form').on('submit', function () {
                $('#marketing_checkbox_hidden').val($('#marketing_checkbox').is(':checked') ? 1 : 0);
            });
            
            let selectedItemId = null;

            $('.remove-item').click(function (e) {
                e.preventDefault();
                selectedItemId = $(this).data('id'); // Store item ID
                $('#remove-item-id').val(selectedItemId);
                $('#removeItemModal').modal('show'); // Show confirmation modal
            });

            $('#confirm-remove-item').click(function () {
                const itemId = $('#remove-item-id').val();
                $.ajax({
                    url: '{{ route('cart.remove') }}',
                    method: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        item_id: itemId
                    },
                    success: function (response) {
                        if (response.success) {
                            $('#removeItemModal').modal('hide');
                            window.location.reload();
                        }
                    },
                    error: function () {
                        alert('Ein Fehler ist aufgetreten. Bitte versuchen Sie es erneut.');
                    }
                });
            });
            $('#apply_coupon').click(function() {
                var couponCode = $('#coupon_code').val().trim();
                var userId = $('#cart_userId').val();
                var subTotal = $('#cart_sub_total').text().replace(' €', '').replace(',', '.');

                if (!couponCode) {
                    Swal.fire({
                                icon: 'warning',
                                title: 'Fehler',
                                text: 'Gutscheincode eingeben',
                                confirmButtonColor: '#5BC0DE',
                            });
                    // $('#coupon_message').html(
                    //     '<div class="alert alert-danger">Please enter a coupon code</div>');
                    return;
                }

                $.ajax({
                    url: '{{ route('cart.apply_coupon') }}',
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        coupon_code: couponCode,
                        user_id: userId,
                        sub_total: subTotal,
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            // Show success message
                            // $('#coupon_message').html('<div class="alert alert-success">' +
                            //     response.message + '</div>');

                            // Hide input and show applied coupon
                            $('.coupn_input_wrap').hide();
                            // $('#applied_coupon_section').show();
                            $('.applied-coupon-code').text(couponCode);

                            // Update cart totals
                            if (response.discount) {
                                $('.discount-amount').text('-$' + response.discount.toFixed(2));
                                $('.total-amount').text('$' + response.new_total.toFixed(2));
                            }
                            Swal.fire({
                                icon: 'success',
                                title: 'Erfolg',
                                text: response.message,
                                confirmButtonColor: '#5BC0DE',
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.reload();
                                }
                            });
                            // window.location.reload()
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Fehler',
                                text: response.message,
                                confirmButtonColor: '#5BC0DE',
                            })
                            // $('#coupon_message').html('<div class="alert alert-danger">' +
                            //     response.message + '</div>');

                        }
                    },
                    error: function(xhr) {
                        Swal.fire({
                                icon: 'error',
                                title: 'Fehler',
                                text: 'Ein Fehler ist aufgetreten. Bitte versuchen Sie es erneut.',
                                confirmButtonColor: '#5BC0DE',
                            })
                        // $('#coupon_message').html(
                        //     '<div class="alert alert-danger">An error occurred. Please try again.</div>'
                        // );
                    }
                });
            });

            // Remove coupon handler
            $(document).on('click', '.remove-coupon-btn', function() {
    // Store the button element in case we need it later
    var $removeButton = $(this);
    
    Swal.fire({
        title: "{{ __('messages.remove_voucher_title') }}",
        text: "{{ __('messages.remove_voucher_text') }}",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#5BC0DE',
        cancelButtonColor: '#919191ad',
        confirmButtonText: "{{ __('messages.remove_voucher_confirm') }}",
        cancelButtonText: "{{ __('messages.remove_voucher_cancel') }}"
    }).then((result) => {
        if (result.isConfirmed) {
            // User confirmed - proceed with removal
            var userId = $('#cart_userId').val();
            var itemId = $removeButton.data('item_id');

            // Show loading state
            $removeButton.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Removing...');

            $.ajax({
                url: '{{ route("cart.remove_single_coupon") }}', // Make sure this route is correct
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    user_id: userId,
                    item_id: itemId,
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Erfolg',
                            text: response.message,
                            confirmButtonColor: '#5BC0DE',
                        }).then(() => {
                            // Refresh the page or update UI as needed
                            window.location.reload();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Fehler',
                            text: response.message,
                            confirmButtonColor: '#5BC0DE',
                        });
                        $removeButton.prop('disabled', false).html('Remove');
                    }
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Fehler',
                        text: 'Ein Fehler ist aufgetreten. Bitte versuchen Sie es erneut.',
                        confirmButtonColor: '#5BC0DE',
                    });
                    $removeButton.prop('disabled', false).html('Remove');
                }
            });
        }
    });
});

$('#terms_checkbox').change(function () {
    if ($(this).is(':checked')) {
        const addresses = new Set();
        const pickupDates = new Set();
        const dropoffDates = new Set();
        let pickupTimes = new Set();
        let dropoffTimes = new Set();

        $('.cart-address').each(function () {
            addresses.add($(this).val().trim());
        });

        $('.cart-pickup-date').each(function () {
            pickupDates.add($(this).val().trim());
        });

        $('.cart-dropoff-date').each(function () {
            dropoffDates.add($(this).val().trim());
        });

       

        if (addresses.size > 1) {
            $('#terms_checkbox').prop('checked', false);
            $('#checkout_btn').addClass('disabled');
            $('#addressMismatchModal').modal('show');
        } 
        else if (pickupDates.size > 1) {
            $('#terms_checkbox').prop('checked', false);
            $('#checkout_btn').addClass('disabled');
            $('#pickupDateMismatchModal').modal('show');
        }
        else if (dropoffDates.size > 1) {
            $('#terms_checkbox').prop('checked', false);
            $('#checkout_btn').addClass('disabled');
            $('#dropoffDateMismatchModal').modal('show');
        }
        
        else {
            
            let sameDateSameTime = false;
            let combos = new Set();

            $('.cart-pickup-date').each(function (index) {
                let pickupDate = $(this).val();
                let pickupTime = $('.cart-pickup-time').eq(index).val();
                let dropoffDate = $('.cart-dropoff-date').eq(index).val();
                let dropoffTime = $('.cart-dropoff-time').eq(index).val();

                if (pickupDate === dropoffDate && pickupTime === dropoffTime) {
                    sameDateSameTime = true;
                    return false; // break loop
                }

                let combo = `${pickupDate}|${pickupTime}|${dropoffDate}|${dropoffTime}`;
                if (combos.has(combo)) {
                    sameDateSameTime = true;
                    return false;
                }
                combos.add(combo);
            });

            if (sameDateSameTime) {
                $('#terms_checkbox').prop('checked', false);
                $('#checkout_btn').addClass('disabled');
                $('#sameTimeMismatchModal').modal('show');
                return;
            }
            $('#checkout_btn').removeClass('disabled');

        }
    
    } else {
        $('#checkout_btn').addClass('disabled');
    }
});
        });
    </script>
@endsection
