@extends('layouts.frontend')
@section('content')
<style>#billing_address_select {
    font-size: 15px;
    font-weight: 500;
    height: 45px;
}
</style>
<main>
    
    <div class="navigation-main">
        <div class="container">
            <div class="navigat">
                <a href="{{ route('home') }}">{{ __('messages.nav_home') }}</a>
                <a href="{{ route('product') }}">{{ __('messages.nav_products') }}</a>
                <a class="prod-name active" href="">{{ __('messages.checkout_customer') }}</a>
            </div>     
        </div>
    </div>

    <section class="detail-show-all comn-padd-100">
       
        <div class="container">
            @if($billingAddresses->count() > 0)
            <div class="mb-4">
                <label class="form-label">{{ __('messages.select_billing_address') }}</label>
                <select id="billing_address_select" class="form-select">
                    @foreach($billingAddresses as $address)
                        <option value="{{ $address->id }}" {{ $address->is_default ? 'selected' : '' }}
                            data-email="{{ $address->email }}"
                            data-name="{{ $address->name }}"
                            data-company_name="{{ $address->company_name }}"
                            data-street="{{ $address->street }}"
                            data-zipcode="{{ $address->zipcode }}"
                            data-city="{{ $address->city }}"
                            data-state="{{ $address->state }}"
                            data-phone_code="{{ $address->phone_code ?? '+49' }}"
                            data-contact_number="{{ $address->contact_number }}">
                            {{ $address->name }} - {{ $address->street }}, {{ $address->city }}
                        </option>
                    @endforeach
                </select>
            </div>
        @endif
        <div class="sub_heading_16">{{ __('messages.billing_information') }}</div>

            <div class="row row-gap-3 checkout_page_row">
                <div class="col-lg-8">
                    @php
                     $user = Auth::user();
                    @endphp
                    <form action="{{ route('user.checkout.submit') }}" method="POST">
                    @csrf
                   <div class="row comm_form checkout_form_left">

                       

                        <div class="col-md-12">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.email') }}</label>
                                <input type="email" name="email" class="form-control"
                                    value="{{ old('email', $formValues['email'] ?? '') }}"
                                    placeholder="{{ __('messages.enter_email_address') }}" required>
                            </div>
                        </div>
                        
                    
                        <div class="sub_heading_16">{{ __('messages.user_details') }}</div>
                    
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.first_name') }}</label>
                                <input type="text" name="first_name" class="form-control"
                                    value="{{ old('first_name', $formValues['first_name'] ?? '') }}"
                                    placeholder="{{ __('messages.enter_first_name') }}" required>
                            </div>
                        </div>
                    
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.surname') }}</label>
                                <input type="text" name="last_name" class="form-control"
                                    value="{{ old('last_name', $formValues['last_name'] ?? '') }}"
                                    placeholder="{{ __('messages.enter_surname') }}" required>
                            </div>
                        </div>
                    
                        <div class="col-md-12">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.company_name_optional') }}</label>
                                <input type="text" name="company_name" class="form-control"
                                    value="{{ old('company_name', $formValues['company_name'] ?? '') }}"
                                    placeholder="{{ __('messages.enter_company_name') }}">
                            </div>
                        </div>
                    
                        <div class="col-md-12">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.street_house_number') }}</label>
                                <input type="text" name="address" class="form-control"
                                    value="{{ old('address',$formValues['address']?? '') }}"
                                    placeholder="{{ __('messages.enter_street_house_number') }}" required>
                            </div>
                        </div>
                    
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.zip_code') }}</label>
                                <input type="text" name="zip" class="form-control"
                                    value="{{ old('zip',$formValues['zip'] ?? '') }}"
                                    placeholder="{{ __('messages.enter_zip_code') }}" required>
                                </div>
                        </div>
                    
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.city') }}</label>
                                <input type="text" name="city" class="form-control"
                                    value="{{ old('city', $formValues['city'] ?? '') }}"
                                    placeholder="{{ __('messages.enter_city') }}" required>
                                </div>
                        </div>
                    
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.state_region') }}</label>
                                 <select class="form-select" name="region">
                                    <option value="">{{ __('messages.select_option') }}</option>

                                    @foreach(__('messages.regions') as $key => $label)
                                        <option value="{{ $key }}" {{ old('region', $formValues['region'] ?? '') == $key ? 'selected' : '' }}>
                                            {{ $label }}
                                        </option>
                                    @endforeach
                                </select>
                                
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex profile_title_input">
                                <div class="inner-main-input inner-main-input2 title_inpt">
                                    <label class="form-label">{{ __('messages.phone_code') }}</label>
                                    <select class="form-select country_code_custom" name="phone_code" id="phone_code">
                                        <option value="+49"  data-image="https://flagcdn.com/16x12/de.png" {{ old('phone_code', $formValues['phone_code'] ?? '') == '+49' ? 'selected' : '' }}> +49</option>
                                        <option value="+41" data-image="https://flagcdn.com/16x12/ch.png" {{ old('phone_code', $formValues['phone_code'] ?? '') == '+41' ? 'selected' : '' }}> +41</option>
                                        <option value="+43"  data-image="https://flagcdn.com/16x12/at.png"{{ old('phone_code', $formValues['phone_code'] ?? '') == '+43' ? 'selected' : '' }}>+43</option>
                                    </select>
                                </div>
                                
                                <div class="inner-main-input inner-main-input2">
                                    <label class="form-label">{{ __('messages.phone_number') }}</label>
                                    <input type="tel" name="phone_number" class="form-control"
                                        value="{{ old('phone_number', $formValues['phone_number'] ?? '') }}"
                                        placeholder="{{ __('messages.enter_phone_number') }}" required>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- <div class="d-flex form-check checkout_email_check ">
                        <input class="form-check-input" type="checkbox" id="gridCheck2">
                        <label class="form-check-label" for="gridCheck2">
                            <p class="default_text">Create Customer Account</p>
                        </label>
                    </div> --}}



                    


                </div>
                <div class="col-lg-4">
                    <div class="cart_total_right_col">
                        <div class="sub_heading_18">{{ __('messages.cart_totals') }}</div>

                        <div class="d-flex comm_detail_list_view cart_total_list">
                            <div class="comm_detail_list_col">
                                <h5>{{ __('messages.subtotal') }}:</h5>
                                <h6>{{ number_format($subtotal, 2, ',', '') }} €</h6>
                            </div>
                            <div class="comm_detail_list_col">
                                <h5>{{ __('messages.discount') }}:</h5>
                                <h6>{{ number_format($discount, 2,',', '') }} €</h6>
                            </div>
                            <div class="comm_detail_list_col">
                                <h5>{{ __('messages.net_price') }}:</h5>
                                <h6>{{ number_format($netPrice, 2,',','') }} €</h6>
                            </div> 
                            <div class="comm_detail_list_col">
                                <h5>{{ __('messages.net_price_insurance') }}:</h5>

                                <h6>{{ number_format($insuranceTotal, 2 , ',','') }} €</h6>
                            </div>
                            <div class="comm_detail_list_col">
                                <h5>{{ __('messages.tax_19') }}:</h5>

                                <h6>{{ number_format($tax, 2, ',', '') }} €</h6>
                            </div>                                      
                            <div class="comm_detail_list_col bott_total_row">
                                <h5>{{ __('messages.total') }}:</h5>

                                <h6>{{ number_format($total, 2,',','') }} €</h6>
                            </div> 
                        </div>
                      
                        <button type="submit" class="btn primary-btn primary-btn2 w-100 mt-3">
                            {{ __('messages.book_now') }}
                        </button>
                        

                        
                    </div>
                </div>
            </div>
        </form>
        </div>
    </section>

</main>

<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

<script>
    $(document).ready(function() {
        $("#calendar-box").datepicker({});
    });

    // date input js

    document.addEventListener("DOMContentLoaded", function() {
        const dateInputs = document.querySelectorAll(".date-input");

        dateInputs.forEach((input) => {
            input.addEventListener("click", function() {
                this.showPicker();
            });
        });
    });
</script>

<script>
    $(document).ready(function() {

        $('input[name="email"], input[name="first_name"], input[name="last_name"], input[name="company_name"], input[name="address"], input[name="zip"], input[name="city"], select[name="region"], select[name="phone_code"], input[name="phone_number"]').on('change input', function() {
    const name = $(this).attr('name');
    const value = $(this).val();

    $('input[type="hidden"][name="' + name + '"]').val(value);
});


        $('input[name="payment_method"]').change(function() {
            $('#selected_payment_method').val($(this).val());
        });
    
        $('#checkoutForm').submit(function(e) {
            e.preventDefault();
            
            if (!validateForm()) {
                return false;
            }
    
            $(this).find('button[type="submit"]').prop('disabled', true).html('Processing...');
    
            this.submit();
        });
    
        function validateForm() {
            let isValid = true;
            $('.is-invalid').removeClass('is-invalid');
            $('.invalid-feedback').remove();
    
            const requiredFields = [
                'email', 'first_name', 'last_name', 'address', 
                'zip', 'city', 'phone_number'
            ];
    
            requiredFields.forEach(field => {
                if (!$(`[name="${field}"]`).val()) {
                    $(`[name="${field}"]`).addClass('is-invalid')
                        .after(`<div class="invalid-feedback">This field is required</div>`);
                    isValid = false;
                }
            });
    
            const email = $('[name="email"]').val();
            if (email && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) {
                $('[name="email"]').addClass('is-invalid')
                    .after(`<div class="invalid-feedback">Please enter a valid email</div>`);
                isValid = false;
            }
    
            if (!isValid) {
                $('html, body').animate({
                    scrollTop: $('.is-invalid').first().offset().top - 100
                }, 500);
            }
    
            return isValid;
        }
    });
    </script>

<script>
        function formatFlag(option) {
            if (!option.id) return option.text;
            const imageUrl = $(option.element).data('image');
            const text = option.text;
            if (imageUrl) {
                return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
            }
            return text;
        }
        $(document).ready(function() {
    $('#billing_address_select').on('change', function() {
            const selected = $(this).find(':selected');
            
            // Split the name into first and last name
            const fullName = selected.data('name') || '';
            const nameParts = fullName.split(' ', 2);
            const firstName = nameParts[0] || '';
            const lastName = nameParts.length > 1 ? nameParts[1] : '';
            
            // Update form fields
            $('input[name="email"]').val(selected.data('email') || '');
            $('input[name="first_name"]').val(firstName);
            $('input[name="last_name"]').val(lastName);
            $('input[name="company_name"]').val(selected.data('company_name') || '');
            $('input[name="address"]').val(selected.data('street') || '');
            $('input[name="zip"]').val(selected.data('zipcode') || '');
            $('input[name="city"]').val(selected.data('city') || '');
            $('select[name="region"]').val(selected.data('state') || '');
            
            // Handle phone number and code
            const contactNumber = selected.data('contact_number') || '';
            const phoneCode = selected.data('phone_code') || '+49';
            $('select[name="phone_code"]').val(phoneCode).trigger('change');
            
            // Extract just the phone number (without country code)
            const phoneNumber = contactNumber.replace(phoneCode, '');
            $('input[name="phone_number"]').val(phoneNumber);
        });

        // Initialize Select2 for phone code
        $('#phone_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });
        
        // Trigger change on page load if there's a selected address
        if ($('#billing_address_select').find(':selected').length > 0) {
            $('#billing_address_select').trigger('change');
        }
    });
    
        $(document).ready(function () {
            $('#phone_code').select2({
                templateResult: formatFlag,
                templateSelection: formatFlag,
                minimumResultsForSearch: -1 
            });
        });
    </script>

@endsection