<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="csrf-token" content="{{ csrf_token() }}">

  <title>Dachboxmiete</title>

  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@200..800&family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

  <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@200..800&family=Montserrat:ital,wght@0,100..900;1,100..900&family=Oswald:wght@200..700&display=swap" rel="stylesheet">

  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">


  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">


  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css">
  <link rel="stylesheet" href="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.css" />
  <!-- ===============owl============ -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.css">

  <link rel="stylesheet" href="{{ asset('frontend/css/main.css') }}">
  <link rel="stylesheet" href="{{ asset('frontend/css/responsive.css') }}">
  <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script> 
  <script src="{{ asset('frontend/js/main.js') }}"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  @yield('style')
</head>
<header>
  <div class="top-header">
    <img src="{{ asset('frontend/images/google-img.svg') }}" alt="Google Logo">
    <p>{{__('messages.overall')}} <span class="txt-600">{{__('messages.rating')}}</span></p>
    <div class="icon">
      <i class="fa-solid fa-star"></i>
      <i class="fa-solid fa-star"></i>
      <i class="fa-solid fa-star"></i>
      <i class="fa-solid fa-star"></i>
      <i class="fa-solid fa-star"></i>
    </div>
    <p><span class="txt-600">5.0</span> {{ __('messages.out_of') }} <span class="txt-600">5</span>, {{ __('messages.based_on') }} <span class="txt-600">{{ GetMetaData('total_reviews', 'home') }}  {{ __('messages.reviews') }}</span></p>

  </div>


  <div class="main-header">
    <nav class="navbar navbar-expand-lg navbar-light bg-light">
      <a class="navbar-brand" href="{{ route('home') }}"><img src="{{ asset('frontend/images/logo.svg') }}" alt=""></a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNavAltMarkup" aria-controls="navbarNavAltMarkup" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="menu collapse navbar-collapse" id="navbarNavAltMarkup">
        <div class="navbar-nav">
          <a class="nav-item nav-link active" href="{{ route('home') }}">{{ __('messages.home') }} <span class="sr-only">(current)</span></a>
          @if(getHeaderLink('about-us'))
          <a class="nav-item nav-link" href="{{ route('about') }}">{{ GetMetaData('page_title','about-us') }}</a>
          @endif
          <a class="nav-item nav-link" href="{{ route('product') }}">{{ __('messages.products') }}</a>
          <a class="nav-item nav-link" href="{{ route('blog') }}">{{ __('messages.blog') }}</a>
          
          @if(getHeaderLink('how-to'))
          <a class="nav-item nav-link" href="{{ route('howto') }}">{{ GetMetaData('page_title','how-to') }}</a>
          @endif
          @if(getHeaderLink('Impressum'))
           <a class="nav-item nav-link" href="{{ route('impresusm') }}">{{ GetMetaData('page_title','Impressum') }}</a>
          @endif
          @if(getHeaderLink('term-condition'))
          <a class="nav-item nav-link" href="{{ route('termcondition') }}">{{ GetMetaData('page_title','term-condition') }}</a>
          @endif
          @if(getHeaderLink('return-process'))
          <a class="nav-item nav-link" href="{{ route('returnprocess') }}">{{ GetMetaData('page_title','return-process') }}</a>
          @endif
          @if(getHeaderLink('withdrawal-right'))
          <a class="nav-item nav-link" href="{{ route('withdrawlrights') }}">{{ GetMetaData('page_title','withdrawal-right') }}</a>
          @endif
          @if(getHeaderLink('gdpr'))
          <a class="nav-item nav-link" href="{{ route('gdpr') }}">{{ GetMetaData('page_title','gdpr') }}</a>
          @endif
        </div>
      </div>
      <div class="he-btn-gp">
        <a href="{{route('getquote')}}" class=" btn primary-btn">{{__('messages.get_a_quote')}}</a>
      
        <button type="submit" class="search-btn" id="search-form">
          <img src="{{ asset('frontend/images/search-icon.svg') }}" alt="Search" style="width: 24px">
        </button>
        <a href="{{ route('cart.index') }}" class="header-icon position-relative">
            <img src="{{ asset('frontend/images/cart-icon.svg') }}" alt="" style="width: 24px">
            <span class="cart-count-badge position-absolute top-0 start-100 translate-middle badge" >
                0
            </span>
        </a>
        @if(Auth::check())
        <a href="{{route('user.index')}}" class="header-icon user-icon">
          <img src="{{ asset('frontend/images/user-icon.svg') }}" alt="">
        </a>
        @else
        <a href="{{ route('login') }}" class="btn primary-btn">{{__('messages.login')}}</a>
        @endif

      </div>
    </nav>
  </div>
  <div class="modal search-form d-none" tabindex="-1">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Search</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="search-modal-close"></button>
        </div>
        <div class="modal-body">
          <div class="search-container">
            <form class="search-form">
              <input type="text" class="search-input" placeholder="Search products..." autocomplete="off">
             
            </form>
            <div class="search-results-dropdown"></div>
          </div>
        </div>
    
      </div>
    </div>
  </div>
</header>
<script>
    window.searchRoute = "{{ route('user.search') }}";

    $('#search-form').click(function(){
      $('.search-form').removeClass('d-none');
    })
    $('#search-modal-close').click(function(){
      $('.search-form').addClass('d-none');
    })
</script>