<section class="news-letter-back">
    <div class="back-imges">
        <img class="left-arow-news" src="{{ asset('frontend/images/LEFT-AROW.png') }}" alt="">
        <img class="right-arow-news" src="{{ asset('frontend/images/right-arrow.png') }}" alt="">
    </div>
    <div class="container">
        <div class="inner-news-lettr">
            <h3>{{ __('messages.subscribe_newsletter') }}</h3>
            <p>{{ __('messages.subscribe_newsletter_text') }}</p>
                <form class="row comm_form profile_newsletter_form" method="POST" action="{{ route('user.newsletter.subscribe') }}">
                    @csrf
            <div class="input-subscribe p-0">
                <input type="text" name="email" placeholder="{{ __('messages.enter_your_email_here') }}">

                <button type="submit" class="subscribe-btn">{{ __('messages.subscribe') }}</button>

            </div>
            <div id="newsletter-error" class="text-danger text-center" style="display: none;"></div>
        </form>
        </div>
    </div>
</section>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const form = document.querySelector('.profile_newsletter_form');
        const emailInput = form.querySelector('input[name="email"]');
        const errorContainer = document.getElementById('newsletter-error');
    
        form.addEventListener('submit', function (e) {
            const emailValue = emailInput.value.trim();
    
            emailInput.classList.remove('is-invalid');
            errorContainer.style.display = 'none';
            errorContainer.textContent = '';
    
            if (!emailValue) {
                e.preventDefault();
                emailInput.classList.add('is-invalid');
                errorContainer.textContent = 'Please enter your email address';
                errorContainer.style.display = 'block';
                return;
            }
    
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailRegex.test(emailValue)) {
                e.preventDefault();
                emailInput.classList.add('is-invalid');
                errorContainer.textContent = 'Please enter a valid email address';
                errorContainer.style.display = 'block';
            }
        });
    });
    </script>