@extends('layouts.frontend')
@section('content')
<main>

    <section class="banner-back-img-about">
        <div class="inner-main-img">
            <div class="container">
                <div class="inner-banner-comn">
                <h1>{{ GetMetaData('page_title','about-us') }}</h1>
                </div>
            </div>
        </div>
    </section>

    <section class="comn-padd contact-about">
        <div class="container">
            <div class="inner-main-about-page">
                <div class="row row-gap-4">
                    <div class="col-md-6">
                        <figure class="img-main-fig">
                            <img src="{{ asset('storage/'.GetMetaData('image',$page_type)) }}" alt="">
                        </figure>
                    </div>
                    <div class="col-md-6">
                        <div class="inner-about-section">
                            
                            <h2>{{ GetMetaData('page_title','about-us') }}</h2>
                            <p class="main-descript-para">{!! GetMetaData('description',$page_type) !!} </p>

                            <div class="main-info-number">
                                <h5>{{ GetMetaData('sub_title',$page_type) }}</h5>
                                <div class="main-all d-flex">
                                    <img src="{{ asset('frontend/images/email-pic.png') }}" alt="">
                                    <a href="mailto:info@dachboxmiete-stuttgart.de">{{ GetMetaData('email',$page_type) }}</a>
                                </div>
                                <div class="main-all d-flex">
                                    <img src="{{ asset('frontend/images/phone-pic.png') }}" alt="">
                                    <a href="tel:+4915172876293">{{ GetMetaData('number',$page_type) }}</a>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>


    </section>

    <section class="our-booking-process">
        <div class="container">
            <div class="inner-booking-head">
                <h2>{{ GetMetaData('booking_title', 'home') }}</h2>
            </div>
            <div class="inner">
            <div class="steps-process-book d-flex justify-content-between">
                <div class="dots-process">
                    <div class="first-process">
                        <img src="{{ asset('frontend/images/Frame.png') }}" alt="">
                    </div>
                </div>
                <div class="dots-process">
                    <div class="first-process">
                        <img src="{{ asset('frontend/images/Group.png') }}" alt="">
                    </div>
                </div>

                <div class="dots-process">
                    <div class="first-process">
                        <img src="{{ asset('frontend/images/Frame (3).png') }}" alt="">
                    </div>
                </div>

                <div class="dots-process">
                    <div class="first-process">
                        <img src="{{ asset('frontend/images/Frame (1).png') }}" alt="">
                    </div>
                </div>

                <div class="dots-process">
                    <div class="first-process">
                        <img src="{{ asset('frontend/images/Frame (2).png') }}" alt="">
                    </div>
                </div>
            </div>

            <div class="cards-main-all d-flex">
                <div class="upper-padd-all">
                    <div class="first-card-quote">
                        <h5>{{ GetMetaData('booking_step_1_title', 'home') }}</h5>
                        <p>{{ GetMetaData('booking_step_1_description', 'home') }}</p>
                        <a href="">{{ __('messages.learn_more') }}</a>
                    </div>
                </div>
                <div class="upper-padd-all">
                    <div class="first-card-quote">
                        <h5>{{ GetMetaData('booking_step_2_title', 'home') }}</h5>
                        <p>{{ GetMetaData('booking_step_2_description', 'home') }}</p>
                        <a href="">{{ __('messages.learn_more') }}</a>
                    </div>
                </div>
                <div class="upper-padd-all">
                    <div class="first-card-quote">
                        <h5>{{ GetMetaData('booking_step_3_title', 'home') }}</h5>
                        <p>{{ GetMetaData('booking_step_3_description', 'home') }}</p>
                        <a href="">{{ __('messages.learn_more') }}</a>
                    </div>
                </div>
                <div class="upper-padd-all">
                    <div class="first-card-quote">
                        <h5>{{ GetMetaData('booking_step_4_title', 'home') }}</h5>
                        <p>{{ GetMetaData('booking_step_4_description', 'home') }}</p>
                        <a href="">{{ __('messages.learn_more') }}</a>
                    </div>
                </div>
                <div class="upper-padd-all">
                    <div class="first-card-quote">
                        <h5>{{ GetMetaData('booking_step_5_title', 'home') }}</h5>
                        <p>{{ GetMetaData('booking_step_5_description', 'home') }}</p>
                        <a href="">{{ __('messages.learn_more') }}</a>
                    </div>
                </div>
            </div>
            </div>
        </div>
    </section>

    <section class="touch-with-us comn-padd">
        <div class="container">
            <div class="inner-touch-contact">
                <div class="row">
                    <div class="col-md-6">
                        <div class="inner-form-touch">
                            <h2>{{ GetMetaData('contact_title',$page_type) }}</h2>

                            <form class="row" id="contactForm" method="post" action="{{ route('contact.store') }}">
                                @csrf
                            
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="name" class="form-label">{{ __('messages.name') }}</label>
                                        <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" placeholder="{{ __('messages.enter_your_name') }}" value="{{ old('name') }}">
                                        @error('name')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="email" class="form-label">{{ __('messages.email') }}</label>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror" placeholder="{{ __('messages.enter_your_email') }}" id="email" name="email" value="{{ old('email') }}">
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="contact-number" class="form-label">{{ __('messages.contact_number') }}</label>
                                        <input type="tel" class="form-control @error('number') is-invalid @enderror" placeholder="{{ __('messages.enter_your_contact_number') }}" id="contact-number" name="number" value="{{ old('number') }}">
                                        @error('number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="message" class="form-label">{{ __('messages.message') }}</label>
                                        <textarea class="form-control @error('message') is-invalid @enderror" placeholder="{{ __('messages.leave_a_comment') }}" id="message" name="message" style="height: 135px">{{ old('message') }}</textarea>
                                        @error('message')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            
                                <div class="col-12">
                                    <button type="submit">{{ __('messages.send_message') }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="inner-figure-contact">
                            <figure class="fig-main-img-touch">
                                <img src="{{ asset('frontend/images/touch.png')}}" alt="">
                            </figure>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @include('frontend.include.subscribe_news')
</main>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        const errorField = document.querySelector('.is-invalid');
        if (errorField) {
            errorField.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }
    });
    </script>
@endsection

