@extends('layouts.frontend')
@section('content')
<main>

<div class="navigation-main">
    <div class="container">
        <div class="navigat">
            <a href="/">{{ __('messages.home') }}</a>
            <a href="{{ route('blog') }}">{{ __('messages.blog') }}</a>
            <a class="prod-name active">{{ \Illuminate\Support\Str::limit($blog->title, 25, '...') }}</a>
        </div>
    </div>
</div>

<section class="comn-padd">
    <div class="container">
        <div class="main-img-detail">
            <figure>
                <img src="{{ asset('storage/'.$blog->image) }}" alt="">
            </figure>
        </div>
        <div class="upper-name-and-date detail-main-blog d-flex">
            <div class="date-news d-flex">
                <img src="{{ asset('storage/'.$admin->image) }}" alt="">
                <p>{{ $admin->first_name . ' ' . $admin->last_name }}</p>
            </div>
            <div class="date-news d-flex">
                <i class="fa-regular fa-calendar"></i>
                <p>{{ $blog->created_at->format('d.m.Y') }}</p>
            </div>
        </div>

        <div class="detail-main-all-blog">
        {!! $blog->description !!}
        </div>
    </div>
</section>


<section class="comn-padd pt-0">
    <div class="container">
        <div class="main-also-like">
            <h2>{{ __('messages.you_may_also_like') }}</h2>
            <div class="row row-gap-3">
                @foreach($randomBlog as $rand)
                <div class="col-4">
                    <a href="{{route('blogDetails',$rand->slug)}}">
                    <div class="latest-news-card">
                        <figure>
                            <img src="{{ asset('storage/'.$rand->image) }}" alt="">
                        </figure>
                        <div class="card-detail-price">

                            <div class="upper-name-and-date d-flex">
                                <div class="date-news d-flex">
                                    <i class="fa-regular fa-calendar"></i>
                                    <p>{{ $rand->created_at->format('d.m.Y') }}</p>
                                </div>
                                <div class="date-news d-flex">
                                    <i class="fa-regular fa-user"></i>
                                    <p>{{ __('messages.by') }}  {{ $admin->first_name . ' ' . $admin->last_name }}</p>
                                </div>
                            </div>
                            <h3>{{ \Illuminate\Support\Str::limit($rand->title, 25, '...') }}</h3>
                            <p class="discript-news-articel">
                            {!! substr($rand->description, 0, 200) . '...' !!}
                            </p>

                            <a class="view-more-news-card" href="{{route('blogDetails',$rand->slug)}}">{{ __('messages.view_more') }}</a>
                        </div>
                    </div>
                </a>
                </div>
                @endforeach
               
            </div>
        </div>
    </div>
</section>
</main>
@endsection