@extends('layouts.frontend')
@section('content')
<main>

    <section class="banner-back-img-blog-list">
        <div class="inner-main-img">
            <div class="container">
                <div class="inner-banner-comn">
                    <h1>{{ __('messages.blog_listing') }}</h1>
                </div>
            </div>
        </div>
    </section>

    <section class="comn-padd">
        <div class="container">

            <div class="row row-gap-3">
                @foreach($blogs as $blog)
                <div class="col-sm-6 col-md-4">
                        <a href="{{route('blogDetails',$blog->slug)}}">
                        <div class="latest-news-card">
                            <figure>
                                <img src="{{ asset('storage/'.$blog->image) }}" alt="">
                            </figure>
                            <div class="card-detail-price">

                                <div class="upper-name-and-date d-flex">
                                    <div class="date-news d-flex">
                                        <i class="fa-regular fa-calendar"></i>
                                        <p>{{ $blog->created_at->format('d.m.Y') }}</p>
                                    </div>
                                    <div class="date-news d-flex">
                                        <i class="fa-regular fa-user"></i>
                                        <p>{{ __('messages.by') }} {{ $admin->first_name . ' ' . $admin->last_name }}</p>
                                    </div>
                                </div>
                                <h3>{{ \Illuminate\Support\Str::limit($blog->title, 25, '...') }}</h3>
                                <p class="discript-news-articel">
                                    {!! substr($blog->description, 0, 200) . '...' !!}
                                </p>
                                <a class="view-more-news-card" href="{{route('blogDetails',$blog->slug)}}">{{ __('messages.view_more') }}</a>
                            </div>

                        </div>

                    </a>
                    </div>
                @endforeach


            </div>
        </div>
    </section>


</main>
@endsection