@extends('layouts.frontend')
@section('content')
<main>
    <section class="hero">
        <div class="owl-carousel hero-slider">
            <div class="item">
                <div class="inner-crousel-banner"
                style="background-image: url('{{ asset('frontend/images/heroimg.png') }}');">
                    <div class="inner-box-shad">
                        <div class="container">
                            <div class="cont-wrap typography">
                                <h1>{{ GetMetaData('hero_title', 'home') }}</h1>
                                <ul class="hero-list">
                                    <li>
                                        <div class="icon"><i class="fa-solid fa-check"></i></div>
                                        <p>{{ GetMetaData('hero_feature_1', 'home') }}</p>
                                    </li>
                                    <li>
                                        <div class="icon"><i class="fa-solid fa-check"></i></div>
                                        <p>{{ GetMetaData('hero_feature_2', 'home') }}</p>
                                    </li>
                                    <li>
                                        <div class="icon"><i class="fa-solid fa-check"></i></div>
                                        <p>{{ GetMetaData('hero_feature_3', 'home') }}</p>
                                    </li>
                                    <li>
                                        <div class="icon"><i class="fa-solid fa-check"></i></div>
                                        <p>{{ GetMetaData('hero_feature_4', 'home') }}
                                        <div class="icon-inner">
                                            <i class="fa-solid fa-star"></i>
                                            <i class="fa-solid fa-star"></i>
                                            <i class="fa-solid fa-star"></i>
                                            <i class="fa-solid fa-star"></i>
                                            <i class="fa-solid fa-star"></i>
                                        </div>
                                        </p>
                                    </li>
                                    <li>
                                        <div class="icon"><i class="fa-solid fa-check"></i></div>
                                        <p>{{ GetMetaData('hero_feature_5', 'home') }}</p>
                                    </li>
                                    <li>
                                        <div class="icon"><i class="fa-solid fa-check"></i></div>
                                        <p>{{ GetMetaData('hero_feature_6', 'home') }}</p>
                                    </li>
                                    <li>
                                        <div class="icon"><i class="fa-solid fa-check"></i></div>
                                        <p>{{ GetMetaData('hero_feature_7', 'home') }}</p>
                                    </li>
                                    <li>
                                        <div class="icon"><i class="fa-solid fa-check"></i></div>
                                        <p>{{ GetMetaData('hero_feature_8', 'home') }}</p>
                                    </li>
                                </ul>
                                <div class="hero-btn">
                                    <a href="{{route('getquote')}}" class="primary-btn">{{__('messages.get_a_quote')}}</a>

                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>


        </div>
    </section>

    <section class="sec-120 our-product typography">
        <div class="container">
            <div class="cont-wrap">
                <h2 class="our-prod-main">{{ GetMetaData('products_title', 'home') }}</h2>
                <div class="pro-div">
                    @foreach ($products as $product)
                    <div class="pro-item">
                        <a href="{{ route('product.details', $product->category->slug) }}">
                            <img src="{{ $product->homePhoto?->image_path ? asset('storage/' . $product->homePhoto->image_path) : asset('frontend/images/placeholder.png') }}" alt="{{ $product->name }}">
                        </a>
                        <div class="content">
                            <a href="{{ route('product.details', $product->category->slug) }}" class="btn rent-btn">
                                <p class="p-18">{{ $product->name }}</p>
                            </a>
                        </div>
                    </div>
                    @endforeach
                   
                </div>
            </div>
        </div>
    </section>


    <section class="iner-roof-rack">
        <div class="roof-rack typography">
            <div class="container">
                <div class="cont-wrap main-text-roof-rack">
                    <h2>{{ GetMetaData('roof_rack_title', 'home') }}</h2>
                    <p>{!! GetMetaData('roof_rack_description', 'home') !!}</p>
                    <a href="{{route('product')}}" class="primary-btn">{{ GetMetaData('roof_rack_button_text', 'home') }}</a>
                </div>
            </div>
        </div>
    </section>

    <section class="our-booking-process">
        <div class="container">
            <div class="inner-booking-head">
                <h2>{{ GetMetaData('booking_title', 'home') }}</h2>
            </div>
            <div class="inner">
            <div class="steps-process-book d-flex justify-content-between">
                <div class="dots-process">
                    <div class="first-process">
                        <img src="{{ asset('frontend/images/Frame.png') }}" alt="">
                    </div>
                </div>
                <div class="dots-process">
                    <div class="first-process">
                        <img src="{{ asset('frontend/images/Group.png') }}" alt="">
                    </div>
                </div>

                <div class="dots-process">
                    <div class="first-process">
                        <img src="{{ asset('frontend/images/Frame (3).png') }}" alt="">
                    </div>
                </div>

                <div class="dots-process">
                    <div class="first-process">
                        <img src="{{ asset('frontend/images/Frame (1).png') }}" alt="">
                    </div>
                </div>

                <div class="dots-process">
                    <div class="first-process">
                        <img src="{{  asset('frontend/images/Frame (2).png') }}" alt="">
                    </div>
                </div>
            </div>
            <div class="cards-main-all d-flex">
                <div class="upper-padd-all">
                    <div class="first-card-quote">
                        <h5>{{ GetMetaData('booking_step_1_title', 'home') }}</h5>
                        <p>{{ GetMetaData('booking_step_1_description', 'home') }}</p>
                        <a href="">{{ __('messages.learn_more') }}</a>
                    </div>
                </div>
                <div class="upper-padd-all">
                    <div class="first-card-quote">
                        <h5>{{ GetMetaData('booking_step_2_title', 'home') }}</h5>
                        <p>{{ GetMetaData('booking_step_2_description', 'home') }}</p>
                        <a href="">{{ __('messages.learn_more') }}</a>
                    </div>
                </div>
                <div class="upper-padd-all">
                    <div class="first-card-quote">
                        <h5>{{ GetMetaData('booking_step_3_title', 'home') }}</h5>
                        <p>{{ GetMetaData('booking_step_3_description', 'home') }}</p>
                        <a href="">{{ __('messages.learn_more') }}</a>
                    </div>
                </div>
                <div class="upper-padd-all">
                    <div class="first-card-quote">
                        <h5>{{ GetMetaData('booking_step_4_title', 'home') }}</h5>
                        <p>{{ GetMetaData('booking_step_4_description', 'home') }}</p>
                        <a href="">{{ __('messages.learn_more') }}</a>
                    </div>
                </div>
                <div class="upper-padd-all">
                    <div class="first-card-quote">
                        <h5>{{ GetMetaData('booking_step_5_title', 'home') }}</h5>
                        <p>{{ GetMetaData('booking_step_5_description', 'home') }}</p>
                        <a href="">{{ __('messages.learn_more') }}</a>
                    </div>
                </div>
            </div>
         </div>
        </div>
    </section>


    <section class="google-reviews">
        <div class="container">
            <div class="inner-review">
                <div class="inner-booking-head">
                    <h2>{{ GetMetaData('title_testimonial   ', 'home') }}</h2>
                </div>
                <div class="crousel-mian-reviews">
                    <div class="review-wrapper owl-carousel">
                        @php
                        use App\Models\PageMetaTag;
                          
                            $testimonials = PageMetaTag::where('type', 'home')
        ->where('key', 'like', 'testimonial_%')
        ->get()
        ->groupBy(function ($item) {
            preg_match('/testimonial_(\d+)_/', $item->key, $matches);
            return $matches[1] ?? 0;
        })
        ->map(function ($group, $index) {
            // Reconstruct the original keys with values
            $result = [];
            foreach ($group as $item) {
                $result[$item->key] = $item->key_value;
            }
            return $result;
        })
        ->toArray();
        @endphp
      
                        @foreach($testimonials as $index => $testimonial)
                        <div class="item h-100">
                            <div class="review-one h-100">
                                <div class="wrapper-goog-logo">
                                    <div class="name-img d-flex">
                                        <img src="{{ asset('storage/'.$testimonial['testimonial_'.$index.'_avatar']) }}" alt="">
                                        <div class="name-date">
                                            <h6>{{ $testimonial['testimonial_'.$index.'_name'] ?? '' }}</h6>
                                            <p>{{ \Carbon\Carbon::parse($testimonial['testimonial_'.$index.'_date'] ?? '')->format('F j, Y') }}</p>
                                        </div>
                                    </div>
                                    <img class="googl-logo" src="{{ asset('frontend/images/google.png') }}" alt="">

                                </div>
                                <div class="icon icon-google-review">
                                    @php
                                        $rating = $testimonial['testimonial_'.$index.'_rating'] ?? 0;
                                    @endphp
                                    @for ($i = 0; $i < $rating; $i++)
                                    <i class="fa-solid fa-star"></i>
                                    @endfor
                                    
                                   
                                </div>
                                <p class="revew-datail">{{ $testimonial['testimonial_'.$index.'_content']??"" }}</p>

                            </div>
                        </div>
                        @endforeach
                       
                    </div>
                    <div class="top-header main-head-all">
                        <img src="{{ asset('frontend/images/google-img.svg') }}" alt="">
                        <p>{{__('messages.overall')}} <span class="txt-600">{{__('messages.rating')}}</span></p>
                        <div class="icon">
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                        </div>


                        <p><span class="txt-600">5.0</span> {{ __('messages.out_of') }} <span class="txt-600">5</span>, {{ __('messages.based_on') }} <span 
                            class="txt-600">{{ GetMetaData('total_reviews', 'home') }}   {{ __('messages.reviews') }}</span></p>

                    </div>
                </div>
            </div>
        </div>
    </section>


</main>

@endsection
