<!-- Rental Price Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered our-rental-price">
        <div class="modal-content">
            <div class="modal-body">
                <div class="inner-body-price">
                    <h3>{{ __('messages.our_rental_price') }}</h3>
                    <div class="upper-table-main-pop">
                        <table>
                            <tr>
                                <th>{{ __('messages.days') }}</th>
                                <th>{{ __('messages.price') }}</th>
                            </tr>
                            @foreach($dailyPrices as $index => $price)
                                <tr>
                                    <td>{{ __('messages.day_label', ['number' => $index + 1]) }}</td>
                                    <td>{{ number_format($price, 2, ',', '.') }} €</td>
                                </tr>
                            @endforeach
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade modal-not-book" id="railingType" tabindex="-1" aria-labelledby="notBookableLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notBookableLabel">Attention</h5>
                <p>Please check the railing type first.</p>
                <button type="button" class="btn primary-btn" data-bs-dismiss="modal">{{ __('messages.ok') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Not Bookable Modal -->
<div class="modal fade modal-not-book" id="notBookableModal" tabindex="-1" aria-labelledby="notBookableLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notBookableLabel">{{ __('messages.not_bookable_title') }}</h5>
                <p>{{ __('messages.not_bookable_message') }}</p>
                <button type="button" class="btn primary-btn" data-bs-dismiss="modal">{{ __('messages.ok') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Carrier Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notCarrier" tabindex="-1" aria-labelledby="notCarrier" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notCarrier">{{ __('messages.carrier_disclaimer_title') }}</h5>
                <p>{{ __('messages.carrier_disclaimer_message') }}</p>
                <button type="button" class="btn primary-btn" id="rentCarrierBtn">{{ __('messages.rent_carrier') }}</button>
                <button type="button" class="btn seconday-btn" id="bringOwnCarrierBtn">{{ __('messages.bring_own_carrier') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Insurance Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notInsurance" tabindex="-1" aria-labelledby="notInsurance" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notInsurance">{{ __('messages.insurance_disclaimer_title') }}</h5>
                <p>{{ __('messages.insurance_disclaimer_message') }}</p>
                <button type="button" class="btn primary-btn" id="wantInsuranceBtn">{{ __('messages.yes_insure_me') }}</button>
                <button type="button" class="btn seconday-btn" id="noInsuranceBtn">{{ __('messages.no_insurance') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Guest Options Modal -->
<div class="modal fade modal-guest-main" id="guestOptionsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title modal-guest">{{ __('messages.login_modal_title') }}</h5>
                <a href="javascript:void(0);" class="w-100 btn primary-btn" onclick="saveFormDataAndRedirectCarrier('/dachboxmiete-phase-2/login')">
                    {{ __('messages.login') }}
                </a>
                <div class="">
                    <div class="dont-acount">
                        <p>{{ __('messages.dont_have_account') }}</p>
                    </div>
                    <a href="javascript:void(0);" class="w-100 btn primary-outline-btn" onclick="saveFormDataAndRedirectCarrier('/dachboxmiete-phase-2/registration')">
                        {{ __('messages.create_account') }}
                    </a>
                </div>
                <div class="dont-acount">
                    <p>{{ __('messages.or') }}</p>
                </div>
                <button class="w-100 btn primary-outline-btn" data-bs-target="#guestModal" data-bs-toggle="modal">
                    {{ __('messages.continue_with_guest') }}
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Guest Modal Form -->
<div class="modal modal-not-book modal-g fade" id="guestModal" aria-hidden="true" aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h1 class="modal-title modal-guest-l" id="exampleModalToggleLabel2">{{ __('messages.guest_title') }}</h1>
                <div id="guestError" class="alert alert-danger d-none" role="alert"></div>
                <div class="row">
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstname" class="form-label">{{ __('messages.first_name') }}</label>
                            <input type="text" class="form-control" placeholder="{{ __('messages.enter_first_name') }}" id="firstname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="surname" class="form-label">{{ __('messages.surname') }}</label>
                            <input type="text" class="form-control" placeholder="{{ __('messages.enter_surname') }}" id="surname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="number" class="form-label">{{ __('messages.phone_number') }}</label>
                            <input type="text" class="form-control" placeholder="{{ __('messages.enter_phone_number') }}" id="number">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstemail" class="form-label">{{ __('messages.email') }}</label>
                            <input type="email" class="form-control" placeholder="{{ __('messages.enter_email') }}" id="firstemail">
                        </div>
                    </div>
                </div>
                <div class="upper-flex-main-modal">
                    <button class="btn  primary-outline-btn" data-bs-target="#guestOptionsModal" data-bs-toggle="modal">
                        {{ __('messages.back') }}
                    </button>
                    <button class="btn primary-btn" id="continueAsGuest">
                        {{ __('messages.continue') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade modal-not-book" id="requestSuccessful" tabindex="-1" aria-labelledby="requestSuccessful" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center">
                <h5 class="modal-title" id="requestSuccessful">{{ __('messages.thank_you') }}</h5>
                <p>{{ __('messages.thank_you_message') }}</p>
                <button type="button" class="btn primary-btn" id="okayBtn">{{ __('messages.okay') }}</button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="requestModal" tabindex="-1" aria-labelledby="requestModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="requestModalLabel">{{ __('messages.product_request') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>{{ __('messages.request_modal_message') }}</p>
                
                <!-- Display selected product details -->
                <div class="selected-product-details mb-4 p-3 border rounded">
                    <h6>Product Details:</h6>
                    <div id="requestProductDetails">
                        <!-- Will be populated by JavaScript -->
                    </div>
                </div>
                
                <form id="requestForm">
                    <div class="form-full">
                    <div class="col-md-6">
                        <div class="d-flex profile_title_input">
                            <div class="inner-main-input inner-main-input2 title_inpt">
                                <label class="form-label">{{ __('messages.title') }}</label>
                                <select class="form-select" name="title" id="title">
                                    <option value="">Select</option>
                                    <option value="Mr." {{ old('title') == 'Mr.' ? 'selected' : '' }}>Mr.</option>
                                    <option value="Mrs." {{ old('title') == 'Mrs.' ? 'selected' : '' }}>Mrs.</option>
                                    <option value="Miss" {{ old('title') == 'Miss' ? 'selected' : '' }}>Miss</option>
                                </select>
                                <div class="invalid-feedback">{{ __('messages.select_title_error') }}</div>
                            </div>
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.first_name') }}</label>
                                <input type="text" class="form-control" name="first_name" id="first_name" placeholder="{{ __('messages.enter_first_name') }}" value="{{ old('first_name') }}">
                                <div class="invalid-feedback">{{ __('messages.first_name_error') }}</div>
                            </div>
                        </div>
                    </div>
                
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label">{{ __('messages.last_name') }}</label>
                            <input type="text" class="form-control" name="last_name" id="last_name" placeholder="{{ __('messages.enter_surname') }}" value="{{ old('last_name') }}">
                            <div class="invalid-feedback">{{ __('messages.last_name_error') }}</div>
                        </div>
                    </div>
                </div>
                    
                <div class="form-full">
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label">{{ __('messages.email') }}</label>
                            <input type="email" class="form-control" name="email" id="requestEmail" placeholder="{{ __('messages.email') }}" value="{{ old('email') }}">
                            <div class="invalid-feedback">{{ __('messages.email_error') }}</div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">{{ __('messages.country_code') }}</label>
                        <div class="d-flex profile_title_input">
                            <div class="inner-main-input inner-main-input2 title_inpt">
                               
                                
                                <select name="country_code" class="form-select country_code_custom" id="country_code">
                                    <option value="+49" data-image="https://flagcdn.com/16x12/de.png" {{ old('country_code') == '+49' ? 'selected' : '' }}>+49</option>
                                    <option value="+43" data-image="https://flagcdn.com/16x12/at.png" {{ old('country_code') == '+43' ? 'selected' : '' }}>+93</option>
                                    <option value="+41" data-image="https://flagcdn.com/16x12/ch.png"  {{ old('country_code') == '+41' ? 'selected' : '' }}>+41</option>
                                </select>
                                <div class="invalid-feedback">{{ __('messages.select_country_code_error') }}</div>
                            </div>
                            <div class="inner-main-input inner-main-input2">
                                <input type="text" class="form-control" name="contact_number" id="requestPhone" placeholder="{{ __('messages.phone_placeholder') }}" value="{{ old('contact_number') }}">
                                <div class="invalid-feedback">{{ __('messages.phone_error') }}</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="inner-main-input inner-main-input2">
                        <label class="form-label">{{ __('messages.street') }}</label>
                        <input type="text" class="form-control" name="street" id="street" placeholder="{{ __('messages.enter_address') }}" value="{{ old('street') }}">
                        <div class="invalid-feedback">{{ __('messages.street_error') }}</div>
                    </div>
                </div>
                <div class="form-full">
                <div class="col-md-6">
                    <div class="inner-main-input inner-main-input2">
                        <label class="form-label">{{ __('messages.zip_code') }}</label>
                        <input type="text" class="form-control" name="zipcode" id="zipcode" placeholder="{{ __('messages.enter_zip_code') }}" value="{{ old('zipcode') }}">
                        <div class="invalid-feedback">{{ __('messages.zip_code_error') }}</div>
                    </div>
                </div>
                    
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label">{{ __('messages.city') }}</label>
                            <input type="text" class="form-control" name="city" id="city" placeholder="{{ __('messages.enter_city') }}" value="{{ old('city') }}">
                            <div class="invalid-feedback">{{ __('messages.city_error') }}</div>
                        </div>
                    </div>
                </div>
                    
                
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label">{{__('messages.state_region')}}</label>
                            <select class="form-select" name="state" id="state">
                                <option value="">Select State</option>
                                <option value="Baden-Württemberg" {{ old('state') == 'Baden-Württemberg' ? 'selected' : '' }}>Baden-Württemberg</option>
                                <option value="Bavaria" {{ old('state') == 'Bavaria' ? 'selected' : '' }}>Bavaria</option>
                                <option value="Berlin" {{ old('state') == 'Berlin' ? 'selected' : '' }}>Berlin</option>
                                <option value="Brandenburg" {{ old('state') == 'Brandenburg' ? 'selected' : '' }}>Brandenburg</option>
                                <option value="Bremen" {{ old('state') == 'Bremen' ? 'selected' : '' }}>Bremen</option>
                                <option value="Hamburg" {{ old('state') == 'Hamburg' ? 'selected' : '' }}>Hamburg</option>
                                <option value="Hesse" {{ old('state') == 'Hesse' ? 'selected' : '' }}>Hesse</option>
                                <option value="Lower Saxony" {{ old('state') == 'Lower Saxony' ? 'selected' : '' }}>Lower Saxony</option>
                                <option value="Mecklenburg-Vorpommern" {{ old('state') == 'Mecklenburg-Vorpommern' ? 'selected' : '' }}>Mecklenburg-Vorpommern</option>
                                <option value="North Rhine-Westphalia" {{ old('state') == 'North Rhine-Westphalia' ? 'selected' : '' }}>North Rhine-Westphalia</option>
                                <option value="Rhineland-Palatinate" {{ old('state') == 'Rhineland-Palatinate' ? 'selected' : '' }}>Rhineland-Palatinate</option>
                                <option value="Saarland" {{ old('state') == 'Saarland' ? 'selected' : '' }}>Saarland</option>
                                <option value="Saxony" {{ old('state') == 'Saxony' ? 'selected' : '' }}>Saxony</option>
                                <option value="Saxony-Anhalt" {{ old('state') == 'Saxony-Anhalt' ? 'selected' : '' }}>Saxony-Anhalt</option>
                                <option value="Schleswig-Holstein" {{ old('state') == 'Schleswig-Holstein' ? 'selected' : '' }}>Schleswig-Holstein</option>
                                <option value="Thuringia" {{ old('state') == 'Thuringia' ? 'selected' : '' }}>Thuringia</option>
                            </select>
                            <div class="invalid-feedback">{{ __('messages.state_error') }}</div>

                            
                        </div>
                    </div>
                
                 
                
                    

                    <div class="mb-3">
                        <label for="requestMessage" class="form-label">{{ __('messages.message') }}</label>
                        <textarea class="form-control" id="requestMessage" rows="3" placeholder="Any specific requirements or questions..."></textarea>
                    </div>
                    
                    <!-- Hidden fields to store product information -->
                    <input type="hidden" id="requestProductId">
                    <input type="hidden" id="requestProductName">
                    <input type="hidden" id="requestColorId">
                    <input type="hidden" id="requestColorName">
                    <input type="hidden" id="requestSizeId">
                    <input type="hidden" id="requestSizeName">
                    <input type="hidden" id="requestVariationId">
                    <input type="hidden" id="requestVariationName">
                    <input type="hidden" id="requestRentalFrom">
                    <input type="hidden" id="requestRentalTo">
                    <input type="hidden" id="requestCarrierLength">
                    <input type="hidden" id="requestFootSku">
                    <input type="hidden" id="requestFootkitSku">
                    <input type="hidden" id="requestRoofType">
                    <input type="hidden" id="requestUnavailableComponents">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn  primary-outline-btn" data-bs-dismiss="modal">{{ __('messages.cancel') }}</button>
                <button type="button" class="btn primary-btn" id="submitRequest">{{ __('messages.submit_request') }}</button>
            </div>
        </div>
    </div>
</div>
