@extends('layouts.frontend')
@section('content')

<main>

    <div class="navigation-main">
        <div class="container">
            <div class="navigat">
                <a href="/">{{__('messages.home')}}</a>
                <a href="/product">{{$product->name}}</a>
                <a class="prod-name active" href="">{{ ($product->brand->name ?? '') . ' ' . ($product->name ?? '') }}</a>

                
            </div>
        </div>
    </div>

    <section class="detail-show-all comn-padd-100">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="inner-crousel-product">
                        <div class="slider-main-left">
                            <div class="slider-inner-detail row">
                                @php
                                    $mainImage = $product->images->firstWhere('type', 'main');
                                    $galleryImages = $product->images->where('type', 'gallery');
                                    $infoImage = $product->images->firstWhere('type','info');
                                    $allImages = collect();
                                    if ($mainImage) {
                                        $allImages->push($mainImage);
                                    }
                                    $allImages = $allImages->merge($galleryImages);
                                @endphp
                            
                                <div class="col-2 p-0 padd-st">
                                    <div class="slider-nav">
                                        @foreach($allImages as $image)
                                            <div class="main-img-slider-nav">
                                                <figure>
                                                    <img src="{{ asset('storage/' . $image->image_path) }}" alt="Product Thumbnail">
                                                </figure>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                
                                <div class="col-10">
                                    <div class="slider-for main-slider-for">
                                        @foreach($allImages as $image)
                                            <div class="main-img-slider-for">
                                                <figure>
                                                    <img src="{{ asset('storage/' . $image->image_path) }}" alt="Product Image">
                                                </figure>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="insuranc-show-all">
                        @foreach($product->otherInfo as $info)
                            <div class="main-show-insuranc mb-0">
                                <img src="{{ asset('storage/' . $info->image_path) }}" alt="Other Info Image">
                                <p>{{ $info->description }}</p>
                            </div>
                        @endforeach
                    </div>
                    
                    @if(!empty($infoImage) && !empty($infoImage->image_path))
                    <div class="main-img-detail-one">
                        <figure>
                            <img src="{{ asset('storage/' . $infoImage->image_path) }}" alt="Info Thumbnail">
                        </figure>
                    </div>
                @endif

                </div>
                <div class="col-lg-6">
                    <div class="inner-data-detail">
                        <div class="head-disc">
                            <h3>{{$product->name}}</h3>
                            <h6 class="brand-name-detail">{{ __('messages.brand') }} : {{$product->brand->name??''}}</h6>
                            <p>{{ $product->description ?? 'N/A'}}</p>
                        </div>

                        <div class="price-detail-main">
                            <div class="price-big d-flex">
                                <h3>{{ $product->first_price  ?? 'N/A'  }}</h3>
                                <a href="javascript:void()" data-bs-toggle="modal" data-bs-target="#exampleModal">{{ __('messages.view_price_breakdown') }}</a>
                            </div>
                            <p>{{ __('messages.per_day_incl_vat') }}</p>
                        </div>

                        <div class="pick-location">
                            <h3>{{ __('messages.pickup_location') }}</h3>
                            <div class="pick-locati-name-icon d-flex">
                                <img src="{{ asset('frontend/images/loct.png')}}" alt="">
                                <select class="form-select" id="vendor_select" name="vendor_select">
                                    <option value ="admin">Esperantostr. 10, 70197 Stuttgart</option>
                                @foreach($vendors as $vendor)
                                    <option value="{{ $vendor->id }}">{{ $vendor->street . ' ' . $vendor->zip_code . ' ' . $vendor->city }}</option>
                                @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="choose-car">
                            <h3>{{ __('messages.choose_your_car') }}</h3>
                            <form id="car-form">
                                <div class="row">
                                    <div class="col-md-6 inner-main-input">
                                        <label>{{ __('messages.manufacturer') }}</label>
                                        <select class="form-select" id="manufacturer" name="manufacturer">
                                            <option selected disabled>{{ __('messages.select') }}</option>
                                            @foreach($manufacturers as $manufacturer)
                                                <option value="{{ $manufacturer }}">{{ $manufacturer }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-md-6 inner-main-input">
                                        <label>{{ __('messages.model') }}</label>
                                        <select class="form-select" id="model" name="model" disabled></select>
                                    </div>

                                    <div class="col-md-6 inner-main-input">
                                        <label>{{ __('messages.year_of_make') }}</label>
                                        <select class="form-select" id="year" name="year" disabled></select>
                                    </div>

                                  

                                    <div class="col-md-6 inner-main-input">
                                        <label>{{ __('messages.trailer_hitch') }}</label>
                                        <select class="form-select" id="trailer_hitch" name="trailer_hitch" 
                                                data-product-name="{{ $product->name }}">
                                            <option value="" selected disabled>Select</option>
                                            <option value="yes">{{ __('messages.yes') }}</option>
                                            <option value="no">{{ __('messages.no') }}</option>
                                        </select>
                                    </div>
                                </div>

                                <div id="result" class="mt-3"></div>
                            </form>
                        </div>
                        <input id="railing_type" hidden value="{{$product->railing_type}}" />
                        @if($product->railing_type)
                        <div class="railing-type">
                            <h3>{{ __('messages.railing_type') }}</h3>
                            <p>{{ __('messages.railing_type_description') }}</p>
                        </div>
                        
                        <div id="roof-types-container" style="display: none;">
                            @foreach($roofTypes as $roofType)
                                <div class="roof-name-detail" id="roof-type-{{ Str::slug($roofType) }}">
                                    <figure>
                                        @php
                                            $imageName = strtolower(str_replace(' ', '-', $roofType)) . '.jpg';
                                        @endphp
                                        <img src="{{ asset('frontend/images/' . $imageName) }}" alt="{{ $roofType }}">
                                    </figure>
                                    <h4>{{ $roofType }}</h4>
                                    @if($roofType == 'Normal Roof')
                                    <p>A smooth roof surface without side mounts or rails</p>
                                    @elseif($roofType == 'Normal roof without glass roof')
                                    <p>A smooth roof surface without side mounts or rails</p>
                                    @elseif($roofType == 'Normal Roof with glass roof')
                                    <p>A smooth roof surface without side mounts or rails and with a glass roof</p>
                                    @elseif($roofType == 'Fixpoints')
                                    <p>A car roof with fixed points has integrated mounting points for roof racks</p>
                                    @elseif($roofType == 'Fixpoints without glass roof')
                                    <p>A car roof with fixed points has integrated mounting points for roof racks</p>
                                    @elseif($roofType == 'Fixpoints with glass roof')
                                    <p>A car roof with fixed points has integrated mounting points for roof racks and with a glass roof</p>
                                    @elseif($roofType == 'Integrated Roof Railing')
                                    <p>A car roof with flush roof rails features low-profile, seamlessly integrated rails</p>
                                    @elseif($roofType == 'Elevated Roof Rails')
                                    <p>A car roof with open rails has mounted roof rails raised above the roof surface </p>
                                    @elseif($roofType == 'T-Profile')
                                    <p>A car roof with a T-slot profile has integrated T-slots for mounting roof racks </p>
                                    @elseif($roofType == 'Raingutter')
                                    <p>A car roof with a rain gutter has side channels for water drainage and roof rack mounting</p>
                                    @endif
                            </div>
                            @endforeach
                        </div>
                        @endif

                        <div id="roof-details-box" style="display: none; margin-top: 20px;"></div>

                        <div class="choose-rental-period">
                            <h3>{{ __('messages.choose_rental_period') }}</h3>
                            <p>{{ __('messages.add_rental_period_description') }}</p>
                            <form class=" email-login">
                                <div class="row">
                                    <div class="col-md-12 inner-main-input">
                                        <label for="inputEmail4" class="form-label">{{ __('messages.from') }}</label>
                                        <input class="form-control"  id="rental_from">
                                    </div>
                                    <div class="col-md-12 inner-main-input">
                                        <label for="inputEmail4" class="form-label">{{ __('messages.to') }}</label>
                                        <input class="form-control"  id="rental_to">
                   
                                        
                                    </div>
                                </div>
                            </form>


                            
                        </div>
                        <input type="hidden" name="insurance_selected" id="insurance_selected" value="0">
                        <input type="hidden" name="roof_rack_selected" id="roof_rack_selected" value="0">
                        
                      
                        
                        <div class="select-main-detail d-flex mt-4">
                            <div class="">
                                 
                                @if($product->name == 'Roof Box' || $product->name == 'Roof Bike Carrier'  || $product->name =='Dachbox'  || $product->name =='Dachfahrradträger')
                                <div class="form-check mb-1">
                                    <input class="form-check-input" type="checkbox" id="roof_rack_checkbox" checked>
                                    <label class="form-check-label" for="gridCheck">
                                        {{ __('messages.roof_rack_included') }}
                                    </label>
                                </div>
                                @endif
                               
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox"  id="insurance_checkbox" checked>
                                    <label class="form-check-label" for="gridCheck1">
                                        {{ __('messages.insurance_label') }}
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="calculated-rent">
                            <div class="row align-items-end">
                                <div class="col-md-6">
                                    <h3>{{ __('messages.calculated_rent') }}</h3>

                                    <p class="text-calc-rent " id="withinsurance">({{ __('messages.calculated_rent_with_insurance') }})
                                    </p>
                                    <p class="text-calc-rent d-none" id="withoutinsurance">({{ __('messages.calculated_rent_without_insurance') }})
                                    </p>
                                </div>
                                <div class="col-md-6">
                                    <div class="inner-number-days">
                                        <p>{{ __('messages.number_of_days') }}: <span> </span>

                                        </p>
                                        <p class="mb-0">{{ __('messages.total_rent') }}: <span></span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div id="errorMessage" class=""></div>
                        
                        <form id="bookingForm" action="{{ route('cart.add') }}" method="POST">
                            @csrf
                            <input type="hidden" name="product_id" value="{{ $product->id }}" id="product_id">
                            <input type="hidden" name="product_name" value="{{$product->name }}" id="product_name">
                            <input type="hidden" name="manufacturer" id="hidden_manufacturer">
                            <input type="hidden" name="car_year" id="hidden_car_year">
                            <input type="hidden" name="model" id="hidden_model">
                            <input type="hidden" name="trailer_hitch" id="hidden_trailer_hitch">
                            <input type="hidden" name="roof_type" id="hidden_roof_type">
                            <input type="hidden" name="color_id" id="hidden_color_id">
                            <input type="hidden" name="color_name" id="hidden_color_name">
                            <input type="hidden" name="size_id" id="hidden_size_id">
                            <input type="hidden" name="size_name" id="hidden_size_name">
                            <input type="hidden" name="rental_from" id="hidden_rental_from">
                            <input type="hidden" name="rental_to" id="hidden_rental_to">
                            <input type="hidden" name="days" id="hidden_days">
                            <input type="hidden" name="calculated_rent" id="hidden_calculated_rent">
                            <input type="hidden" name="is_carrier_included" id="hidden_is_carrier_included">
                            <input type="hidden" name="is_insured" id="hidden_is_insured">
                            

                            <button type="submit" id="rentNowButton" class="mt-4 w-100 btn primary-btn">{{ __('messages.rent_now') }}</button>

                            <button type="button" id="requestButton" class="mt-4 w-100 btn primary-btn d-none" data-bs-toggle="modal" data-bs-target="#requestModal">
                                {{ __('messages.send_request') }}
                            </button>
                        </form>
                        
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="comn-padd-100 faq-detail">
        <div class="inner-privacy-content">
            <div class="container">
                <div class="inner-faq">
                    <h2 class="head-faq">{{ __('messages.additional_info') }}</h2>
                    <div class="accordion" id="accordionExample">
                        <!-- Available Models Section -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                    {{ __('messages.available_models') }}
                                </button>
                            </h2>
                            <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        @foreach($product->models as $index => $model)
                                            <h6>{{ $index + 1 }}. {{ $model['title'] ?? '' }}</h6>
                                            <p>{{ $model['description'] ?? '' }}</p>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
    
                        <!-- Dimensions -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    {{ __('messages.dimensions') }}
                                </button>
                            </h2>
                            <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <p id="dimensionsText">{{ __('messages.select_size_dimensions') }}</p>
                                        <ul id="dimensionsList" style="display:none;">
                                            <li>{{ __('messages.length') }}: <span id="dimensionLength"></span> cm</li>
                                            <li>{{ __('messages.width') }}: <span id="dimensionWidth"></span> cm</li>
                                            <li>{{ __('messages.height') }}: <span id="dimensionHeight"></span> cm</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                        <!-- Weight -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                    {{ __('messages.weight') }}
                                </button>
                            </h2>
                            <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <p id="weightText">{{ __('messages.select_size_weight') }}</p>
                                        <ul id="weightList" style="display:none;">
                                            <li>{{ __('messages.weight') }}: <span id="weightValue"></span> kg</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                        <!-- Volume -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsefour" aria-expanded="false" aria-controls="collapsefour">
                                    {{ __('messages.volume') }}
                                </button>
                            </h2>
                            <div id="collapsefour" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <p id="volumeText">{{ __('messages.select_size_volume') }}</p>
                                        <ul id="volumeList" style="display:none;">
                                            <li>{{ __('messages.volume') }}: <span id="volumeValue"></span> liters</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                        <!-- Max Load -->
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsefive" aria-expanded="false" aria-controls="collapsefive">
                                    {{ __('messages.max_load') }}
                                </button>
                            </h2>
                            <div id="collapsefive" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="inner-body-faq">
                                        <p id="maxLoadText">{{ __('messages.select_size_max_load') }}</p>
                                        <ul id="maxLoadList" style="display:none;">
                                            <li>{{ __('messages.max_load') }}: <span id="maxLoadValue"></span> kg</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
    
                    </div> <!-- .accordion -->
                </div> <!-- .inner-faq -->
            </div>
        </div>
    </section>

    @include('frontend.include.subscribe_news')

    <section class="comn-padd-100 related-product-detail">
        <div class="container">
            <div class="products-main-wrapper">
                <h2 class="related-prod">{{ __('messages.related_products') }}</h2>
                <div class="row row-gap-4">
                    @forelse($relatedProducts as $relatedProduct)
                        @php
                                $mainImage = $relatedProduct->images->first();

                        @endphp
                       
                        
                        <div class="col-lg-4">
                            <div class="product-main-one">
                                <div class="upper-imag-product-card">
                                    <figure>
                                        @if($mainImage)
                                            <img src="{{ asset('storage/' . $mainImage->image_path) }}" alt="{{ $relatedProduct->name }}">
                                        @else
                                            <img src="{{ asset('frontend/images/default-product.png') }}" alt="Default product image">
                                        @endif
                                    </figure>
                                </div>
                                <div class="product-detail-name-card">
                                    <h3>{{ $relatedProduct->name }}</h3>
                                    <p>{{ __('messages.from') }} {{ $relatedProduct->first_price }}</p>
                                    <a href="{{ route('product.details', ['slug' => $relatedProduct->category->slug ?? 'default']) }}" class="btn rent-btn">
                                        {{ __('messages.rent_now') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="col-12">
                            <p>{{ __('messages.no_related_products') }}</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    </section>
    
    <section class="touch-with-us comn-padd">
        <div class="container">
            <div class="inner-touch-contact product-detail-touch">
                <div class="row">
                    <div class="col-md-7">
                        <div class="inner-form-touch">
                            <h2>{{ __('messages.get_in_touch') }}</h2>
                            <form class="row" id="contactForm" method="post" action="{{ route('contact.store') }}">
                                @csrf
    
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="name" class="form-label">{{ __('messages.name') }}</label>
                                        <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" placeholder="{{ __('messages.enter_your_name') }}" value="{{ old('name') }}">
                                        @error('name')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
    
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="email" class="form-label">{{ __('messages.email') }}</label>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror" placeholder="{{ __('messages.enter_your_email') }}" id="email" name="email" value="{{ old('email') }}">
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
    
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="contact-number" class="form-label">{{ __('messages.contact_number') }}</label>
                                        <input type="tel" class="form-control @error('number') is-invalid @enderror" placeholder="{{ __('messages.enter_your_contact_number') }}" id="contact-number" name="number" value="{{ old('number') }}">
                                        @error('number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
    
                                <div class="col-md-12">
                                    <div class="inner-main-input">
                                        <label for="message" class="form-label">{{ __('messages.message') }}</label>
                                        <textarea class="form-control @error('message') is-invalid @enderror" placeholder="{{ __('messages.leave_a_comment') }}" id="message" name="message" style="height: 135px">{{ old('message') }}</textarea>
                                        @error('message')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
    
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">{{ __('messages.send_message') }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="inner-figure-contact">
                            <figure class="fig-main-img-touch">
                                <img src="{{ asset('frontend/images/touch.png')}}" alt="">
                            </figure>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" id="booking_item_ids" >
    </section>
    
</main>


<div class="modal fade" id="requestModal" tabindex="-1" aria-labelledby="requestModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="requestModalLabel">{{ __('messages.product_request') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>{{ __('messages.request_modal_message') }}</p>
                
                <!-- Display selected product details -->
                <div class="selected-product-details mb-4 p-3 border rounded">
                    <h6>Product Details:</h6>
                    <div id="requestProductDetails">
                        <!-- Will be populated by JavaScript -->
                    </div>
                </div>
                
                <form id="requestForm">
                    <div class="form-full">
                    <div class="col-md-6">
                        <div class="d-flex profile_title_input">
                            <div class="inner-main-input inner-main-input2 title_inpt">
                                <label class="form-label">{{ __('messages.title') }}</label>
                                <select class="form-select" name="title" id="title">
                                    <option value="">Select</option>
                                    <option value="Mr." {{ old('title') == 'Mr.' ? 'selected' : '' }}>Mr.</option>
                                    <option value="Mrs." {{ old('title') == 'Mrs.' ? 'selected' : '' }}>Mrs.</option>
                                    <option value="Miss" {{ old('title') == 'Miss' ? 'selected' : '' }}>Miss</option>
                                </select>
                                <div class="invalid-feedback">{{ __('messages.select_title_error') }}</div>
                            </div>
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.first_name') }}</label>
                                <input type="text" class="form-control" name="first_name" id="first_name" placeholder="{{ __('messages.enter_first_name') }}" value="{{ old('first_name') }}">
                                <div class="invalid-feedback">{{ __('messages.first_name_error') }}</div>
                            </div>
                        </div>
                    </div>
                
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label">{{ __('messages.last_name') }}</label>
                            <input type="text" class="form-control" name="last_name" id="last_name" placeholder="{{ __('messages.enter_surname') }}" value="{{ old('last_name') }}">
                            <div class="invalid-feedback">{{ __('messages.last_name_error') }}</div>
                        </div>
                    </div>
                </div>
                    
                <div class="form-full">
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label">{{ __('messages.email') }}</label>
                            <input type="email" class="form-control" name="email" id="requestEmail" placeholder="{{ __('messages.email') }}" value="{{ old('email') }}">
                            <div class="invalid-feedback">{{ __('messages.email_error') }}</div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">{{ __('messages.country_code') }}</label>
                        <div class="d-flex profile_title_input">
                            <div class="inner-main-input inner-main-input2 title_inpt">
                               
                                
                                <select name="country_code" class="form-select country_code_custom" id="country_code">
                                    <option value="+49" data-image="https://flagcdn.com/16x12/de.png" {{ old('country_code') == '+49' ? 'selected' : '' }}>+49</option>
                                    <option value="+43" data-image="https://flagcdn.com/16x12/at.png" {{ old('country_code') == '+43' ? 'selected' : '' }}>+93</option>
                                    <option value="+41" data-image="https://flagcdn.com/16x12/ch.png"  {{ old('country_code') == '+41' ? 'selected' : '' }}>+41</option>
                                </select>
                                <div class="invalid-feedback">{{ __('messages.select_country_code_error') }}</div>
                            </div>
                            <div class="inner-main-input inner-main-input2">
                                <input type="text" class="form-control" name="contact_number" id="requestPhone" placeholder="{{ __('messages.phone_placeholder') }}" value="{{ old('contact_number') }}">
                                <div class="invalid-feedback">{{ __('messages.phone_error') }}</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="inner-main-input inner-main-input2">
                        <label class="form-label">{{ __('messages.street') }}</label>
                        <input type="text" class="form-control" name="street" id="street" placeholder="{{ __('messages.enter_address') }}" value="{{ old('street') }}">
                        <div class="invalid-feedback">{{ __('messages.street_error') }}</div>
                    </div>
                </div>
                <div class="form-full">
                <div class="col-md-6">
                    <div class="inner-main-input inner-main-input2">
                        <label class="form-label">{{ __('messages.zip_code') }}</label>
                        <input type="text" class="form-control" name="zipcode" id="zipcode" placeholder="{{ __('messages.enter_zip_code') }}" value="{{ old('zipcode') }}">
                        <div class="invalid-feedback">{{ __('messages.zip_code_error') }}</div>
                    </div>
                </div>
                    
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label">{{ __('messages.city') }}</label>
                            <input type="text" class="form-control" name="city" id="city" placeholder="{{ __('messages.enter_city') }}" value="{{ old('city') }}">
                            <div class="invalid-feedback">{{ __('messages.city_error') }}</div>
                        </div>
                    </div>
                </div>
                    
                
                    <div class="col-md-6">
                        <div class="inner-main-input inner-main-input2">
                            <label class="form-label">{{__('messages.state_region')}}</label>
                            <select class="form-select" name="state" id="state">
                                <option value="">Select State</option>
                                <option value="Baden-Württemberg" {{ old('state') == 'Baden-Württemberg' ? 'selected' : '' }}>Baden-Württemberg</option>
                                <option value="Bavaria" {{ old('state') == 'Bavaria' ? 'selected' : '' }}>Bavaria</option>
                                <option value="Berlin" {{ old('state') == 'Berlin' ? 'selected' : '' }}>Berlin</option>
                                <option value="Brandenburg" {{ old('state') == 'Brandenburg' ? 'selected' : '' }}>Brandenburg</option>
                                <option value="Bremen" {{ old('state') == 'Bremen' ? 'selected' : '' }}>Bremen</option>
                                <option value="Hamburg" {{ old('state') == 'Hamburg' ? 'selected' : '' }}>Hamburg</option>
                                <option value="Hesse" {{ old('state') == 'Hesse' ? 'selected' : '' }}>Hesse</option>
                                <option value="Lower Saxony" {{ old('state') == 'Lower Saxony' ? 'selected' : '' }}>Lower Saxony</option>
                                <option value="Mecklenburg-Vorpommern" {{ old('state') == 'Mecklenburg-Vorpommern' ? 'selected' : '' }}>Mecklenburg-Vorpommern</option>
                                <option value="North Rhine-Westphalia" {{ old('state') == 'North Rhine-Westphalia' ? 'selected' : '' }}>North Rhine-Westphalia</option>
                                <option value="Rhineland-Palatinate" {{ old('state') == 'Rhineland-Palatinate' ? 'selected' : '' }}>Rhineland-Palatinate</option>
                                <option value="Saarland" {{ old('state') == 'Saarland' ? 'selected' : '' }}>Saarland</option>
                                <option value="Saxony" {{ old('state') == 'Saxony' ? 'selected' : '' }}>Saxony</option>
                                <option value="Saxony-Anhalt" {{ old('state') == 'Saxony-Anhalt' ? 'selected' : '' }}>Saxony-Anhalt</option>
                                <option value="Schleswig-Holstein" {{ old('state') == 'Schleswig-Holstein' ? 'selected' : '' }}>Schleswig-Holstein</option>
                                <option value="Thuringia" {{ old('state') == 'Thuringia' ? 'selected' : '' }}>Thuringia</option>
                            </select>
                            <div class="invalid-feedback">{{ __('messages.state_error') }}</div>

                            
                        </div>
                    </div>
                
                 
                
                    

                    <div class="mb-3">
                        <label for="requestMessage" class="form-label">{{ __('messages.message') }}</label>
                        <textarea class="form-control" id="requestMessage" rows="3" placeholder="Any specific requirements or questions..."></textarea>
                    </div>
                    
                    <!-- Hidden fields to store product information -->
                    <input type="hidden" id="requestProductId">
                    <input type="hidden" id="requestProductName">
                    <input type="hidden" id="requestColorId">
                    <input type="hidden" id="requestColorName">
                    <input type="hidden" id="requestSizeId">
                    <input type="hidden" id="requestSizeName">
                    <input type="hidden" id="requestVariationId">
                    <input type="hidden" id="requestVariationName">
                    <input type="hidden" id="requestRentalFrom">
                    <input type="hidden" id="requestRentalTo">
                    <input type="hidden" id="requestCarrierLength">
                    <input type="hidden" id="requestFootSku">
                    <input type="hidden" id="requestFootkitSku">
                    <input type="hidden" id="requestRoofType">
                    <input type="hidden" id="requestUnavailableComponents">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn  primary-outline-btn" data-bs-dismiss="modal">{{ __('messages.cancel') }}</button>
                <button type="button" class="btn primary-btn" id="submitRequest">{{ __('messages.submit_request') }}</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade modal-not-book" id="railingType" tabindex="-1" aria-labelledby="notBookableLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notBookableLabel">Attention</h5>
                <p>Please check the railing type first.</p>
                <button type="button" class="btn primary-btn" data-bs-dismiss="modal">{{ __('messages.ok') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Not Bookable Modal -->
<div class="modal fade modal-not-book" id="notBookableModal" tabindex="-1" aria-labelledby="notBookableLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notBookableLabel">{{ __('messages.not_bookable_title') }}</h5>
                <p>{{ __('messages.not_bookable_message') }}</p>
                <button type="button" class="btn primary-btn" data-bs-dismiss="modal">{{ __('messages.ok') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Carrier Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notCarrier" tabindex="-1" aria-labelledby="notCarrier" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notCarrier">{{ __('messages.carrier_disclaimer_title') }}</h5>
                <p>{{ __('messages.carrier_disclaimer_message') }}</p>
                <button type="button" class="btn primary-btn" id="rentCarrierBtn">{{ __('messages.rent_carrier') }}</button>
                <button type="button" class="btn seconday-btn" id="bringOwnCarrierBtn">{{ __('messages.bring_own_carrier') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Insurance Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notInsurance" tabindex="-1" aria-labelledby="notInsurance" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notInsurance">{{ __('messages.insurance_disclaimer_title') }}</h5>
                <p>{{ __('messages.insurance_disclaimer_message') }}</p>
                <button type="button" class="btn primary-btn" id="wantInsuranceBtn">{{ __('messages.yes_insure_me') }}</button>
                <button type="button" class="btn seconday-btn" id="noInsuranceBtn">{{ __('messages.no_insurance') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Guest Options Modal -->
<div class="modal fade modal-guest-main" id="guestOptionsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title modal-guest">{{ __('messages.login_modal_title') }}</h5>
                <a href="javascript:void(0);" class="w-100 btn primary-btn" onclick="saveFormDataAndRedirect('/dachboxmiete-phase-2/login')">
                    {{ __('messages.login_modal_title') }}
                </a>
                <div class="">
                    <div class="dont-acount">
                        <p>{{ __('messages.dont_have_account') }}</p>
                    </div>
                    <a href="javascript:void(0);" class="w-100 btn primary-outline-btn" onclick="saveFormDataAndRedirect('/dachboxmiete-phase-2/registration')">
                        {{ __('messages.create_account') }}
                    </a>
                </div>
                <div class="dont-acount">
                    <p>{{ __('messages.or') }}</p>
                </div>
                <button class="w-100 btn primary-outline-btn" data-bs-target="#guestModal" data-bs-toggle="modal">
                    {{ __('messages.continue_with_guest') }}
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Guest Modal Form -->
<div class="modal modal-not-book modal-g fade" id="guestModal" aria-hidden="true" aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h1 class="modal-title modal-guest-l" id="exampleModalToggleLabel2">{{ __('messages.guest_title') }}</h1>
                <div id="guestError" class="alert alert-danger d-none" role="alert"></div>
                <div class="row">
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstname" class="form-label">{{ __('messages.first_name') }}</label>
                            <input type="text" class="form-control" placeholder="{{ __('messages.enter_first_name') }}" id="firstname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="surname" class="form-label">{{ __('messages.surname') }}</label>
                            <input type="text" class="form-control" placeholder="{{ __('messages.enter_surname') }}" id="surname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="number" class="form-label">{{ __('messages.phone_number') }}</label>
                            <input type="text" class="form-control" placeholder="{{ __('messages.enter_phone_number') }}" id="number">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstemail" class="form-label">{{ __('messages.email') }}</label>
                            <input type="email" class="form-control" placeholder="{{ __('messages.enter_email') }}" id="firstemail">
                        </div>
                    </div>
                </div>
                <div class="upper-flex-main-modal">
                    <button class="btn  primary-outline-btn" data-bs-target="#guestOptionsModal" data-bs-toggle="modal">
                        {{ __('messages.back') }}
                    </button>
                    <button class="btn primary-btn" id="continueAsGuest">
                        {{ __('messages.continue') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered our-rental-price">
        <div class="modal-content">
            <div class="modal-body">
                <div class="inner-body-price">
                    <h3>{{ __('messages.our_rental_price') }}</h3>
                    <div class="upper-table-main-pop">
                        <table>
                            <tr>
                                <th>{{ __('messages.days') }}</th>
                                <th>{{ __('messages.price') }}</th>
                            </tr>
                            @foreach($dailyPrices as $index => $price)
                                <tr>
                                    <td>{{ __('messages.day_label', ['number' => $index + 1]) }}</td>
                                    <td>{{ number_format($price, 2, ',', '.') }} €</td>
                                </tr>
                            @endforeach
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade modal-not-book" id="requestSuccessful" tabindex="-1" aria-labelledby="requestSuccessful" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body text-center">
                <h5 class="modal-title" id="requestSuccessful">{{ __('messages.thank_you') }}</h5>
                <p>{{ __('messages.thank_you_message') }}</p>
                <button type="button" class="btn primary-btn" id="okayBtn">{{ __('messages.okay') }}</button>
            </div>
        </div>
    </div>
</div>
<script>
    let bookingData = {};
    $(document).ready(function() {
        $.get(`${baseUrl}/userCarDetail`, function(data) {
            if (data) {

                bookingData = data.data;
                if (bookingData && Object.keys(bookingData).length > 0) {
                    console.log(bookingData)
                    fillBookingData(bookingData);
                }
                
                
            }

    });
    const waitForOption = (selector, value) => {
        return new Promise(resolve => {
            const interval = setInterval(() => {
                const $option = $(`${selector} option`).filter(function () {
                    return $(this).val().trim() === value.trim();
                });
                if ($option.length) {
                    console.log($option.val(),selector)

                    $(selector).val($option.val()).trigger('change');
                    clearInterval(interval);
                    resolve();
                }
            }, 200);
        });
    };

    async function fillBookingData(data) {
        if (data.manufacturer) {
            await waitForOption("#manufacturer", data.manufacturer);
        }
        
        if (data.car_model) {
            await waitForOption("#model", data.car_model);
        }
        if (data.car_year) {
            await waitForOption("#year", data.car_year);
        }
        if (data) {
            if(data.trailer_hitch == 1){
                data.trailer_hitch = 'yes';
            }else{
                data.trailer_hitch = 'no'
            }
            await waitForOption("#trailer_hitch", data.trailer_hitch.toLowerCase());
        }
    }
    });

</script>

<script>
     var baseUrl = "{{ rtrim(config('app.url'), '/') }}";
    let carrier_length = null;
    let foot_sku = null;
    let footkit_sku = null;

    let user = @json(auth()->user());

    if(user) {
        $('#title').val(user.title);
        $('#first_name').val(user.first_name);
        $('#last_name').val(user.last_name);
        $('#requestEmail').val(user.email);
        $('#country_code').val(user.country_code);
        $('#requestPhone').val(user.number);
        $('#street').val(user.street);
        $('#zipcode').val(user.zip_code);
        $('#city').val(user.city);
        $('#state').val(user.region);
    }

    window.unavailableComponents = [];

    $(document).on('click', '#okayBtn', function() {
        location.reload();
    });


    function toggleRentButton(isAvailable) {
        if (isAvailable) {
            $('#rentNowButton').removeClass('d-none');
            $('#requestButton').addClass('d-none');
        } else {
            $('#rentNowButton').addClass('d-none');
            $('#requestButton').removeClass('d-none');
        }
    }

    function populateRequestForm() {
        // Get all relevant product information
        const productId = $('#product_id').val();
        const productName = $('#product_name').val();
       
        const rentalFrom = $('#rental_from').val();
        const rentalTo = $('#rental_to').val();
        const manufacturer = $('#manufacturer').val();
        const model = $('#model').val();
        const year = $('#year').val();
        const trailerHitch = $('#trailer_hitch').val();
        const roofType = selectedRecommendation ? selectedRecommendation.rooftype_eng : '';
        
        // Set hidden field values
        $('#requestProductId').val(productId);
        $('#requestProductName').val(productName);
      
        $('#requestRentalFrom').val(rentalFrom);
        $('#requestRentalTo').val(rentalTo);
        $('#requestCarrierLength').val(selectedRecommendation ? selectedRecommendation.carrier_length : '');
        $('#requestFootSku').val(selectedRecommendation ? selectedRecommendation.foot_sku : '');
        $('#requestFootkitSku').val(selectedRecommendation ? selectedRecommendation.footkit_sku : '');
        $('#requestRoofType').val(roofType);
        
        // Build product details display
        let detailsHtml = `
            <p><strong>Product:</strong> ${productName}</p>
            <p><strong>Rental Period:</strong> ${rentalFrom} to ${rentalTo}</p>
        `;
        
        if (manufacturer) {
            detailsHtml += `<p><strong>Vehicle:</strong> ${manufacturer} ${model} (${year})</p>`;
        }
        
        if (trailerHitch) {
            detailsHtml += `<p><strong>Trailer Hitch:</strong> ${trailerHitch}</p>`;
        }
        
        if (roofType) {
            detailsHtml += `<p><strong>Roof Type:</strong> ${roofType}</p>`;
        }
        
        // Add unavailable components if any
        if (window.unavailableComponents && window.unavailableComponents.length > 0) {
            detailsHtml += `<p><strong>Unavailable Components:</strong> ${window.unavailableComponents.join(', ')}</p>`;
            $('#requestUnavailableComponents').val(window.unavailableComponents.join(', '));
        }
        
        $('#requestProductDetails').html(detailsHtml);
    }

function parseDMY(dateStr) {
        const [day, month, year] = dateStr.split('.');
        const fullYear = parseInt(year) < 100 ? 2000 + parseInt(year) : parseInt(year);
        return new Date(fullYear, parseInt(month) - 1, parseInt(day));
    }
function saveFormDataAndRedirect(redirectUrl) {

    let rentalFromStr = $('#rental_from').val();
    let rentalToStr = $('#rental_to').val();

    let rentalFrom = parseDMY(rentalFromStr);
    let rentalTo = parseDMY(rentalToStr);

    let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
    let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
    let formData = {
        product_id: $('#product_id').val(),
        product_name: $('#product_name').val(),
        manufacturer: $('#manufacturer').val(),
        car_year: $('#year').val(),
        model: $('#model').val(),
        trailer_hitch: $('#trailer_hitch').val(),
        roof_type: selectedRecommendation?.rooftype_eng || '',
        carrier_length: selectedRecommendation?.carrier_length || '',
        foot_sku: selectedRecommendation?.foot_sku || '',
        footkit_sku: selectedRecommendation?.footkit_sku || '',
        booking_item_ids: $('#booking_item_ids').val() || '',
        bundle_name: selectedRecommendation?.bundle_name || '',
        rental_from: $('#rental_from').val(),
        rental_to: $('#rental_to').val(),
        days: days,
        calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
        is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
        vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
    };
    formData._token = $('meta[name="csrf-token"]').attr('content');


    $.post(`${baseUrl}/store-rental-form`, formData, function() {
        window.location.href = redirectUrl; 
    });
}

$(document).ready(function() {
    $('#manufacturer').change(function() {
        $('#model').prop('disabled', true).html('<option>Loading...</option>');
        $('#year').prop('disabled', true).html('<option>Select</option>');
        
        let manufacturer = $(this).val();

        $.get(`${baseUrl}/car/models`, {manufacturer}, function(data) {
            $('#model').prop('disabled', false).html('<option selected disabled>Select</option>');
            data.forEach(model => {
                $('#model').append(`<option value="${model}">${model}</option>`);
            });
        });
    });

    $('#model').change(function() {
        $('#year').prop('disabled', true).html('<option>Loading...</option>');
        
        let manufacturer = $('#manufacturer').val();
        let model = $(this).val();

        $.get(`${baseUrl}/car/years`, {manufacturer, model}, function(data) {
            $('#year').prop('disabled', false).html('<option selected disabled>Select</option>');
            data.forEach(year => {
                $('#year').append(`<option value="${year}">${year}</option>`);
            });
        });
    });

    var railing_type = $('#railing_type').val();
console.log('railing_type',railing_type)
$('#year, #trailer_hitch').change(function() {
    let manufacturer = $('#manufacturer').val();
    let year = $('#year').val();
    let model = $('#model').val();
    let trailer_hitch = $('#trailer_hitch').val();


    const productName = $('#trailer_hitch').data('product-name');
    const selectedValue = $('#trailer_hitch').val();
    const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
    if (selectedValue === 'no' && hitchRequired) {
        $('#trailer_hitch').val('');

        const modal = new bootstrap.Modal(document.getElementById('notBookableModal'));
        modal.show();
        return ;
    }


    if (manufacturer && year && model && trailer_hitch) {
        $.get(`${baseUrl}/car/recommendation`, {manufacturer, year, model, trailer_hitch}, function(data) {
            window.currentRecommendation = data;
            window.currentRecommendationMap = {};

            if (data.length === 0) {
                $('#result').html('<p>No recommendations found.</p>');
                return;
            }

            $('.roof-name-detail').hide();
            $('#roof-types-container').show();

            

            data.forEach((item, index) => {
                const roofTypeSlug = item.rooftype_eng.toLowerCase().replace(/ /g, '-');

               console.log('roofTypeSlug',roofTypeSlug)
                if(railing_type){
                    $(`#roof-type-${roofTypeSlug}`).show();
    
                    window.currentRecommendationMap[roofTypeSlug] = item;
                    $(`#roof-type-${roofTypeSlug}`)
                        .addClass('clickable-roof')
                        .attr('data-rooftype-slug', roofTypeSlug);
                }
            });

            $('#result').html(html);
            highlightRecommendedSizes(data);
        });
    }
});

});




function checkAvailability() {
    const fromDate = $('#rental_from').val();
    const toDate = $('#rental_to').val();
    const vendor_id = $('#vendor_select').val();

   
    
    const params = {
        from_date: fromDate,
        to_date: toDate,
        vendor_id : vendor_id,
        carrier_length : carrier_length,
        foot_sku : foot_sku,
        footkit_sku : footkit_sku

    };

    if(!fromDate || !toDate || !vendor_id){
        return; 
    }
    
    $.get(`${baseUrl}/product/{{ $product->id }}/roofRack/availability`, params, function(availability) {
        $('.inner-size-card').each(function() {
            const $card = $(this);
            const sizeName = $card.data('size-name');
            const sizeId = $card.data('size-id') || $card.data('variation-id');
            const isAvailable = availability[sizeId] > 0;
            
            $card.toggleClass('available', isAvailable)
                 .toggleClass('unavailable', !isAvailable);
                 
            const $badge = $card.find('.badge');
            $badge.removeClass('bg-secondary bg-success bg-danger')
                  .addClass(isAvailable ? 'bg-success' : 'bg-danger')
                  .text(isAvailable ? '' : 'Unavailable');
        });
        const bookingItemIds = {};
        
        if (availability.carrier && availability.carrier.booking_item_ids.length > 0) {
            bookingItemIds.carrier = availability.carrier.booking_item_ids[0];
        }
        
        if (availability.foot && availability.foot.booking_item_ids.length > 0) {
            bookingItemIds.foot = availability.foot.booking_item_ids[0];
        }
        
        if (availability.footkit && availability.footkit.booking_item_ids.length > 0) {
            bookingItemIds.footkit = availability.footkit.booking_item_ids[0];
        }
        
        // Store the dictionary as JSON string
        window.bookingItemIds = JSON.stringify(bookingItemIds);
        
        // Check availability
        const isCarrierAvailable = availability.carrier && availability.carrier.available_units > 0;
        const isFootAvailable = availability.foot && availability.foot.available_units > 0;
        const isFootkitAvailable = availability.footkit && availability.footkit.available_units > 0;
        const isAvailable = isCarrierAvailable && isFootAvailable && isFootkitAvailable;



        $('#booking_item_ids').val(window.bookingItemIds);
        if (!isAvailable) {
            let errorMessage = '';
            const unavailableComponents = [];
            
            // if (!isCarrierAvailable) unavailableComponents.push('carrier');
            // if (!isFootAvailable) unavailableComponents.push('foot');
            // if (!isFootkitAvailable) unavailableComponents.push('footkit');


            // if (!isCarrierAvailable) window.unavailableComponents.push('carrier');
            // if (!isFootAvailable) window.unavailableComponents.push('foot');
            // if (!isFootkitAvailable) window.unavailableComponents.push('footkit');

            if (!isCarrierAvailable) window.unavailableComponents.push('traverse');
            if (!isFootAvailable) window.unavailableComponents.push('fuß');
            if (!isFootkitAvailable) window.unavailableComponents.push('fußkit');


            if (!isCarrierAvailable) unavailableComponents.push('traverse');
            if (!isFootAvailable) unavailableComponents.push('fuß');
            if (!isFootkitAvailable) unavailableComponents.push('fußkit');
            
            errorMessage += unavailableComponents.join(', ');
            
            $('#errorMessage').html(`
                
                <div class="size-unavailable-message text-danger mt-2">
                    The ${errorMessage} you have selected is currently unavailable, but you can send a request and we will let you know when it is available.
                </div>
            `);

            toggleRentButton(isAvailable);
        } else {
            $('#errorMessage').empty();
        }
        
        if (window.currentRecommendation) {
            highlightRecommendedSizes(window.currentRecommendation);
        }


        
        if (window.currentRecommendation) {
            highlightRecommendedSizes(window.currentRecommendation);
        }
    });
}

$('#vendor_select').on('change',function(){
    const fromDate = $('#rental_from').val();
    const toDate = $('#rental_to').val();
    if ( fromDate && toDate) {
        checkAvailability();
    }
})


$('#rental_from, #rental_to').on('change', function() {

        checkAvailability();
   
});



// function highlightRecommendedSizes(recommendation) {
//     $('.inner-size-card').removeClass('recommended-size');
    
//     recommendation.forEach(item => {
//         $(`.inner-size-card[data-size-name="${item.recommended_roofbox_size}"]`)
//             .addClass('recommended-size');
//     });
// }



function highlightRecommendedSizes(recommendation) {
        $('.inner-size-card').removeClass('recommended-size');
        $('.recommended').addClass('d-none')
    recommendation.forEach(item => {
        const $card = $(`.inner-size-card[data-size-name="${item.recommended_roofbox_size}"]`);
        $card.addClass('recommended-size');
        console.log(item)
        $card.find('.recommended').removeClass('d-none');
            $card.find('.recommended').text('EMPFOHLEN');
    });
}

var railing_type = $('#railing_type').val();
console.log('railing_type',railing_type)
$('#year, #trailer_hitch').change(function() {
    let manufacturer = $('#manufacturer').val();
    let year = $('#year').val();
    let model = $('#model').val();
    let trailer_hitch = $('#trailer_hitch').val();


    const productName = $('#trailer_hitch').data('product-name');
    const selectedValue = $('#trailer_hitch').val();
    const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
    if (selectedValue === 'no' && hitchRequired) {
        $('#trailer_hitch').val('');

        const modal = new bootstrap.Modal(document.getElementById('notBookableModal'));
        modal.show();
        return ;
    }


    if (manufacturer && year && model && trailer_hitch) {
        $.get(`${baseUrl}/car/recommendation`, {manufacturer, year, model, trailer_hitch}, function(data) {
            window.currentRecommendation = data;
            window.currentRecommendationMap = {};

            if (data.length === 0) {
                $('#result').html('<p>No recommendations found.</p>');
                return;
            }

            $('.roof-name-detail').hide();
            $('#roof-types-container').show();

            

            data.forEach((item, index) => {
                const roofTypeSlug = item.rooftype_eng.toLowerCase().replace(/ /g, '-');

               console.log('roofTypeSlug',roofTypeSlug)
                if(railing_type){
                    $(`#roof-type-${roofTypeSlug}`).show();
    
                    window.currentRecommendationMap[roofTypeSlug] = item;
                    $(`#roof-type-${roofTypeSlug}`)
                        .addClass('clickable-roof')
                        .attr('data-rooftype-slug', roofTypeSlug);
                }
            });

         
            highlightRecommendedSizes(data);
        });
    }
});

let selectedRecommendation = null;


$(document).on('click', '.clickable-roof', function () {
    $('.clickable-roof').removeClass('selected');
    $(this).addClass('selected');

    const slug = $(this).data('rooftype-slug');
    selectedRecommendation = window.currentRecommendationMap[slug];


    console.log(selectedRecommendation);

    $('#roof-types-container .invalid-feedback').remove();

    if (selectedRecommendation) {
        const html = `
            <div class="roof-info-card" style="padding: 15px; border: 1px solid #ccc; border-radius: 8px; background: #f9f9f9;">
                <h4>Bundle Name : ${selectedRecommendation.bundle_name}</h4>
                <ul style="list-style: none; padding-left: 0;">
                    <li><strong>Carrier Length:</strong> ${selectedRecommendation.carrier_length || 'N/A'}</li>
                    <li><strong>Foot SKU:</strong> ${selectedRecommendation.foot_sku || 'N/A'}</li>
                    <li><strong>Foot Kit SKU:</strong> ${selectedRecommendation.footkit_sku || 'N/A'}</li>
                    <li><strong>Recommended Roofbox Size:</strong> ${selectedRecommendation.recommended_roofbox_size || 'N/A'}</li>
                    <li><strong>Roof Type:</strong> ${selectedRecommendation.rooftype_ger || 'N/A'}</li>
                </ul>
            </div>
        `;
        carrier_length = selectedRecommendation.carrier_length;
        foot_sku = selectedRecommendation.foot_sku;
        footkit_sku = selectedRecommendation.footkit_sku;
        $('#roof-details-box').html(html).fadeIn();
    } else {
        $('#roof-details-box').hide();
    }
});



$(document).on('click', '.inner-size-card', function () {

    const colorId = $('#color-select').val();
    const colorName = $('#color-select').find('option:selected').data('color-name');
    if (!colorName) {
        $('#errorMessage').html(`
            <div class="text-danger mt-2">
                Please select a color first.
            </div>
        `);
        return;
    }


    const $card = $(this);
    const isAvailable = $card.hasClass('available');
    const isUnavailable = $card.hasClass('unavailable');

    $('.inner-size-card').removeClass('selected');
    $('#errorMessage').empty();

    $card.addClass('selected');

    if (isUnavailable) {
        const message = `
            <div class="size-unavailable-message text-danger mt-2">
                    Some of the products you selected are not available at this location. Please select a different size/variant or location, or send us a booking request. We will review your request and let you know if the products can be made available at your desired time and location.
            </div>
        `;
        $('#errorMessage').html(message);
    }

    const sizeId = $(this).data('size-id');
    const variationId = $(this).data('variation-id');
    const sizeName = $(this).data('size-name');

    $.get(`${baseUrl}/product/{{ $product->id }}/size-details`, {
        size_id: sizeId,
        variation_id: variationId
    }, function(data) {
        if (data) {
            if (data.length && data.width && data.height) {
                $('#dimensionsText').hide();
                $('#dimensionsList').show();
                $('#dimensionLength').text(data.length);
                $('#dimensionWidth').text(data.width);
                $('#dimensionHeight').text(data.height);
            } else {
                $('#dimensionsText').show().text('Dimensions not available for this size');
                $('#dimensionsList').hide();
            }

            if (data.weight) {
                $('#weightText').hide();
                $('#weightList').show();
                $('#weightValue').text(data.weight);
            } else {
                $('#weightText').show().text('Weight not available for this size');
                $('#weightList').hide();
            }

            if (data.volume) {
                $('#volumeText').hide();
                $('#volumeList').show();
                $('#volumeValue').text(data.volume);
            } else {
                $('#volumeText').show().text('Volume not available for this size');
                $('#volumeList').hide();
            }

            if (data.max_load) {
                $('#maxLoadText').hide();
                $('#maxLoadList').show();
                $('#maxLoadValue').text(data.max_load);
            } else {
                $('#maxLoadText').show().text('Max load not available for this size');
                $('#maxLoadList').hide();
            }
        } else {
            $('#dimensionsText').show().text('Product details not available for this size');
            $('#dimensionsList').hide();
            $('#weightText').show().text('Product details not available for this size');
            $('#weightList').hide();
            $('#volumeText').show().text('Product details not available for this size');
            $('#volumeList').hide();
            $('#maxLoadText').show().text('Product details not available for this size');
            $('#maxLoadList').hide();
        }
    }).fail(function() {
        $('#dimensionsText').show().text('Error loading product details');
        $('#weightText').show().text('Error loading product details');
        $('#volumeText').show().text('Error loading product details');
        $('#maxLoadText').show().text('Error loading product details');
    });

});

$('.roof-name-detail').hide();
$('#roof-types-container').hide();
    const dailyPrices = @json($dailyPrices);
    const roofRackPrices = @json($roofRackPrices); 
    const insuranceFlatFee = 25.00;
  

    function calculateRent() {
        // const from = new Date($('#rental_from').val());
        // const to = new Date($('#rental_to').val());


        const from = parseDMY($('#rental_from').val());
        const to = parseDMY($('#rental_to').val());

        if (isNaN(from) || isNaN(to) || to < from) return;

        const days = Math.ceil((to - from) / (1000 * 60 * 60 * 24)) + 1;

        let totalRent = 0;

        for (let i = 0; i < days && i < dailyPrices.length; i++) {
            totalRent += dailyPrices[i];

            if ($('#roof_rack_checkbox').is(':checked') && i < roofRackPrices.length) {
                console.log('totalRent', totalRent)
                totalRent += roofRackPrices[i];
            }
        }

        if ($('#insurance_checkbox').is(':checked')) {
            totalRent += insuranceFlatFee;
            $('#withinsurance').removeClass('d-none');
            $('#withoutinsurance').addClass('d-none');
        }else{
            $('#withoutinsurance').removeClass('d-none');
            $('#withinsurance').addClass('d-none');
        }

        $('.inner-number-days span:first').text(days);
        $('.inner-number-days span:last').text(totalRent.toFixed(2).replace('.', ',') + ' €');
    }

    $('#rental_from, #rental_to').on('change', calculateRent);


</script>

<script>
    $('#insurance_checkbox').on('change', function () {
        $('#insurance_selected').val(this.checked ? 1 : 0);
    });

    $('#roof_rack_checkbox').on('change', function () {
        $('#roof_rack_selected').val(this.checked ? 1 : 0);
    });



    $(document).ready(function() {

        $('#roof_rack_checkbox').change(function() {
            if (!this.checked) {
                const modal = new bootstrap.Modal(document.getElementById('notCarrier'));
                modal.show();
            }else{
                calculateRent();
            }
        });

        $('#insurance_checkbox').change(function() {
            if (!this.checked) {
                const modal = new bootstrap.Modal(document.getElementById('notInsurance'));
                modal.show();
            }else{
                calculateRent();
            }
        });

        $('#rentCarrierBtn').click(function() {
            $('#roof_rack_checkbox').prop('checked', true).trigger('change');
            $('#notCarrier').modal('hide');
        });

        $('#bringOwnCarrierBtn').click(function() {
            $('#roof_rack_checkbox').prop('checked', false);
            $('#notCarrier').modal('hide');
            calculateRent(); 
        });

        $('#wantInsuranceBtn').click(function() {
            $('#insurance_checkbox').prop('checked', true).trigger('change');
            $('#notInsurance').modal('hide');
        });

        $('#noInsuranceBtn').click(function() {
            $('#insurance_checkbox').prop('checked', false);
            $('#notInsurance').modal('hide');
            calculateRent(); 
        });
    function validateForm() {
        let isValid = true;

        // Reset all error states
        $('.is-invalid').removeClass('is-invalid');
        $('.invalid-feedback').remove();

        // Validate required fields
        if (!$('#manufacturer').val()) {
            showError($('#manufacturer'), 'Please enter Manufacturer');
            isValid = false;
        }
        
        if (!$('#year').val()) {
            showError($('#year'), 'Please enter Year ');
            isValid = false;
        }
        
        if (!$('#model').val()) {
            showError($('#model'), 'Please enter Model ');
            isValid = false;
        }
        
        // Trailer hitch validation
        const productName = $('#trailer_hitch').data('product-name');
        const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
        if (hitchRequired && !$('#trailer_hitch').val()) {
            showError($('#trailer_hitch'), 'Trailer hitch selection is required for this product');
            isValid = false;
        }
        
       
        
       
        
        // Rental dates validation
        if (!$('#rental_from').val()) {
            showError($('#rental_from'), 'Please enter Start date ');
            isValid = false;
        }
        
        if (!$('#rental_to').val()) {
            showError($('#rental_to'), 'Please enter End date ');
            isValid = false;
        } 
        
        if ($('#rental_from').val() && $('#rental_to').val()) {
            

            const from = parseDMY($('#rental_from').val());
            const to = parseDMY($('#rental_to').val());
            if (to < from) {
                showError($('#rental_to'), 'End date must be after start date');
                isValid = false;
            }
        }

        if($('#errorMessage').text()){
            isValid = false;
        }
        
        return isValid;
    }

    function showError(element, message) {
        element.addClass('is-invalid');
        if (element.is('select')) {
            element.parent().append(`<div class="invalid-feedback">${message}</div>`);
        } else {
            element.after(`<div class="invalid-feedback">${message}</div>`);
        }
    }

    $('#manufacturer, #year, #model, #trailer_hitch, #rental_from, #rental_to').on('input change', function() {
        $(this).removeClass('is-invalid');
        $(this).next('.invalid-feedback').remove();
        $(this).parent().find('.invalid-feedback').remove();
    });
    $('.inner-size-card').on('click', function() {
        $('.invalid-feedback.d-block').remove();
    });


    $('#requestButton').click(function() {
        populateRequestForm();
    });

    $('#submitRequest').click(function() {
        const $btn = $(this); // reference to the button

        $btn.prop('disabled', true).text('Submitting...');
        let isValid = true;
        $('#requestForm .is-invalid').removeClass('is-invalid');

        function showError(id) {
            $(`#${id}`).addClass('is-invalid');
            isValid = false;
        }
    const formData = {
        title : $('#title').val(),
        first_name : $('#first_name').val(),
        last_name : $('#last_name').val(),
        street : $('#street').val(),
        zipcode : $('#zipcode').val(),
        city : $('#city').val(),
        email: $('#requestEmail').val(),
        state : $('#state').val(),
        country_code :$('#country_code').val(),
        phone: $('#requestPhone').val(),
        message: $('#requestMessage').val(),
        product_id: $('#requestProductId').val(),
        product_name: $('#requestProductName').val(),
        rental_from: $('#requestRentalFrom').val(),
        rental_to: $('#requestRentalTo').val(),
        manufacturer: $('#manufacturer').val(),
        car_model: $('#model').val(),
        car_year: $('#year').val(),
        trailer_hitch: $('#trailer_hitch').val(),
        roof_type: $('#requestRoofType').val(),
        carrier_length: $('#requestCarrierLength').val(),
        foot_sku: $('#requestFootSku').val(),
        footkit_sku: $('#requestFootkitSku').val(),
        unavailable_components: $('#requestUnavailableComponents').val(),
        pickup_location : $('#vendor_select option:selected').text(),
        _token: $('meta[name="csrf-token"]').attr('content')
    };
    
    if (!formData.title) showError('title');
        if (!formData.first_name) showError('first_name');
        if (!formData.last_name) showError('last_name');
        if (!formData.email) showError('requestEmail');
        if (!formData.phone) showError('requestPhone');
        if (!formData.street) showError('street');
        if (!formData.zipcode) showError('zipcode');
        if (!formData.city) showError('city');
        if (!formData.state) showError('state');
        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (formData.email && !emailPattern.test(formData.email)) showError('requestEmail');
        if (!isValid) {
            $btn.prop('disabled', false).text('Submit');
            return;
        }
    
    $.post(`${baseUrl}/product/request`, formData, function(response) {
        if (response.success) {
            $('#requestModal').modal('hide');
            
            $('#requestForm')[0].reset();
            $('#requestSuccessful').modal('show');
        } else {
            alert('There was an error submitting your request. Please try again.');
        }
    }).fail(function() {
        alert('There was an error submitting your request. Please try again.');
    }).always(function() {
        $btn.prop('disabled', false).text('Submit');
    });
});

    $('#bookingForm').on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission
        @auth
        if (validateForm()) {
            let rentalFromStr = $('#rental_from').val();
            let rentalToStr = $('#rental_to').val();

            let rentalFrom = parseDMY(rentalFromStr);
            let rentalTo = parseDMY(rentalToStr);

            let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
            let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
            let formData = {
                product_id: $('#product_id').val(),
                product_name: $('#product_name').val(),
                manufacturer: $('#manufacturer').val(),
                car_year: $('#year').val(),
                model: $('#model').val(),
                trailer_hitch: $('#trailer_hitch').val(),
                roof_type: selectedRecommendation?.rooftype_eng || '',
                carrier_length: selectedRecommendation?.carrier_length || '',
                foot_sku: selectedRecommendation?.foot_sku || '',
                footkit_sku: selectedRecommendation?.footkit_sku || '',
                booking_item_ids: $('#booking_item_ids').val() || '',

                bundle_name: selectedRecommendation?.bundle_name || '',
                
                rental_from: $('#rental_from').val(),
                rental_to: $('#rental_to').val(),
                days: days,
                calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                
                is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
                vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
            };

            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.redirect) {
                        window.location.href = response.redirect;
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        const errors = xhr.responseJSON.errors;
                        for (const field in errors) {
                            showError($(`#${field}`), errors[field][0]);
                        }
                    } else {
                        alert('An error occurred. Please try again.');
                    }
                }
            });
        } else {
            $('html, body').animate({
                scrollTop: $('.is-invalid').first().offset().top - 100
            }, 500);
        }
        @else
            if(validateForm()){
                e.preventDefault();
                $('#guestOptionsModal').modal('show');

            }
        @endauth
    });

    $('#continueAsGuest').click(function() {
        const name = $('#firstname').val().trim();
        const surname = $('#surname').val().trim();
        const email = $('#firstemail').val().trim();
        const number = $('#number').val();

      let isValid = true;

      $('#firstname, #surname, #firstemail,#number').removeClass('is-invalid');

      if (name === '') {
        $('#firstname').addClass('is-invalid');
        isValid = false;
      }

      
      if (surname === '') {
        $('#surname').addClass('is-invalid');
        isValid = false;
      }

      if(number === ''){
        $('#number').addClass('is-invalid');
        isValid = false;
      }

      const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (email === '' || !emailPattern.test(email)) {
        $('#firstemail').addClass('is-invalid');
        isValid = false;
      }

      if (isValid) {
      
        // $('#guestModal').modal('hide');

      }
        // $('#guestModal').modal('hide');
        let rentalFromStr = $('#rental_from').val();
        let rentalToStr = $('#rental_to').val();

        let rentalFrom = parseDMY(rentalFromStr);
        let rentalTo = parseDMY(rentalToStr);

        let timeDiff = rentalTo.getTime() - rentalFrom.getTime();
        let days = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1;
        let formData = {
                is_guest: 1,
                name: $('#firstname').val(),
                surname: $('#surname').val(),
                email: $('#firstemail').val(),
                number : $('#number').val(),
                product_id: $('#product_id').val(),
                product_name: $('#product_name').val(),
                manufacturer: $('#manufacturer').val(),
                car_year: $('#year').val(),
                model: $('#model').val(),
                trailer_hitch: $('#trailer_hitch').val(),
                roof_type: selectedRecommendation?.rooftype_eng || '',
                carrier_length: selectedRecommendation?.carrier_length || '',
                foot_sku: selectedRecommendation?.foot_sku || '',
                footkit_sku: selectedRecommendation?.footkit_sku || '',
                booking_item_ids: $('#booking_item_ids').val() || '',

                bundle_name: selectedRecommendation?.bundle_name || '',                
                rental_from: $('#rental_from').val(),
                rental_to: $('#rental_to').val(),
                days: days,
                calculated_rent: $('.inner-number-days span:last').text().replace(' €', '').replace(',', '.'),
                is_insured: $('#insurance_checkbox').is(':checked') ? 1 : 0,
                vendor_id : $('#vendor_select').val() == 'admin' ? '' : $('#vendor_select').val()
            };
        $.ajax({
            url: "{{route('cart.add')}}",
            method: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if(response.status ==  false){
                    $('#guestError')
                .removeClass('d-none')
                .text(response.message || 'Something went wrong. Please try again.');
                }else{
                    $('#guestModal').modal('hide');
                    $('#guestError').addClass('d-none');
                    if (response.redirect) {
                        window.location.href = response.redirect;
                    }
                }
             
            }
        });
    });
});
</script>
<script>

    $(function () {
        let holidays = @json($holidays);
        let nonworkingDays = @json($nonworkingDays); 
        let dayMap = {
            sunday: 0,
            monday: 1,
            tuesday: 2,
            wednesday: 3,
            thursday: 4,
            friday: 5,
            saturday: 6,
        };

        let closedDays = nonworkingDays.map(day => dayMap[day]);
        function disableWeekendsAndHolidays(date) {
            let day = date.getDay();
            let formattedDate = $.datepicker.formatDate('yy-mm-dd', date);

            let isWeekend = closedDays.includes(day);
            let isHoliday = holidays.includes(formattedDate);

            if (isWeekend || isHoliday) {
                return [false, ''];
            }
            return [true, ''];
        }

        function initDatePickers() {
            $("#rental_from, #rental_to").datepicker("destroy"); // reset old pickers

            $("#rental_from").datepicker({
                dateFormat: 'dd.mm.yy',
                minDate: 0,
                firstDay: 1,
                beforeShowDay: disableWeekendsAndHolidays,
                onSelect: function () {
                    const productName = $('#trailer_hitch').data('product-name');
                    const hitchRequired = !(productName === 'Roof Box' || productName === 'Roof Bike Carrier' || productName == 'Carrier' || productName=='Traverse' || productName == 'Foot' || productName == 'FootKit' || productName == 'Footkit' || productName == 'Roof Rack'
                || productName ==='Dachbox' || productName ==='Dachfahrradträger' || productName ==='Dachträger' || productName ==='Fuß' 
                || productName =='Fußkit' || productName =='FußKit' 
            );
                    if (!selectedRecommendation && !hitchRequired) {
                            const modal = new bootstrap.Modal(document.getElementById('railingType'));
                            modal.show();
                       
                        $(this).val(''); 
                        return ;
                    } 
                   
                        checkAvailability();
                    
                    calculateRent();
                }
            });

            $("#rental_to").datepicker({
                dateFormat: 'dd.mm.yy',
                minDate: 0,
                firstDay: 1,
                beforeShowDay: disableWeekendsAndHolidays,
                onSelect: function () {
                   
                        checkAvailability();
                   
                    calculateRent();
                }
            });
        }

    
        initDatePickers();

   
   


        $('#vendor_select').on('change', function () {


            let vendorId = $(this).val();
            $.ajax({
                url: "{{ route('vendor.calendar.data') }}",
                type: 'GET',
                data: { vendor_id: vendorId },
                success: function (response) {
                    holidays = response.holidays;
                    nonworkingDays = response.nonworkingDays;
                    closedDays = nonworkingDays.map(day => dayMap[day]);
                    initDatePickers();
                }
            });
        });
    });
    function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function () {
        $('#country_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });
    });



</script>

<style>

.clickable-roof {
    border: 2px solid transparent;
    cursor: pointer;
    transition: 0.2s;
}
.clickable-roof:hover {
    border-color: #007bff;
}
.clickable-roof.selected {
    border-color: #007bff;
    background-color: #e9f5ff;
}

</style>

@endsection