@extends('layouts.frontend')
@section('content')
<main>

<section class="banner-back-img-prod">
    <div class="inner-main-img">
        <div class="container">
            <div class="inner-banner-comn">
                <h1>{{ __('messages.all_products') }}</h1>
            </div>
        </div>
    </div>
</section>

<section class="comn-padd">
    <div class="container">
        <div class="inner-main-our-product">
            <h2>{{ __('messages.our_products') }}</h2>
            <p>{!! nl2br(__('messages.our_products_description')) !!}</p>

        </div>

        <div class="products-main-wrapper">
            <div class="row row-gap-4">
                @foreach ($products as $product)
                    <div class="col-lg-4">
                        <div class="product-main-one">
                        <div class="upper-imag-product-card">
                            <a href="{{ route('product.details', $product->category->slug) }}">
                                <figure>
                                    <img src="{{ $product->homePhoto?->image_path ? asset('storage/' . $product->homePhoto->image_path) : asset('frontend/images/placeholder.png') }}" alt="{{ $product->name }}">
                                </figure>
                            </a>
                        </div>

                        <div class="product-detail-name-card">
                            <h3>{{ $product->name }}</h3>
                            @if ($product->first_price)
                                <p>{{ __('messages.from_price', ['price' => $product->first_price]) }}</p>
                            @endif
                            <a href="{{ route('product.details', $product->category->slug) }}" class="btn rent-btn">{{ __('messages.rent_now') }}</a>
                        </div>

                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>

</main>

@endsection