<!DOCTYPE html>
<html>
<head>
    <title>{{ __('messages.invoice') }} {{ $invoice_number }}</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        .header { margin-bottom: 20px; border-bottom: 1px solid #eee; padding-bottom: 10px; }
        .issuer, .recipient { width: 45%; float: left; margin-bottom: 30px; }
        .recipient { float: right; }
        .clear { clear: both; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; font-weight: bold; }
        .totals { float: right; width: 300px; margin-top: 20px; }
        .footer { margin-top: 50px; font-size: 10px; border-top: 1px solid #eee; padding-top: 10px; }
        .invoice-title { font-size: 24px; color: #333; }
    </style>
</head>
<body>
    <div class="header">
        <h1 class="invoice-title">{{ __('messages.invoice') }} {{ $invoice_number }}</h1>
        <p><strong>{{ __('messages.date') }}:</strong> {{ $invoice_date->format('d.m.Y') }}</p>
    </div>

    <div class="issuer">
        <h3>{{ __('messages.issuer') }}:</h3>
        <p><strong>{{ $issuer['name'] }}</strong></p>
        <p>{{ $issuer['address'] }}</p>
        <p>{{ __('messages.tax_number') }}: {{ $issuer['tax_number'] }}</p>
        <p>{{ __('messages.vat_id') }}: {{ $issuer['vat_number'] }}</p>
    </div>

    <div class="recipient">
        <h3>{{ __('messages.recipient') }}:</h3>
        <p><strong>{{ $recipient['name'] }}</strong></p>
        <p><strong>{{ $recipient['company_name'] }}</strong></p>
        <p>{{ $recipient['address'] }}</p>
        <p>{{ $recipient['zip'] }} {{ $recipient['city'] }}</p>
        <p>{{ $recipient['country'] }}</p>
        <p>{{ __('messages.email') }}: {{ $recipient['email'] }}</p>
        <p>{{ __('messages.phone') }}: {{ $recipient['phone'] }}</p>
    </div>

    <div class="clear"></div>

    <h3>{{ __('messages.booking_details') }}:</h3>
    <p><strong>{{ __('messages.booking_date') }}:</strong> {{ $booking_date->format('d.m.Y H:i') }}</p>
    <p><strong>{{ __('messages.payment_method') }}:</strong> {{ ucfirst($payment_method) }}</p>

    <table>
        <thead>
            <tr>
                <th>{{ __('messages.product') }}</th>
                <th>{{ __('messages.car_details') }}</th>
                <th>{{ __('messages.insurance') }}</th>
                <th>{{ __('messages.carrier') }}</th>
                <th>{{ __('messages.pickup') }}</th>
                <th>{{ __('messages.dropoff') }}</th>
                <th>{{ __('messages.price') }} (€)</th>
            </tr>
        </thead>
        <tbody>
        @foreach($booking_items as $item)
        <tr>
            <td>{{ $item['product_name'] }} ({{ $item['size'] }})</td>
            <td>
                {{ $item['car_name'] }} {{ $item['car_year'] }} {{ $item['model'] }}<br>
                {{ __('messages.color') }}: {{ $item['color'] }}<br>
                {{ __('messages.roof') }}: {{ $item['roof_type'] }}
            </td>
            <td>{{ $item['is_insured'] ? __('messages.yes') : __('messages.no') }}</td>
            <td>{{ $item['is_carrier_included'] ? __('messages.yes') : __('messages.no') }}</td>
            <td>{{ Carbon\Carbon::parse($item['pickup_date'])->format('d.m.y') }}<br>
                {{ $item['pickup_time'] ? Carbon\Carbon::parse($item['pickup_time'])->format('H:i') : '' }}</td>
            <td>{{ Carbon\Carbon::parse($item['dropoff_date'])->format('d.m.y') }}<br>
                {{ $item['dropoff_time'] ? Carbon\Carbon::parse($item['dropoff_time'])->format('H:i') : '' }}</td>
            <td>{{ number_format($item['calculated_rent'], 2, ',', '.') }}€</td>
        </tr>
        @endforeach
        </tbody>
    </table>

    <div class="totals">
        <table>
            <tr>
                <td>{{ __('messages.subtotal') }}:</td>
                <td>{{ number_format($subtotal, 2, ',', '.') }}€</td>
            </tr>
            @if($booking->discount > 0)
            <tr>
                <td>{{ __('messages.discount') }}:</td>
                <td>-{{ number_format($booking->discount, 2, ',', '.') }}€</td>
            </tr>
            @endif
            <tr>
                <td>{{ __('messages.vat_19') }}:</td>
                <td>{{ number_format($tax, 2, ',', '.') }}€</td>
            </tr>
            <tr>
                <td><strong>{{ __('messages.total') }}:</strong></td>
                <td><strong>{{ number_format($total, 2, ',', '.') }}€</strong></td>
            </tr>
        </table>
    </div>

    <div class="clear"></div>

    <div class="footer">
        <p><strong>{{ __('messages.payment_terms') }}:</strong> {{ __('messages.payment_terms_text') }}</p>
        <p><strong>{{ __('messages.cancellation_policy') }}:</strong> {{ __('messages.cancellation_policy_text') }}</p>
       <p>{{ __('messages.thank_you_invoice_message') }}</p>
    </div>
</body>
</html>
