<div class="comm_renting_dt_row">
    <h3 class="rnt_head">{{ __('messages.previous_booked_slot') }}: <span>{{ __('messages.booking_id') }}: {{ $booking->id }}</span></h3>

    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
        @foreach($booking->items as $item)
            <div class="comm_detail_list_col">
                <h5>{{ __('messages.from') }}:</h5>
                <h6>{{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }}</h6>
            </div>
            <div class="comm_detail_list_col">
                <h5>{{ __('messages.to') }}:</h5>
                @php
                    $dropoffDate = $item->new_dropoff_date ? $item->new_dropoff_date : $item->dropoff_date;
                @endphp
                <h6>{{ \Carbon\Carbon::parse($dropoffDate)->format('d.m.Y') }}</h6>
            </div>
            <div class="comm_detail_list_col">
                <h5>{{ __('messages.pickup_datetime') }}:</h5>
                <h6>{{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }} | {{ \Carbon\Carbon::parse($item->pickup_time)->format('H:i') }}</h6>
            </div>
            <div class="comm_detail_list_col">
                <h5>{{ __('messages.dropoff_datetime') }}:</h5>
                @php
                    $dropoffDate = $item->new_dropoff_date ?? $item->dropoff_date;
                    $dropoffTime = $item->new_dropoff_time ?? $item->dropoff_time;
                @endphp

                <h6>{{ \Carbon\Carbon::parse($dropoffDate)->format('d.m.Y') }} | {{ \Carbon\Carbon::parse($dropoffTime)->format('H:i') }}</h6>

            </div>
        @endforeach
    </div>
</div>

<p class="default-text mt-3 mb-3">{{ __('messages.unable_to_change_notice') }}</p>

<h3 class="main-head-pro">{{ __('messages.change_your_appointment') }}</h3>

<div class="cst_calender">
    <div id="calendar-box"></div>
</div>

<div class="row my_appiont_date_row">
    <div class="col-md-6">
        <div class="my_appiont_date_col">
            <div class="inner-main-input">
                <label for="pickupDate" class="form-label">{{ __('messages.pickup_date') }}</label>
                <input class="form-control date-input" type="text" id="pickupDate" placeholder="{{ __('messages.select_date_calendar') }}" readonly>
            </div>
            <p class="avail_slots_text">{{ __('messages.available_slot') }}</p>
            <ul class="available_slots_row" id="from-slots"></ul>
        </div>
    </div>
    <div class="col-md-6">
        <div class="my_appiont_date_col">
            <div class="inner-main-input">
                <label for="dropoffDate" class="form-label">{{ __('messages.dropoff_date') }}</label>
                <input class="form-control date-input" type="text" id="dropoffDate" placeholder="{{ __('messages.select_date_calendar') }}" readonly>
            </div>
            <p class="avail_slots_text">{{ __('messages.available_slot') }}</p>
            <ul class="available_slots_row" id="to-slots"></ul>
        </div>
    </div>
</div>



<div id="newSlotPreview"></div>

<div class="text-center mt-4">
    <button class="btn primary-btn" id="saveChangesBtn" disabled>{{ __('messages.save_new_slot') }}</button>
</div>

<div class="d-flex align-items-center text-start my_app_bott_cnt_sec">
    <p class="default_text">{{ __('messages.custom_request_notice') }}</p>
    <button class="btn primary-btn" data-bs-toggle="modal" data-bs-target="#contactModal">{{ __('messages.contact_us') }}</button>
</div>


<!-- Contact Us Modal -->
