@extends('layouts.frontend')

@section('content')
<main>
  <section class="banner-back-img-with banner-back-img-with-addaddress">
    <div class="inner-main-img">
      <div class="container">
        <div class="inner-banner-comn">
          <h1>{{ __('messages.edit_billing_address') }}
</h1>
        </div>
      </div>
    </div>
  </section>

  <div class="prof-main">
    <section class="comn-padd">
      <div class="container">
        <div class="inner-acount">
          <div class="row">
            <div class="col-lg-3">
              <div class="inner-left-tabs">
                @include('frontend.user.include.sidebar')
              </div>
            </div>

            <div class="col-lg-9">
              <section id="edit-address">
                <div class="comm_border_box">
                  <h3 class="main-head-pro">{{ __('messages.edit_address') }}</h3>
                  <div class="upper-form-main">
                    <div class="add_profile_form">

                      <form class="row comm_form" method="POST" action="{{ route('user.billing-address.update', $address->id) }}" id="editAddressForm">
                        @csrf

                        <div class="col-md-6">
                          <div class="d-flex profile_title_input">
                            <div class="inner-main-input inner-main-input2">
                              <label class="form-label">{{ __('messages.name') }}</label>
                              <input type="text" class="form-control" name="first_name" id="first_name" value="{{ old('first_name', $address->name) }}">
                              <div class="invalid-feedback">{{ __('messages.first_name_error') }}</div>
                            </div>
                          </div>
                        </div>
                         <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.company_name_optional') }}</label>
                                <input type="text" class="form-control" name="company_name" id="company_name" placeholder="{{ __('messages.enter_company_name') }}" value="{{ old('street', $address->company_name) }}">
                                
                            </div>
                        </div>

                        <div class="col-md-6">
                          <div class="inner-main-input inner-main-input2">
                            <label class="form-label">{{ __('messages.street_house_number') }}</label>
                            <input type="text" class="form-control" name="street" id="street" value="{{ old('street', $address->street) }}">
                            <div class="invalid-feedback">{{ __('messages.street_error') }}</div>
                          </div>
                        </div>

                        <div class="col-md-6">
                          <div class="inner-main-input inner-main-input2">
                            <label class="form-label">{{ __('messages.zip_code') }}</label>
                            <input type="text" class="form-control" name="zipcode" id="zipcode" value="{{ old('zipcode', $address->zipcode) }}">
                            <div class="invalid-feedback">{{ __('messages.zip_code_error') }}</div>
                          </div>
                        </div>

                        <div class="col-md-6">
                          <div class="inner-main-input inner-main-input2">
                            <label class="form-label">{{ __('messages.city') }}</label>
                            <input type="text" class="form-control" name="city" id="city" value="{{ old('city', $address->city) }}">
                            <div class="invalid-feedback">{{ __('messages.city_error') }}</div>
                          </div>
                        </div>

                        <div class="col-md-6">
                          <div class="inner-main-input inner-main-input2">
                            <label class="form-label">{{ __('messages.state_region') }}</label>
                            <select class="form-select" name="state" id="state">
                                <option value="">{{ __('messages.select_state') }}</option>

                                @foreach(__('messages.states') as $key => $label)
                                    <option value="{{ $key }}" {{ ($address->state ?? '') === $key ? 'selected' : '' }}>
                                        {{ $label }}
                                    </option>
                                @endforeach
                            </select>

                            <div class="invalid-feedback">{{ __('messages.state_error') }}</div>
                          </div>
                        </div>

                        <div class="col-md-6">
                          <div class="inner-main-input inner-main-input2">
                            <label class="form-label">{{ __('messages.email') }}</label>
                            <input type="email" class="form-control" name="email" id="email" value="{{ old('email', $address->email) }}">
                            <div class="invalid-feedback">{{ __('messages.email_error') }}</div>
                          </div>
                        </div>
                       
                        <div class="col-md-6">
                          <div class="inner-main-input profile_title_input">
                            <label class="form-label">{{ __('messages.contact_number') }}</label>
                            <div class="int-wrap">
                            <div class="inner-main-input inner-main-input2 title_inpt">
                              <select class="form-select country_code_custom" name="country_code" id="country_code">
                                <option value="+49"  data-image="https://flagcdn.com/16x12/de.png" {{ str_starts_with($address->contact_number, '+49') ? 'selected' : '' }}>+49</option>
                                <option value="+43" data-image="https://flagcdn.com/16x12/at.png" {{ str_starts_with($address->contact_number, '+43') ? 'selected' : '' }}>+43</option>
                                <option value="+41" data-image="https://flagcdn.com/16x12/ch.png"  {{ str_starts_with($address->contact_number, '+41') ? 'selected' : '' }}>+41</option>
                              </select>
                              <div class="invalid-feedback">{{ __('messages.select_country_code_error') }}</div>
                            </div>
                            <div class="inner-main-input inner-main-input2">
                              <!-- <label class="form-label disapear">Phone</label> -->
                              <input type="text" class="form-control" name="contact_number" id="contact_number" value="{{ old('contact_number', preg_replace('/^\+\d{1,3}/', '', $address->contact_number)) }}">
                              <div class="invalid-feedback">{{ __('messages.phone_error') }}</div>
                            </div>
                            </div>
                          </div>
                        </div>

                        <div class="col-12 mt-3">
                          <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="is_default" id="is_default" {{ $address->is_default ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_default">
                              {{ __('messages.make_default_billing') }}
                            </label>
                          </div>
                        </div>

                        <div class="comm_profile_two_btns mt-4">
                          <button type="submit" class="primary-btn">{{ __('messages.update_address') }}</button>
                          <a href="{{ route('user.billingAddress') }}" class="secondary-btn">{{ __('messages.cancel_button') }}</a>
                        </div>
                      </form>

                    </div>
                  </div>
                </div>
              </section>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</main>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('editAddressForm');
    
    function validateName(name) {
        return name.length >= 2 && name.length <= 50 && /^[a-zA-Z\s\-']+$/.test(name);
    }
    
    function validateStreet(street) {
        return street.length >= 5 && street.length <= 100;
    }
    
    function validateZip(zip) {
        return /^[a-zA-Z0-9\s\-]{4,10}$/.test(zip);
    }
    
    function validateCity(city) {
        return city.length >= 2 && city.length <= 50;
    }
    
    function validatePhone(phone) {
        return /^[0-9\s\-]{8,15}$/.test(phone);
    }
    
    function validateEmail(email) {
        return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
    }
    
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        let isValid = true;
        
        document.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));
        
        const firstName = document.getElementById('first_name').value.trim();
        if (!validateName(firstName)) {
            document.getElementById('first_name').classList.add('is-invalid');
            isValid = false;
        }
        
        const street = document.getElementById('street').value.trim();
        if (!validateStreet(street)) {
            document.getElementById('street').classList.add('is-invalid');
            isValid = false;
        }
        
        const zipcode = document.getElementById('zipcode').value.trim();
        if (!validateZip(zipcode)) {
            document.getElementById('zipcode').classList.add('is-invalid');
            isValid = false;
        }
        
        const city = document.getElementById('city').value.trim();
        if (!validateCity(city)) {
            document.getElementById('city').classList.add('is-invalid');
            isValid = false;
        }
        
        if (!document.getElementById('state').value) {
            document.getElementById('state').classList.add('is-invalid');
            isValid = false;
        }
        
        const email = document.getElementById('email').value.trim();
        if (!validateEmail(email)) {
            document.getElementById('email').classList.add('is-invalid');
            isValid = false;
        }
        
        const phone = document.getElementById('contact_number').value.trim();
        if (!validatePhone(phone)) {
            document.getElementById('contact_number').classList.add('is-invalid');
            isValid = false;
        }
        
        if (!document.getElementById('country_code').value) {
            document.getElementById('country_code').classList.add('is-invalid');
            isValid = false;
        }
        
        if (isValid) {
            form.submit();
        } else {
            const firstInvalid = document.querySelector('.is-invalid');
            if (firstInvalid) {
                firstInvalid.scrollIntoView({
                    behavior: 'smooth',
                    block: 'center'
                });
                firstInvalid.focus();
            }
        }
    });
    
    document.getElementById('first_name').addEventListener('blur', function() {
        if (!validateName(this.value.trim())) {
            this.classList.add('is-invalid');
        } else {
            this.classList.remove('is-invalid');
        }
    });
    
    document.getElementById('street').addEventListener('blur', function() {
        if (!validateStreet(this.value.trim())) {
            this.classList.add('is-invalid');
        } else {
            this.classList.remove('is-invalid');
        }
    });
    
    document.getElementById('zipcode').addEventListener('blur', function() {
        if (!validateZip(this.value.trim())) {
            this.classList.add('is-invalid');
        } else {
            this.classList.remove('is-invalid');
        }
    });
    
    document.getElementById('city').addEventListener('blur', function() {
        if (!validateCity(this.value.trim())) {
            this.classList.add('is-invalid');
        } else {
            this.classList.remove('is-invalid');
        }
    });
    
    document.getElementById('email').addEventListener('blur', function() {
        if (!validateEmail(this.value.trim())) {
            this.classList.add('is-invalid');
        } else {
            this.classList.remove('is-invalid');
        }
    });
    
    document.getElementById('contact_number').addEventListener('blur', function() {
        if (!validatePhone(this.value.trim())) {
            this.classList.add('is-invalid');
        } else {
            this.classList.remove('is-invalid');
        }
    });
});
</script>

<script>
  function formatFlag(option) {
      if (!option.id) return option.text;
      const imageUrl = $(option.element).data('image');
      const text = option.text;
      if (imageUrl) {
          return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
      }
      return text;
  }

  $(document).ready(function () {
      $('#country_code').select2({
          templateResult: formatFlag,
          templateSelection: formatFlag,
          minimumResultsForSearch: -1 
      });
  });
</script>


@endsection