@php
    $flagMap = [
        '+49' => 'https://flagcdn.com/16x12/de.png',
        '+43' => 'https://flagcdn.com/16x12/at.png',
        '+41' => 'https://flagcdn.com/16x12/ch.png',
    ];
@endphp
<style>
    .flag-icon {
    width: 16px;
    height: 12px;
    margin-right: 6px;
    vertical-align: middle;
    object-fit: cover;
    display: inline-block;
}

.phone-display {
    display: flex;
    align-items: center;
    font-weight: 600;
    gap: 8px;
}

</style>


@extends('layouts.frontend')
@section('content')
<main>
    <section class="banner-back-img-with banner-back-img-appointment">
        <div class="inner-main-img">
            <div class="container">
                <div class="inner-banner-comn">
                    <h1>{{ __('messages.billing_address') }}</h1>
                </div>
            </div>
        </div>
    </section>
    

      <div class="prof-main">
        <section class="comn-padd">
          <div class="container">
            <div class="inner-acount">
              <div class="row">
                <div class="col-lg-3">
                    <div class="inner-left-tabs">
                        @include('frontend.user.include.sidebar')
                    </div>
                </div>
                <div class="col-lg-9">              
                  <section id="billing-address">
                    <div class="comm_border_box">
                      <h3 class="main-head-pro">{{ __('messages.billing_address') }}</h3>
              
                      <div class="comm_border_box_outer">
                        @foreach($billingAddresses as $index => $address)
                            <div class="comm_border_box inner_comm_border_box">
                                <div class="d-flex justify-content-between flex-wrap gap-3 address_edit_btn_row">
                                    <h3 class="main-head-pro mb-0">{{ __('messages.address') }} {{ $index + 1 }}</h3>
                                    <div class="d-flex gap-2">
                                        <a href="{{ route('user.billing-address.edit', $address->id) }}" class="address_edit_btn">
                                            <img src="{{ asset('frontend/images/edit.png') }}" alt="{{ __('messages.edit') }}" />
                                        </a>
                                        @if(!$address->is_default)
                                        <button type="button" class="delete-btn-eye"
                                            data-id="{{ $address->id }}"
                                            data-name="{{ $address->name }}"
                                            data-bs-toggle="modal"
                                            data-bs-target="#deleteAddressModal">
                                            <i class="fa-solid fa-trash"></i>
                                        </button>
                                    @endif

                                        
                                    </div>
                                    
                                    
                                </div>
                                <div class="d-flex comm_detail_list_view">
                                    <div class="comm_detail_list_col">
                                        <h5>{{ __('messages.name') }}</h5>
                                        <h6>{{ $address->name }}</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5>{{ __('messages.street_house_number') }}</h5>
                                        <h6>{{ $address->street }}</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5>{{ __('messages.zip_code') }}</h5>
                                        <h6>{{ $address->zipcode }}</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5>{{ __('messages.city') }}</h5>
                                        <h6>{{ $address->city }}</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5>{{ __('messages.state_region') }}</h5>
                                        <h6>{{ $address->state }}</h6>
                                    </div>
                                     <div class="comm_detail_list_col">
                                        <h5>{{ __('messages.company_name') }}</h5>
                                        <h6>{{ $address->company_name ?? 'N/A' }}</h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5>{{ __('messages.email') }}</h5>
                                        <h6 class="email_text">{{ $address->email }}</h6>
                                    </div>
                                    @php
                                    $contactNumber = $address->contact_number;

                                    // Find which country code matches the start of the contact number
                                    $countryCode = '';
                                    $localNumber = '';

                                    foreach ($flagMap as $code => $flag) {
                                        if (str_starts_with($contactNumber, $code)) {
                                            $countryCode = $code;
                                            $localNumber = substr($contactNumber, strlen($code));
                                            break;
                                        }
                                    }

                                    // If no match, fallback
                                    if (!$countryCode) {
                                        $countryCode = '+41';  // Default country code (or empty string)
                                        $localNumber = $contactNumber;
                                    }

                                    $localNumber = ltrim($localNumber, '0');  // Remove leading zero if any
                                @endphp

                                <div class="comm_detail_list_col phone-number">
                                    <h5>{{ __('messages.contact_number') }}</h5>
                                    <h6>
                                        @if(isset($flagMap[$countryCode]))
                                            <img src="{{ $flagMap[$countryCode] }}" alt="Flag" class="flag-icon" />
                                        @endif
                                        {{ $countryCode }} {{ $localNumber }}
                                    </h6>
                                </div>

                                </div>
                                <div class="make_defaut_addr_row">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="default_{{ $address->id }}" {{ $address->is_default ? 'checked' : '' }}>
                                        <label class="form-check-label" for="default_{{ $address->id }}">
                                            {{ __('messages.make_default_address') }}
                                        </label>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    
                    </div>
              
                    
                    <div class="comm_profile_two_btns">
                        <a href="{{ route('user.billing-address.create') }}" class="primary-btn mt-4">{{ __('messages.add_new_address') }}</a>
                    </div>
                    
              
                      
                    </div>
                  </section>   
                </div>
              </div>
            </div>
          </div>
        </section>

      </div>

       <div class="modal fade modal-delete-logout" id="deleteAddressModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteAddressModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="p-0 modal-body">
                    <div class="inner-body-delete-logout">
                        <h4 id="deleteAddressText">{{ __('messages.are_your_sure_delete_address') }}</h4>
                        <div class="upper-btns-modal-pair">
                            <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">
                              {{ __('messages.no') }}
                            </button>
                            <form id="deleteAddressForm" method="POST">
                                @csrf
                                <button type="submit" class="comn-modal-btns-transparent primary-btn comm_primary_icon_btn">
                                   {{ __('messages.yes') }}
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </main>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const deleteButtons = document.querySelectorAll(".delete-btn-eye");
            const deleteForm = document.getElementById("deleteAddressForm");
            const deleteText = document.getElementById("deleteAddressText");
    
            deleteButtons.forEach(button => {
                button.addEventListener("click", function () {
                    const id = this.getAttribute("data-id");
                    const name = this.getAttribute("data-name");
                    const routeTemplate = "{{ route('user.billing-address.delete', ':id') }}";
                    const actionUrl = routeTemplate.replace(':id', id);
                    deleteForm.action = actionUrl;
    
                    // deleteText.innerHTML = `Are you sure you want to delete? `;
                });
            });
        });
    </script>
    
  
@endsection