@extends('layouts.frontend')
@section('content')
<style>
   .stamp {
    font-weight: 700;
    display: inline-block;
    text-transform: uppercase;
    border-radius: 1rem;
    font-family: 'Courier';
    -webkit-mask-image: url('https://s3-us-west-2.amazonaws.com/s.cdpn.io/8399/grunge.png');
    -webkit-mask-size: 944px 604px;
    mix-blend-mode: multiply;
    position: unset;
    z-index: 10;
    opacity: 0.85;
    width: 180px;
}
.comm_booking_detail_col {
    position: relative;
}

.is-cancelled {
    color: #D23;
    border: 0.5rem double #D23;
    transform: rotate(-8deg) translateX(-50%);
    -webkit-mask-position: 2rem 3rem;
    font-size: 2.5rem;
    background: rgba(255, 255, 255, 0.3);
    padding: 0.4rem 1.2rem;
    position: absolute;
    top: 20px;
    left: 50%;
}

</style>

<main>
    <section class="banner-back-img-with banner-back-img-booking">
        <div class="inner-main-img">
            <div class="container">
                <div class="inner-banner-comn">
                    <h1>{{ __('messages.my_booking') }}</h1>
                </div>
            </div>
        </div>
    </section>

    <div class="prof-main">
        <section class="comn-padd">
            <div class="container">
                <div class="inner-acount">
                    <div class="row">
                        <div class="col-lg-3">
                            <div class="inner-left-tabs">
                                @include('frontend.user.include.sidebar')
                            </div>
                        </div>
                        <div class="col-lg-9">
                            <section id="my_booking_page">
                                <div class="comm_border_box_outer">
                                    <div class="comm_border_box">
                                        <h3 class="main-head-pro">{{ __('messages.my_booking') }}</h3>
                                        
                                        @if(count($recentBookings) > 0)
                                        <div class="comm_booking_head">
                                            <h6>{{ __('messages.recent_bookings') }}</h6>
                                        </div>
                                        <div class="comm_booking_detail_row">
                                            @foreach($recentBookings as $booking)
                                                @foreach($booking->items as $item)
                                                    @if(!$item->related_item)
                                                <div class="d-flex comm_booking_detail_col">
                                                    @if($booking->status == 'cancelled')
                                                        <span class="stamp is-cancelled">Cancelled</span>
                                                    @endif
                                                    <div class="d-flex comm_detail_inner_row">
                                                        <div class="d-flex book-dt-left comm_product_cstom_row">
                                                            <figure class="booking-dt-img">
                                                                @if($item->product && $item->product->homePhoto)
                                                                <img src="{{ asset('storage/' . $item->product->homePhoto->image_path) }}" alt="{{ $item->product_name }}" />
                                                                @else
                                                                    <img src="{{ asset('frontend/images/roof1.png') }}" alt="Default Image" />
                                                                @endif
                                                            </figure>
                                                            <div class="booking_cs_detail">
                                                                <h3 class="name">THULE {{ $item->product_name }} | {{ $item->size }}</h3>
                                                                <h6 class="book_id_txt">{{ __('messages.booking_id') }}: <span>{{ $booking->id }}</span></h6>


                                                                <div class="d-flex book_loctn_wrap">
                                                                    <i class="fa-solid fa-location-dot"></i>
                                                                    <p>{{$item->vendor_address}}</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <button class="primary-btn show-more" data-booking-id="{{ $booking->id }}" data-bs-toggle="modal">
                                                            {{ __('messages.show_more') }}
                                                        </button>
                                                    </div>
                                                    <div class="comm_renting_dt_row">
                                                        <h3 class="rnt_head">{{ __('messages.renting_details') }}:</h3>
                                                        @php
                                                            $dropoffDate = $item->new_dropoff_date ?? $item->dropoff_date;
                                                            $dropoffTime = $item->new_dropoff_time ?? $item->dropoff_time;
                                                        @endphp

                                                        <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                            <div class="comm_detail_list_col">
                                                                <h5>{{ __('messages.from') }}:</h5>
                                                                <h6>{{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }}</h6>
                                                            </div>
                                                            <div class="comm_detail_list_col">
                                                                <h5>{{ __('messages.to') }}:</h5>
                                                                <h6>{{ \Carbon\Carbon::parse($dropoffDate)->format('d.m.Y') }}</h6>

                                                            </div>
                                                            <div class="comm_detail_list_col">
                                                                <h5>{{ __('messages.pickup_datetime') }}:</h5>
                                                                <h6>
                                                                    {{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }} |
                                                                    {{ \Carbon\Carbon::parse($item->pickup_time)->format('H:i') }}
                                                                </h6>
                                                            </div>
                                                            <div class="comm_detail_list_col">
                                                                <h5>{{ __('messages.dropoff_datetime') }}:</h5>
                                                                <h6>
                                                                    {{ \Carbon\Carbon::parse($dropoffDate)->format('d.m.Y') }} |
                                                                    {{ \Carbon\Carbon::parse($dropoffTime)->format('H:i') }}
                                                                </h6>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
                                                @endforeach
                                            @endforeach
                                        </div>
                                        @endif

                                        @if(count($pastBookings) > 0)
                                        <div class="past_booking_wrap">
                                            <div class="comm_booking_head">
                                                <h6>{{ __('messages.past_bookings') }}</h6>
                                            </div>
                                            <div class="comm_booking_detail_row">
                                                @foreach($pastBookings as $booking)
                                                    @foreach($booking->items as $item)
                                                    @if(!$item->related_item)
                                                    <div class="d-flex comm_booking_detail_col">
                                                        @if($booking->status == 'cancelled')
                                                            <span class="stamp is-cancelled">Cancelled</span>
                                                        @endif
                                                        <div class="d-flex comm_detail_inner_row">
                                                            <div class="d-flex book-dt-left comm_product_cstom_row">
                                                                <figure class="booking-dt-img">
                                                                    @if($item->product && $item->product->homePhoto)
                                                                    <img src="{{ asset('storage/' . $item->product->homePhoto->image_path) }}" alt="{{ $item->product_name }}" />
                                                                    @else
                                                                        <img src="{{ asset('frontend/images/roof1.png') }}" alt="Default Image" />
                                                                    @endif
                                                                </figure>
                                                                <div class="booking_cs_detail">
                                                                    <h3 class="name">{{ $item->product_name }} | {{ $item->size }}</h3>
                                                                    <h6 class="book_id_txt">{{ __('messages.booking_id') }}: <span>{{ $booking->id }}</span></h6>
                                                                    

                                                                    <div class="d-flex book_loctn_wrap">
                                                                        <i class="fa-solid fa-location-dot"></i>
                                                                        <p>{{$item->vendor_address}}</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <button class="primary-btn show-more" data-booking-id="{{ $booking->id }}" data-past="1" data-bs-toggle="modal">
                                                                {{ __('messages.show_more') }}
                                                            </button>
                                                        </div>
                                                        <div class="comm_renting_dt_row">
                                                            <h3 class="rnt_head">{{ __('messages.renting_details') }}:</h3>
                                                            @php
                                                            $dropoffDate = $item->new_dropoff_date ?? $item->dropoff_date;
                                                            $dropoffTime = $item->new_dropoff_time ?? $item->dropoff_time;
                                                        @endphp
                                                            <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                                                                <div class="comm_detail_list_col">
                                                                    <h5>{{ __('messages.from') }}:</h5>
                                                                    <h6>{{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }}</h6>
                                                                </div>
                                                                <div class="comm_detail_list_col">
                                                                    <h5>{{ __('messages.to') }}:</h5>

                                                                    <h6>{{ \Carbon\Carbon::parse($dropoffDate)->format('d.m.Y') }}</h6>
                                                                </div>
                                                                <div class="comm_detail_list_col">
                                                                    <h5>{{ __('messages.pickup_datetime') }}:</h5>
                                                                    <h6>
                                                                    {{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }} |
                                                                    {{ \Carbon\Carbon::parse($item->pickup_time)->format('H:i') }}
                                                                </h6>
                                                            </div>
                                                            <div class="comm_detail_list_col">
                                                                <h5>{{ __('messages.dropoff_datetime') }}:</h5>
                                                                <h6>
                                                                    {{ \Carbon\Carbon::parse($dropoffDate)->format('d.m.Y') }} |
                                                                    {{ \Carbon\Carbon::parse($dropoffTime)->format('H:i') }}
                                                                </h6>
                                                            </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif
                                                    @endforeach
                                                @endforeach
                                            </div>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </section>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</main>

<div class="modal fade" id="booking_detail_modal" tabindex="-1" aria-labelledby="bookingDetailModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
        </div>
    </div>
</div>

<div class="modal fade" id="cancel_booking_modal" aria-hidden="true" aria-labelledby="cancelBookingModalLabel" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <div class="inner-modal-content">
                    <h2 class="modal_heading text-center">{{ __('messages.cancel_booking_modal_heading') }}</h2>
                    <p class="modal_sub_heading text-center">{{ __('messages.cancel_booking_modal_subheading') }}</p>

                    <form id="cancelBookingForm" action="{{ route('user.booking.cancel') }}" method="POST">
                        @csrf
                        <input type="hidden" name="booking_id" id="cancel_booking_id" value="">
                        <h6 class="reason_modal_inner_heading">{{ __('messages.cancel_booking_reason_heading') }}</h6>
                        <div class="custom_radio_wrapper cancel_booking_radio_wrapper">
                            <div class="custom-radio">
                                <div class="form-check">
                                    <input type="radio" id="test1" name="cancel_reason" class="form-check-input" value="{{ __('messages.cancel_reason_option_1') }}" checked>
                                    <label class="form-check-label" for="test1">{{ __('messages.cancel_reason_option_1') }}</label>
                                </div>
                            </div>
                            <div class="custom-radio">
                                <div class="form-check">
                                    <input type="radio" id="test2" name="cancel_reason" class="form-check-input" value="{{ __('messages.cancel_reason_option_2') }}">
                                    <label class="form-check-label" for="test2">{{ __('messages.cancel_reason_option_2') }}</label>
                                </div>
                            </div>
                            <div class="custom-radio">
                                <div class="form-check">
                                    <input type="radio" id="test3" name="cancel_reason" class="form-check-input" value="{{ __('messages.cancel_reason_option_3') }}">
                                    <label class="form-check-label" for="test3">{{ __('messages.cancel_reason_option_3') }}</label>
                                </div>
                            </div>
                            <div class="custom-radio">
                                <div class="form-check">
                                    <input type="radio" id="test4" name="cancel_reason" class="form-check-input" value="{{ __('messages.cancel_reason_option_4') }}">
                                    <label class="form-check-label" for="test4">{{ __('messages.cancel_reason_option_4') }}</label>
                                </div>
                            </div>
                           
                            <div class="custom-radio">
                                <div class="form-check">
                                    <input type="radio" id="test6" name="cancel_reason" class="form-check-input" value="{{ __('messages.cancel_reason_option_6') }}">
                                    <label class="form-check-label" for="test6">{{ __('messages.cancel_reason_option_6') }}</label>
                                </div>
                            </div>
                        </div>

                        <div class="ohter_reason_wrp" style="display: none;">
                            <div class="inner-main-input inner-main-input2">
                                <label for="cancel_reason_text" class="form-label">{{ __('messages.cancel_reason_text_label') }}</label>                                <textarea class="form-control" name="cancel_reason_text" id="cancel_reason_text" placeholder="{{ __('messages.cancel_reason_text_placeholder') }}"style="height: 172px; resize:none"></textarea>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="modal_two_btns d-flex justify-content-center">
                    <button type="button" class="secondary-btn" data-bs-dismiss="modal">{{ __('messages.cancel_btn') }}</button>

                    <button type="button" class="primary-btn" id="submitCancelBooking">{{ __('messages.submit_btn') }}</button>

                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var baseUrl = "{{ rtrim(config('app.url'), '/') }}";
    var bookingDetailModal = new bootstrap.Modal(document.getElementById('booking_detail_modal'));
    var cancelBookingModal = new bootstrap.Modal(document.getElementById('cancel_booking_modal'));
    
    $(document).on('click', '.show-more', function(e) {
        var bookingDetailModal = new bootstrap.Modal(document.getElementById('booking_detail_modal'));

        e.preventDefault();
        const bookingId = $(this).data('booking-id');
        const isPast = $(this).data('past');

        console.log(isPast)

        
        if (!bookingId) return;
        
        $('#booking_detail_modal .modal-content').html('<div class="text-center p-5"><div class="spinner-border" role="status"></div></div>');
        bookingDetailModal.show();
        
        
        $.ajax({
            url: `${baseUrl}/user/booking/` + bookingId + '/details',
            type: 'GET',
            success: function(response) {
                if (response.success) {
                    $('#booking_detail_modal .modal-content').html(response.html);
                    if(isPast == "1" || isPast == 1){
                        console.log('egre')
                        $('#booking_detail_modal').find('.cancel_booking_btn').hide();
                    }else{
                        $('#booking_detail_modal').find('.cancel_booking_btn').show();
                    }
                } else {
                    bookingDetailModal.hide();
                    alert(response.message || 'Failed to load booking details');
                }
            },
            error: function() {
                bookingDetailModal.hide();
                alert('Failed to load booking details');
            }
        });
    });
    
    $(document).on('click', '.cancel_booking_btn', function() {
        const bookingId = $(this).data('booking-id');
        $('#cancel_booking_id').val(bookingId);
        bookingDetailModal.hide();
        cancelBookingModal.show();
    });
    
    $('#submitCancelBooking').click(function() {
        const form = $('#cancelBookingForm');
        const submitBtn = $(this);
        
        submitBtn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Processing...');
        
        $.ajax({
            url: form.attr('action'),
            type: 'POST',
            data: form.serialize(),
            success: function(response) {
                if (response.success) {
                    cancelBookingModal.hide();
                    Swal.fire({
                        icon: 'success',
                        title: '{{ __("messages.booking_cancelled_title") }}',
                        text: '{{ __("messages.booking_cancelled_text") }}',
                        confirmButtonText: '{{ __("messages.ok") }}',
                        confirmButtonColor: '#5bc0de',
                    }).then(() => {
                        location.reload();
                    });
                }else {
                    Swal.fire({
                        icon: 'error',
                        title: '{{ __("messages.failed_title") }}',
                        text: response.message || '{{ __("messages.failed_text") }}',
                        confirmButtonText: '{{ __("messages.ok") }}',
                        confirmButtonColor: '#5bc0de',
                    });
                }
            },
            error: function() {
                alert('An error occurred while cancelling the booking');
            },
           complete: function() {
                submitBtn.prop('disabled', false).text('{{ __("messages.submit_btn") }}');
            }
        });
    });
    
    $('body').on('change', 'input[name="cancel_reason"]', function() {
        if ($(this).val() === '{{ __('messages.cancel_reason_option_6') }}') {
            $('.ohter_reason_wrp').show();
        } else {
            $('.ohter_reason_wrp').hide();
        }
    });
});
</script>
@endsection