
<div class="modal-body booking-detail-modal-main">
    <div class="inner-modal-content">
        <h2 class="booking-modal-head">{{ __('messages.booking_details') }}</h2>
        <div class="">
            @foreach($booking->items as $item)
            @if(!$item->related_item)
            <div class="d-flex comm_product_cstom_row">
                <figure class="booking-dt-img">
                    @if($item->product && $item->product->homePhoto)
                        <img src="{{ asset('storage/' . $item->product->homePhoto->image_path) }}" alt="{{ $item->product_name }}" />
                    @else
                        <img src="{{ asset('frontend/images/roof1.png') }}" alt="Default Image" />
                    @endif
                </figure>
                <div class="booking_cs_detail">
                    <h3 class="name">{{ $item->product_name }} | {{ $item->size }}</h3>
                    <h6 class="book_id_txt">{{__('messages.booking_id')}}: <span>{{ $booking->id }}</span></h6>

                    <div class="d-flex book_loctn_wrap">
                        <i class="fa-solid fa-location-dot"></i>
                        {{-- <p>{{ $booking->userDetails->address ?? '' }}, {{ $booking->userDetails->zip ?? '' }} {{ $booking->userDetails->city ?? '' }}, {{ $booking->userDetails->country ?? '' }}</p> --}}
                        <p> {{ $item->vendor_address }}</p>
                        
                    </div>
                </div>
            </div>
            <div class="comm_renting_dt_row_outer">

                <div class="comm_renting_dt_row">
                    <h3 class="rnt_head">{{ __('messages.car_information') }}</h3>

                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                        <div class="comm_detail_list_col">
                            <h5>{{ __('messages.brand') }}:</h5>
                            <h6>{{ $item->car_name }}</h6>
                        </div>
                        <div class="comm_detail_list_col">
                            <h5>{{ __('messages.model') }}:</h5>
                            <h6>{{ $item->model }}</h6>
                        </div>
                        <div class="comm_detail_list_col">
                            <h5>{{ __('messages.year_of_make') }}:</h5>
                            <h6>{{ $item->car_year }}</h6>
                        </div>
                        <div class="comm_detail_list_col">
                            <h5>{{ __('messages.railing_type') }}:</h5>
                            <h6>{{ $item->roof_type }}</h6>
                        </div>
                        <div class="comm_detail_list_col">
                            <h5>{{ __('messages.trailer_hitch') }}:</h5>
                            <h6>{{ $item->trailer_hitch ? __('messages.yes') : __('messages.no') }}</h6>
                        </div>
                    </div>

                </div>
                <div class="comm_renting_dt_row">
                    <h3 class="rnt_head">{{ __('messages.renting_details') }}</h3>


                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                        <div class="comm_detail_list_col">
                            <h5>{{ __('messages.from') }}:</h5>

                            <h6>{{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }}</h6>
                        </div>
                        <div class="comm_detail_list_col">
                            <h5>{{ __('messages.to') }}:</h5>

                            <h6>{{ \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') }}</h6>
                        </div>
                        @php
                            $dropoffDate = $item->new_dropoff_date ?? $item->dropoff_date;
                            $dropoffTime = $item->new_dropoff_time ?? $item->dropoff_time;
                        @endphp
                        <div class="comm_detail_list_col">
                            <h5>{{ __('messages.pickup_datetime') }}:</h5>

                            <h6>
                                {{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }} |
                                {{ \Carbon\Carbon::parse($item->pickup_time)->format('H:i') }}
                            </h6>
                        </div>
                        <div class="comm_detail_list_col">
                            <h5>{{ __('messages.dropoff_datetime') }}:</h5>
                            <h6>
                                {{ \Carbon\Carbon::parse($dropoffDate)->format('d.m.Y') }} |
                                {{ \Carbon\Carbon::parse($dropoffTime)->format('H:i') }}
                            </h6>
                        </div>
                    </div>

                </div>
                <div class="comm_renting_dt_row">
                    <h3 class="rnt_head">{{ __('messages.rent_information') }}</h3>

                    <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                        <div class="comm_detail_list_col">
                            <h5>{{ __('messages.units') }}:</h5>
                            <h5>01</h5>
                        </div>
                        <div class="comm_detail_list_col">
                            <h5>{{__('messages.rental_days')}}:</h5>
                            <h6>{{ $item->days }}</h6>
                        </div>
                       <div class="comm_detail_list_col">
                            @php
                                $formattedTotal = app()->getLocale() === 'de'
                                    ? number_format($booking->total, 2, ',', '.')
                                    : number_format($booking->total, 2, '.', ',');
                            @endphp
                            <h6>{{ __('messages.for_days_total', ['days' => $item->days, 'price' => $formattedTotal]) }}</h6>
                        </div>
                    </div>
                </div>
            </div>

            <div class="booking_modal_carrier_sec">
                @if($item->is_carrier_included)
                <div class="d-flex booking_modal_carrier_row">
                    <div class="cr_box"></div>
                    <h6>{{ __('messages.carrier_included') }}</h6>
                </div>
                <div class="d-flex comm_detail_list_view comm_renting_dt_list">
                    <div class="comm_detail_list_col">
                        <h5>{{ __('messages.length') }}:</h5>
                        <h6>{{ $item->carrier_length }}</h6>
                    </div>
                    <div class="comm_detail_list_col">
                        <h5>{{ __('messages.foot_kit') }}:</h5>
                        <h6>{{ $item->footkit_sku }}</h6>
                    </div>
                    <div class="comm_detail_list_col">
                        <h5>{{ __('messages.foot') }}:</h5>
                        <h6>{{ $item->foot_sku }}</h6>
                    </div>
                </div>
                @endif

                @if($item->is_insured)
                <div class="d-flex booking_modal_carrier_row vkassko_rw">
                    <div class="cr_box"></div>
                    <h6>{{ __('messages.insurance_label') }}</h6>
                </div>
                @endif
            </div>
            @endif
            @endforeach
        </div>
        @if($booking->status != 'cancelled')
        <div class="modal_two_btns">
            <button class="primary-btn cancel_booking_btn" data-bs-toggle="modal" data-booking-id="{{ $booking->id }}">
                {{ __('messages.cancel_booking_btn') }}
            </button>
        </div>
        @endif
    </div>
</div>


<!-- cancel_booking_modal  -->

