@extends('layouts.frontend')
@section('content')
<main>
    <section class="banner-back-img-with banner-back-img-appointment">
        <div class="inner-main-img">
            <div class="container">
                <div class="inner-banner-comn">
                  <h1>{{ __('messages.edit_car_details') }}</h1>
                </div>
            </div>
        </div>
    </section>
    <div class="prof-main">
        <section class="comn-padd">
          <div class="container">
            <div class="inner-acount">
              <div class="row">
                <div class="col-lg-3">
                    <div class="inner-left-tabs">
                        @include('frontend.user.include.sidebar')
                    </div>
                </div>
                <div class="col-lg-9">              
                  <section id="edit-car-detail">
                    <div class="comm_border_box">
                      <h3 class="main-head-pro">{{ __('messages.edit_car_details') }}</h3>
                      <div class="upper-form-main">
                        <div class="dash_form_outer">
                            <form method="POST" action="{{ route('user.car.update') }}" class="row comm_form">
                                @csrf
                                <div class="col-md-6">
                                  <div class="inner-main-input inner-main-input2">
                                    <label class="form-label">{{ __('messages.manufacturer') }}:</label>
                                    <select id="manufacturer" name="manufacturer" class="form-select" >
                                      <option value="">{{ __('messages.select_manufacturer') }}</option>
                                      @foreach($manufacturers as $manufacturer)
                                            <option value="{{ $manufacturer }}" {{ $car->manufacturer == $manufacturer ? 'selected' : '' }}>{{ $manufacturer }}</option>
                                        @endforeach
                                    </select>
                                  </div>
                                </div>
                                <div class="col-md-6">
                                  <div class="inner-main-input inner-main-input2">
                                    <label class="form-label">{{ __('messages.model') }}:</label>
                                    <select id="model" name="model" class="form-select" >
                                      <option value="">{{ __('messages.select_model') }}</option>
                                      @if($car->model)
                                            <option value="{{ $car->model }}" selected>{{ $car->model }}</option>
                                        @endif
                                    </select>
                                  </div>
                                </div>
                                <div class="col-md-6">
                                  <div class="inner-main-input inner-main-input2">
                                    <label class="form-label">{{ __('messages.year_of_make') }}:</label>
                                    <select id="year" name="year" class="form-select" >
                                      <option value="">{{ __('messages.select_year') }}</option>
                                      @if($car->year)
                                            <option value="{{ $car->year }}" selected>{{ $car->year }}</option>
                                        @endif
                                    </select>
                                  </div>
                                </div>
                              
                          
                              
                                <div class="col-md-6">
                                  <div class="inner-main-input inner-main-input2">
                                    <label class="form-label">{{ __('messages.trailer_hitch') }}:</label>
                                    <select class="form-select" name="trailer_hitch" >
                                      <option value="Yes" {{ isset($car) && $car->trailer_hitch ? 'selected' : '' }}>{{ __('messages.yes') }}</option>
                                      <option value="No" {{ isset($car) && !$car->trailer_hitch ? 'selected' : '' }}>{{ __('messages.no') }}</option>
                                    </select>
                                  </div>
                                </div>
                              
                                <div class="comm_profile_two_btns">
                                  <button type="submit" class="primary-btn">{{ __('messages.update_car_details') }}</button>
                                  <a href="{{ route('user.carDetails') }}" class="secondary-btn">{{ __('messages.cancel') }}</a>
                                </div>
                            </form>
                        </div>
                      </div>
                    </div>
                  </section>     
                </div>
              </div>
            </div>
          </div>
        </section>
      </div>
</main>

@section('script')
<script>
  $(document).ready(function() {
    var baseUrl = "{{ rtrim(config('app.url'), '/') }}";
    var selectedManufacturer = "{{ $car->manufacturer ?? '' }}";
    var selectedModel = "{{ $car->model ?? '' }}";
    var selectedYear = "{{ $car->year ?? '' }}";
  
    $('#manufacturer').change(function() {
      let manufacturer = $(this).val();
      $('#model').prop('disabled', true).html('<option value="">Loading...</option>');
      $('#year').prop('disabled', true).html('<option value="">Select Year</option>');
  
      if (manufacturer) {
        $.get(`${baseUrl}/car/models`, { manufacturer: manufacturer }, function(data) {
          $('#model').prop('disabled', false).html('<option value="">Select Model</option>');
          $.each(data, function(_, value) {
            let cleanValue = value.trim();
            $('#model').append(
              `<option value="${cleanValue}" ${cleanValue === selectedModel ? 'selected' : ''}>${cleanValue}</option>`
            );
          });
          if (selectedModel) $('#model').trigger('change');
        });
      } else {
        $('#model').prop('disabled', false).html('<option value="">Select Model</option>');
        $('#year').prop('disabled', false).html('<option value="">Select Year</option>');
      }
    });
  
    $('#model').change(function() {
      let manufacturer = $('#manufacturer').val();
      let model = $(this).val();
      $('#year').prop('disabled', true).html('<option value="">Loading...</option>');
      if (manufacturer && model) {
        $.get(`${baseUrl}/car/years`, { manufacturer: manufacturer, model: model }, function(data) {
          $('#year').prop('disabled', false).html('<option value="">Select Year</option>');
          $.each(data, function(_, value) {
            let cleanValue = value.trim();
            $('#year').append(
              `<option value="${cleanValue}" ${cleanValue === selectedYear ? 'selected' : ''}>${cleanValue}</option>`
            );
          });
        });
      } else {
        $('#year').prop('disabled', false).html('<option value="">Select Year</option>');
      }
    });
  
    if (selectedManufacturer) $('#manufacturer').trigger('change');
  });
  </script>
  

@endsection

@endsection