


@extends('layouts.frontend')
@section('content')
@if(session('success'))
  <div class="alert alert-success">{{ session('success') }}</div>
@endif

@if(session('info'))
  <div class="alert alert-info">{{ session('info') }}</div>
@endif

@if($errors->any())
  <div class="alert alert-danger">{{ $errors->first() }}</div>
@endif

<main>
      <section class="banner-back-img-with banner-back-img-news">
        <div class="inner-main-img">
          <div class="container">
            <div class="inner-banner-comn">
              <h1>newsletter setup</h1>
            </div>
          </div>
        </div>
      </section>

      <div class="prof-main">
        <section class="comn-padd">
          <div class="container">
            <div class="inner-acount">
              <div class="row">
              <div class="col-lg-3">
                        <div class="inner-left-tabs">
                            @include('frontend.user.include.sidebar')
                        </div>
                    </div>
                <div class="col-lg-9">              
                  <section id="newsletter-setup">
                   <div class="comm_border_box_outer">
                      <div class="comm_border_box">
                          <h3 class="main-head-pro">{{ __('messages.newsletter_subscribe_title') }}</h3>
                          <p class="default_text">{{ __('messages.newsletter_subscribe_text') }}</p>

                          <form class="row comm_form profile_newsletter_form" method="POST" action="{{ route('user.newsletter.subscribe') }}">
                              @csrf
                              <div class="col-md-12">
                                  <div class="inner-main-input inner-main-input2">
                                      <label for="email" class="form-label">{{ __('messages.email_address') }}</label>
                                      <input type="email" name="email" class="form-control" placeholder="{{ __('messages.email_address') }}" required>
                                  </div>
                                  <div class="comm_profile_two_btns">
                                      <button type="submit" class="primary-btn">{{ __('messages.submit') }}</button>
                                  </div>
                              </div>
                          </form>
                      </div>
                  </div>

                  <div class="comm_border_box">
                      <h4 class="main-head-pro">{{ __('messages.newsletter_notification_title') }}</h4>                                    
                      <form method="POST" action="{{ route('user.newsletter.toggle') }}" id="newsletterToggleForm">
                          @csrf
                          <div class="d-flex newsletter_toggle_row">
                              <p class="default_text">{{ __('messages.unsubscribe_question') }}</p>
                              <div class="cl-toggle-switch">
                                  <label class="cl-switch">
                                      <input type="checkbox" name="toggle" onchange="document.getElementById('newsletterToggleForm').submit();" {{ $isSubscribed ? 'checked' : '' }}>
                                      <span></span>
                                  </label>
                              </div>
                          </div>
                      </form>
                  </div>
                   
                  </div>
                    </div>
                  </div>
                </div>
                  </section>             
                </div>
              </div>
            </div>
          </div>
        </section>
      </div>
    </main>

    @endsection