@extends('layouts.frontend')

@section('content')
<main>
  <section class="banner-back-img-with profile_main_page">
    <div class="inner-main-img">
      <div class="container">
        <div class="inner-banner-comn">
            <h1>{{ __('messages.profile_overview') }}</h1>
        </div>
      </div>
    </div>
  </section>

  <div class="prof-main">
    <section class="comn-padd">
      <div class="container">
        <div class="inner-acount">
          <div class="row">
            <div class="col-lg-3">
              @include('frontend.user.include.sidebar')
            </div>

            <div class="col-lg-9">              
              <section id="edit-my-profile">
                <div class="comm_border_box">
                    <h3 class="main-head-pro">{{ __('messages.my_profile') }}</h3>

                  @if ($errors->any())
                    <div class="alert alert-danger">
                      <ul>
                        @foreach ($errors->all() as $error)
                          <li>{{ $error }}</li>
                        @endforeach
                      </ul>
                    </div>
                  @endif

                  @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                  @endif

                  
                  <div class="dash_form_outer">
                    <form id="profileForm" class="row comm_form needs-validation" method="POST" action="{{ route('user.update') }}" enctype="multipart/form-data" novalidate>
                        @csrf
                        @method('PUT')

                        <div class="img-profile-main d-flex mb-4">
                          <div class="profile-pic">
                              <label class="label" for="file">
                                  <img class="edit-prof-img" src="{{ asset('frontend/images/basil_edit-outline.svg')}}" alt="edit" />
                              </label>
                              <input name="profile_picture" type="file" id="file" class="form-control" accept="image/*" />
                              <figure class="profile-img">
                                  <img id="profileImagePreview" 
                                      src="{{ $user->profile_image ? asset('storage/' . $user->profile_image) : asset('frontend/images/user.png') }}"
                                      alt="Profile Image" />
                              </figure>
                              <div class="invalid-feedback" id="profile-picture-error"></div>
                          </div>
                      </div>
                        
                        <!-- Title Field -->
                        <div class="col-md-6">
                            <div class="d-flex profile_title_input">
                                <div class="inner-main-input inner-main-input2 title_inpt">
                                    <label class="form-label">{{ __('messages.title') }}</label>
                                     <select name="title" class="form-select" required>
                                        <option value="">Select</option>
                                        <option value="Mr." {{ $user->title == 'Mr.' ? 'selected' : '' }}>{{ __('messages.title_mr') }}</option>
                                        <option value="Mrs." {{ $user->title == 'Mrs.' ? 'selected' : '' }}> {{ __('messages.title_mrs') }}</option>
                                    </select>
                                    <div class="invalid-feedback">Please select a title</div>
                                </div>
                                <div class="inner-main-input inner-main-input2">
                                    <label class="form-label">{{ __('messages.first_name') }}</label>
                                    <input type="text" name="first_name" class="form-control"   placeholder="{{ __('messages.enter_first_name') }}" 
                                        value="{{ $user->first_name }}" required minlength="2" maxlength="50">
                                    <div class="invalid-feedback">First name must be 2-50 characters</div>
                                </div>
                            </div>
                        </div>
                    
                        <!-- Last Name Field -->
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.surname') }}</label>
                                <input type="text" name="last_name" class="form-control" placeholder="{{ __('messages.enter_surname') }}" 
                                    value="{{ $user->last_name }}" required minlength="2" maxlength="50">
                                <div class="invalid-feedback">Last name must be 2-50 characters</div>
                            </div>
                        </div>
                    
                        <!-- Address Field -->
                        <div class="col-md-12">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.street_house_number') }}</label>
                                <input type="text" name="street" class="form-control"  placeholder="{{ __('messages.enter_street_house_number') }}" 
                                    value="{{ $user->street }}" required>
                                <div class="invalid-feedback">Please enter your address</div>
                            </div>
                        </div>
                    
                        <!-- Zip Code Field -->
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.zip_code') }}</label>
                                <input type="text" name="zip_code" class="form-control"                                                placeholder="{{ __('messages.enter_zip_code') }}" 

                                    value="{{ $user->zip_code }}" required pattern="\d{4,6}">
                                <div class="invalid-feedback">Please enter a valid 4-6 digit zip code</div>
                            </div>
                        </div>
                    
                        <!-- City Field -->
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.city') }}</label>
                                <input type="text" name="city" class="form-control" placeholder="{{ __('messages.enter_city') }}" 
                                    value="{{ $user->city }}" required>
                                <div class="invalid-feedback">Please enter your city</div>
                            </div>
                        </div>
                    
                        <!-- Region Field -->
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.region_state') }}</label>
                                <select name="region" class="form-select" required>
                                    <option value="">{{ __('messages.select_option') }}</option>

                                    @foreach(__('messages.region') as $key => $value)
                                        <option value="{{ $key }}" {{ $user->region == $key ? 'selected' : '' }}>
                                            {{ $value }}
                                        </option>
                                    @endforeach
                                </select>
                                
                                <div class="invalid-feedback">Please select your region</div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.country') }}</label>
                                

                                <select id="inputState" class="form-select" name="country">
                                    <option value="" hidden>{{ __('messages.choose_country') }}</option>

                                    @foreach(__('messages.countries') as $key => $label)
                                        <option value="{{ $label }}" {{ old('country', $user->country ?? '') === $label ? 'selected' : '' }}>
                                            {{ $label }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">Please select your country</div>
                            </div>
                        </div>
                    
                        <!-- Phone Field -->
                        <div class="col-md-6">
                            <div class="d-flex profile_title_input">
                                <div class="inner-main-input inner-main-input2 title_inpt">
                                    <label class="form-label">{{ __('messages.phone_code') }}</label>
                                    <select name="country_code" class="form-select country_code_custom" required id="country_code">
                                        <option value="" disable>Select Code</option>
                                        <option value="+49" data-image="https://flagcdn.com/16x12/de.png"  {{ $user->country_code == '+49' ? 'selected' : '' }}>+49</option>
                                        <option value="+43" data-image="https://flagcdn.com/16x12/at.png" {{ $user->country_code == '+43' ? 'selected' : '' }}>+43</option>
                                        <option value="+41"  data-image="https://flagcdn.com/16x12/ch.png" {{ $user->country_code == '+41' ? 'selected' : '' }}>+41</option>
                                    </select>
                                    <div class="invalid-feedback">Please select phone code</div>
                                </div>
                                <div class="inner-main-input inner-main-input2">
                                    <label class="form-label">{{ __('messages.phone_number') }}</label>
                                    <input type="tel" name="number" class="form-control" placeholder="{{ __('messages.phone_placeholder') }}"
                                        value="{{ $user->number }}" required pattern="[\d\-\s]{6,20}">
                                    <div class="invalid-feedback">Please enter a valid phone number (6-20 digits)</div>
                                </div>
                            </div>
                        </div>
                    
                        <!-- Email Field -->
                        <div class="col-md-6">
                            <div class="inner-main-input inner-main-input2">
                                <label class="form-label">{{ __('messages.email') }}</label>
                                <input type="email" name="email" class="form-control" placeholder="{{ __('messages.enter_email_address') }}" 
                                    value="{{ $user->email }}" required>
                                <div class="invalid-feedback">Please enter a valid email address</div>
                            </div>
                        </div>
                    
                        <!-- Profile Picture -->
                        
                    
                        <div class="comm_profile_two_btns">
                            <button type="submit" class="primary-btn">{{ __('messages.save_changes') }}</button>
                            <a href="{{ route('user.index') }}" class="secondary-btn">{{ __('messages.cancel') }}</a>
                        </div>
                    </form>
                    </div>
                  </div>
                </div>
              </section>         
            </div>
          </div>
        </div>
      </div>
    </section>
    {{-- <img class="white-botm-amin" src="{{ asset('frontend/whit.png')}}" alt="" /> --}}
  </div>
</main>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('file').addEventListener('change', function(event) {
        const output = document.getElementById('profileImagePreview');
        const file = event.target.files[0];
        const errorElement = document.getElementById('profile-picture-error');
        
        if (file) {
            // Validate file type
            if (!file.type.startsWith('image/')) {
                errorElement.textContent = 'Please select an image file';
                event.target.value = '';
                return;
            }
            
            // Validate file size (max 2MB)
            if (file.size > 2 * 1024 * 1024) {
                errorElement.textContent = 'Image must be less than 2MB';
                event.target.value = '';
                return;
            }
            
            errorElement.textContent = '';
            const reader = new FileReader();
            reader.onload = function(e) {
                output.src = e.target.result;
            }
            reader.readAsDataURL(file);
        }
    });

    const form = document.getElementById('profileForm');
    
    form.querySelectorAll('input, select').forEach(element => {
        element.addEventListener('blur', function() {
            validateField(this);
        });
    });
    
    const emailField = form.querySelector('input[name="email"]');
    if (emailField) {
        emailField.addEventListener('blur', function() {
            if (this.value && this.value !== '{{ $user->email }}') {
                checkEmailAvailability(this.value);
            }
        });
    }
    
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        let isValid = true;
        form.querySelectorAll('input, select').forEach(element => {
            if (!validateField(element)) {
                isValid = false;
            }
        });
        
        if (isValid) {
            submitForm();
        }
    });
    
    function validateField(field) {
    const errorElement = field.nextElementSibling;

    const name = field.name;
    const value = field.value.trim();

    // Required fields
    if (field.hasAttribute('required') && !value) {
        field.classList.add('is-invalid');
        if (errorElement) {
            switch (name) {
                case 'first_name':
                    errorElement.textContent = '{{ __("messages.please_enter_first_name") }}';
                    break;
                case 'last_name':
                    errorElement.textContent = '{{ __("messages.please_enter_surname") }}';
                    break;
                case 'street':
                    errorElement.textContent = '{{ __("messages.please_enter_address") }}';
                    break;
                case 'zip_code':
                    errorElement.textContent = '{{ __("messages.please_enter_zip_code") }}';
                    break;
                case 'city':
                    errorElement.textContent = '{{ __("messages.please_enter_city") }}';
                    break;
                case 'region':
                    errorElement.textContent = '{{ __("messages.please_select_region") }}';
                    break;
                case 'country':
                    errorElement.textContent = '{{ __("messages.please_select_country") }}';
                    break;
                case 'phone_code':
                    errorElement.textContent = '{{ __("messages.please_select_phone_code") }}';
                    break;
                case 'number':
                    errorElement.textContent = '{{ __("messages.please_enter_phone_number") }}';
                    break;
                case 'email':
                    errorElement.textContent = '{{ __("messages.please_enter_email") }}';
                    break;
                case 'title':
                    errorElement.textContent = '{{ __("messages.please_select_title") }}';
                    break;
                default:
                    errorElement.textContent = '{{ __("messages.this_field_required") }}';
            }
        }
        return false;
    }

    // Email format
    if (field.type === 'email' && value && !/^\S+@\S+\.\S+$/.test(value)) {
        field.classList.add('is-invalid');
        if (errorElement) {
            errorElement.textContent = '{{ __("messages.email_already_in_use") }}';
        }
        return false;
    }

    // Zip code
    if (name === 'zip_code' && value && !/^\d{4,6}$/.test(value)) {
        field.classList.add('is-invalid');
        if (errorElement) {
            errorElement.textContent = 'Zip code must be 4-6 digits';
        }
        return false;
    }

    // Phone number
    if (name === 'number' && value && !/^[\d\-\s]{8,15}$/.test(value)) {
        field.classList.add('is-invalid');
        if (errorElement) {
            errorElement.textContent = 'Phone number must be 8-15 digits';
        }
        return false;
    }

    // Minlength (e.g., first/last name)
    if (field.hasAttribute('minlength') && value.length < parseInt(field.getAttribute('minlength'))) {
        field.classList.add('is-invalid');
        if (errorElement) {
            errorElement.textContent = `Must be at least ${field.getAttribute('minlength')} characters`;
        }
        return false;
    }

    // Passed all validations
    field.classList.remove('is-invalid');
    if (errorElement) {
        errorElement.textContent = '';
    }
    return true;
}
    function checkEmailAvailability(email) {
        fetch('{{ route("user.check-email") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ email: email })
        })
        .then(response => response.json())
        .then(data => {
            const emailField = form.querySelector('input[name="email"]');
            const errorElement = emailField.nextElementSibling;
            
            if (data.available) {
                emailField.classList.remove('is-invalid');
                errorElement.textContent = '';
            } else {
                emailField.classList.add('is-invalid');
                errorElement.textContent = 'This email is already in use';
            }
        });
    }
    
    function submitForm() {
        const formData = new FormData(form);
        
        fetch(form.action, {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
         
            if (data.success) {
                window.location.href = data.redirect_url + '?updated=1';
            } else {
                // Show validation errors
                if (data.errors) {
                    for (const [field, messages] of Object.entries(data.errors)) {
                        const input = form.querySelector(`[name="${field}"]`);
                        const errorElement = input.nextElementSibling;
                        
                        if (input && errorElement) {
                            input.classList.add('is-invalid');
                            errorElement.textContent = messages[0];
                        }
                    }
                }
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
    }
});
  </script>
      <script>
        function formatFlag(option) {
            if (!option.id) return option.text;
            const imageUrl = $(option.element).data('image');
            const text = option.text;
            if (imageUrl) {
                return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
            }
            return text;
        }
    
        $(document).ready(function () {
            $('#country_code').select2({
                templateResult: formatFlag,
                templateSelection: formatFlag,
                minimumResultsForSearch: -1 
            });
        });
    </script>
  @endsection