@extends('layouts.frontend')
@section('content')

<main>
    <section class="banner-back-img-with banner-back-img-voucher">
      <div class="inner-main-img">
        <div class="container">
          <div class="inner-banner-comn">
            <h1>{{ __('messages.my_voucher') }}</h1>
           
          </div>
        </div>
      </div>
    </section>

    <div class="prof-main">
      <section class="comn-padd">
        <div class="container">
          <div class="inner-acount">
            <div class="row">
              <div class="col-lg-3">
                <div class="inner-left-tabs">
                    @include('frontend.user.include.sidebar')
                </div>
              </div>
              <div class="col-lg-9">
                <section id="my-voucher">
                    <div class="comm_border_box">
                        <h3 class="main-head-pro">{{ __('messages.my_vouchers') }}</h3>
                        <h4>{{ __('messages.dear_customers') }}</h4>
                        <h4>{{ __('messages.voucher_location_note') }}</h4>
                        <br>
                        <div class="comm_border_box_outer">
                            @if(count($vouchers))
                            @foreach ($vouchers as $voucher)
                                @php
                      
                                    $isExpired = $voucher->isExpired();
                                    $isApplied = $voucher->isAppliedByUser($userId);
                                    $isApplicable = $voucher->isApplicableForUser($userId);
                                @endphp
            
                                @if ($isApplicable)
                                    <div class="d-flex voucher_coupan_row">
                                        <div class="d-flex coupon_management_outer @if ($isApplied) applied_coupan_outer  @endif @if ($isExpired) expired_coupan_outer  @endif">
                                            <figure class="coupon_manage_shape">
                                                <img src="{{ asset('frontend/images/coup_shape.png') }}" alt="" class="img-fluid" />
                                            </figure>
                                            <figure class="coupon_management_img">
                                                <img src="{{ asset('frontend/images/coup-left.png') }}" alt="" class="img-fluid" />
                                            </figure>
                                            <div class="coupon_mange_content">
                                                <h4 class="off">{{ $voucher->name }}</h4>
                                                    <h5 class="coupon_txt">
                                                        {{ __('messages.coupon_code') }}     <span>{{ $voucher->code }}</span>
                                                        <img 
                                                        src="{{ asset('frontend/images/CopySimple.svg') }}" 
                                                        alt="Copy" 
                                                        class="img-fluid copy-coupon-code" 
                                                        data-clipboard-target="{{ $voucher->code }}"
                                                        id="copy-icon-{{ $voucher->id }}"
                                                    />
                                                    @if(!empty($voucher->applied_to))
                                                    <p>{{ __('messages.applied_to') }} {{ implode(', ', $voucher->applied_product_names) }}</p>
                                                    @else
                                                    <p><strong>{{ __('messages.applied_to') }}</strong> {{ __('messages.all_products') }}</p>
                                                    @endif
                                                    <span id="tooltip-{{ $voucher->id }}" class="tooltip-text">{{__('messages.copied')}}!</span>
                                                    </h5>
                                               
                                                @if ($isApplied)
                                                <h6 class="valid">{{ __('messages.applied') }}</h6>
                                                @elseif ($isExpired)
                                                <h6 class="valid">{{ __('messages.expired') }}</h6>
                                                @else
                                                    <h6 class="valid">{{ __('messages.valid_until') }}  {{ \Carbon\Carbon::parse($voucher->expiration_date)->format('d F Y') }}</h6>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                            @else
                            <h3 class="main-head-pro">{{ __('messages.no_vouchers') }}</h3>



                            @endif
                        </div>
                    </div>
                </section>
            </div>  
            </div>
          </div>
        </div>
      </section>
    </div>
  </main>

<style>
    .tooltip-text {
    display: none;
    position: absolute;
    background-color: rgba(0, 0, 0, 0.7);
    color: white;
    padding: 5px 10px;
    border-radius: 5px;
    font-size: 12px;
    bottom: -25px;
    left: 0;
    z-index: 10;
}

.copy-coupon-code {
    cursor: pointer;
    position: relative;
}

/* Show the tooltip when triggered */
.tooltip-show {
    display: block;
}

</style>
<script>
$('.copy-coupon-code').on('click', function () {
    var couponCode = $(this).data('clipboard-target'); 
    var $this = $(this); 
    
    if (!couponCode) {
        console.warn('Coupon code element not found.');
        return;
    }

    var showTooltip = function () {
        var tooltip = $('#tooltip-' + $this.attr('id').split('-')[2]);
        tooltip.addClass('tooltip-show');
        setTimeout(function () {
            tooltip.removeClass('tooltip-show');
        }, 2000);
    };

    if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(couponCode).then(function () {
            showTooltip();
        }).catch(function (err) {
            console.error('Clipboard API failed: ', err);
            fallbackCopy(couponCode, showTooltip);
        });
    } else {
        fallbackCopy(couponCode, showTooltip);
    }

    function fallbackCopy(text, callback) {
        var textArea = document.createElement("textarea");
        textArea.value = text;
        textArea.style.position = "fixed";
        textArea.style.top = "0";
        textArea.style.left = "0";
        textArea.style.opacity = "0";
        document.body.appendChild(textArea);
        textArea.focus();
        textArea.select();
        try {
            var successful = document.execCommand('copy');
            if (successful) callback();
            else throw new Error("execCommand failed");
        } catch (err) {
            console.error('Fallback copy failed: ', err);
        }
        document.body.removeChild(textArea);
    }
});


</script>
@endsection
