@extends('layouts.vendor')
@section('content')
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{route('vendor.profile')}}">{{ __('messages.my_profile') }}</a>
            <a class="active">{{ __('messages.change_password') }}</a>
        </div>
    </div>

    <div class="add-user-form">
        <h3>{{ __('messages.change_password') }}</h3>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        <form class="row" method="POST" action="{{ route('vendor.update.changepassword') }}">
            @csrf

            <div class="col-md-6">
                <div class="comn-input-select position-relative">
                    <label for="current_password" class="form-label">{{ __('messages.current_password') }}</label>
                    <div class="main-icon-div">
                    <input type="password" class="form-control @error('old_password') is-invalid @enderror" id="current_password" name="old_password" placeholder="{{ __('messages.enter_password') }}">
                    <i class="fa fa-eye toggle-password" toggle="#current_password"></i>
                </div>
                    @error('old_password')
                        <div class="text-danger error mt-1">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select position-relative">
                    <label for="new_password" class="form-label">{{ __('messages.new_password') }}</label>
                    <div class="main-icon-div">
                    <input type="password" class="form-control @error('new_password') is-invalid @enderror" id="new_password" name="new_password" placeholder="{{ __('messages.enter_new_password') }}">
                    <i class="fa fa-eye toggle-password" toggle="#new_password"></i>
                </div>
                    @error('new_password')
                        <div class="text-danger error mt-1">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="col-md-6">
                <div class="comn-input-select position-relative">
                    <label for="confirm_password" class="form-label">{{ __('messages.confirm_new_password') }}</label>
                    <div class="main-icon-div">
                    <input type="password" class="form-control" id="confirm_password" name="confirm_new_password" placeholder="{{ __('messages.enter_confirm_new_password') }}">
                    <i class="fa fa-eye toggle-password" toggle="#confirm_password"></i>
                </div>
                @error('confirm_new_password')
                    <div class="text-danger error mt-1">{{ $message }}</div>
                @enderror
                </div>
            </div>

            <div class="col-12">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user">{{ __('messages.update_password') }}</button>
                    <button class="cancel-btn"><a href="{{route('vendor.profile')}}">{{ __('messages.cancel') }}</a></button>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.toggle-password').forEach(function (toggle) {
            toggle.addEventListener('click', function () {
                const input = document.querySelector(this.getAttribute('toggle'));
                if (input) {
                    const type = input.getAttribute('type') === 'password' ? 'text' : 'password';
                    input.setAttribute('type', type);
                    this.classList.toggle('fa-eye');
                    this.classList.toggle('fa-eye-slash');
                }
            });
        });
    });
</script>

<style>
    .toggle-password {
        position: absolute;
        right: 15px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        color: #888;
    }
</style>
@endsection