@extends('layouts.vendor')
@section('content')
    <div class="col-9 main-dash-left">
        <div class="upper-main-user-navigation">
            <div class="user-manage">
                <a href="{{ route('vendor.profile') }}">{{ __('messages.my_profile') }}</a>
                <a class="active">{{ __('messages.profile') }}</a>
            </div>
        </div>

        <div class="add-user-form">
            <div class="profile-img-btn d-flex justify-content-between align-items-center">
                <div class="profile-pic my-profile-img">
                    <figure class="profile-img"><img src="{{ asset('storage/' . $vendor->profile_image) }}" alt=""></figure>
                </div>
                <button type="button" class="add-notification-btn" data-bs-toggle="modal" data-bs-target="#editConfirmModal">
                    {{ __('messages.edit_profile') }}
                </button>
            </div>
            <div class="name-profile-holder">
                <h3>{{ $vendor->first_name . ' ' . $vendor->last_name }}</h3>
            </div>
            <div class="profile-detai-all">
                <div class="inner-detail-profile">
                    <div class="pair-streetmain d-flex">
                        <div class="inner-pair-street">
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.phone_number') }} :</h6>
                                @foreach ($country_code as $code)
                                    @if ($code['dial_code'] == $vendor->country_code)
                                        <p>
                                            <span class="fi fi-{{ strtolower($code['code']) }}"></span>
                                            {{ $code['dial_code'] }} {{ $vendor->number }}
                                        </p>
                                    @endif
                                @endforeach
                            </div>
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.street_house_number') }}:</h6>
                                <p>{{ $vendor->street }}</p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.city') }}:</h6>
                                <p>{{ $vendor->city }}</p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.name_of_contract') }}:</h6>
                               <p>{{ $vendor->contact_person ? __('messages.' . $vendor->contact_person) : 'N/A'  }}</p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.profile_business_model') }}:</h6>
                                 <p>{{ $vendor->business_model ? __('messages.' . $vendor->business_model) : 'N/A'  }}</p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.profile_new_in_business') }}:</h6>
                                <p>{{ $vendor->new_in_business ? 'Ja' : 'Nein' }}</p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.status') }}:</h6>
                                <p>
                                    {{
                                        match($vendor->status) {
                                            'active'  => 'Aktiv',
                                            'blocked' => 'Gesperrt',
                                            'closed'  => 'Geschlossen',
                                            default   => ucfirst($vendor->status),
                                        }
                                    }}
                                </p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.tax_number') }}:</h6>
                                <p>{{ $vendor->tax_number }}</p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.bank_name') }}:</h6>
                                <p>{{ $vendor->bank_name }}</p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.bank_account_owner') }}:</h6>
                                <p>{{ $vendor->account_owner }}</p>
                            </div>
                            
                           
                            <div class="name-profile-detail" style="margin-bottom: 50px">
                                <h6>{{ __('messages.iban') }}:</h6>
                                <p>{{ $vendor->iban_number }}</p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.working_hours') }}:</h6>
                                <div class="time-profile-all">
                                    @foreach ($time as $availability)
                                        @if ($availability->open_time && $availability->close_time)
                                            <p><span>{{ ucfirst($availability->day) }}:</span>{{ \Carbon\Carbon::parse($availability->open_time)->format('H:i') }}
                                                - {{ \Carbon\Carbon::parse($availability->close_time)->format('H:i') }}</p>
                                        @else
                                            <p><span>{{ ucfirst($availability->day) }}:</span>{{ __('messages.closed') }}</p>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        <div class="inner-pair-street">
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.email_address') }} :</h6>
                                <p>{{ $vendor->email }}</p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.zip_code') }}:</h6>
                                <p>{{ $vendor->zip_code }}</p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.country') }}:</h6>
                                <p>{{ $vendor->country }}</p>
                            </div>
                        
                           
                           
                           <div class="name-profile-detail">
                                <h6>{{ __('messages.business_type') }}:</h6>
                                <p>{{ $vendor->business_type ? __('messages.' . $vendor->business_type) : 'N/A' }}</p>
                            </div>
                          
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.profile_size_of_location') }}:</h6>
                                 <p>{{ $vendor->size_of_location? __('messages.' . $vendor->size_of_location) : 'N/A' }}</p>
                            </div>
                           
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.no_of_employees') }}:</h6>
                                <p>{{ $vendor->employees }}</p>
                            </div>
                          
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.tax_id_vendor') }}:</h6>
                                <p>{{ $vendor->tax_id }}</p>
                            </div>
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.bank_account_number') }}:</h6>
                                <p>{{ $vendor->account_number }}</p>
                            </div>
                           
                            <div class="name-profile-detail">
                                <h6>{{ __('messages.bic_number') }}:</h6>
                                <p>{{ $vendor->bic_number }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="abcent-days">
                        <div class="head-abcent-days">
                            <h3>{{ __('messages.absent_days') }}:</h3>
                            {{-- <button class="add-notification-btn" type="button" data-bs-toggle="modal"
                                data-bs-target="#exampleModal" data-bs-whatever="@getbootstrap">{{ __('messages.add_holiday') }}</button> --}}
                        </div>

                        <div class="modal add-holiday-modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                            aria-hidden="true" style="display: none;">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h1 class="modal-title" id="exampleModalLabel">{{ __('messages.add_holiday') }}</h1>
                                    </div>
                                    <div class="modal-body">
                                        <form id="holiday_add_form" action=""
                                            method="POST">
                                            @csrf
                                            <div class="mb-3 comn-input-select">
                                                <label for="holiday_name" class="col-form-label">{{ __('messages.holiday_name') }}:</label>
                                                <input type="text" class="form-control" id="holiday_name"
                                                    name="holiday_name" required>
                                            </div>
                                            <div class="mb-3 comn-input-select">
                                                <label for="date_text" class="col-form-label">{{ __('messages.date') }}:</label>
                                                <input class="form-control" id="date_text" type="date"
                                                    name="holiday_date" required>
                                            </div>
                                            <div class="upper-main-btn-last-comn d-flex">
                                                <button type="button" class="add-user"
                                                    data-bs-dismiss="modal">{{ __('messages.cancel') }}</button>
                                                <button type="submit" class="cancel-btn">{{ __('messages.save') }}</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="table-abcent-list">
                            <table>
                                @if ($holidays->isEmpty())
                                    <tr>
                                        <td colspan="4" class="text-center">{{ __('messages.no_holidays_available') }}</td>
                                    </tr>
                                @else
                                    @foreach ($holidays as $holiday)
                                        <tr>
                                            <td class="abcent-name">{{ $holiday->name }}</td>
                                            <td class="abcent-date"
                                                data-date="{{ \Carbon\Carbon::parse($holiday->date)->format('Y-m-d') }}">
                                                {{ \Carbon\Carbon::parse($holiday->date)->format('d-m-Y') }}
                                            </td>
                                            <td class="abcent-total"></td>
                                            <td class="delete-last">
                                                {{-- <div class="delete-ico" data-bs="{{ $holiday->id }}"
                                                    data-route="{{ route('admin.holidays.delete', $holiday->id) }}">
                                                    <i class="fa-solid fa-trash" data-bs="{{ $holiday->id }}"></i>
                                                </div> --}}
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                            </table>
                        </div>
                    </div>

                    <div class="col-md-12 mt-3 detail-section">
                        <h2 class="mb-5">{{ __('messages.conditions') }}:</h2>
                        <table class="table table-bordered" id="existingCommissionTable">
                            <thead>
                                <tr>
                                    <th>{{ __('messages.sales_tier') }}</th>
                                    <th>{{ __('messages.commission') }}</th>
                                    <th>{{ __('messages.shop_fee') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if(!empty($vendor->commission_rate) && is_array($vendor->commission_rate))
                                    @foreach($vendor->commission_rate as $range => $data)
                                    @php
                                        $parts = explode('-', $range);
                                        $from = $parts[0];
                                        $to = $parts[1] ?? 'Above';
                                        $commission = $data['commission'] ?? '';
                                        $shop_fee = $data['shop_fee'] ?? '';
                                    @endphp
                                       <tr>
                                            <td>{{ number_format($from, 0, ',', '.') }}€ - {{ number_format($to, 0, ',', '.') }}€</td>
                                            <td>{{ $commission }}%</td>
                                            <td>{{ number_format($shop_fee, 2, ',', '.') }}€</td>
                                        </tr>


                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="editConfirmModal" tabindex="-1" aria-labelledby="editConfirmModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content p-3">
                <div class="modal-header">
                    <h5 class="modal-title" id="editConfirmModalLabel">{{ __('messages.edit_functionality') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" style="font-size : 16px">
                    <p>{{ __('messages.dear_vendor') }},</p>
                    <p>{{ __('messages.view_details_message') }}</p>
                    <p>{{ __('messages.adjustment_contact') }} <strong>cs@dachboxit.de</strong>.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="cancel-btn" data-bs-dismiss="modal">{{ __('messages.no') }}</button>
                    <a href="{{ route('vendor.edit.profile') }}" class="add-user">{{ __('messages.yes') }}</a>
                </div>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let today = new Date();
            today.setHours(0, 0, 0, 0);

            document.querySelectorAll(".abcent-date").forEach(function(element) {
                let holidayDateStr = element.getAttribute("data-date");
                let holidayDate = new Date(holidayDateStr + "T00:00:00");
                holidayDate.setHours(0, 0, 0, 0);

                let timeDiff = holidayDate - today;
                let daysLeft = Math.ceil(timeDiff / (1000 * 60 * 60 * 24));

                let daysLeftCell = element.closest("tr").querySelector(".abcent-total");
                
                if (daysLeft > 0) {
                    daysLeftCell.textContent = "{{ __('messages.in_days') }}".replace(':days', daysLeft);
                } else if (daysLeft === 0) {
                    daysLeftCell.textContent = "{{ __('messages.today') }}";
                } else {
                    daysLeftCell.textContent = "{{ __('messages.before_days') }}".replace(':days', Math.abs(daysLeft));
                }
            });
        });
        
        document.addEventListener("DOMContentLoaded", function() {
            document.querySelectorAll(".delete-ico").forEach(function(deleteButton) {
                deleteButton.addEventListener("click", function() {
                    let holidayId = this.getAttribute("data-id");
                    let deleteRoute = this.getAttribute("data-route");
                    let row = this.closest("tr");
                    if (confirm("Are you sure you want to delete this holiday?")) {
                        fetch(deleteRoute, {
                                method: "DELETE",
                                headers: {
                                    "X-CSRF-TOKEN": document.querySelector(
                                        'meta[name="csrf-token"]').getAttribute("content"),
                                    "Content-Type": "application/json",
                                },
                            })
                            .then(response => response.json())
                            .then(data => {
                                if (data.success) {
                                    row.remove();
                                    Swal.fire({
                                        title: "Deleted Successfully",
                                        icon: "success",
                                        draggable: true
                                    });
                                } else {
                                    alert("Error deleting holiday.");
                                }
                            })
                            .catch(error => console.error("Error:", error));
                    }
                });
            });
        });
    </script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flag-icons/css/flag-icons.min.css"/>
@endsection