@extends('frontend.include.app')
<style>
    .error {
        color: red !important;
    }
    .alert-danger {
        color: #721c24;
        background-color: #f8d7da;
        border-color: #f5c6cb;
        padding: 0.75rem 1.25rem;
        margin-bottom: 1rem;
        border: 1px solid transparent;
        border-radius: 0.25rem;
    }
    .alert-danger ul {
        margin: 0;
        padding-left: 20px;
    }
    .is-invalid {
        border-color: #dc3545 !important;
    }
    .invalid-feedback {
        display: none;
        color: #dc3545;
        font-size: 0.875em;
        margin-top: 0.25rem;
    }
    .is-invalid ~ .invalid-feedback {
        display: block;
    }
    .toggle-password {
        position: absolute;
        top: 50%;
        right: 15px;
        transform: translateY(-50%);
        cursor: pointer;
        color: #999;
        z-index: 10;
    }
    .inner-login-page .inner-main-input label {
        text-transform: none !important;
    }
    .profile_title_input .inner-main-input.title_inpt {
        max-width: 11.1rem !important;
    }
    .profile_title_input .inner-main-input.title_inpt select {
        width: 11rem !important;
        margin: 0;
    }
</style>

<section>
    <div class="inner-login vendor">
        <div class="row">
            <div class="col-lg-6">
                <div class="inner-login-img">
                    <figure>
                        <img src="{{ asset('frontend/images/signup.png') }}" alt="">
                    </figure>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="upper-high-main">
                    <div class="inner-login-input-form register-main-wrapper">
                        <div class="inner-login-page">
                            <div class="inner-login-wrapper">
                                <div class="logo-login register-logo">
                                    <img src="{{ asset('frontend/images/login-logo.png') }}" alt="">
                                </div>
                                <h2>{{ __('messages.vendor_registration') }}</h2>
                                <p>{{ __('messages.welcome_to_dachboxit') }} {{ __('messages.become_service_point') }}</p>
                            </div>
                            @if($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <form id="registerForm" method="POST" action="{{ route('vendor.register') }}" class="email-login">
                                @csrf
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="new_in_business" id="new_in_business" {{ old('new_in_business') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="new_in_business">{{ __('messages.new_in_business') }}</label>
                                </div>
                                <div class="row">
                                    <div class="col-md-3 inner-main-input">
                                        <label for="title" class="form-label">{{ __('messages.title') }}</label>
                                                                               <select class="form-select @error('title') is-invalid @enderror" name="title" required>
                                            <option value="">{{ __('messages.select_title') }}</option>
                                            <option value="Mr." {{ old('title') == 'Mr.' ? 'selected' : '' }}>{{ __('messages.title_mr') }}</option>
                                            <option value="Mrs." {{ old('title') == 'Mrs.' ? 'selected' : '' }}>{{ __('messages.title_mrs') }}</option>
                                        </select>
                                        @error('title')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-4 inner-main-input">
                                        <label for="first_name" class="form-label">{{ __('messages.first_name') }}</label>
                                        <input type="text" class="form-control @error('first_name') is-invalid @enderror" name="first_name" value="{{ old('first_name') }}" placeholder="{{ __('messages.enter_first_name') }}" required>
                                        @error('first_name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-4 inner-main-input">
                                        <label for="last_name" class="form-label">{{ __('messages.surname') }}*</label>
                                        <input type="text" class="form-control @error('last_name') is-invalid @enderror" name="last_name" value="{{ old('last_name') }}" placeholder="{{ __('messages.enter_surname') }}" required>
                                        @error('last_name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-12 inner-main-input">
                                        <label for="street" class="form-label">{{ __('messages.street_house_number') }}*</label>
                                        <input type="text" class="form-control @error('street') is-invalid @enderror" name="street" value="{{ old('street') }}" placeholder="{{ __('messages.enter_street_house_number') }}" required>
                                        @error('street')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-6 inner-main-input">
                                        <label for="zip_code" class="form-label">{{ __('messages.zip_code') }}*</label>
                                        <input type="text" class="form-control @error('zip_code') is-invalid @enderror" name="zip_code" value="{{ old('zip_code') }}" placeholder="{{ __('messages.enter_zip_code') }}" required>
                                        @error('zip_code')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-6 inner-main-input">
                                        <label for="city" class="form-label">{{ __('messages.city') }}*</label>
                                        <input type="text" class="form-control @error('city') is-invalid @enderror" name="city" value="{{ old('city') }}" placeholder="{{ __('messages.enter_city') }}" required>
                                        @error('city')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-12 inner-main-input">
                                        <label for="region" class="form-label">{{ __('messages.state_region') }}*</label>
                                        <select id="region" class="form-select @error('region') is-invalid @enderror" name="region" required>
                                            <option value="">{{ __('messages.select_option') }}</option>

                                            @foreach(__('messages.regions') as $key => $label)
                                                <option value="{{ $key }}" {{ old('region', $user->region ?? '') === $key ? 'selected' : '' }}>
                                                    {{ $label }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('region')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-12 inner-main-input">
                                        <label for="email" class="form-label">{{ __('messages.email') }}*</label>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" placeholder="{{ __('messages.enter_email_address') }}" required>
                                        @error('email')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-12 inner-main-input">
                                        <div class="d-flex profile_title_input">
                                            <div class="inner-main-input inner-main-input2 title_inpt">
                                                <label class="form-label">{{ __('messages.phone_code') }}*</label>
                                                <select class="form-select country_code_custom @error('phone_code') is-invalid @enderror" name="phone_code" required id="phone_code">
                                                    <option data-image="https://flagcdn.com/16x12/de.png"  value="+49" {{ old('phone_code') == '+49' ? 'selected' : '' }}>+49</option>
                                                    <option value="+43" data-image="https://flagcdn.com/16x12/at.png"  {{ old('phone_code') == '+43' ? 'selected' : '' }}> +43</option>
                                                    <option value="+41" data-image="https://flagcdn.com/16x12/ch.png"  {{ old('phone_code') == '+41' ? 'selected' : '' }}>+41</option>
                                                </select>
                                                @error('phone_code')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                            </div>
                                            <div class="inner-main-input inner-main-input2">
                                                <label class="form-label">{{ __('messages.phone_number') }}*</label>
                                                <input type="tel" name="phone_number" class="form-control @error('phone_number') is-invalid @enderror" value="{{ old('phone_number') }}" placeholder="{{ __('messages.enter_phone_number') }}" required>
                                                @error('phone_number')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                            </div>
                                        </div>
                                    </div>
                                   
                                    <div class="col-md-6 inner-main-input">
                                        <label for="business_model" class="form-label">{{ __('messages.business_model') }}</label>
                                        <select name="business_model" class="form-select @error('business_model') is-invalid @enderror" required>
                                            <option value="">{{ __('messages.select_business_model') }}</option>
                                            <option value="Fulltimer" {{ old('business_model') == 'Fulltimer' ? 'selected' : '' }}>{{ __('messages.fulltimer') }}</option>
                                            <option value="Side Business" {{ old('business_model') == 'Side Business' ? 'selected' : '' }}>{{ __('messages.side_business') }}</option>
                                        </select>
                                        @error('business_model')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-6 inner-main-input">
                                        <label for="size_of_location" class="form-label">{{ __('messages.size_of_location') }}</label>
                                       <select name="size_of_location" class="form-select @error('size_of_location') is-invalid @enderror" required>
                                            <option value="">{{ __('messages.select_size') }}</option>
                                            <option value="Beginner" {{ old('size_of_location') == 'Beginner' ? 'selected' : '' }}>{{ __('messages.beginner') }}</option>
                                            <option value="Small (< 5)" {{ old('size_of_location') == 'Small (< 5)' ? 'selected' : '' }}>{{ __('messages.small_business') }}</option>
                                            <option value="Middle (6 - 15)" {{ old('size_of_location') == 'Middle (6 - 15)' ? 'selected' : '' }}>{{ __('messages.middle_business') }}</option>
                                            <option value="Large (16-35)" {{ old('size_of_location') == 'Large (16-35)' ? 'selected' : '' }}>{{ __('messages.large_business') }}</option>
                                            <option value="XXL (>30)" {{ old('size_of_location') == 'XXL (>30)' ? 'selected' : '' }}>{{ __('messages.xxl_business') }}</option>
                                        </select>
                                        @error('size_of_location')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                </div>

                                <button type="submit" class="btn primary-btn w-100">{{ __('messages.register') }}</button>
                                <p class="not-yet">{{ __('messages.already_have_account') }} <a href="{{ route('vendor.login') }}">{{ __('messages.login') }}</a></p>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@if(session('success'))
<div class="modal fade" id="registrationSuccessModal" tabindex="-1" aria-labelledby="successModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="successModalLabel">{{ __('messages.registration_submitted') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-success">
                {{ session('success') }}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">OK</button>
            </div>
        </div>
    </div>
</div>
@endif

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<script>
    function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function () {
        $('#phone_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });
    });
</script>
<script>
    $(document).ready(function() {
        $.validator.addMethod("numericOnly", function(value, element) {
            return this.optional(element) || /^[0-9]+$/.test(value);
        }, "{{ __('messages.valid_phone_number') }}");

        $("#registerForm").validate({
            rules: {
                title: { required: true },
                first_name: { required: true, minlength: 2, maxlength: 50 },
                last_name: { required: true, minlength: 2, maxlength: 50 },
                email: {
                    required: true,
                    email: true,
                    remote: {
                        url: "{{ route('vendor.check.email') }}",
                        type: "GET",
                        data: {
                            email: function() {
                                return $("input[name='email']").val();
                            }
                        },
                        dataFilter: function(response) {
                            return response === 'false';
                        }
                    }
                },
                phone_code: { required: true },
                phone_number: {
                    required: true,
                    numericOnly: true,
                    minlength: 8,
                    maxlength: 15
                },
                street: { required: true },
                zip_code: { required: true },
                city: { required: true },
                region: { required: true },
                business_model: { required: true },
                size_of_location: { required: true }
            },
            messages: {
                title: "{{ __('messages.select_title_error') }}",
                first_name: {
                    required: "{{ __('messages.enter_first_name') }}",
                    minlength: "{{ __('messages.first_name_min') }}",
                    maxlength: "{{ __('messages.first_name_max') }}"
                },
                last_name: {
                    required: "{{ __('messages.enter_surname_error') }}",
                    minlength: "{{ __('messages.surname_min') }}",
                    maxlength: "{{ __('messages.surname_max') }}"
                },
                email: {
                    required: "{{ __('messages.enter_email_address_error') }}",
                    email: "{{ __('messages.enter_valid_email_address') }}",
                    remote: "{{ __('messages.email_already_taken') }}"
                },
                phone_code: "{{ __('messages.select_phone_code') }}",
                phone_number: {
                    required: "{{ __('messages.enter_phone_number_error') }}",
                    numericOnly: "{{ __('messages.valid_phone_number') }}",
                    minlength: "{{ __('messages.phone_number_length') }}",
                    maxlength: "{{ __('messages.phone_number_length') }}"
                },
                street: "{{ __('messages.enter_street_house_number_error') }}",
                zip_code: "{{ __('messages.enter_zip_code_error') }}",
                city: "{{ __('messages.enter_city_error') }}",
                region: "{{ __('messages.enter_region_state_error') }}",
                business_model: "{{ __('messages.select_business_model_error') }}",
                size_of_location: "{{ __('messages.select_size_of_location_error') }}"
            },
            errorElement: "div",
            errorClass: "invalid-feedback",
            highlight: function(element) {
                $(element).addClass('is-invalid').removeClass('is-valid');
            },
            unhighlight: function(element) {
                $(element).removeClass('is-invalid').addClass('is-valid');
            },
            errorPlacement: function(error, element) {
                error.insertAfter(element);
            }
        });
    });
</script>

@if(session('success'))
<script>
    document.addEventListener('DOMContentLoaded', function() {
        var myModal = new bootstrap.Modal(document.getElementById('registrationSuccessModal'));
        myModal.show();
    });
</script>
@endif