@extends('layouts.vendor')
@section('content')
<div class="col-9 main-dash-left">
    <div class="analytics">
        <div class="name-head">
            <h2>@lang('messages.booking_analytics')</h2>
            <div class="d-flex comm_head_top_right">
            <div class="sownload-cv-pdf">
                <a href="#" class="download-pdf" onclick="exportData('pdf')">@lang('messages.download_pdf')</a>
                <a href="#" class="download-csv" onclick="exportData('csv')">@lang('messages.download_csv')</a>
            </div>
            <form method="GET" action="{{ route('vendor.booking.index') }}" id="timeFilterForm">
                <select name="time_filter" class="form-select select-main-head" aria-label="Default select example">
                    <option value="year" {{ request('time_filter', 'year') == 'year' ? 'selected' : '' }}>@lang('messages.year')</option>
                    <option value="month" {{ request('time_filter') == 'month' ? 'selected' : '' }}>@lang('messages.month')</option>
                    <option value="week" {{ request('time_filter') == 'week' ? 'selected' : '' }}>@lang('messages.week')</option>
                    <option value="day" {{ request('time_filter') == 'day' ? 'selected' : '' }}>@lang('messages.day')</option>
                </select>
            </form>
            </div>
        </div>
        <div class="cards-dashboard">
            <div class="row row-gap-3">
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-green">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/total.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>@lang('messages.net_revenue_excl_tax')</p>
                                    <h4>{{ $analytics['net_revenue'] }}</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/green-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-purple">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/return.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>@lang('messages.number_of_bookings')</p>
                                    <h4>{{ $analytics['total_bookings'] }}</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/white-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-yellow">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/top.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>@lang('messages.number_of_cancellations')</p>
                                    <h4>{{ $analytics['cancellations'] }}</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/orange-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="inner-dashboard-card back-parrot">
                        <div class="ing-sec-acrd-dash">
                            <figure class="logo-card"><img src="{{asset('admin/images/lost.png')}}" alt=""></figure>
                            <div class="main-card-analy d-flex">
                                <div class="text-disc-card">
                                    <p>@lang('messages.total_revenue_bookings')</p>
                                    <h4>{{ $analytics['total_revenue'] }}</h4>
                                </div>
                                <figure class="img-graph">
                                    <img src="{{asset('admin/images/parot-line.png')}}" alt="">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
       
        <form id="exportForm" method="GET" action="" style="display: none;">
            <input type="hidden" name="time_filter" id="exportTimeFilter" value="{{ request('time_filter', 'year') }}">
            <input type="hidden" name="status" id="exportStatusFilter" value="{{ request('status', 'all') }}">
        </form>
        <div class="main-notification-messege">
            <div class="notifi-list d-flex">
            <div class="cont-wrap">
                <h6>@lang('messages.booking_management')</h6>
                <p style="margin-top: 6px ; font-size: 14px"><strong>@lang('messages.red_flag')</strong> @lang('messages.red_flag_desc')</p>
                    <p style=" font-size: 14px"><strong>@lang('messages.grey_flag')</strong> @lang('messages.grey_flag_desc')</p>
                    <p style=" font-size: 14px"><strong>@lang('messages.blue_flag')</strong> @lang('messages.blue_flag_desc')</p>
                        <p style=" font-size: 14px">@lang('messages.blue_flag_info')</p>
            </div>
                <div class="dropdowns-inner-list d-flex">
                    <div class="dropdowns-inner-list">
                        <div class="icon-search-main">
                            <i class="fa-solid fa-magnifying-glass"></i>
                            <input aria-describedby="passwordHelpBlock" placeholder="@lang('messages.search_placeholder')"
                                type="text" id="booking_user" class="form-control" value="{{ request('search') }}">
                        </div>
                    </div>
                    @php
                        $status = request()->get('status', ''); // get status from query
                        $statusLabel = 'Filter'; // default text
                        if ($status && $status !== 'all') {
                            $statusLabel = ucfirst($status); // make first letter capital
                        } elseif ($status === 'all') {
                            $statusLabel = 'All Statuses';
                        }
                    @endphp
                    <div class="filter-main-div">
                        <p class="lable-filt">Filter:</p>
                        <div class="dropdown">
                            <button class="filter-btn dropdown-toggle" type="button" id="statusFilterDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-solid fa-filter"></i> {{$statusLabel}}
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="statusFilterDropdown">
                                <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['status' => 'all']) }}">All</a></li>
                                <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['status' => 'pending']) }}">Pending</a></li>
                                <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['status' => 'confirmed']) }}">Confirmed</a></li>
                                <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['status' => 'completed']) }}">Completed</a></li>
                                <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['status' => 'cancelled']) }}">Cancelled</a></li>
                            </ul>
                        </div>
                    </div>

                    <a class="add-notification-btn" href="{{route('vendor.getquote')}}">    @lang('messages.add_booking')
                    </a>
                </div>
            </div>
            <div class="notification-table pt-0">
                <table id="bookingTable" class="table">
                    <thead>
                        <tr class="head-class-td">
                            <th>@lang('messages.booking_id')</th>
                            <th>@lang('messages.customer_name')</th>
                            <th>@lang('messages.email_address')</th>
                            <th>@lang('messages.rental_period')</th>
                            <th>@lang('messages.total_amount')</th>
                            <th>@lang('messages.rental_days')</th>
                            <th>@lang('messages.additional_rental_days')</th>
                            <th>@lang('messages.new_dropoff_datetime')</th>
                            <th>@lang('messages.damaged')</th>
                            <th>@lang('messages.delay_fee_additional')</th>
                            <th>@lang('messages.extra_cost_paid')</th>
                            <th>@lang('messages.status')</th>
                            <th>@lang('messages.action')</th>
                        </tr>
                    </thead>
                    <tbody id="searchBookingUser">
                        @foreach($bookings as $booking)
                        <tr>
                            <td>
                                @if($booking->items->contains(function ($item) {
                                    return !empty($item->vendor_id);
                                }))
                                    <span class="text-secondary me-1" title="Includes vendor items">
                                        <i class="fa-solid fa-flag"></i>
                                    </span>
                                @endif
                                #{{ $booking->id }}
                               
                                @if($booking->items->contains('user_timing', 1))
                                    <span class="text-primary me-1" title="Customer requested timing change">
                                        <i class="fa-solid fa-flag"></i>
                                    </span>
                                @endif

                                {{-- Red flag for delay or damaged item --}}
                                @if($booking->delay || $booking->items->contains('damage', 1))
                                    <span class="text-danger me-1" title="Delay or Damage reported">
                                        <i class="fa-solid fa-flag"></i>
                                    </span>
                                @endif
                            </td>
                            
                            <td>
                                @if($booking->userDetails)
                                    {{ $booking->userDetails->first_name }} {{ $booking->userDetails->last_name }}
                                @else
                                    N/A
                                @endif
                            </td>
                            
                            <td>
                                @if($booking->userDetails)
                                    {{ $booking->userDetails->email }}
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>
                                @if($booking->items->isNotEmpty())
                                    <span style="{{ $booking->highlight_pickup ? 'color: blue; font-weight: 600;' : '' }}">
                                        {{ $booking->items->first()->pickup_date->format('d.m.Y') }}
                                    </span>
                                    -
                                    {{ $booking->items->first()->dropoff_date->format('d.m.Y') }}
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>{{number_format($booking->total , 2 , ',' , '.')}} €</td>

                            <td>
                                @if($booking->items->isNotEmpty())
                                    {{ $booking->items->first()->days }} Days
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>
                                @if($booking->additional_days)
                                    {{$booking->additional_days }} Days
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>
                                @if($booking->new_dropoff_date)
                                    {{ \Carbon\Carbon::parse($booking->new_dropoff_date)->format('d.m.Y') }} -  {{ \Carbon\Carbon::parse($booking->items->first()->new_dropoff_time)->format('H:i') }}
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>
                                @if($booking->items->contains('damage', 1))
                                    
                                        <span>Yes</span>
                                    
                                @endif
                            </td>

                            <td>{{ number_format($booking->additional_days_rent + $booking->delay_fees , 2 , ',' , '.') }} €</td>
                            <td>
                                <p>
                                    @if(($booking->additional_days_rent + $booking->delay_fees) == 0)
                                        N/A
                                    @elseif(isset($booking->delay_fees_paid))
                                        {{ $booking->delay_fees_paid ? 'Paid' : 'Pending' }}
                                    @else
                                        N/A
                                    @endif
                                </p>
                            </td>
                            <td>
                                <select class="form-select select-active-block" 
                                id="statusSelect{{ $booking->id }}" 
                                aria-label="Default select example" data-current-status="{{$booking->status}}"  {{ $booking->refund_amount ? 'disabled' : '' }}>
                                    <option value="pending" class="pending-op" {{ $booking->status == 'pending' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">pending</option>
                                    <option value="cancelled" class="cancel-op" {{ $booking->status == 'cancelled' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">Cancelled</option>
                                    <option value="confirmed" class="confirmed-op" {{ $booking->status == 'confirmed' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">confirmed</option>
                                    <option value="completed" class="completed-op"  {{ $booking->status == 'completed' ? 'selected' : '' }} data-previous-value="{{ $booking->status }}">completed</option>
                                </select>
                            </td>
                            <td>
                                <div class="upper-delete-btns d-flex">
                                    <a class="view-btn-eye" href="{{ route('vendor.view.booking.detail', [$booking->id]) }}">
                                        <i class="fa-solid fa-eye"></i>
                                    </a>
                                    <a class="edit-btn-eye" href="{{ route('vendor.edit.booking.detail', $booking->id) }}">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Status Change Modal -->
<div class="modal fade modal-delete-logout" id="statusChangeModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-0 modal-body">
                <div class="inner-body-delete-logout">
                    <h4 id="statusChangeModalText">@lang('messages.status_change_confirm')</h4>
                    <div class="upper-btns-modal-pair">
                        <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">@lang('messages.no_button')</button>
                        <form id="statusChangeForm" method="POST" action="">
                            @csrf
                            <input type="hidden" name="status" id="newStatusValue">
                            <button type="submit" class="comn-modal-btns-blue btn btn-primary">@lang('messages.yes_button')</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function exportData(type) {
        const timeFilter = $('#timeFilterForm select').val();
        const statusFilter = "{{ request('status', 'all') }}";
        
        $('#exportTimeFilter').val(timeFilter);
        $('#exportStatusFilter').val(statusFilter);
        
        const action = type === 'csv' 
            ? "{{ route('vendor.bookings.download.csv') }}" 
            : "{{ route('vendor.bookings.download.pdf') }}";
        $('#exportForm').attr('action', action);
        
        $('#exportForm').submit();
    }
$(document).ready(function() {
    var baseUrl = "{{ rtrim(config('app.url'), '/') }}";
    $('#bookingTable').DataTable({
        paging: true,
        searching: true, 
        info: true,
        lengthChange: true,
        pageLength: 10,
        ordering: false, 
        language: {
            lengthMenu: 'Show _MENU_ entries',
            paginate: {
                previous: '&laquo;',
                next: '&raquo;'
            }
        },
        dom: '<"top"lf>rt<"bottom"ip><"clear">'
    });

    $('#booking_user').on('keyup', function () {
        $('#bookingTable').DataTable().search(this.value).draw();
    });


    // Time filter change
    $('.select-main-head').on('change', function() {
        $('#timeFilterForm').submit();
    });
    
    // Search bookings
    // $('#booking_user').on('keyup', function() {
    //     let searchQuery = $(this).val();
        
    //     $.ajax({
    //         url: "{{ route('vendor.booking.user.search') }}",
    //         method: 'GET',
    //         data: {
    //             search: searchQuery,
    //             time_filter: "{{ request('time_filter', 'year') }}"
    //         },
    //         success: function(response) {
    //             $('#searchBookingUser').html(response.html);
    //         },
    //         error: function(xhr, status, error) {
    //             console.error("Error: " + error);
    //         }
    //     });
    // });
   
    // Status change handling
    $('.select-active-block').on('change', function() {
        const $select = $(this);
        const newStatus = $select.val();
        const bookingId = $select.attr('id').replace('statusSelect', '');
        const currentStatus = $select.find('option:selected').data('previous-value');
        
        if (newStatus === currentStatus) {
            return;
        }
    
        let message = '';
        switch(newStatus) {
            case 'pending':
                message = "@lang('messages.confirm_pending')";
                break;
            case 'cancelled':
                message = "@lang('messages.confirm_cancelled')";
                break;
            case 'confirmed':
                message = "@lang('messages.confirm_confirmed')";
                break;
            case 'completed':
                message = "@lang('messages.confirm_completed')";
                break;
        }
    
        $('#statusChangeModalText').text(message);
        $('#newStatusValue').val(newStatus);
        $('#statusChangeForm').attr('action', baseUrl +'/vendor/bookings/' + bookingId + '/status');
        
        $('#statusChangeModal').data('select', $select);
        $('#statusChangeModal').data('current-status', currentStatus);
        
        $('#statusChangeModal').modal('show');
    });
    
    $('#statusChangeForm').on('submit', function(e) {
        e.preventDefault();
        
        const form = $(this);
        const url = form.attr('action');
        const $select = $('#statusChangeModal').data('select');
        
        $.ajax({
            url: url,
            type: 'POST',
            data: form.serialize(),
            success: function(response) {
                if(response.success) {
                    $select.find('option:selected').data('previous-value', $('#newStatusValue').val());
                    
                    $('#statusChangeModal').modal('hide'); 
                    Swal.fire({
                            icon: 'success',
                            title: "@lang('messages.booking_status')",
                            text: "@lang('messages.status_updated_successfully')",
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.location.reload();
                            }
                        });
                    
                    updateRowStatus($select.closest('tr'), $('#newStatusValue').val());
                }
            },
            error: function(xhr) {
                let msg =  "@lang('messages.status_update_error')";
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    msg = xhr.responseJSON.message;
                }

                Swal.fire({
                    icon: 'error',
                    title: "@lang('messages.booking_status')",
                    text: msg,
                });

                // revert status select
                $select.val($('#statusChangeModal').data('current-status'));
                $('#statusChangeModal').modal('hide');
            }
        });
    });
    
    $('#statusChangeModal').on('hidden.bs.modal', function() {
        const $select = $(this).data('select');
        const currentStatus = $(this).data('current-status');
        
        if ($select && currentStatus) {
            $select.val(currentStatus);
        }
    });
    
    function updateRowStatus($row, status) {
        $row.removeClass('table-warning table-success table-danger table-info');
        
        switch(status) {
            case 'pending':
                $row.addClass('table-warning');
                break;
            case 'confirmed':
                $row.addClass('table-info');
                break;
            case 'completed':
                $row.addClass('table-success');
                break;
            case 'cancel':
                $row.addClass('table-danger');
                break;
        }
    }
  
});
</script>
@endsection