<!-- Rental Price Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered our-rental-price">
        <div class="modal-content">
            <div class="modal-body">
                <div class="inner-body-price">
                    <h3>{{ __('messages.our_rental_price') }}</h3>
                    <div class="upper-table-main-pop">
                        <table>
                            <tr>
                                <th>{{ __('messages.days') }}</th>
                                <th>{{ __('messages.price') }}</th>
                            </tr>
                            @foreach($dailyPrices as $index => $price)
                                <tr>
                                    <td>{{ __('messages.day_label', ['number' => $index + 1]) }}</td>
                                    <td>{{ number_format($price, 2, ',', '.') }} €</td>
                                </tr>
                            @endforeach
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade modal-not-book" id="railingType" tabindex="-1" aria-labelledby="notBookableLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notBookableLabel">{{ __('messages.attention') }}</h5>
                <p>{{ __('messages.please_check_railing_type') }}</p>
                <button type="button" class="btn primary-btn" data-bs-dismiss="modal">{{ __('messages.ok') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Not Bookable Modal -->
<div class="modal fade modal-not-book" id="notBookableModal" tabindex="-1" aria-labelledby="notBookableLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notBookableLabel">{{ __('messages.not_bookable_title') }}</h5>
                <p>{{ __('messages.not_bookable_message') }}</p>
                <button type="button" class="btn primary-btn" data-bs-dismiss="modal">{{ __('messages.ok') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Carrier Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notCarrier" tabindex="-1" aria-labelledby="notCarrier" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notCarrier">{{ __('messages.carrier_disclaimer_title') }}</h5>
                <p>{{ __('messages.carrier_disclaimer_message') }}</p>
                <button type="button" class="btn primary-btn" id="rentCarrierBtn">{{ __('messages.rent_carrier') }}</button>
                <button type="button" class="btn seconday-btn" id="bringOwnCarrierBtn">{{ __('messages.bring_own_carrier') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Insurance Disclaimer Modal -->
<div class="modal fade modal-not-book" id="notInsurance" tabindex="-1" aria-labelledby="notInsurance" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h5 class="modal-title" id="notInsurance">{{ __('messages.insurance_disclaimer_title') }}</h5>
                <p>{{ __('messages.insurance_disclaimer_message') }}</p>
                <button type="button" class="btn primary-btn" id="wantInsuranceBtn">{{ __('messages.yes_insure_me') }}</button>
                <button type="button" class="btn seconday-btn" id="noInsuranceBtn">{{ __('messages.no_insurance') }}</button>
            </div>
        </div>
    </div>
</div>

<!-- Guest Options Modal -->
<div class="modal fade modal-guest-main" id="guestOptionsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <h1 class="modal-title modal-guest-l" id="exampleModalToggleLabel2">{{ __('messages.guest_title') }}</h1>
                <div id="guestError" class="alert alert-danger d-none" role="alert"></div>
                <div class="row">
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstname" class="form-label">{{ __('messages.first_name') }}</label>
                            <input type="text" class="form-control" placeholder="{{ __('messages.enter_first_name') }}" id="firstname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="surname" class="form-label">{{ __('messages.surname') }}</label>
                            <input type="text" class="form-control" placeholder="{{ __('messages.enter_surname') }}" id="surname">
                        </div>
                    </div>
                    
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstemail" class="form-label">{{ __('messages.email') }}</label>
                            <input type="email" class="form-control" placeholder="{{ __('messages.enter_email') }}" id="firstemail">
                        </div>
                    </div>
                </div>
                <div class="upper-flex-main-modal">
                    <button class="btn  primary-outline-btn" data-bs-target="#guestOptionsModal" data-bs-toggle="modal">
                        {{ __('messages.back') }}
                    </button>
                    <button class="btn primary-btn" id="continueAsGuest">
                        {{ __('messages.continue') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Guest Modal Form -->
<div class="modal modal-not-book modal-g fade" id="guestModal" aria-hidden="true" aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <h1 class="modal-title modal-guest-l" id="exampleModalToggleLabel2">{{ __('messages.guest_title') }}</h1>
                <div id="guestError" class="alert alert-danger d-none" role="alert"></div>
                <div class="row">
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstname" class="form-label">{{ __('messages.first_name') }}</label>
                            <input type="text" class="form-control" placeholder="{{ __('messages.enter_first_name') }}" id="firstname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="surname" class="form-label">{{ __('messages.surname') }}</label>
                            <input type="text" class="form-control" placeholder="{{ __('messages.enter_surname') }}" id="surname">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="number" class="form-label">{{ __('messages.phone_number') }}</label>
                            <input type="text" class="form-control" placeholder="{{ __('messages.enter_phone_number') }}" id="number">
                        </div>
                    </div>
                    <div class="col">
                        <div class="inner-main-input inner-main-input2">
                            <label for="firstemail" class="form-label">{{ __('messages.email') }}</label>
                            <input type="email" class="form-control" placeholder="{{ __('messages.enter_email') }}" id="firstemail">
                        </div>
                    </div>
                </div>
                <div class="upper-flex-main-modal">
                    <button class="btn  primary-outline-btn" data-bs-target="#guestOptionsModal" data-bs-toggle="modal">
                        {{ __('messages.back') }}
                    </button>
                    <button class="btn primary-btn" id="continueAsGuest">
                        {{ __('messages.continue') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
