@extends('layouts.vendor')
@section('content')
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{ route('vendor.booking.index') }}">@lang('messages.booking_management')</a>
            <a class="active" href="">@lang('messages.view_booking_details')</a>
        </div>
        @if($booking->payment_status !== 'paid' && 
    (!empty($booking->last_payment_link_sent_at) && now()->diffInHours($booking->last_payment_link_sent_at) >= 24))
    <div class="mt-4 resend-payment">
        <form action="{{ route('vendor.booking.resend-payment-link', $booking->id) }}" method="POST">
            @csrf
            <button type="submit" class="add-notification-btn mb-3">@lang('messages.resend_payment_link')</button>
        </form>
    </div>
    @endif
</div>

    <div class="add-user-form">
        <h2 class="head-mian-all-payment">@lang('messages.view_booking_details')</h2>
        <div class="main-show-detail-viwe">
            <!-- User Details Section -->
            <div class="inner-pack-view">
                <h3>@lang('messages.user_details')</h3>
                
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>@lang('messages.customer_id')</h5>
                        <p>#{{ $booking->user_id ?? 'N/A' }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.customer_name')</h5>
                        <p>
                            @if($booking->userDetails)
                            {{ trim($booking->userDetails->first_name . ' ' . $booking->userDetails->last_name) ?: 'N/A' }}
                            @else
                                N/A
                            @endif
                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.street_house_number')</h5>
                        <p>{{ $booking->userDetails->address ?? 'N/A' }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.zip_code')</h5>
                        <p>{{ $booking->userDetails->zip ?? 'N/A' }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.city')</h5>
                        <p>{{ $booking->userDetails->city ?? 'N/A' }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.country')</h5>
                        <p>{{ $booking->userDetails->country ?? 'N/A' }}</p>
                    </div>
                </div>

                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>@lang('messages.email_address')</h5>
                        <p style="text-transform: lowercase;">{{ $booking->userDetails->email ?? 'N/A' }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.phone_number')</h5>
                        <p>{{ $booking->userDetails->phone ?? 'N/A' }}</p>
                    </div>
                    <div class="patient-anme-view">

                        <h5>@lang('messages.note')</h5>
    
                        <p>{{ $booking->notes ?? 'N/A' }}</p>
    
                    </div>
                </div>
            </div>

            <!-- Car Details Section - Displaying first item's car details -->
            @foreach($booking->items as $item)
            @if(!$item->related_item)
            <div class="car-details-wrap">

                <!-- Car Details -->
                <div class="inner-pack-view">
                    <h3>Car Details:</h3>
                    <div class="patient-age-name d-flex">
                        <div class="patient-anme-view">
                            <h5>@lang('messages.brand')</h5>
                            <p>{{ $item->car_name ? explode(' ', $item->car_name)[0] : 'N/A' }}</p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>@lang('messages.year')</h5>
                            <p>{{ $item->car_year ?? 'N/A' }}</p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>@lang('messages.model')</h5>
                            <p>{{ $item->model ?? 'N/A' }}</p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>@lang('messages.trailer_hitch')</h5>
                            <p>{{ isset($item->trailer_hitch) ? ($item->trailer_hitch ? 'Yes' : 'No') : 'N/A' }}</p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>@lang('messages.roof_type')</h5>
                            <p>{{ $item->roof_type ?? 'N/A' }}</p>
                        </div>
                    </div>
                </div>

                <div class="inner-pack-view">
                    <h3>@lang('messages.product_details')</h3>
                    <div class="patient-age-name d-flex">
                        <div class="patient-anme-view">
                            <h5>@lang('messages.product_id')</h5>
                            <p>#{{ $item->product_id ?? 'N/A' }}</p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>@lang('messages.product_name')</h5>
                            <p>{{ $item->product_name ?? 'N/A' }}</p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>@lang('messages.size_variation')</h5>
                            <p>{{ $item->size ?? 'N/A' }}</p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>@lang('messages.color')</h5>
                            <p>{{ $item->color ?? 'N/A' }}</p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>@lang('messages.quantity')</h5>
                            <p>{{ $item->quantity ?? 1 }}</p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>@lang('messages.insurance')</h5>
                            <p>{{ isset($item->is_insured) ? ($item->is_insured ? 'Yes' : 'No') : 'N/A' }}</p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>@lang('messages.roof_rack_included')</h5>
                            <p>{{ isset($item->is_carrier_included) ? ($item->is_carrier_included ? 'Yes' : 'No') : 'N/A' }}</p>
                        </div>
                    </div>
                </div>
            

            <!-- Booking Details Section -->
            <div class="inner-pack-view">
                <h3>@lang('messages.booking_details')</h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>@lang('messages.booking_no')</h5>
                        <p>#{{ $booking->id ?? 'N/A' }}
                            @if(!empty($item->vendor_id))
                                <span class="text-secondary me-1" title="Includes vendor item"><i class="fa-solid fa-flag"></i></span>
                            @endif
                            @if($item->user_timing==1)
                                <span class="text-primary me-1" title="Customer requested timing change"><i class="fa-solid fa-flag"></i></span>
                            @endif
                            @if($booking->delay || $item->damage == 1)
                                <span class="text-danger me-1" title="Delay or Damage reported"><i class="fa-solid fa-flag"></i></span>
                            @endif
                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.rental_period')</h5>
                        <p>
                            {{ $item->pickup_date ? $item->pickup_date->format('d.m.Y') : 'N/A' }} -
                            {{ $item->dropoff_date ? $item->dropoff_date->format('d.m.Y') : 'N/A' }}
                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.rental_days')</h5>
                        <p>{{ $item->days ?? 'N/A' }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.pickup_datetime')</h5>
                        <p>
                            {{ $item->pickup_date ? $item->pickup_date->format('d.m.Y') : 'N/A' }} |
                            {{ !empty($item->pickup_time) ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : 'N/A' }}
                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.dropoff_datetime')</h5>
                        <p>
                            {{ $item->dropoff_date ? $item->dropoff_date->format('d.m.Y') : 'N/A' }} |
                            {{ !empty($item->dropoff_time) ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : 'N/A' }}
                        </p>
                    </div>
                </div>

                <div class="patient-anme-view" style="margin-bottom : 30px">
                    <h5>@lang('messages.sa_spo_change_reason')</h5>
                    <p>{{ $item->change_reason ?? 'N/A' }}</p>
                </div>

                <div class="patient-age-name d-flex mt-3">
                    <div class="patient-anme-view">
                        <h5>@lang('messages.roof_rack_information')</h5>
                        <p>
                            @lang('messages.length'): {{ !empty($item->carrier_length) ? preg_replace('/\s*mm$/i', '', $item->carrier_length) : 'N/A' }}
                            @if(!empty($item->foot_sku))
                                @lang('messages.foot'): {{ $item->foot_sku }}
                            @endif
                            @if(!empty($item->footkit_sku))
                                <span>@lang('messages.foot_kit'): {{ $item->footkit_sku }}</span>
                            @endif
                        </p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.payment_method')</h5>
                        <p>{{ $booking->payment_method ? ($booking->payment_method === 'stripe' ? 'Credit Card' : ucfirst($booking->payment_method)) : 'N/A' }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.payment_status')</h5>
                        <p>{{ $booking->payment_status ? ucfirst($booking->payment_status) : 'N/A' }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.booking_status')</h5>
                        <p>{{ $booking->status ? ucfirst($booking->status) : 'N/A' }}</p>
                    </div>
                </div>

                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>@lang('messages.total_amount')</h5>
                        <p>€{{ number_format($booking->total ?? 0, 2, ',' , '.') }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.discount')</h5>
                        <p>€{{ number_format($booking->discount ?? 0, 2 , ',' , '.') }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.pickup_location')</h5>
                        @php 
                            $pickupAddress = 'N/A';
                            $vendorId = (int) ($item->vendor_id ?? 0);
                            if ($vendorId) {
                                $v = $vendors->where('id', $vendorId)->first();
                                if ($v) {
                                    $pickupAddress = "{$v->street} {$v->zip_code} {$v->city}";
                                }
                            } else {
                                $pickupAddress = 'Esperantostr. 10, 70197 Stuttgart';
                            }
                        @endphp
                        <p>{{ $pickupAddress ?? 'N/A' }}</p>
                    </div>
                </div>
            </div>

            <!-- Return Info -->
            <div class="inner-pack-view mt-4">
                <h3>@lang('messages.return_information')</h3>
                @php
                    $hasAlreadyBooked = $booking->items->contains(fn($i) => !empty($i->already_booked) && $i->already_booked == true);
                @endphp
                @if($hasAlreadyBooked)
                <p style="color:red;">@lang('messages.already_booked_warning')</p>
            @endif
                <div class="patient-age-name d-flex">
                     <div class="patient-anme-view">
                        <h5>@lang('messages.damaged_products')</h5>
                        <p>
                                @php
                                    $damagedProducts = $booking->items->where('damage', 1)->pluck('product_name')->toArray();
                                @endphp
                                {{ !empty($damagedProducts) ? implode(', ', $damagedProducts) : 'N/A' }}
                            </p>
                        </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.new_dropoff_date')</h5>
                        <p>{{ $booking->new_dropoff_date ? \Carbon\Carbon::parse($booking->new_dropoff_date)->format('d.m.Y') : 'N/A' }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.new_dropoff_time')</h5>
                        <p>{{ !empty($booking->items->first()->new_dropoff_time) ? \Carbon\Carbon::parse($booking->items->first()->new_dropoff_time)->format('H:i') : 'N/A' }}</p>
                    </div>
                   
                    <div class="patient-anme-view">
                        <h5>@lang('messages.delay_fees')</h5>
                        <p>€{{ number_format($booking->delay_fees ?? 0, 2, ',', '.') }}</p>
                    </div>
                    
                    <div class="patient-anme-view">
                        <h5>@lang('messages.additional_days')</h5>
                        <p>{{ $booking->additional_days ?? 'N/A' }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.additional_days_rent')</h5>
                        <p>€{{ number_format($booking->additional_days_rent ?? 0, 2, ',', '.') }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>@lang('messages.extra_costs_paid')</h5>
                        <p>
                            @if(($booking->additional_days_rent + $booking->delay_fees) == 0)
                                N/A
                            @elseif(isset($booking->delay_fees_paid))
                                {{ $booking->delay_fees_paid ? 'Paid' : 'Pending' }}
                            @else
                                N/A
                            @endif
                        </p>
                    </div>
                </div>
            </div>

        </div>
        @endif
        @endforeach
    </div>
    <div class="upper-main-btn-last-comn d-flex">
        
        <a href="{{ route('vendor.booking.index') }}" class="cancel-btn">
            @lang('messages.back_to_list')
        </a>
    </div>
</div>
</div>
@endsection
