<div class="inner-data-detail">
    <div class="head-roof-box">
        <h3>{{ $product->brand->name }} {{ $product->name }}</h3>
    </div>
    

    <div class="price-detail-main">
        <div class="price-big d-flex">
            <h3>{{ $product->first_price  ?? 'N/A'  }}</h3>
            <a href="javascript:void()" data-bs-toggle="modal" data-bs-target="#exampleModal">{{ __('messages.view_price_breakdown') }}</a>
        </div>
        <p>{{ __('messages.per_day_incl_vat') }}</p>
    </div>

    <div class="pick-location">
        <h3>{{ __('messages.pickup_location') }}</h3>
        <div class="pick-locati-name-icon d-flex">
            <img src="{{ asset('frontend/images/loct.png')}}" alt="">
            <select class="form-select" id="vendor_select" name="vendor_select">
                <option value ="admin">Esperantostr. 10, 70197 Stuttgart</option>
            @foreach($vendors as $vendor)
                <option value="{{ $vendor->id }}">{{ $vendor->street . ' ' . $vendor->zip_code . ' ' . $vendor->city }}</option>
            @endforeach
            </select>
        </div>
    </div>
    <div class="choose-car">
        <h3>{{ __('messages.choose_your_car') }}</h3>
        <form id="car-form">
            <div class="row">
                <div class="col-md-6 inner-main-input">
                    <label>{{ __('messages.manufacturer') }}</label>
                    <select class="form-select" id="manufacturer" name="manufacturer">
                        <option selected disabled>{{ __('messages.select') }}</option>
                        @foreach($manufacturers as $manufacturer)
                            <option value="{{ $manufacturer }}">{{ $manufacturer }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-6 inner-main-input">
                    <label>{{ __('messages.model') }}</label>
                    <select class="form-select" id="model" name="model" disabled></select>
                </div>

                <div class="col-md-6 inner-main-input">
                    <label>{{ __('messages.year_of_make') }}</label>
                    <select class="form-select" id="year" name="year" disabled></select>
                </div>

              

                <div class="col-md-6 inner-main-input">
                    <label>{{ __('messages.trailer_hitch') }}</label>
                    <select class="form-select" id="trailer_hitch" name="trailer_hitch" 
                            data-product-name="{{ $product->name }}">
                        <option value="" selected disabled>{{ __('messages.select') }}</option>
                        <option value="yes">{{ __('messages.yes') }}</option>
                        <option value="no">{{ __('messages.no') }}</option>
                    </select>
                </div>
            </div>

            <div id="result" class="mt-3"></div>
        </form>
    </div>
    <input id="railing_type" hidden value="{{$product->railing_type}}" />
    @if($product->railing_type)
    <div class="railing-type">
        <h3>{{ __('messages.railing_type') }}</h3>
        <p>{{ __('messages.railing_type_description') }}</p>
    </div>
    
    <div id="roof-types-container" style="display: none;">
        @foreach($roofTypes as $roofType)
            <div class="roof-name-detail" id="roof-type-{{ Str::slug($roofType) }}">
                <figure>
                    @php
                        $imageName = strtolower(str_replace(' ', '-', $roofType)) . '.jpg';
                    @endphp
                    <img src="{{ asset('frontend/images/' . $imageName) }}" alt="{{ $roofType }}">
                </figure>
                <h4>{{ __('messages.' .($roofType)) }}</h4>
                @if($roofType == 'Normal Roof')
                <p>{{ __('messages.normal') }}</p>
                @elseif($roofType == 'Normal roof without glass roof')
                <p>{{ __('messages.normal') }}</p>
                @elseif($roofType == 'Normal Roof with glass roof')
                <p>{{ __('messages.normal_glass') }}</p>
                @elseif($roofType == 'Fixpoints')
                <p>{{ __('messages.fixpoints') }}</p>
                @elseif($roofType == 'Fixpoints without glass roof')
                <p>{{ __('messages.fixpoints') }}</p>
                @elseif($roofType == 'Fixpoints with glass roof')
                <p>{{ __('messages.fixpoints_glass') }}</p>
                @elseif($roofType == 'Integrated Roof Railing')
                <p>{{ __('messages.integrated_rails') }}</p>
                @elseif($roofType == 'Elevated Roof Rails')
                <p>{{ __('messages.elevated_rails') }}</p>
                @elseif($roofType == 'T-Profile')
                <p>{{ __('messages.t_profile') }}</p>
                @elseif($roofType == 'Raingutter')
                <p>{{ __('messages.raingutter') }}</p>
                @endif
        </div>
        @endforeach
    </div>
    @endif

    <div id="roof-details-box" style="display: none; margin-top: 20px;"></div>

    <div class="choose-rental-period">
        <h3>{{ __('messages.choose_rental_period') }}</h3>
        <p>{{ __('messages.add_rental_period_description') }}</p>
        <form class=" email-login">
            <div class="row">
                <div class="col-md-6 inner-main-input">
                    <label for="inputEmail4" class="form-label">{{ __('messages.from') }}</label>
                    <input class="form-control"  id="rental_from">
                </div>
                <div class="col-md-6 inner-main-input">
                    <label for="inputEmail4" class="form-label">{{ __('messages.to') }}</label>
                    <input class="form-control"  id="rental_to">

                    
                </div>
            </div>
        </form>


        
    </div>
    <input type="hidden" name="insurance_selected" id="insurance_selected" value="0">
    <input type="hidden" name="roof_rack_selected" id="roof_rack_selected" value="0">
    
  
    
    <div class="select-main-detail d-flex mt-4">
        <div class="">
             
            @if($product->name == 'Roof Box' || $product->name == 'Roof Bike Carrier'  || $product->name =='Dachbox'  || $product->name =='Dachfahrradträger')
            <div class="form-check mb-1">
                <input class="form-check-input" type="checkbox" id="roof_rack_checkbox" checked>
                <label class="form-check-label" for="gridCheck">
                    {{ __('messages.roof_rack_included') }}
                </label>
            </div>
            @endif
           
            <div class="form-check">
                <input class="form-check-input" type="checkbox"  id="insurance_checkbox" checked>
                <label class="form-check-label" for="gridCheck1">
                    {{ __('messages.insurance_label') }}
                </label>
            </div>
        </div>
    </div>
    <div class="calculated-rent">
        <div class="row align-items-end">
            <div class="col-md-6">
                <h3>{{ __('messages.calculated_rent') }}</h3>

                <p class="text-calc-rent " id="withinsurance">({{ __('messages.calculated_rent_with_insurance') }})
                </p>
                <p class="text-calc-rent d-none" id="withoutinsurance">({{ __('messages.calculated_rent_without_insurance') }})
                </p>
            </div>
            <div class="col-md-6">
                <div class="inner-number-days">
                    <p>{{ __('messages.number_of_days') }}: <span> </span>

                    </p>
                    <p class="mb-0">{{ __('messages.total_rent') }}: <span></span></p>
                </div>
            </div>
        </div>
    </div>
    
    <div id="errorMessage" class=""></div>
    <input type="hidden" id="booking_item_ids" >

    
    <form id="bookingForm" action="{{ route('cart.add') }}" method="POST">
        @csrf
        <input type="hidden" name="product_id" value="{{ $product->id }}" id="product_id">
        <input type="hidden" name="product_name" value="{{$product->name }}" id="product_name">
        <input type="hidden" name="manufacturer" id="hidden_manufacturer">
        <input type="hidden" name="car_year" id="hidden_car_year">
        <input type="hidden" name="model" id="hidden_model">
        <input type="hidden" name="trailer_hitch" id="hidden_trailer_hitch">
        <input type="hidden" name="roof_type" id="hidden_roof_type">
        <input type="hidden" name="color_id" id="hidden_color_id">
        <input type="hidden" name="color_name" id="hidden_color_name">
        <input type="hidden" name="size_id" id="hidden_size_id">
        <input type="hidden" name="size_name" id="hidden_size_name">
        <input type="hidden" name="rental_from" id="hidden_rental_from">
        <input type="hidden" name="rental_to" id="hidden_rental_to">
        <input type="hidden" name="days" id="hidden_days">
        <input type="hidden" name="calculated_rent" id="hidden_calculated_rent">
        <input type="hidden" name="is_carrier_included" id="hidden_is_carrier_included">
        <input type="hidden" name="is_insured" id="hidden_is_insured">
        
        <button type="submit" class="mt-4 w-100 btn primary-btn">{{ __('messages.rent_now') }}</button>
    </form>
    
</div>