@extends('layouts.vendor')
@section('content')
<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="{{route('vendor.payment.index')}}">{{ __('messages.payment_management') }}</a>
            <a class="active" href="">{{ __('messages.payment_details') }}</a>
        </div>
    </div>

    <div class="add-user-form">
        <h2 class="head-mian-all-payment">{{ __('messages.payment_details') }}</h2>
        <div class="main-show-detail-viwe">
            <div class="inner-pack-view">
                <h3>{{ __('messages.user_details') }}:</h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.customer_id') }}</h5>
                        <p>#{{$booking->userDetails->user_id}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.customer_name') }}</h5>
                        <p>{{$booking->userDetails->title." ".$booking->userDetails->first_name." ".$booking->userDetails->last_name}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.street_house_number') }}</h5>
                        <p>{{$booking->userDetails->address}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.zip_code') }}</h5>
                        <p>{{$booking->userDetails->zip}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.city') }}</h5>
                        <p>{{$booking->userDetails->city}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.state_region') }}</h5>
                        <p>{{$booking->userDetails->country}}</p>
                    </div>
                </div>

                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.email_address') }}</h5>
                        <p>{{$booking->userDetails->email}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.phone_number') }}</h5>
                        <p>{{$booking->userDetails->phone }}</p>
                    </div>
                </div>
            </div>

            @foreach($booking->items as $item)
            <div class="inner-pack-view">
                <h3>{{ __('messages.car_details') }}:</h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.brand') }}</h5>
                        <p>{{ explode(' ', $item->car_name)[0] }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.year') }}</h5>
                        <p>{{ $item->car_year }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.model') }}</h5>
                        <p>{{ $item->model }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.trailer_hitch') }}</h5>
                        <p>{{ $item->trailer_hitch ? __('messages.yes') : __('messages.no') }}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.roof_type') }}</h5>
                        <p>{{ $item->roof_type }}</p>
                    </div>
                </div>
            </div>

            <div class="inner-pack-view">
                <h3>{{ __('messages.product_details') }}:</h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.product_id') }}</h5>
                        <p>#{{$item->product_id}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.product_name') }}</h5>
                        <p>{{$item->product_name}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.size_or_variant') }}</h5>
                        <p>{{$item->size}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.color') }}</h5>
                        <p>{{$item->color}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.insurance') }}</h5>
                        <p>{{$item->is_insured ? __('messages.yes') : __('messages.no') }}</p>
                    </div>
                </div>
            </div>
            @endforeach

            <div class="inner-pack-view border-0 mb-0">
                <h3>{{ __('messages.payment_details') }}:</h3>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.subtotal') }}</h5>
                        <p>{{$booking->subtotal}} €</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.tax') }}</h5>
                        <p>{{$booking->tax}} €</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.discount') }}</h5>
                        <p>{{$booking->discount}} €</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.total_amount') }}</h5>
                        <p>{{$booking->total}} €</p>
                    </div>
                </div>
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.payment_method') }}</h5>
                        <p>{{ucfirst($booking->payment_method)}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.payment_status') }}</h5>
                        <p>{{ucfirst($booking->payment_status)}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.booking_date') }}</h5>
                        <p>{{$booking->created_at->format('d-m-Y')}}</p>
                    </div>
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.booking_status') }}</h5>
                        <p>{{ucfirst($booking->status)}}</p>
                    </div>
                </div>
                @if($booking->payment_method == 'stripe')
                <div class="patient-age-name d-flex">
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.stripe_session_id') }}</h5>
                        <p>{{$booking->stripe_session_id}}</p>
                    </div>
                    @if($booking->stripe_payment_intent)
                    <div class="patient-anme-view">
                        <h5>{{ __('messages.stripe_payment_intent') }}</h5>
                        <p>{{$booking->stripe_payment_intent}}</p>
                    </div>
                    @endif
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection