@extends('layouts.vendor')
@section('content')

       <style>
        h2#heading-roof-box {
                padding-right: 30px;
            }

            h2#heading-roof-box a.edit-btn-eye {
                margin-right: 5px;
            }
            h2#heading-roof-box {
    padding-right: 30px;
}

h2#heading-roof-box a.edit-btn-eye {
    margin-right: 5px;
}

.upper-btns-modal-pair button.btn-primary.comn-modal-btns-blue {
    background-color: var(--maincolor);
    color: white;
    border-color: var(--maincolor);
    width: 100%;
    max-width: 25%;
    min-width: 25%;
}

.quantity-info {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.rented-count {
    font-size: 12px;
    color: #e74c3c;
    font-weight: 500;
}

.available-count {
    font-size: 12px;
    color: #27ae60;
    font-weight: 500;
}

.low-stock {
    color: #f39c12;
    font-weight: bold;
}

.out-of-stock {
    color: #e74c3c;
    font-weight: bold;
}
/* =================== */
.dropdowns-inner-list {
    width: 75%;
    flex-wrap: wrap;
    justify-content: flex-end;
}

.dropdowns-inner-list > .dropdowns-inner-list {
    width: 228px;
}

.dropdowns-inner-list > .dropdowns-inner-list input#inputPassword5 {
    width: 100%;
}
.notifi-list {
    align-items: flex-start;
}
       </style>
        
            <div class="col-9 main-dash-left">

                <div class="comm_head_top">
                    <div class="name-head">
                        <h2>@lang('messages.product_analytics')</h2>
                        <div class="d-flex comm_head_top_right">
                          
                            <div class="sownload-cv-pdf">
                                <button class="download-pdf" id="download-pdf">@lang('messages.download_pdf')</button>
                                <button id="download-csv" class="download-pdf">@lang('messages.download_csv')</button>
                               
                                <a class="add-notification-btn" id="addMoreProducts">@lang('messages.add_new_product')</a>
                            </div>
                            <select class="form-select select-main-head" aria-label="Time period filter">
                                <option value="year" {{ request('time_period') == 'year' ? 'selected' : '' }}>@lang('messages.year')</option>
                                <option value="month" {{ request('time_period') == 'month' ? 'selected' : '' }}>@lang('messages.month')</option>
                                <option value="week" {{ request('time_period') == 'week' ? 'selected' : '' }}>@lang('messages.week')</option>
                                <option value="day" {{ request('time_period') == 'day' ? 'selected' : '' }}>@lang('messages.day')</option>
                            </select>
                        </div>
                    </div>

                    <div class="cards-dashboard">
                        <div class="row row-gap-3">
                            <div class="col-lg-3 col-md-6">
                                <div class="inner-dashboard-card back-green">
                                    <div class="ing-sec-acrd-dash">
                                        <figure class="logo-card"><img src="{{asset('admin/images/total.png')}}" alt=""></figure>
                                        <div class="main-card-analy d-flex">
                                            <div class="text-disc-card">
                                                <p>@lang('messages.active_products_categories')</p>
                                                <h4>{{ $totalProducts }}</h4>
                                            </div>
                                            <figure class="img-graph">
                                            <img src="{{asset('admin/images/green-line.png')}}" alt="">
                                            </figure>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6">
                                <div class="inner-dashboard-card back-purple">
                                    <div class="ing-sec-acrd-dash">
                                    <figure class="logo-card"><img src="{{asset('admin/images/return.png')}}" alt="">
                                        </figure>
                                        <div class="main-card-analy d-flex">
                                            <div class="text-disc-card">
                                                <p>@lang('messages.inactive_products')</p>
                                                <h4>{{ $disabledVariants }}</h4>
                                            </div>
                                            
                                            <figure class="img-graph">
                                            <img src="{{asset('admin/images/white-line.png')}}" alt="">
                                            </figure>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6">
                                <div class="inner-dashboard-card back-yellow">
                                    <div class="ing-sec-acrd-dash">
                                    <figure class="logo-card"><img src="{{asset('admin/images/top.png')}}" alt=""></figure>
                                        <div class="main-card-analy d-flex">
                                            <div class="text-disc-card">
                                                <p>@lang('messages.product_categories_available')</p>
                                                <h4>{{ $totalProductCategories }}</h4>
                                            </div>
                                            <figure class="img-graph">
                                            <img src="{{asset('admin/images/orange-line.png')}}" alt="">
                                            </figure>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6">
                                <div class="inner-dashboard-card back-parrot">
                                    <div class="ing-sec-acrd-dash">
                                    <figure class="logo-card"><img src="{{asset('admin/images/lost.png')}}" alt=""></figure>
                                        <div class="main-card-analy d-flex">
                                            <div class="text-disc-card">
                                                <p>@lang('messages.bundle_products')</p>
                                                <h4>{{ $bundleProducts }}</h4>
                                            </div>
                                            <figure class="img-graph">
                                            <img src="{{asset('admin/images/parot-line.png')}}" alt="">
                                            </figure>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>



                    <div class="notifi-list d-flex">
                        <h6>@lang('messages.product_management')</h6>
                        <div class="dropdowns-inner-list d-flex">
                            <div class="dropdowns-inner-list">
                                <div class="icon-search-main white_bg">
                                    <i class="fa-solid fa-magnifying-glass"></i>
                                    <input aria-describedby="passwordHelpBlock"  placeholder="@lang('messages.search_for_products')"
                                        type="text" id="inputPassword5" class="form-control" value="">
                                </div>
                            </div>
                            <div class="filter-main-div">
                                <p class="lable-filt">@lang('messages.filter'):</p>
                                <div class="dropdown">
                                    <button class="filter-btn dropdown-toggle" type="button" id="categoryFilterDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fa-solid fa-filter"></i> @lang('messages.filter')
                                    </button>
                                    <ul class="dropdown-menu" aria-labelledby="categoryFilterDropdown">
                                        <li><a class="dropdown-item filter-category" href="#" data-category="all">@lang('messages.all_categories')</a></li>
                                        @foreach($groupedByCategory as $categoryName => $products)
                                            @php $categoryId = \Illuminate\Support\Str::slug($categoryName); @endphp
                                            <li><a class="dropdown-item filter-category" href="#" data-category="{{ $categoryId }}">{{ $categoryName }}</a></li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                            
                            <button class="download-pdf add-notification-btn" data-bs-toggle="modal" data-bs-target="#uploadCsvModal">@lang('messages.upload_quantity_template')</button>
                            <button class="download-pdf add-notification-btn" data-bs-toggle="modal" data-bs-target="#downloadTemplateModal">@lang('messages.download_quantity_template')</button>
                            <a class="add-notification-btn" id="enableMoreProducts" href="">@lang('messages.enable_product_categories')</a>

                            
                        </div>
                    </div>
                    


                    <div class="accordion product_accordion" id="accordionExample">
                  
                       
                        @foreach($groupedByCategory as $categoryName => $products)
                            @php $categoryId = \Illuminate\Support\Str::slug($categoryName); @endphp
                            @php
                                        $product = $products->first(); 
                                    @endphp
                            <div class="accordion-item">
                                <h2 class="accordion-header aco-head-flex flex-edit-btn" id="heading-{{ $categoryId }}">

                                    <button class="accordion-button comm_heading_20" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse-{{ $categoryId }}" aria-expanded="true"
                                            aria-controls="collapse-{{ $categoryId }}">
                                        {{ $categoryName }}
                                       
                                    </button>
                                    
                                  
                                  
                                    
                                </h2>
                                <div id="collapse-{{ $categoryId }}" class="accordion-collapse collapse show"
                                    aria-labelledby="heading-{{ $categoryId }}" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <div class="notification-table pt-0">
                                            <table class="table">
                                                <thead>
                                                    <tr class="head-class-td">
                                                        <th>@lang('messages.nr')</th>
                                                        <th>@lang('messages.sku')</th>
                                                        <th>@lang('messages.product_name')</th>
                                                        <th>@lang('messages.size_variation')</th>
                                                        <th>@lang('messages.color')</th>
                                                        <th>@lang('messages.total_quantity')</th>
                                                        <th>@lang('messages.remaining_quantity')</th>
                                                        <th>@lang('messages.dimensions')</th>
                                                        <th>@lang('messages.weight')</th>
                                                        <th>@lang('messages.volume')</th>
                                                        <th>@lang('messages.action')</th>
                                                        <th>@lang('messages.status')</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($products as $product)
                                                    <?php $i= 1; ?>
                                                    @php $i = 1; @endphp

                                                        @if($product->variations->isEmpty())
                                                            <tr>
                                                                <td>{{ $i++ }}</td>
                                                                <td>{{ $product->sku ?? '-' }}</td>
                                                                <td>{{ $product->name }}</td>
                                                                <td>-</td>
                                                                <td>{{ $product->color->name ?? '-' }}</td>
                                                                {{-- <td>{{ $product->quantity ?? '-' }}</td> --}}

                                                                {{-- <td>
                                                                    <div class="quantity-info">
                                                                        <span>{{ $product->quantity ?? 0 }}</span>
                                                                        @if(isset($rentedCounts['product'][$product->id]))
                                                                        <span class="rented-count">Rented: {{ $rentedCounts['product'][$product->id] }}</span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <div class="quantity-info">
                                                                        <span @class([
                                                                            'low-stock' => $product->total_quantity > 0 && $product->total_quantity <= 2,
                                                                            'out-of-stock' => $product->total_quantity <= 0
                                                                        ])>
                                                                            {{ $product->total_quantity ?? 0 }}
                                                                        </span>
                                                                        
                                                                    </div>
                                                                </td> --}}
                                                                <td>N/A</td>
                                                                <td>N/A</td>


                                                                <td>{{ $product->length }} x {{ $product->width }} x {{ $product->height }}</td>
                                                                <td>{{ $product->weight ?? '—' }}</td>
                                                                <td>{{ $product->volume ?? '—' }}</td>
                                                                <td>
                                                                    <div class="upper-delete-btns d-flex">
                                                                        <a class="view-btn-eye" href="{{ route('admin.products.show', $product->id) }}">
                                                                            <i class="fa-solid fa-eye"></i>
                                                                        </a>
                                                                        {{-- <a href="javascript:void(0);" class="edit-btn-eye openEditModal" data-option-id="{{ $option->id }}" data-current-quantity = "{{$product->quantity}}">
                                                                            <i class="fa-solid fa-pen-to-square"></i>
                                                                        </a> --}}
                                                                        
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <label class="switch custm_toggle_switch">
                                                                        <input type="checkbox" class="variant-status-toggle"
                                                                            data-type="product"
                                                                            data-variant-id="{{ $product->id }}"
                                                                            {{ $product->status === 'in_stock' ? 'checked' : '' }}>
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                </td>
                                                            </tr>
                                                            @else
                                                            @foreach($product->variations as $variation)
                                                                @php $firstRow = true; @endphp
                                                                @if(!$variation->options->isEmpty())
                                                                @foreach($variation->options as $option)
                                                                    <tr>
                                                                        <td>{{ $i++ }}</td>
                                                                        <td>{{ $option->sku }}</td>
                                                                        <td>{{ $product->name }}</td>
                                                                        <td>{{ $variation->size->name ?? $variation->variation->name ?? '-' }}</td>
                                                                        <td>{{ $option->color->name ?? '-' }}</td>
                                                                        {{-- <td>{{ $option->quantity }}</td> --}}

                                                                        <td>
                                                                            <div class="quantity-info">
                                                                                <span>{{ $option->quantity ?? 0 }}</span>
                                                                                @if(isset($rentedCounts['option'][$option->id]))
                                                                                <span class="rented-count">@lang('messages.rented'): {{ $rentedCounts['option'][$option->id] }}</span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="quantity-info">
                                                                                <span @class([
                                                                                    'low-stock' => $option->total_quantity > 0 && $option->total_quantity <= 2,
                                                                                    'out-of-stock' => $option->total_quantity <= 0
                                                                                ])>
                                                                                    {{ $option->total_quantity ?? $option->quantity }}
                                                                                </span>
                                                                               
                                                                            </div>
                                                                        </td>


                                                                        <td>{{ $variation->length }} x {{ $variation->width }} x {{ $variation->height }}</td>
                                                                        <td>{{ $variation->weight ?? '—' }}</td>
                                                                        <td>{{ $variation->volume ?? '—' }}</td>
                                                                        <td>
                                                                            <div class="upper-delete-btns d-flex">
                                                                                
                                                                                <a class="view-btn-eye" href="{{ route('vendor.products.variant.show', ['product' => $product->id, 'variant' => $variation->id, 'option' => $option->id ?? null]) }}">
                                                                                    <i class="fa-solid fa-eye"></i>
                                                                                </a>
                                                                                <a href="javascript:void(0);" class="edit-btn-eye openEditModal" data-option-id="{{ $option->id }}" data-current-quantity = "{{$option->quantity}}">
                                                                                    <i class="fa-solid fa-pen-to-square"></i>
                                                                                </a>
                                                                               
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            @if($firstRow)
                                                                                <label class="switch custm_toggle_switch">
                                                                                    <input type="checkbox" class="variant-status-toggle"
                                                                                         data-type="variant"
                                                                                        data-variant-id="{{ $variation->id }}"
                                                                                        {{ $variation->status === 'in_stock' ? 'checked' : '' }}>
                                                                                    <span class="slider round"></span>
                                                                                </label>
                                                                                @php $firstRow = false; @endphp
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                @endforeach
                                                                @else
                                                                    <tr>
                                                                        <td>{{ $i++ }}</td>
                                                                        <td>{{ $variation->sku ?? '-' }}</td>
                                                                        <td>{{ $product->name }}</td>
                                                                        <td>{{ $variation->size->name ?? $variation->variation->name ?? '-' }}</td>
                                                                        <td>{{ $variation->color->name ?? '-' }}</td>
                                                                        {{-- <td>{{ $variation->quantity }}</td> --}}

                                                                        <td>
                                                                            <div class="quantity-info">
                                                                                <span>{{ $variation->quantity ?? 0 }}</span>
                                                                                @if(isset($rentedCounts['variation'][$variation->id]))
                                                                                <span class="rented-count">@lang('messages.rented'): {{ $rentedCounts['variation'][$variation->id] }}</span>
                                                                                @endif
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="quantity-info">
                                                                                <span @class([
                                                                                    'low-stock' => $variation->total_quantity > 0 && $variation->total_quantity <= 2,
                                                                                    'out-of-stock' => $variation->total_quantity <= 0
                                                                                ])>
                                                                                    {{ $variation->total_quantity ?? $variation->quantity }}
                                                                                </span>
                                                                                @if(isset($rentedCounts['variation'][$variation->id]))
                                                                                <span class="available-count">
                                                                                    @lang('messages.available'): {{ $variation->quantity - $rentedCounts['variation'][$variation->id] }}
                                                                                </span>
                                                                                @endif
                                                                            </div>
                                                                        </td>

                                                                        
                                                                        <td>{{ $variation->length }} x {{ $variation->width }} x {{ $variation->height }}</td>
                                                                        <td>{{ $variation->weight ?? '—' }}</td>
                                                                        <td>{{ $variation->volume ?? '—' }}</td>
                                                                        <td>
                                                                            <div class="upper-delete-btns d-flex">
                                                                                
                                                                                <a class="view-btn-eye" href="{{ route('vendor.products.variant.show', ['product' => $product->id, 'variant' => $variation->id, 'option' => null]) }}">
                                                                                    <i class="fa-solid fa-eye"></i>
                                                                                </a>
                                                                                <a href="javascript:void(0);" class="edit-btn-eye openEditModal" data-option-id="{{ $option->id }}" data-current-quantity = "{{$variation->quantity}}">
                                                                                    <i class="fa-solid fa-pen-to-square"></i>
                                                                                </a>
                                                                               
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            @if($firstRow)
                                                                                <label class="switch custm_toggle_switch">
                                                                                    <input type="checkbox" class="variant-status-toggle"
                                                                                         data-type="variant"
                                                                                        data-variant-id="{{ $variation->id }}"
                                                                                        {{ $variation->status === 'in_stock' ? 'checked' : '' }}>
                                                                                    <span class="slider round"></span>
                                                                                </label>
                                                                                @php $firstRow = false; @endphp
                                                                            @endif
                                                                        </td>


                                                                    </tr>


                                                                @endif
                                                            @endforeach
                                                        @endif
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                   

                       
                    </div>


                </div>


            </div>

        </div>

    </div>


    <div class="modal fade" id="downloadTemplateModal" tabindex="-1" aria-labelledby="downloadTemplateModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="downloadTemplateModalLabel">@lang('messages.download_csv_template')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>@lang('messages.template_instructions')</p>
                    <p>@lang('messages.template_attention')</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="cancel-btn" data-bs-dismiss="modal">@lang('messages.cancel')</button>
                    <a href="{{ route('vendor.products.quantity.template') }}" class="add-user">@lang('messages.download_csv_template')</a>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Upload CSV Modal -->
    <div class="modal fade" id="uploadCsvModal" tabindex="-1" aria-labelledby="uploadCsvModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="uploadCsvModalLabel">@lang('messages.upload_csv_modal_title')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('vendor.products.quantity.import') }}" method="POST" enctype="multipart/form-data" id="quantityUploadForm">
                    @csrf
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="quantityCsvFile" class="form-label">@lang('messages.select_csv_file_label')</label>

                            <input class="form-control" type="file" id="quantityCsvFile" name="csv_file" accept=".csv" required>
                            <div class="form-text">@lang('messages.csv_file_format')</div>
                        </div>
                        <div class="progress mb-3" style="display: none;" id="uploadProgress">
                            <div class="progress-bar" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">0%</div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="cancel-btn" data-bs-dismiss="modal">@lang('messages.cancel')</button>
                        <button type="submit" class="add-user" id="uploadCsvBtn">@lang('messages.upload_button')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    

    <div class="modal fade modal-delete-logout" id="deleteProductModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="p-0 modal-body">
                    <div class="inner-body-delete-logout">
                        <h4 id="delete-text" class="mb-3"></h4>
                        <p id="delete-description" class=" mb-0"></p>
                        <div class="upper-btns-modal-pair">
                            <button type="button" id="cancelToggle" data-bs-dismiss="modal" class="comn-modal-btns-transparent cancel-btn">@lang('messages.toggle_modal_confirm_no')</button>
                            <button type="button" id="confirmToggle" class="comn-modal-btns-blue add-user">@lang('messages.toggle_modal_confirm_yes')</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade vendor-product" id="enableProductsModal" tabindex="-1" aria-labelledby="enableProductsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="enableProductsModalLabel">@lang('messages.enable_products_modal_title')</h4>
                    <h6>@lang('messages.enable_products_modal_subtitle')</h6>
                    <p>@lang('messages.enable_products_modal_description')</p>
                    <!-- <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button> -->
                </div>
                <div class="modal-body">
                    <div class="container">
                        <form id="enableProductsForm" method="POST" action="{{ route('vendor.products.saveUpdatedProducts') }}">
                            @csrf
                            <div class="row pro-div" id="productsContainer">
                            </div>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="cancel-btn" data-bs-dismiss="modal">@lang('messages.enable_products_discard_button')</button>
                    <button type="button" id="saveProductsBtn" class="add-user">@lang('messages.enable_products_save_button')</button>
                </div>

                
            </div>
        </div>
    </div>
    <div class="modal fade modal-delete-logout" id="editQuantityModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="editQuantityModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form method="POST" action="{{ route('vendor.update.quantity') }}">
                    @csrf
                    <input type="hidden" name="option_id" id="editOptionId">
                    <div class="modal-body">
                        <div class="inner-body-delete-logout">
                            <h4 class="mb-3" id="editQuantityTitle">@lang('messages.edit_quantity_modal_title')</h4>
                            <p>@lang('messages.edit_quantity_modal_description')</p>
                            <div class="form-group mb-3">
                                <label for="editQuantity">@lang('messages.edit_quantity_label')</label>
                                <input type="number" class="form-control" id="editQuantity" name="quantity" min="0" required>
                            </div>
                            <div class="upper-btns-modal-pair">
                                <button type="submit" class="comn-modal-btns-transparent add-user">@lang('messages.edit_quantity_add_button')</button>
                                <button type="button" class="comn-modal-btns-transparent cancel-btn" data-bs-dismiss="modal">@lang('messages.edit_quantity_discard_button')</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade modal-delete-logout" id="addProductModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="addProductModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form method="POST" id="add_product" action="{{ route('vendor.add.product') }}">
                    @csrf
                    <div class="modal-body">
                        <div class="inner-body-delete-logout">
                            <h4 class="mb-3">@lang('messages.add_product_modal_title')</h4>
                            <p>@lang('messages.add_product_modal_description')</p>
                            <div class="form-group mb-3">
                                <label for="productName">@lang('messages.add_product_name_label')</label>
                                <input type="text" class="form-control" id="productName" name="productName"  required>
                            </div>
                            <div class="form-group mb-3">
                                <label for="productReq">@lang('messages.add_product_reason_label')</label>
                                <textarea class="form-control" id="productReq" name="productReq" required></textarea>
                            </div>
                            <div class="upper-btns-modal-pair">
                                <button type="button" class="comn-modal-btns-transparent cancel-btn" data-bs-dismiss="modal">@lang('messages.add_product_cancel_button')</button>
                                <button type="submit" class="comn-modal-btns-blue add-user">@lang('messages.add_product_send_button')</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script>
     var baseUrl = "{{ rtrim(config('app.url'), '/') }}";
     document.addEventListener('DOMContentLoaded', function () {
    let pendingToggle = null;

    document.getElementById('enableMoreProducts').addEventListener('click', function(e) {
        e.preventDefault();
        loadProductsForModal();
    });

 function loadProductsForModal() {
    fetch('{{ route("vendor.products.getAvailable") }}')
        .then(response => response.json())
        .then(data => {
            const container = document.getElementById('productsContainer');
            container.innerHTML = '';

            data.products.forEach(product => {
                const productDiv = document.createElement('div');
                productDiv.className = '';
                productDiv.innerHTML = `
                    <div class="card pro-item h-100 product-card" style="position: relative;" data-id="${product.id}">
                        <img src="${product.image}" class="card-img-top" alt="${product.name}">
                        <div class="content">
                            <a href="#" class="btn rent-btn">
                                <input 
                                    type="checkbox" 
                                    name="product_ids[]" 
                                    value="${product.id}" 
                                    id="product_${product.id}"
                                    ${product.selected ? 'checked' : ''} 
                                />
                                <p class="p-18">${product.name}</p>
                            </a>
                        </div>
                    </div>
                `;
                container.appendChild(productDiv);
            });

            // Make each card clickable to toggle the checkbox
            document.querySelectorAll('.product-card').forEach(card => {
                card.addEventListener('click', function (e) {
                    const checkbox = this.querySelector('input[type="checkbox"]');
                    if (e.target !== checkbox) {
                        checkbox.checked = !checkbox.checked;
                    }
                });

                // Prevent double toggle if clicking directly on the checkbox
                const checkbox = card.querySelector('input[type="checkbox"]');
                checkbox.addEventListener('click', e => e.stopPropagation());
            });

            // Show the modal
            const modal = new bootstrap.Modal(document.getElementById('enableProductsModal'));
            modal.show();
        })
        .catch(error => {
            console.error('Error:', error);
        });
}


        document.getElementById('saveProductsBtn').addEventListener('click', function() {
            const form = document.getElementById('enableProductsForm');

            const checkboxes = form.querySelectorAll('input[type="checkbox"]');
    
            const selectedProducts = Array.from(checkboxes)
                .filter(cb => cb.checked)
                .map(cb => cb.nextElementSibling.textContent.trim().toLowerCase());

            // Define dependencies
            const dependencies = {
                'dachträger': ['traverse' ,'fuß' ,'fußkit'],
                'dachbox' : [ 'traverse' ,'fuß' ,'fußkit' ,'dachträger'],
                'dachfahrradträger' : [ 'traverse' ,'fuß' ,'fußkit' , 'dachträger'],
            };
            let errorMessages = [];

            console.log(dependencies,selectedProducts);
            Object.keys(dependencies).forEach(product => {
                if (selectedProducts.includes(product)) {
                    const required = dependencies[product];
                    const missing = required.filter(r => !selectedProducts.includes(r));

                    if (missing.length > 0) {
                        // Capitalize first letter of each missing product
                        const missingCapitalized = missing.map(name => name.charAt(0).toUpperCase() + name.slice(1));
                        const productCapitalized = product.charAt(0).toUpperCase() + product.slice(1);

                        errorMessages.push(`You must also select: ${missingCapitalized.join(', ')} when ${productCapitalized} is selected.`);
                    }
                }
            });
            console.log(errorMessages);
            if (errorMessages.length > 0) {
                Swal.fire({
                    title: '@lang("messages.selection_error")',
                    html: '@lang("messages.error_dependency_required")',
                    icon: 'error',
                    confirmButtonText: 'OK',
                    customClass: {
                        popup: 'swal-wide',
                        title: 'swal-title-big',
                        confirmButton: 'swal-btn-big'
                    }
                });
                return;
            }

            
            const formData = new FormData(form);

            fetch(form.action, {
                method: 'POST',
                body: formData,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        title: 'Erfolgreich!',
                        text: '@lang('messages.success_products_updated')',
                        icon: 'success',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        const modal = bootstrap.Modal.getInstance(document.getElementById('enableProductsModal'));
                        modal.hide();
                        window.location.reload();
                    });
                } else {
                    Swal.fire({
                        title: 'Error!',
                        text: data.message || '@lang('messages.error_something_wrong')',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    title: 'Error!',
                    text: '@lang('messages.error_failed_update_products')',
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            });
        });

    document.querySelectorAll('.variant-status-toggle').forEach(function (toggle) {
        toggle.addEventListener('change', function (e) {
            e.preventDefault(); 
            const checkbox = this;

            checkbox.checked = !checkbox.checked;

            const id = checkbox.dataset.variantId;
            const type = checkbox.dataset.type;
            const isEnabling = !checkbox.checked;
            const status = isEnabling ? 'in_stock' : 'out_of_stock';
            const productName = checkbox.closest('tr').querySelector('td:nth-child(3)')?.textContent?.trim() || 'Product';
            const colorName = checkbox.closest('tr').querySelector('td:nth-child(4)')?.textContent?.trim() || 'SKU';

            pendingToggle = { checkbox, id, type, status };

            const heading = isEnabling
            ? `@lang('messages.enable_product_confirm', ['product_name' => '${productName}', 'color_name' => '${colorName}'])`
            : `@lang('messages.disable_product_confirm', ['product_name' => '${productName}', 'color_name' => '${colorName}'])`;

            const description = isEnabling
                ? `@lang('messages.enable_product_description')`
                : `@lang('messages.disable_product_description')`;

            document.getElementById('delete-text').textContent = heading;
            document.getElementById('delete-description').textContent = description;

            const modal = new bootstrap.Modal(document.getElementById('deleteProductModal'));
            modal.show();
        });
    });

    document.getElementById('confirmToggle').addEventListener('click', function () {
        if (!pendingToggle) return;

        const { checkbox, id, type, status } = pendingToggle;

        fetch(`${baseUrl}/vendor/${type}/${id}/status`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ status })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                checkbox.checked = (status === 'in_stock');
                location.reload();
            } else {
                alert('Failed to update status');
            }
        })
        .catch(() => {
            alert('Something went wrong');
        })
        .finally(() => {
            pendingToggle = null;
            const modalEl = bootstrap.Modal.getInstance(document.getElementById('deleteProductModal'));
            modalEl?.hide();
        });
    });

    document.getElementById('cancelToggle').addEventListener('click', function () {
        pendingToggle = null;
    });
});

</script>

<script>



    document.addEventListener('DOMContentLoaded', function () {
        let activeCategory = 'all';
        let activeSearch = '';
    
        const categoryFilterItems = document.querySelectorAll('.filter-category');
        const dropdownButton = document.querySelector('#categoryFilterDropdown');
        const searchInput = document.getElementById('inputPassword5');
    
        categoryFilterItems.forEach(item => {
            item.addEventListener('click', function (e) {
                e.preventDefault();
    
                categoryFilterItems.forEach(el => el.classList.remove('active'));
                this.classList.add('active');
    
                activeCategory = this.dataset.category;
    
                dropdownButton.innerHTML = `<i class="fa-solid fa-filter"></i> ${this.textContent.trim()}`;
    
                filterProducts();
            });
        });
    
        searchInput.addEventListener('input', function () {
            activeSearch = this.value.trim().toLowerCase();
            filterProducts();
        });
    
        function filterProducts() {
            document.querySelectorAll('.accordion-item').forEach(accordionItem => {
                const headingBtn = accordionItem.querySelector('.accordion-button');
                if (!headingBtn) return;

                const categoryId = headingBtn.dataset.bsTarget.replace('#collapse-', '');
                const matchCategory = activeCategory === 'all' || activeCategory === categoryId;
                let hasVisibleRow = false;

                accordionItem.querySelectorAll('tbody tr').forEach(row => {
                    const rowText = row.textContent.toLowerCase();
                    const matchSearch = activeSearch === '' || rowText.includes(activeSearch);
                    const showRow = matchCategory && matchSearch;

                    row.style.display = showRow ? '' : 'none';
                    if (showRow) hasVisibleRow = true;
                });

                accordionItem.style.display = hasVisibleRow ? '' : 'none';

                const collapse = accordionItem.querySelector('.accordion-collapse');
                if (collapse) {
                    if (hasVisibleRow) {
                        collapse.classList.add('show');
                    } else {
                        collapse.classList.remove('show');
                    }
                }
            });
            // updateDownloadLinks();
        }



        filterProducts();


        const timePeriodSelect = document.querySelector('.select-main-head');
        if (timePeriodSelect) {
            timePeriodSelect.addEventListener('change', function() {
                // updateDownloadLinks();
                const timePeriod = this.value;
                window.location.href = `${window.location.pathname}?time_period=${timePeriod}`;
            });
        }

        document.getElementById('download-pdf')?.addEventListener('click', function() {
            window.location.href = "{{ route('vendor.products.download.pdf') }}";
        });

        document.getElementById('download-csv')?.addEventListener('click', function() {
            window.location.href = "{{ route('vendor.products.download.csv') }}";
        });


        document.getElementById('download-template')?.addEventListener('click', function() {
            window.location.href = "{{ route('admin.products.export.template') }}";
        });

        document.getElementById('download-csv-new')?.addEventListener('click', function() {
            window.location.href = "{{ route('admin.products.export.full') }}";
        });
        // updateDownloadLinks();
    });
    </script>

    <script>
        // $(document).on('click', '.openEditModal', function () {
        //     const optionId = $(this).data('option-id');
        //     const currentQty = $(this).data('current-quantity');
        
        //     $('#editOptionId').val(optionId);
        //     $('#editQuantity').val(currentQty);
        //     $('#editQuantityModal').modal('show');
        // });
        $(document).on('click', '.openEditModal', function () {
            const optionId = $(this).data('option-id');
            const currentQty = $(this).data('current-quantity');
            
            const row = $(this).closest('tr');
            const productName = row.find('td:nth-child(3)').text().trim();
            const sizeVariation = row.find('td:nth-child(4)').text().trim();
            const color = row.find('td:nth-child(5)').text().trim();
            
            // Build the descriptive text
            let description = `${productName}`;
            if (sizeVariation && sizeVariation !== '-') {
                description += ` (${sizeVariation}`;
                if (color && color !== '-') {
                    description += ` ${color}`;
                }
                description += ')';
            } else if (color && color !== '-') {
                description += ` (${color})`;
            }
            
            $('#editOptionId').val(optionId);
            $('#editQuantity').val(currentQty);
            
            // Update the modal heading with descriptive text
            const specificTitle = `@lang('messages.edit_quantity_specific_title', ['product_description' => '${description}'])`;
            $('#editQuantityTitle').text(specificTitle);            
            $('#editQuantityModal').modal('show');
        });

        $(document).on('click', '#addMoreProducts', function () {

            $('#addProductModal').modal('show');
        });
    </script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const uploadForm = document.getElementById('quantityUploadForm');
        const uploadProgress = document.getElementById('uploadProgress');
        const progressBar = uploadProgress.querySelector('.progress-bar');
        const uploadBtn = document.getElementById('uploadCsvBtn');
        
        uploadForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            uploadBtn.disabled = true;
            uploadProgress.style.display = 'block';
            
            const formData = new FormData(uploadForm);
            
            // Using AJAX to submit the form with progress tracking
            const xhr = new XMLHttpRequest();
            
            xhr.upload.addEventListener('progress', function(e) {
                if (e.lengthComputable) {
                    const percentComplete = (e.loaded / e.total) * 100;
                    progressBar.style.width = percentComplete + '%';
                    progressBar.setAttribute('aria-valuenow', percentComplete);
                    progressBar.textContent = Math.round(percentComplete) + '%';
                }
            });
            
            xhr.addEventListener('load', function() {
                if (xhr.status === 200) {
                    const response = JSON.parse(xhr.responseText);
                    if (response.success) {
                        Swal.fire({
                            title: 'Erfolgreich!',
                            text: response.message || 'Quantities updated successfully!',
                            icon: 'success',
                            confirmButtonText: 'OK'
                        }).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire({
                            title: 'Error!',
                            text: response.message || 'Something went wrong during upload.',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    }
                } else {
                    Swal.fire({
                        title: 'Error!',
                        text: 'Upload failed. Please try again.',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                }
                
                uploadBtn.disabled = false;
                uploadProgress.style.display = 'none';
            });
            
            xhr.open('POST', uploadForm.action, true);
            xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
            xhr.send(formData);
        });
    });
    </script>
    
    
    

    @endsection
    