@extends('layouts.vendor')
@section('content')
<div id="sidebar"></div>
<div class="col-9 main-dash-left">

    <div class="d-flex main-div-upper-flex-custm mb-4">
        <div class="wd-large">
            <div class="add-user-form view-product">
                <h3 class="uppr_heading">@lang('messages.view_product_details')</h3>
                <div class="main-show-detail-viwe">
                    <div class="upper-section-detail pb-0">
                        <div class="patient-age-name d-flex border_bottom pb-0 border-0">
                            <div class="patient-anme-view">
                                <h5>@lang('messages.product_id')</h5>
                                <p>{{ $product->id }}</p>
                            </div>
                            <div class="patient-anme-view">
                                <h5>@lang('messages.product_sku')</h5>
                                <p>{{ $mainOption->sku ?? 'N/A' }}</p>
                            </div>
                            <div class="patient-anme-view">
                                <h5>@lang('messages.product_category')</h5>
                                <p>{{ $product->category->name ?? 'N/A' }}</p>
                            </div>
                            <div class="patient-anme-view">
                                <h5>@lang('messages.product_name')</h5>
                                <p>{{ $product->name ?? 'N/A' }}</p>
                            </div>
                            <div class="patient-anme-view">
                                <h5>@lang('messages.product_brand')</h5>
                                <p>{{ $product->brand->name ?? 'N/A' }}</p>
                            </div>

                        </div>
                        <div class="patient-age-name d-flex">
                            <div class="patient-anme-view">
                                <h5>@lang('messages.description')</h5>
                                <p>{{ $product->description ?? 'N/A'}}</p>
                            </div>

                        </div>

                        <div class="patient-age-name d-flex border_bottom pb-0 border-0">
                            <div class="patient-anme-view">
                                <h5>@lang('messages.size')</h5>
                                <p>{{ $variant->size->name ?? $variant->variation->name ?? 'N/A' }}</p>
                            </div>
                            <div class="patient-anme-view">
                                <h5>@lang('messages.color')</h5>
                                <p>{{ $mainOption->color->name ?? 'N/A' }}</p>
                            </div>
                            <div class="patient-anme-view">
                                <h5>@lang('messages.quantity')</h5>
                                <p>{{ $mainOption->quantity ?? 'N/A' }}</p>
                            </div>
                            @php
                                $isDisabled = $vendor->disabledVariants->contains($variant->id) || $variant->status != 'in_stock';
                            @endphp
                            <div class="patient-anme-view">
                                <h5>@lang('messages.status')</h5>
                                <p>{{ $isDisabled ? __('messages.out_of_stock') : __('messages.in_stock') }}</p>
                            </div>
                        </div>

                        <div class="product_dt_inner_wrap">
                             <div class="upper-main-btn-last-comn d-flex marg-t mb-0">
                                <button data-bs-toggle="modal" data-bs-target="#exampleModal" class="add-user">@lang('messages.price_breakdown')
                                </button>

                            </div>
                        </div>

                    </div>
                    
                </div>
            </div>
        </div>
        <div class="wd-short">
                        <div class="add-user-form view-product">

                            <div class="related-product-view-product pt-0">
                                <h3 class="heading">@lang('messages.product_main_photo')</h3>
                                <div class="product-main-img">
                                <figure>
                                    @if($product->images->where('type', 'main')->first())
                                        <img src="{{ asset('storage/'.$product->images->where('type', 'main')->first()->image_path) }}" 
                                            alt="{{ $product->name }}">
                                    @else
                                        <img src="{{ asset('admin/images/default-product.png') }}" 
                                            alt="Default product image">
                                    @endif
                                </figure>
                                </div>
                            </div>

                            <div class="related-product-view-product">
                                <h3 class="heading">@lang('messages.product_photos')</h3>
                                <div class="product-img-name view-pro d-flex mb-0">
                                    @foreach($product->images->where('type', 'gallery') as $image)
                                        <div class="prod-one">
                                            <div class="images-first">
                                                <figure>
                                                    <img src="{{ asset('storage/'.$image->image_path) }}" 
                                                        alt="Gallery image">
                                                </figure>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <div class="related-product-view-product ">
                                <h3 class="heading">@lang('messages.information_photo')</h3>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="inform-main-img">
                                        <figure>
                                            @if($product->images->where('type', 'info')->first())
                                                <img src="{{ asset('storage/'.$product->images->where('type', 'info')->first()->image_path) }}" 
                                                    alt="Information image">
                                            @else
                                                <img src="{{ asset('admin/images/default-info.png') }}" 
                                                    alt="Information image">
                                            @endif
                                        </figure>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
</div>
                    <div class="add-user-form view-product mb-4">
                        <h3 class="uppr_heading">@lang('messages.additional_information')</h3>
                        <div class="main-show-detail-viwe">
                    <div class="upper-section-detail border_bottom main-prod-view-line-marg-padd">
                        <p class="avail-mod">@lang('messages.available_models')</p>
                            
                            @foreach ($product->models as $index => $model)
                                <div class="additional-info-view">
                                    <h6>{{ $index + 1 }}. {{ $model->title }}</h6>
                                    <p>{{ $model->description }}</p>
                                </div>
                            @endforeach

                        </div>
                        <div class="patient-age-name d-flex mb-0">
                        <div class="patient-anme-view">
                            <h5>@lang('messages.dimensions')</h5>
                            <p>{{ $variant->length }} * {{ $variant->width }} * {{ $variant->height }}</p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>@lang('messages.product_weight')</h5>
                            <p>{{ $variant->weight ?? 'N/A' }}Kg</p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>@lang('messages.max_load')</h5>
                            <p>{{ $variant->max_load ?? 'N/A' }}Kg</p>
                        </div>
                        <div class="patient-anme-view">
                            <h5>@lang('messages.volume')</h5>
                            <p>{{ $variant->volume ?? 'N/A' }}L</p>
                        </div>
                    </div>
                    </div>
                </div>


        <div class="d-flex main-div-upper-flex-custm mb-4 keywords-h">
                            <div class="wd-large">
                                <div class="add-user-form view-product">
                                   
                                    
                                    <h3 class="key-word-head-comn">@lang('messages.related_product')</h3>

                                    <div class="product-img-name keys-pro d-flex">
                                        @forelse ($relatedProducts as $relatedProduct)
                                            @php
                                                $mainPhoto = $relatedProduct->homePhoto->image_path ?? null;
                                            @endphp
                                            <div class="prod-one">
                                                <div class="images-first">
                                                    <figure>
                                                        <img src="{{ $mainPhoto ? asset('storage/' . $mainPhoto) : asset('assets/images/placeholder.png') }}" 
                                                             alt="{{ $relatedProduct->name }}">
                                                    </figure>
                                                </div>
                                                <h6>{{ $relatedProduct->name }}</h6>
                                            </div>
                                        @empty
                                        <p>@lang('messages.no_related_products')</p>
                                        @endforelse
                                    </div>
                                </div>

                            </div>
                            <div class="wd-short">
                                <div class="add-user-form view-product">
                                    <h3 class="key-word-head-comn">@lang('messages.other_information')</h3>
                                    <div class="list-othe-info">
                                        <ul>
                                            @foreach ($product->otherInfo as $info)
                                                <li>
                                                    <img src="{{ asset('storage/' . $info->image_path) }}" alt="">
                                                    <p>{{ $info->description }}</p>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            </div>

                        </div>


            <!-- Edit/Delete buttons -->
            {{-- <div class="upper-main-btn-last-comn d-flex">
                <a href="{{ route('admin.products.edit', $product->id) }}" class="add-user">Edit Product</a>
                <form method="POST" action="{{ route('admin.products.destroy', $product->id) }}">
                    @csrf @method('DELETE')
                    <button type="submit" class="delete-cancel-btn" 
                            onclick="return confirm('Are you sure you want to delete this product?')">
                        Delete
                    </button>
                </form>
            </div> --}}

            <div class="upper-main-btn-last-comn d-flex">
               
                <a href="{{ route('vendor.products') }}" class="cancel-btn">
                    @lang('messages.back_to_list')
                </a>
            </div>
          
        </div>


<!-- Modal -->
<div class="modal fade price-detail-modal" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header border-0">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
      <div class="add-user-form price-break-d border-0">
        <h3 class="modal-detail-head">@lang('messages.price_breakdown')</h3>
        <div class="main-show-detail-viwe view_pricing_detail_wrap">

                    @foreach ($productPrice->weekDays() as $wkIndex => $weeklyPrice)
            
                    <h3>@lang('messages.total_week') {{ $wkIndex+1 }} (W{{ $wkIndex+1 }})</h3>
                    <div class="patient-age-name d-flex">
                    @foreach ($weeklyPrice as $kp => $wprice)
                
                        <div class="patient-anme-view">
                            <h5>@lang('messages.day') {{ $kp+1 }}</h5>
                            <p>{{$wprice}}</p>
                        </div>

                    @endforeach
                </div>
                    @endforeach
                </div>
        
            </div>
      </div>
      
    </div>
  </div>
</div>
        
@endsection