<style>
    @import url('https://fonts.googleapis.com/css2?family=Sora:wght@100..800&display=swap');
    
    :root {
        --font-secondary: "Montserrat", serif;
        --font-primary: "Oswald", serif;
        --black: #000;
        --secondary-black: #111;
        --white: #fff;
        --text: #666;
        --primary-color: #5BC0DE;
        --secondary-color: #2DA5F3;
        ---yellow: #FFCE31;
        --black-secondary: #141414;
    }
    .primary-btn {
        background: var(--primary-color);
        color: var(--white);
        
        padding: 1.3rem 3.7rem;
        border-radius: 0.4rem;
        text-decoration: none;
        border: 0.1rem solid var(--primary-color);
        text-transform: uppercase;
        font-family: Sora !important;
    font-weight: 600;
    font-size: 16px;
    line-height: 100%;
    text-transform: capitalize;
    min-width: 269px;
    
    }
    .container-fluid {
        padding-right: 12px;
        padding-left: 12px;
            margin: 0 auto;
    }
    
    .container {
        width: 100%;
        max-width: 1432px;
        padding: 0 15px;
        margin: 0 auto;
    }
    
    * {
        box-sizing: border-box;
    }
    
    *:focus-visible,
    *:focus {
        outline: none !important;
    }
    
    html {
        font-size: 62.5%;
    }
    
    .row {
        --bs-gutter-x: 2.4rem !important;
    }
    
    .row.g-0 {
        --bs-gutter-x: 0 !important;
    }
    
    body {
        margin: 0;
        padding: 0;
        font-size: 1.6rem;
        line-height: 2.4rem;
    }
    
    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {
        margin: 0;
        line-height: 1.22;
        font-family: "Oswald", serif !important;
    }
    
    p {
        margin: 0;
        font-family: var(--font-secondary);
        font-size: 1.6rem;
        line-height: 2.4rem;
    }
    
    ul,
    ol,
    li {
        margin: 0;
        padding: 0;
        list-style: none;
    }
    
    
    ul {
        margin-left: 0 !important;
    }
    
    a {
        text-decoration: none !important;
        transition: all 0.4s ease-in-out;
    }
    
    .btn:focus {
        box-shadow: none !important;
    }
    
    a:hover {
        text-decoration: none;
        transition: all 0.4s ease-in-out;
    }
    
    .vendor-product {
        padding: 106px 0;
    }
    
    .vendor-product .cont-wrap {
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        gap: 10px;
    }
    
    .vendor-product .cont-wrap h2.our-prod-main {
        font-family: Sora !important;
        font-weight: 400;
        font-size: 32px;
        line-height: 100%;
        color: #000000;
    }
    
    .vendor-product .cont-wrap h5 {
        font-family: Sora !important;
        font-weight: 600;
        font-size: 20px;
        line-height: 32px;
        text-align: center;
        text-transform: capitalize;
    }
    
    .vendor-product .cont-wrap p {
        font-family: Sora !important;
        font-weight: 400;
        font-size: 16px;
        line-height: 30px;
        text-align: center;
        color: #666666;
        margin: 20px 0 40px;
    }
    .vendor-product form {
        width: 100%;
        display: block;
    }
    
    .vendor-product form .pro-div {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 20px;
        position: relative;
        width: 100% !important;
        max-width: 100% !important;
    }
    
    .vendor-product form .pro-div .pro-item {
        width: 100%;
        border-radius: 3px !important;
        overflow: hidden;
    }
    
    .vendor-product form .pro-div .pro-item img {
        aspect-ratio: 335/204;
        object-fit: cover;
        width: 100%;
        height: auto;
    }
    .vendor-product form .pro-div .pro-item .content {
        background: #A6A6A6;
        padding: 13px 0;
    }
    
    .vendor-product form .pro-div .pro-item .content a {
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 14px;
    }
    
    .vendor-product form .pro-div .pro-item .content a p {
        padding: 0;
        margin: 0;
        font-family: Sora !important;
        font-weight: 600;
        font-size: 20px;
        line-height: 100%;
        text-align: center;
        text-transform: capitalize;
        color: #FFFFFF;
    }
    
    .vendor-product form .pro-div .pro-item .content  input {
        width: 20px;
        height: 20px;
        margin: 0;
        background: #fff;
        border: 3px solid #fff !important;
    }
    .btn-center {
        margin-top: 50px;
        text-align: center;
    }
    
    </style>
    
    <section class="sec-120 our-product vendor-product typography">
        <div class="container">
            <div class="cont-wrap">
                <h2 class="our-prod-main">Enable products for your Service point</h2>
                <h5>Standardized Productlist</h5>
                <p>Only enable products that are in your warehouse. Enabled products will be available for rent unless the stock level is 0. Low availability may negatively impact your ratings.We recommend monitoring your stock and replenishing it promptly to maximize sales potential.</p>
    
                <form action="{{ route('vendor.products.save') }}" method="POST">
                    @csrf
    
                    <div class="pro-div">
                        @foreach ($products as $product)
                            <div class="pro-item" style="position: relative;">
                               
    
                                <a href="#">
                                    <img 
                                        src="{{ $product->homePhoto?->image_path ? asset('storage/' . $product->homePhoto->image_path) : asset('frontend/images/placeholder.png') }}" 
                                        alt="{{ $product->name }}"
                                    >
                                </a>
                                
    
                                <div class="content">

                                    
                                    <a href="#" class="btn rent-btn">
                                         <input 
                                    type="checkbox" 
                                    name="product_ids[]" 
                                    value="{{ $product->id }}" 
                                    id="product_{{ $product->id }}" 
                                    disabled
                                
                                />
                                        <p class="p-18">{{ $product->name }}</p>
                                    </a>
                                </div>
                            </div>
                        @endforeach
                    </div>
    
                    <div class="btn-center">
                        <button type="submit" class="primary-btn ">Continue</button>
                    </div>
                </form>
            </div>
        </div>
    </section>
    