<?php

use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\Auth\AuthController;
use App\Http\Controllers\Admin\ContentManagement\ContentManagementController;
use App\Http\Controllers\Admin\Faq\FaqController;
use App\Http\Controllers\Admin\PageMetaTag\CmsPageController;
use App\Http\Controllers\Admin\User\UserController;
use App\Http\Controllers\Admin\Product\ProductController;
use App\Http\Controllers\Admin\Booking\BookingController;
use App\Http\Controllers\Admin\Calender\CalenderController;
use App\Http\Controllers\Admin\Payment\PaymentController;
use App\Http\Controllers\Admin\Voucher\VoucherController;
use App\Http\Controllers\Admin\Category\CategoryController;
use App\Http\Controllers\Admin\Blog\BlogController;
use App\Http\Controllers\Admin\Size\SizeController;
use App\Http\Controllers\Admin\Variation\VariationController;
use App\Http\Controllers\Admin\ProductBrand\ProductBrandController;
use App\Http\Controllers\Admin\ReportAnalytics\ReportAnalyticsController;
use App\Http\Controllers\Admin\Pricing\PriceController;
use App\Http\Controllers\Admin\Color\ColorController;
use App\Http\Controllers\MotherFileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\SPO\SPOController;
use App\Http\Controllers\Admin\SpoProduct\SpoProductController;
use App\Http\Controllers\Admin\Bundle\BundleController;
use App\Http\Controllers\Admin\Notification\NotificationController;

use App\Http\Controllers\Admin\Commission\CommissionController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Route::get('/admin/login', [AuthController::class, 'index'])->name('admin.login');
Route::post('/admin/login/submit', [AuthController::class, 'login'])->name('admin.login.submit');

Route::get('/admin/forgot-password', [AuthController::class, 'forgotPasswordView'])->name('admin.forgot.password.view');
Route::post('/admin/forgot-password', [AuthController::class, 'forgotPassword'])->name('admin.forgot.password');
Route::get('/admin/reset-password/{token}', [AuthController::class, 'showResetForm'])->name('admin.password.reset');
Route::post('/admin/reset-password', [AuthController::class, 'reset'])->name('admin.password-reset-admin.update');

Route::group(['prefix' => 'admin', 'as' => 'admin.', 'middleware' => 'admin'], function () {


  //Admin Routes
  Route::get('/profile', [AdminController::class, 'profileView'])->name('profile');
  Route::get('/profile/edit', [AdminController::class, 'editProfile'])->name('edit.profile');
  Route::post('/profile/edit/{admin}', [AdminController::class, 'updateProfile'])->name('update.profile');
  Route::get('/change-password', [AdminController::class, 'getChangePassword'])->name('change.password');
  Route::post('/update-password', [AdminController::class, 'updateChangePassword'])->name('update.changepassword');

  //Dashboard Routes
  Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');

  //Users Routes
  Route::get('/users', [UserController::class, 'index'])->name('user.index');
  Route::get('/users-list', [UserController::class, 'addUserView'])->name('add.user.view');
  Route::post('/add-user', [UserController::class, 'addUser'])->name('add.user');
  Route::get('/user-profile/{user}', [UserController::class, 'viewProfile'])->name('user.profile');
  Route::get('user/edit/{user}', [UserController::class, 'editUser'])->name('user.edit');
  Route::post('/user/update/{user}', [UserController::class, 'updateUser'])->name('user.update');
  Route::post('/user/delete', [UserController::class, 'deleteUser'])->name('user.delete');
  Route::post('/admin/user/status/update', [UserController::class, 'updateStatus'])->name('user.status.update');


  Route::get('/commissions',[CommissionController::class,'index'])->name('commission.index');
  Route::post('/vendors/{vendor}/save-commission', [CommissionController::class, 'saveCommission'])->name('vendors.save-commission');
  Route::get('/detail/{vendor}',[CommissionController::class,'detail'])->name('commission.spo.profile');

  Route::post('/spo/{id}/status', [CommissionController::class, 'updatePayoutStatus']);

  Route::post('/spo/{vendor}/payout-date', [CommissionController::class, 'updatePayoutDate']);




  

  Route::get('/users/download/pdf', [UserController::class, 'downloadPDF'])->name('users.download.pdf');
  Route::get('/users/download/csv', [UserController::class, 'downloadCSV'])->name('users.download.csv');
  Route::get('/users/search', [UserController::class, 'search'])->name('users.search');


  // Blog Management
  Route::get('/blog-list', [BlogController::class, 'index'])->name('blog.index');
  Route::get('blog-create', [BlogController::class, 'view'])->name('blog.view');
  Route::post('blog-store', [BlogController::class, 'store'])->name('blog.store');
  Route::get('blog-edit/{content}', [BlogController::class, 'edit'])->name('blog.edit');
  Route::post('blog-update/{content}', [BlogController::class, 'update'])->name('blog.update');
  Route::post('/blog/delete/{blog}', [BlogController::class, 'deleteblog'])->name('blog.delete');


  // Category Routes
  Route::get('/categories', [CategoryController::class, 'getAll'])->name('category.index');
  Route::get('/categories/add', [CategoryController::class, 'addView'])->name('category.add.view');
  Route::post('/categories/add', [CategoryController::class, 'add'])->name('category.add');
  Route::get('/category/edit/{slug}', [CategoryController::class, 'edit'])->name('category.edit.view');
  Route::post('/category/edit/{slug}', [CategoryController::class, 'update'])->name('category.update');
  Route::post('/category', [CategoryController::class, 'delete'])->name('category.delete');

  // Size Routes
  Route::resource('size', SizeController::class)->names('size');
  Route::post('/size/delete', [SizeController::class, 'delete'])->name('size.delete');

  // Variation Routes
  Route::resource('variation', VariationController::class)->names('variation');
  Route::post('/variation/delete', [VariationController::class, 'delete'])->name('variation.delete');


  // Product Brand Routes
  Route::get('/products-brand', [ProductBrandController::class, 'getAll'])->name('brand.index');
  Route::get('/product-brand/add', [ProductBrandController::class, 'addView'])->name('brand.add.view');
  Route::post('/product-brand/add', [ProductBrandController::class, 'add'])->name('brand.add');
  Route::get('/product-brand/edit/{slug}', [ProductBrandController::class, 'edit'])->name('brand.edit.view');
  Route::post('/product-brand/edit/{slug}', [ProductBrandController::class, 'update'])->name('brand.update');
  Route::post('/product-brand', [ProductBrandController::class, 'delete'])->name('brand.delete');

  // Pricing Management
  Route::resource('pricing', PriceController::class)->names('price');

  Route::post('upload/price-csv', [PriceController::class, 'uploadPriceCsv'])->name('upload.price.csv');
  Route::post('update/price/{id}', [PriceController::class, 'updatePrice'])->name('update.price');

  Route::get('/product-prices-pdf', [PriceController::class, 'downloadPricePdf'])->name('product-prices.pdf');


  //Products Routes
  Route::get('/product-management', [ProductController::class, 'index'])->name('product.index');
  Route::get('/add-product', [ProductController::class, 'addProduct'])->name('add.product');
  Route::get('/product-detail', [ProductController::class, 'productDetail'])->name('product.detail');
  Route::get('/edit-product', [ProductController::class, 'editProductDetail'])->name('edit.product.detail');


  Route::resource('products', ProductController::class)->names('products');
  Route::get('/products/download/pdf', [ProductController::class, 'downloadPdf'])->name('products.download.pdf');
  Route::get('/products/download/csv', [ProductController::class, 'downloadCsv'])->name('products.download.csv');


  Route::post('/variant/{id}/status', [ProductController::class, 'updateVariantStatus']);
  Route::post('/product/{id}/status', [ProductController::class, 'updateProductStatus']);




  // Booking Management //
  Route::get('/booking-management', [BookingController::class, 'index'])->name('booking.index');
  Route::get('/add-booking', [BookingController::class, 'addBooking'])->name('add.booking');
  Route::get('/booking-detail/{id}', [BookingController::class, 'bookingDetail'])->name('view.booking.detail');
  Route::get('/edit-booking-detail/{id}', [BookingController::class, 'editBookingDetail'])->name('edit.booking.detail');
  Route::get('/products/{slug}/details', [BookingController::class, 'getProductDetails2'])->name('get.product.details');
  Route::get('/search-booking-user', [BookingController::class, 'searchBookingUser'])->name('booking.user.search');
  Route::post('/bookings/{booking}/status', [BookingController::class, 'updateStatus'])
  ->name('bookings.status');
  Route::post('/bookings/{id}/update', [BookingController::class, 'updateBookingDetail'])
    ->name('update.booking.detail');
  Route::post('/save/bookings', [BookingController::class, 'saveBooking'])
    ->name('save.booking.detail');
    Route::post('/admin/booking/apply-coupon', [BookingController::class, 'applyCoupon'])->name('booking.apply_coupon');
    Route::get('/admin/booking/get-coupons', [BookingController::class, 'getCouponsForProduct'])->name('booking.get_coupons');

    Route::get('/getTime',[BookingController::class,'getTime'])->name('booking.getTime');

    
    Route::get('/bookings/download/pdf', [BookingController::class, 'downloadPDF'])->name('bookings.download.pdf');
Route::get('/bookings/download/csv', [BookingController::class, 'downloadCSV'])->name('bookings.download.csv');

Route::post('/bookings/{id}/resend-payment-link', [BookingController::class, 'resendPaymentLink'])
    ->name('booking.resend-payment-link');

    Route::post('/bookings/{id}/resend-delay-payment-link', [BookingController::class, 'resendPaymentLinkForDelay'])
    ->name('booking.resend-delay-payment-link');
  // Calendar Management //
  Route::get('/calendar-management', [CalenderController::class, 'index'])->name('calendar.index');

  Route::get('/calendar/day/{day}', [CalenderController::class, 'getAvailabilityByDay']);

  Route::post('calendar/day/update', [CalenderController::class, 'updateDay']);



  // Payment Management //
  Route::get('/payment-management', [PaymentController::class, 'index'])->name('payment.index');
  Route::get('/search-payment-user', [PaymentController::class, 'searchPaymentUser'])->name('payment.user.search');
  Route::get('/view-payment-history/{id}', [PaymentController::class, 'viewPaymentHistory'])->name('view.payment.history');
  Route::post('/bookings/{booking}/update-payment-status', [PaymentController::class, 'updatePaymentStatus'])
  ->name('bookings.update-payment-status');
  Route::get('/payment/search', [PaymentController::class, 'searchPaymentUser'])->name('payment.user.search');

  Route::get('/payments/export/pdf', [PaymentController::class, 'downloadPdf'])->name('payments.export.pdf');
  Route::get('/payments/export/csv', [PaymentController::class, 'downloadCsv'])->name('payments.export.csv');

  // Voucher Management //
  Route::get('/voucher-management', [VoucherController::class, 'index'])->name('voucher.index');
  Route::get('/create-voucher', [VoucherController::class, 'createVoucher'])->name('create.voucher');
  Route::post('store/voucher', [VoucherController::class, 'storeVoucher'])->name('store.voucher');
  Route::get('/voucher/{id}/view', [VoucherController::class, 'viewVoucher'])->name('view.voucher');
  Route::get('/admin/voucher/{id}/edit', [VoucherController::class, 'editVoucher'])->name('edit.voucher');
  Route::put('/admin/voucher/{id}', [VoucherController::class, 'updateVoucher'])->name('voucher.update');
  Route::post('/vouchers/check-code', [VoucherController::class, 'checkCode'])
    ->name('vouchers.check.code');
  Route::post('/voucher/delete', [VoucherController::class, 'destroy'])->name('delete.voucher');
  Route::get('/search-payment-user', [VoucherController::class, 'searchVoucher'])->name('voucher.search');
  Route::get('/admin/vouchers/export/csv', [VoucherController::class, 'exportCSV'])->name('voucher.export.csv');
  Route::get('/admin/vouchers/export/pdf', [VoucherController::class, 'exportPDF'])->name('voucher.export.pdf');

  // Report and Analytics Management //
  Route::get('report-management', [ReportAnalyticsController::class, 'index'])->name('report.index');

  Route::get('/daily-tasks/export/pdf', [ReportAnalyticsController::class, 'downloadDailyTasksPdf'])->name('daily.tasks.export.pdf');
  Route::get('/daily-tasks/export/csv', [ReportAnalyticsController::class, 'downloadDailyTasksCsv'])->name('daily.tasks.export.csv');


  Route::get('/revenue/export/pdf', [ReportAnalyticsController::class, 'downloadRevenueReportPdf'])->name('revenue.tasks.export.pdf');
  Route::get('/revenue/export/csv', [ReportAnalyticsController::class, 'downloadRevenueReportCsv'])->name('revenue.tasks.export.csv');



  //content Routes
  Route::get('/content-management', [ContentManagementController::class, 'index'])->name('content.index');
  Route::get('content-management/create', [ContentManagementController::class, 'createContent'])->name('content.create');
  Route::post('content-management/store', [ContentManagementController::class, 'storeContent'])->name('content.store');
  Route::get('content-management/edit/{content}', [ContentManagementController::class, 'editContent'])->name('content.edit');
  Route::post('content-management/update/{content}', [ContentManagementController::class, 'updateContent'])->name('content.update');

  // Settings Page Route  
  Route::get('/content-management/edits/{page_type}', [ContentManagementController::class, 'edit'])->name('admin_settings_edit_page');
  Route::post('/content-management/edits/{page_type}', [ContentManagementController::class, 'update'])->name('admin_settings_update_page');


  //Faq Routes 
  Route::get('/faqs', [FaqController::class, 'index'])->name('faq.index');
  Route::get('faq/create', [FaqController::class, 'createFaq'])->name('faq.create');
  Route::post('faq/store', [FaqController::class, 'storeFaq'])->name('faq.store');
  Route::get('faq/edit/{faq}', [FaqController::class, 'editFaq'])->name('faq.edit');
  Route::post('faq/update/{faq}', [FaqController::class, 'updateFaq'])->name('faq.update');

  //web pages routes
  Route::get('/web/general/settings', [CmsPageController::class, 'generalSetting'])->name('page.general');

  Route::get('/web/pages', [CmsPageController::class, 'index'])->name('page.index');
  Route::get('/web/pages/create', [CmsPageController::class, 'create'])->name('page.create');
  Route::post('/web/pages/store', [CmsPageController::class, 'storePage'])->name('page.store');
  Route::get('/pages/edit/{slug}', [CmsPageController::class, 'edit'])->name('page.edit');
  Route::post('/pages/edit/{page_type}', [CmsPageController::class, 'update'])->name('page.data.store');

  // holidays routes
  Route::get('/users/search', [UserController::class, 'search'])->name('users.search');

  Route::post('/holidays/add', [AdminController::class, 'addHolidays'])->name('holidays.add');
  Route::delete('/holidays/delete/{id}', [AdminController::class, 'deleteHoliday'])->name('holidays.delete');
  Route::get('/holidays', [AdminController::class, 'getHolidays'])->name('holidays.get');

  Route::get('/products/{product}/variant/{variant}/option/{option?}', [ProductController::class, 'showVariant'])
  ->name('products.variant.show');
  

    Route::get('/admin/products/{id}/quick-edit', [ProductController::class, 'quickEdit'])->name('products.quick-edit');
  Route::put('/admin/products/{id}/quick-update', [ProductController::class, 'quickUpdate'])->name('products.quick-update');



  // Route::get('/admin-create',[AdminController::class,'adminCreate'])->name('create');

  //Logout route
  Route::post('/logout/submit', [AuthController::class, 'logout'])->name('logout.submit');

  Route::get('/settings/index', [MotherFileController::class, 'importForm'])->name('settings.index');
  Route::get('/roofrack/export', [MotherFileController::class, 'export'])->name('roofrack.export');

  Route::post('/roofrack/import', [MotherFileController::class, 'import'])->name('roofrack.import');

  Route::get('/revenue-chart-data', [ReportAnalyticsController::class, 'revenueChartData'])->name('revenueChart');
  Route::get('/revenue-breakdown', [ReportAnalyticsController::class, 'revenueBreakdown']);
  Route::get('/cancellation-report', [ReportAnalyticsController::class, 'cancellationReport']);
  Route::get('/payment-method-chart', [ReportAnalyticsController::class, 'paymentMethodBreakdown']);
  Route::get('/top-products-chart', [ReportAnalyticsController::class, 'topProductsChart']);
  Route::get('/dashboard-cards', [ReportAnalyticsController::class, 'dashboardCards']);

  Route::get('notifications/fetch', [NotificationController::class, 'fetch'])->name('notifications.fetch');
  Route::post('notifications/read/{id}', [NotificationController::class, 'markAsRead'])->name('notifications.read');
  Route::get('/notifications', [NotificationController::class, 'index'])->name('notifications.page');
  Route::post('/notifications/read-all', [NotificationController::class, 'markAllAsRead'])->name('notifications.read.all');
  Route::post('/notifications/{id}/unread', [NotificationController::class, 'markAsUnread'])
    ->name('notifications.unread');


  Route::get('/export/products', [ProductController::class, 'exportFull'])->name('products.export.full');
  Route::get('/export/template/products', [ProductController::class, 'exportTemplate'])->name('products.export.template');
  Route::post('/import', [ProductController::class, 'import'])->name('products.import');


  Route::get('spo', [SPOController::class, 'index'])->name('spo.index');
  Route::get('spo/add', [SPOController::class, 'create'])->name('spo.create');
  Route::post('spo/store', [SPOController::class, 'store'])->name('spo.store');
  Route::get('spo/{vendor}/edit', [SPOController::class, 'edit'])->name('spo.edit');
  Route::put('spo/{vendor}/update', [SPOController::class, 'update'])->name('spo.update');
  Route::post('spo/status', [SPOController::class, 'status'])->name('spo.status');
  Route::post('spo/delete', [SPOController::class, 'destroy'])->name('spo.destroy');
  Route::get('spo/{vendor}', [SPOController::class, 'show'])->name('spo.show');
  Route::get('spo/download/csv', [SPOController::class, 'downloadCSV'])->name('spo.download.csv');
  Route::get('spo/download/pdf', [SPOController::class, 'downloadPDF'])->name('spo.download.pdf');


  Route::get('bundle', [BundleController::class, 'index'])->name('bundle.index');
  Route::get('bundle/add', [BundleController::class, 'create'])->name('bundle.create');
  Route::post('bundle/store', [BundleController::class, 'store'])->name('bundle.store');
  Route::get('bundle/{bundle}/edit', [BundleController::class, 'edit'])->name('bundle.edit');
  Route::put('bundle/{bundle}/update', [BundleController::class, 'update'])->name('bundle.update');
  Route::post('bundle/delete', [BundleController::class, 'destroy'])->name('bundle.destroy');
  Route::get('bundle/{bundle}', [BundleController::class, 'show'])->name('bundle.show');
  Route::get('bundle/download/csv', [BundleController::class, 'downloadCSV'])->name('bundle.download.csv');
  Route::post('bundle/upload/csv', [BundleController::class, 'uploadCSV'])->name('bundle.upload.csv');

  Route::get('bundle/download/reportCSV', [BundleController::class, 'downloadReportCSV'])->name('bundle.download.reportCSV');
  Route::get('bundle/download/reportPDF', [BundleController::class, 'downloadReportPDF'])->name('bundle.download.reportPDF');


  Route::get('spos/productManagement' , [SpoProductController::class,'index'])->name('spo.product.management');
  Route::get('spos/productDetail/{vendor}' , [SpoProductController::class,'detail'])->name('spo.product.detail');

  Route::get('spos/products/{product}/variant/{variant}/option/{option?}/vendor/{vendor}', [SpoProductController::class, 'showVariant'])
  ->name('spo.products.variant.show');

  Route::post('/products/update-quantity', [SpoProductController::class, 'updateQuantity'])->name('update.quantity');
  Route::get('spoProduct/download/csv', [SpoProductController::class, 'downloadCSV'])->name('spoProduct.download.csv');
  Route::get('spoProduct/download/pdf', [SpoProductController::class, 'downloadPDF'])->name('spoProduct.download.pdf');
  Route::get('spoProduct/downloadDetail/pdf/{vendor}', [SpoProductController::class, 'detailDownloadPdf'])->name('spoProduct.downloadProduct.pdf');

  Route::get('spoProduct/downloadDetail/csv/{vendor}', [SpoProductController::class, 'detailDownloadCSV'])->name('spoProduct.downloadProduct.csv');


  Route::get('/dailyPrice/product', [BookingController::class, 'dailyPrice'])->name('dailyPrice.product');
  Route::post('/booking/returnDetail', [BookingController::class, 'returnDetail'])->name('update.booking.returnDetail');




  Route::get('/get-details', [BookingController::class, 'getProductDetails'])->name('product.get-details');
  Route::get('/get-quote', [BookingController::class, 'getQuote'])->name('getquote');
  Route::post('/cart/add', [BookingController::class, 'add'])->name('cart.add');
  Route::get('/cart/confirm/{cartItem}', [BookingController::class, 'confirm'])->name('cart.confirm');
  Route::post('/cart/confirm-slot', [BookingController::class, 'confirmSlot']);
  Route::get('/cart', [BookingController::class, 'cartPage'])->name('cart.index');
  Route::get('/checkout', [BookingController::class, 'checkOutIndex'])->name('checkout.index');
  Route::post('/checkout/submit', [BookingController::class, 'checkout'])->name('checkout.submit');

  Route::post('/cart/remove', [BookingController::class, 'remove'])->name('cart.remove');

  Route::post('/cart/apply_coupon', [BookingController::class, 'applyCoupon'])->name('cart.apply_coupon');

  Route::post('/cart/remove-single-coupon', [BookingController::class, 'removeSingleCoupon'])
    ->name('cart.remove_single_coupon');


    Route::get('/spoproducts/available', [SpoProductController::class, 'getAvailableProducts'])->name('spoproducts.getAvailable');

    Route::post('/spoproducts/updateProducts', [SpoProductController::class, 'updateSelectedProducts'])->name('spoproducts.saveUpdatedProducts');
    Route::post('/spoproducts/delete', [SpoProductController::class, 'destroy'])->name('spoproducts.destroy');


    Route::get('/admin/products/quantity/template', [SpoProductController::class, 'downloadQuantityTemplate'])->name('products.quantity.template');
    Route::post('/admin/products/quantity/import', [SpoProductController::class, 'importQuantities'])->name('products.quantity.import');
    



  
});

Route::prefix('admin/color')->name('admin.color.')->group(function () {
  Route::get('/', [ColorController::class, 'index'])->name('index');
  Route::get('/add', [ColorController::class, 'create'])->name('add.view');
  Route::post('/add', [ColorController::class, 'store'])->name('add');
  Route::get('/edit/{slug}', [ColorController::class, 'edit'])->name('edit.view');
  Route::post('/edit/{slug}', [ColorController::class, 'update'])->name('update');
  Route::post('/delete', [ColorController::class, 'destroy'])->name('delete');
});

Route::prefix('admin/calendar')->group(function() {
  Route::get('availability/{date}', [CalenderController::class, 'getAvailabilityByDate']);
  Route::post('store-availability', [CalenderController::class, 'storeAvailability']);
  Route::post('close-date', [CalenderController::class, 'closeDate']);
  Route::delete('delete-slot/{id}', [CalenderController::class, 'deleteSlot']);
  Route::get('/bookings/{date}', [CalenderController::class, 'getBookingsByDate']);

  Route::get('/download-pdf/{date}', [CalenderController::class, 'downloadPdf']);
  Route::get('/download-csv/{date}', [CalenderController::class, 'downloadCsv']);

});
