<?php

use App\Http\Controllers\Frontend\Payment\PaymentController;
use App\Http\Controllers\Frontend\Payment\StripeWebhookController;

Route::post('user/checkout/submit', [PaymentController::class, 'checkout'])->name('user.checkout.submit');
Route::get('/checkout/success', [PaymentController::class, 'success'])->name('checkout.success');
Route::get('/checkout/cancel', [PaymentController::class, 'cancel'])->name('checkout.cancel');
Route::post('test/webhook', [StripeWebhookController::class, 'handle']);


Route::post('guest/checkout/submit', [PaymentController::class, 'guestCheckout'])->name('guest.checkout.submit');
Route::get('guest/checkout/success', [PaymentController::class, 'guestSuccess'])->name('guest.checkout.success');


Route::get('/delay/success', [PaymentController::class, 'successDelay'])->name('delay.success');
Route::get('/delay/cancel', [PaymentController::class, 'cancelDelay'])->name('delay.cancel');

Route::get('/checkout/cancel', [PaymentController::class, 'cancel'])->name('checkout.cancel');
