<?php

use App\Http\Controllers\Frontend\Voucher\VoucherController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\User\UserController;
use App\Http\Controllers\Frontend\Booking\BookingController;
use App\Http\Controllers\Frontend\Appointment\AppointmentController;
use App\Http\Controllers\Frontend\Cart\CartController;
use App\Http\Controllers\Frontend\Check\CheckoutController;
use App\Http\Controllers\Frontend\Newsletter\NewsletterController;
use App\Http\Controllers\Frontend\WebController;

// Cart Management

Route::get('/cart', [CartController::class, 'index'])->name('cart.index');

Route::group(['prefix' => 'user', 'as' => 'user.', 'middleware' => 'auth'], function () {

    // User Management
    Route::get('/profile', [UserController::class, 'index'])->name('index');
    Route::get('/edit', [UserController::class, 'edit'])->name('edit');
    Route::put('/update', [UserController::class, 'update'])->name('update');
    Route::post('/delete', [UserController::class, 'destroy'])->name('delete');
    Route::post('/logout', [UserController::class, 'logout'])->name('logout');



    // Booking Management
    Route::get('/booking', [BookingController::class, 'index'])->name('booking.index');
    

    // Appointment Management
    Route::get('/appointment', [AppointmentController::class, 'index'])->name('appointment.index');
    Route::get('/appointment/{id}/details/{itemid}', [AppointmentController::class, 'showDetails'])->name('appointment.details');
    Route::get('/appointment/{id}/getdetails/{itemid}', [AppointmentController::class, 'getDetails'])->name('appointment.getdetails');
    Route::post('/appointment/{id}/update/{itemid}', [AppointmentController::class, 'updateAppointment'])->name('appointment.update');
    Route::get('/appointment/get-time', [AppointmentController::class, 'getTime'])->name('appointment.getTime');

     // Appointment Management
     
     //  Route::get('/order-success', [CheckoutController::class, 'orderSuceess'])->name('order.success');
     Route::get('/booking/{id}/details', [BookingController::class, 'getBookingDetails'])->name('booking.details');
     Route::post('/booking/cancel', [BookingController::class, 'cancelBooking'])->name('booking.cancel');

     Route::get('/change-password',[UserController::class,'changePassword'])->name('password');
     Route::post('/update-password',[UserController::class,'updatePassword'])->name('update.password');


     Route::get('/car-detail',[UserController::class,'showCarDetails'])->name('carDetails');
     Route::get('/car-detail/edit',[UserController::class,'editCarDetails'])->name('editCarDetails');
     Route::post('/car-details/update', [UserController::class, 'updateCarDetails'])->name('car.update');


     Route::get('/billing-address',[UserController::class,'showBillingAddress'])->name('billingAddress');
    
     Route::get('billing-address/create', [UserController::class, 'createBillingAddress'])->name('billing-address.create');
     Route::post('billing-address/store', [UserController::class, 'storeBillingAddress'])->name('billing-address.store');
     Route::get('billing-address/{id}/edit', [UserController::class, 'editBillingAddress'])->name('billing-address.edit');
     Route::post('billing-address/{id}/update', [UserController::class, 'updateBillingAddress'])->name('billing-address.update');
     Route::post('billing-address/{id}/delete', [UserController::class, 'destroyAddress'])->name('billing-address.delete');

     Route::get('/newsletter',[UserController::class,'showNewsLetter'])->name('newsletter');
     Route::post('/newsletter-subscribe', [NewsletterController::class, 'subscribe'])->name('newsletter.subscribe');

     //Voucher
     Route::get('/voucher', [VoucherController::class, 'index'])->name('voucher.index');
     Route::post('/check-email', [UserController::class, 'checkEmail'])->name('check-email');


     Route::post('/newsletter/toggle', [NewsletterController::class, 'toggleNewsletter'])->name('newsletter.toggle');




    });
    Route::get('user/search', [WebController::class, 'search'])->name('user.search');

    Route::get('user/checkout', [CheckoutController::class, 'index'])->name('user.checkout.index');
