<?php 
use App\Http\Controllers\Vendor\Auth\AuthController;
use Illuminate\Http\Request;
use App\Models\Vendor;

use App\Http\Controllers\Vendor\VendorController;
use App\Http\Controllers\Vendor\Product\ProductController;
use App\Http\Controllers\Vendor\Booking\BookingController;
use App\Http\Controllers\Vendor\ReportAnalytics\ReportAnalyticsController;
use App\Http\Controllers\Vendor\Calendar\CalendarController;
use App\Http\Controllers\Vendor\Payment\PaymentController;
use App\Http\Controllers\Vendor\Notification\NotificationController;


Route::get('/vendor/login', [AuthController::class, 'index'])->name('vendor.login');
Route::get('/vendor/register', [AuthController::class, 'registerView'])->name('vendor.register.view');
Route::post('/vendor/login/submit', [AuthController::class, 'login'])->name('vendor.login.submit');


Route::get('/vendor/registration/success', [AuthController::class, 'registrationSuccess'])->name('vendor.registration.success');




Route::post('vendor/registration', [AuthController::class, 'register'])->name('vendor.register');
Route::get('vendor/forgot-password', [AuthController::class, 'forgotView'])->name('vendor.forgot.view');
Route::post('vendor/forgot-password', [AuthController::class, 'forgotPassword'])->name('vendor.forgot.password');
Route::get('vendor/reset-password', [AuthController::class, 'resetPasswordView'])->name('vendor.reset.password.view');
Route::post('vendor/reset-password', [AuthController::class, 'resetPassword'])->name('vendor.reset.password');

Route::post('vendor/logout',[AuthController::class,'logout'])->name('vendor.logout.submit');

Route::get('vendor/check-email', function (Request $request) {
  $exists = Vendor::where('email', strtolower($request->email))
                  ->exists();
  return response()->json($exists);
})->name('vendor.check.email');




Route::group(['prefix' => 'vendor', 'as' => 'vendor.', 'middleware' => 'vendor'], function () {

    Route::get('/vendor/products/quantity/template', [ProductController::class, 'downloadQuantityTemplate'])->name('products.quantity.template');
Route::post('/vendor/products/quantity/import', [ProductController::class, 'importQuantities'])->name('products.quantity.import');

    Route::get('/dashboard',[VendorController::class,'dashboard'])->name('dashboard');

    Route::get('/productSelection',[VendorController::class,'productSelection'])->name('productSelection');

    Route::post('/products/save',[VendorController::class,'saveSelectedProducts'])->name('products.save');


    Route::get('/products',[ProductController::class , 'index'])->name('products');

    Route::post('/variant/{id}/status', [ProductController::class, 'updateVariantStatus'])->name('updateVariantStatus');

    Route::get('/updateProduct', [ProductController::class, 'updateProductQuantity'])->name('products.variant.update');

    Route::get('/products/{product}/variant/{variant}/option/{option?}', [ProductController::class, 'showVariant'])
    ->name('products.variant.show');

    Route::get('/products/available', [ProductController::class, 'getAvailableProducts'])->name('products.getAvailable');

    Route::post('/products/updateProducts', [ProductController::class, 'updateSelectedProducts'])->name('products.saveUpdatedProducts');

    Route::post('/products/update-quantity', [ProductController::class, 'updateQuantity'])->name('update.quantity');


    Route::post('/products/add' , [ProductController::class , 'addProduct'])->name('add.product');

    Route::get('/products/pdf/download', [ProductController::class,'downloadPdf'])->name('products.download.pdf');
    Route::get('/products/csv/download' , [ProductController::class,'downloadCsv'])->name('products.download.csv');


    Route::get('notifications/fetch', [NotificationController::class, 'fetch'])->name('notifications.fetch');
    Route::post('notifications/read/{id}', [NotificationController::class, 'markAsRead'])->name('notifications.read');
    Route::get('/notifications', [NotificationController::class, 'index'])->name('notifications.page');
    Route::post('/notifications/read-all', [NotificationController::class, 'markAllAsRead'])->name('notifications.read.all');
    Route::post('/notifications/{id}/unread', [NotificationController::class, 'markAsUnread'])
      ->name('notifications.unread');






    Route::get('/booking-management', [BookingController::class, 'index'])->name('booking.index');  
    Route::get('/add-booking', [BookingController::class, 'addBooking'])->name('add.booking');
    Route::get('/booking-detail/{id}', [BookingController::class, 'bookingDetail'])->name('view.booking.detail');
    Route::get('/edit-booking-detail/{id}', [BookingController::class, 'editBookingDetail'])->name('edit.booking.detail');

    Route::get('/products/{slug}/details', [BookingController::class, 'getProductDetails2'])->name('get.product.details');
    Route::get('/search-booking-user', [BookingController::class, 'searchBookingUser'])->name('booking.user.search');
    Route::post('/bookings/{booking}/status', [BookingController::class, 'updateStatus'])
    ->name('bookings.status');
    Route::post('/save/bookings', [BookingController::class, 'saveBooking'])
    ->name('save.booking.detail');
    Route::post('/admin/booking/apply-coupon', [BookingController::class, 'applyCoupon2'])->name('booking.apply_coupon');
    Route::get('/admin/booking/get-coupons', [BookingController::class, 'getCouponsForProduct'])->name('booking.get_coupons');
    Route::get('/getTime',[BookingController::class,'getTime'])->name('booking.getTime');
    Route::get('/bookings/download/pdf', [BookingController::class, 'downloadPDF'])->name('bookings.download.pdf');
    Route::get('/bookings/download/csv', [BookingController::class, 'downloadCSV'])->name('bookings.download.csv');
    Route::post('/bookings/{id}/resend-payment-link', [BookingController::class, 'resendPaymentLink'])
        ->name('booking.resend-payment-link');

    Route::post('/bookings/{id}/update', [BookingController::class, 'updateBookingDetail'])
    ->name('update.booking.detail');

    Route::get('/dailyPrice/product', [BookingController::class, 'dailyPrice'])->name('dailyPrice.product');
    Route::post('/booking/returnDetail', [BookingController::class, 'returnDetail'])->name('update.booking.returnDetail');
      




    Route::get('/calendar-management', [CalendarController::class, 'index'])->name('calendar.index');
    Route::get('/calendar/day/{day}', [CalendarController::class, 'getAvailabilityByDay']);
    Route::post('calendar/day/update', [CalendarController::class, 'updateDay']);
    Route::get('/calendar/download-pdf/{date}', [CalendarController::class, 'downloadPdf']);
    Route::get('/calendar/download-csv/{date}', [CalendarController::class, 'downloadCsv']);



    Route::get('/payment-management', [PaymentController::class, 'index'])->name('payment.index');
    Route::get('/search-payment-user', [PaymentController::class, 'searchPaymentUser'])->name('payment.user.search');
    Route::get('/view-payment-history/{id}', [PaymentController::class, 'viewPaymentHistory'])->name('view.payment.history');
    Route::post('/bookings/{booking}/update-payment-status', [PaymentController::class, 'updatePaymentStatus'])
    ->name('bookings.update-payment-status');
    Route::get('/payment/search', [PaymentController::class, 'searchPaymentUser'])->name('payment.user.search');
  
    Route::get('/payments/export/pdf', [PaymentController::class, 'downloadPdf'])->name('payments.export.pdf');
    Route::get('/payments/export/csv', [PaymentController::class, 'downloadCsv'])->name('payments.export.csv');



    Route::get('/profile', [VendorController::class, 'profileView'])->name('profile');
    Route::get('/profile/edit', [VendorController::class, 'editProfile'])->name('edit.profile');
    Route::put('/profile/edit/{vendor}', [VendorController::class, 'updateProfile'])->name('update.profile');
    Route::get('/change-password', [VendorController::class, 'getChangePassword'])->name('change.password');
    Route::post('/update-password', [VendorController::class, 'updateChangePassword'])->name('update.changepassword');



  Route::get('/revenue-chart-data', [ReportAnalyticsController::class, 'revenueChartData'])->name('revenueChart');
  Route::get('/revenue-breakdown', [ReportAnalyticsController::class, 'revenueBreakdown']);
  Route::get('/cancellation-report', [ReportAnalyticsController::class, 'cancellationReport']);
  Route::get('/payment-method-chart', [ReportAnalyticsController::class, 'paymentMethodBreakdown']);
  Route::get('/top-products-chart', [ReportAnalyticsController::class, 'topProductsChart']);
  Route::get('/dashboard-cards', [ReportAnalyticsController::class, 'dashboardCards']);



  Route::get('/get-details', [BookingController::class, 'getProductDetails'])->name('product.get-details');
  Route::get('/get-quote', [BookingController::class, 'getQuote'])->name('getquote');
  Route::post('/cart/add', [BookingController::class, 'add'])->name('cart.add');
  Route::get('/cart/confirm/{cartItem}', [BookingController::class, 'confirm'])->name('cart.confirm');
  Route::post('/cart/confirm-slot', [BookingController::class, 'confirmSlot']);
  Route::get('/cart', [BookingController::class, 'cartPage'])->name('cart.index');
  Route::get('/checkout', [BookingController::class, 'checkOutIndex'])->name('checkout.index');
  Route::post('/checkout/submit', [BookingController::class, 'checkout'])->name('checkout.submit');

  Route::post('/cart/remove', [BookingController::class, 'remove'])->name('cart.remove');

  Route::post('/cart/apply_coupon', [BookingController::class, 'applyCoupon'])->name('cart.apply_coupon');

  Route::post('/cart/remove-single-coupon', [BookingController::class, 'removeSingleCoupon'])
    ->name('cart.remove_single_coupon');


  
});


    Route::prefix('vendor/calendar')->group(function() {
    Route::get('availability/{date}', [CalendarController::class, 'getAvailabilityByDate']);
    Route::post('store-availability', [CalendarController::class, 'storeAvailability']);
    Route::post('close-date', [CalendarController::class, 'closeDate']);
    Route::delete('delete-slot/{id}', [CalendarController::class, 'deleteSlot']);
    Route::get('/bookings/{date}', [CalendarController::class, 'getBookingsByDate']);



  
  });