<?php

use App\Http\Controllers\Frontend\Payment\PaymentController;
use App\Http\Controllers\Frontend\Payment\StripeWebhookController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\WebController;
use App\Http\Controllers\Frontend\ContactController;
use App\Http\Controllers\Frontend\Auth\AuthController;
use App\Http\Controllers\Frontend\Auth\SocialiteController;
use App\Http\Controllers\Frontend\Cart\CartController;
use App\Http\Controllers\Frontend\Check\CheckoutController;
use App\Http\Controllers\Admin\Booking\BookingController;

use Illuminate\Http\Request;
use App\Models\User;


#-----------------------------------
#---------- Website Route ----------
#-----------------------------------
Route::get('/', [WebController::class, 'index'])->name('home');
Route::get('/about', [WebController::class, 'about'])->name('about');
Route::get('/work-with-us', [WebController::class, 'workWithUs'])->name('work-with-us');

Route::get('/product', [WebController::class, 'product'])->name('product');
Route::get('/product-details/{slug}', [WebController::class, 'productDetails'])->name('product.details');
Route::get('/car/years', [WebController::class, 'getYears']);
Route::get('/car/models', [WebController::class, 'getModels']);
Route::get('/car/recommendation', [WebController::class, 'getRecommendation']);
Route::get('/blog', [WebController::class, 'blog'])->name('blog');
Route::get('/blog-details/{slug}', [WebController::class, 'blogDetails'])->name('blogDetails');
Route::get('/contact', [WebController::class, 'contact'])->name('contact');
Route::post('/contact', [ContactController::class, 'store'])->name('contact.store');
Route::get('/Impressum', [WebController::class, 'impresum'])->name('impresusm');
Route::get('/term-condition', [WebController::class, 'termCondition'])->name('termcondition');
Route::get('/return-process', [WebController::class, 'returnProcess'])->name('returnprocess');
Route::get('/withdrawal-rights', [WebController::class, 'withdrawlRights'])->name('withdrawlrights');
Route::get('/gdpr', [WebController::class, 'Gdpr'])->name('gdpr');
Route::get('/how-to', [WebController::class, 'howTo'])->name('howto');
Route::get('/roofbox', [WebController::class, 'Roofbox'])->name('roofbox');
Route::get('/get-quote', [WebController::class, 'getQuote'])->name('getquote');
Route::get('/rearbox', action: [WebController::class, 'Rearbox'])->name('rearbox');
Route::get('/roofrack', action: [WebController::class, 'roofrack'])->name('roofrack');
Route::get('/roof-bike-rack', action: [WebController::class, 'roofBikeRack'])->name('roof_bike_rack');
Route::get('/clutch-bike-rack', action: [WebController::class, 'clutchBikeRack'])->name('clutch_bike_rack');

Route::get('/userCarDetail',[WebController::class , 'userCarDetail'])->name('userCarDetail');



Route::get('/bookingRequest', [BookingController::class, 'getBookingRequestData']);





#-----------------------------------
#---------- Website Auth Route ----------
#-----------------------------------
Route::get('/login', [AuthController::class, 'index'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login');


Route::get('auth/google', [SocialiteController::class, 'googleLogin'])->name('user.auth.google');
Route::get('auth/google-callback', [SocialiteController::class, 'googleCallback'])->name('user.auth.callback');




Route::get('/registration', [AuthController::class, 'registerView'])->name('register.view');
Route::post('/registration', [AuthController::class, 'register'])->name('register');
Route::get('/check-email', function (Request $request) {
    $user = User::where('email', strtolower($request->email))->first();

    if (!$user) {
        return response()->json(false);
    }

    if ($user->is_guest) {
        return response()->json(false);
    }

    return response()->json(true);
})->name('check.email');
Route::get('/email/verify/{id}/{token}', [AuthController::class, 'verify'])->name('verify.email');
Route::get('/forgot-password', [AuthController::class, 'forgotView'])->name('forgot.view');
Route::post('/forgot-password', [AuthController::class, 'forgotPassword'])->name('forgot.password');
Route::get('/reset-password', [AuthController::class, 'resetPasswordView'])->name('reset.password.view');
Route::post('/reset-password', [AuthController::class, 'resetPassword'])->name('reset.password');


Route::get('/product/{product}/availability', [WebController::class, 'checkAvailability']);
Route::get('/product/{product}/roofRack/availability', [WebController::class, 'checkAvailabilityForRoofRack']);

Route::post('/cart/add', [CartController::class, 'add'])->name('cart.add');

Route::get('/cart/process-session', [CartController::class, 'processSession'])->name('cart.process.session');


Route::get('/cart/confirm/{cartItem}', [CartController::class, 'confirm'])->name('cart.confirm');

Route::post('/cart/finalize/{cartItem}', [CartController::class, 'finalize'])->name('cart.finalize');
Route::get('/cart/success/{cartItem}', [CartController::class, 'success'])->name('cart.success');


Route::get('/working-hours', [CartController::class, 'getTime']);

Route::post('/cart/confirm-slot', [CartController::class, 'confirmSlot']);

Route::post('/cart/remove', [CartController::class, 'remove'])->name('cart.remove');

Route::post('/cart/apply_coupon', [CartController::class, 'applyCoupon'])->name('cart.apply_coupon');

Route::get('/cart/count', [CartController::class, 'count'])->name('cart.count');

Route::post('/cart/remove-single-coupon', [CartController::class, 'removeSingleCoupon'])
    ->name('cart.remove_single_coupon');
    
Route::post('/cart/guest', [CartController::class, 'storeGuestSession'])->name('cart.store_guest_session');

Route::get('/cart/guest/confirm/', [CartController::class, 'guestTimeSelection'])->name('cart.guest_time-selection');

Route::get('/cart/guest/time-slots', [CartController::class, 'getGuestTimeSlots'])
     ->name('cart.guest_time-slots');

Route::post('/cart/guest/time-selection', [CartController::class, 'storeGuestTimeSelection'])
     ->name('bookings.guest_store-time-selection');

Route::get('/checkout/guest', [CheckoutController::class, 'guestCheckout'])
     ->name('checkout.guest');

Route::post('/store-rental-form', function (Illuminate\Http\Request $request) {
     // session(['rental_form' => $request->all()]);
     session([
          'rental_form' => $request->all(),
          'from_rent_now' => true,
          'rental_form_timestamp' => now()
      ]);
     return response()->json(['stored' => true]);
});

Route::get('/get-details', [WebController::class, 'getProductDetails'])->name('product.get-details');
Route::get('/product/{product}/size-details', [WebController::class, 'getSizeDetails'])->name('product.size-details');


Route::post('/product/request',[WebController::class,'bookingRequest'])->name('product.bookingRequest');



Route::get('/get-vendor-calendar-data', [WebController::class, 'getVendorCalendarData'])
    ->name('vendor.calendar.data');


// Route::get('/checkout/guest', [CheckoutController::class, 'guestCheckout'])->name('checkout.guest');
// Route::post('/checkout/guest', [CheckoutController::class, 'processGuestCheckout'])->name('checkout.guest.process');

#---------------------------------------
require __DIR__ . '/admin/routes.php';
require __DIR__ . '/user/routes.php';
require __DIR__ . '/user/payment/payment.php';
require __DIR__ . '/vendor/routes.php';