<?php
    $flagMap = [
        '+49' => 'https://flagcdn.com/16x12/de.png',
        '+43' => 'https://flagcdn.com/16x12/at.png',
        '+41' => 'https://flagcdn.com/16x12/ch.png',
    ];
?>
<style>
    .flag-icon {
    width: 16px;
    height: 12px;
    margin-right: 6px;
    vertical-align: middle;
    object-fit: cover;
    display: inline-block;
}

.phone-display {
    display: flex;
    align-items: center;
    font-weight: 600;
    gap: 8px;
}

</style>



<?php $__env->startSection('content'); ?>
<main>
    <section class="banner-back-img-with banner-back-img-appointment">
        <div class="inner-main-img">
            <div class="container">
                <div class="inner-banner-comn">
                    <h1><?php echo e(__('messages.billing_address')); ?></h1>
                </div>
            </div>
        </div>
    </section>
    

      <div class="prof-main">
        <section class="comn-padd">
          <div class="container">
            <div class="inner-acount">
              <div class="row">
                <div class="col-lg-3">
                    <div class="inner-left-tabs">
                        <?php echo $__env->make('frontend.user.include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
                <div class="col-lg-9">              
                  <section id="billing-address">
                    <div class="comm_border_box">
                      <h3 class="main-head-pro"><?php echo e(__('messages.billing_address')); ?></h3>
              
                      <div class="comm_border_box_outer">
                        <?php $__currentLoopData = $billingAddresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="comm_border_box inner_comm_border_box">
                                <div class="d-flex justify-content-between flex-wrap gap-3 address_edit_btn_row">
                                    <h3 class="main-head-pro mb-0"><?php echo e(__('messages.address')); ?> <?php echo e($index + 1); ?></h3>
                                    <div class="d-flex gap-2">
                                        <a href="<?php echo e(route('user.billing-address.edit', $address->id)); ?>" class="address_edit_btn">
                                            <img src="<?php echo e(asset('frontend/images/edit.png')); ?>" alt="<?php echo e(__('messages.edit')); ?>" />
                                        </a>
                                        <?php if(!$address->is_default): ?>
                                        <button type="button" class="delete-btn-eye"
                                            data-id="<?php echo e($address->id); ?>"
                                            data-name="<?php echo e($address->name); ?>"
                                            data-bs-toggle="modal"
                                            data-bs-target="#deleteAddressModal">
                                            <i class="fa-solid fa-trash"></i>
                                        </button>
                                    <?php endif; ?>

                                        
                                    </div>
                                    
                                    
                                </div>
                                <div class="d-flex comm_detail_list_view">
                                    <div class="comm_detail_list_col">
                                        <h5><?php echo e(__('messages.name')); ?></h5>
                                        <h6><?php echo e($address->name); ?></h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5><?php echo e(__('messages.street_house_number')); ?></h5>
                                        <h6><?php echo e($address->street); ?></h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5><?php echo e(__('messages.zip_code')); ?></h5>
                                        <h6><?php echo e($address->zipcode); ?></h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5><?php echo e(__('messages.city')); ?></h5>
                                        <h6><?php echo e($address->city); ?></h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5><?php echo e(__('messages.state_region')); ?></h5>
                                        <h6><?php echo e($address->state); ?></h6>
                                    </div>
                                     <div class="comm_detail_list_col">
                                        <h5><?php echo e(__('messages.company_name')); ?></h5>
                                        <h6><?php echo e($address->company_name ?? 'N/A'); ?></h6>
                                    </div>
                                    <div class="comm_detail_list_col">
                                        <h5><?php echo e(__('messages.email')); ?></h5>
                                        <h6 class="email_text"><?php echo e($address->email); ?></h6>
                                    </div>
                                    <?php
                                    $contactNumber = $address->contact_number;

                                    // Find which country code matches the start of the contact number
                                    $countryCode = '';
                                    $localNumber = '';

                                    foreach ($flagMap as $code => $flag) {
                                        if (str_starts_with($contactNumber, $code)) {
                                            $countryCode = $code;
                                            $localNumber = substr($contactNumber, strlen($code));
                                            break;
                                        }
                                    }

                                    // If no match, fallback
                                    if (!$countryCode) {
                                        $countryCode = '+41';  // Default country code (or empty string)
                                        $localNumber = $contactNumber;
                                    }

                                    $localNumber = ltrim($localNumber, '0');  // Remove leading zero if any
                                ?>

                                <div class="comm_detail_list_col phone-number">
                                    <h5><?php echo e(__('messages.contact_number')); ?></h5>
                                    <h6>
                                        <?php if(isset($flagMap[$countryCode])): ?>
                                            <img src="<?php echo e($flagMap[$countryCode]); ?>" alt="Flag" class="flag-icon" />
                                        <?php endif; ?>
                                        <?php echo e($countryCode); ?> <?php echo e($localNumber); ?>

                                    </h6>
                                </div>

                                </div>
                                <div class="make_defaut_addr_row">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="default_<?php echo e($address->id); ?>" <?php echo e($address->is_default ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="default_<?php echo e($address->id); ?>">
                                            <?php echo e(__('messages.make_default_address')); ?>

                                        </label>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    
                    </div>
              
                    
                    <div class="comm_profile_two_btns">
                        <a href="<?php echo e(route('user.billing-address.create')); ?>" class="primary-btn mt-4"><?php echo e(__('messages.add_new_address')); ?></a>
                    </div>
                    
              
                      
                    </div>
                  </section>   
                </div>
              </div>
            </div>
          </div>
        </section>

      </div>

       <div class="modal fade modal-delete-logout" id="deleteAddressModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteAddressModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="p-0 modal-body">
                    <div class="inner-body-delete-logout">
                        <h4 id="deleteAddressText"><?php echo e(__('messages.are_your_sure_delete_address')); ?></h4>
                        <div class="upper-btns-modal-pair">
                            <button type="button" data-bs-dismiss="modal" class="comn-modal-btns-transparent btn btn-primary">
                              <?php echo e(__('messages.no')); ?>

                            </button>
                            <form id="deleteAddressForm" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="comn-modal-btns-transparent primary-btn comm_primary_icon_btn">
                                   <?php echo e(__('messages.yes')); ?>

                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </main>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const deleteButtons = document.querySelectorAll(".delete-btn-eye");
            const deleteForm = document.getElementById("deleteAddressForm");
            const deleteText = document.getElementById("deleteAddressText");
    
            deleteButtons.forEach(button => {
                button.addEventListener("click", function () {
                    const id = this.getAttribute("data-id");
                    const name = this.getAttribute("data-name");
                    const routeTemplate = "<?php echo e(route('user.billing-address.delete', ':id')); ?>";
                    const actionUrl = routeTemplate.replace(':id', id);
                    deleteForm.action = actionUrl;
    
                    // deleteText.innerHTML = `Are you sure you want to delete? `;
                });
            });
        });
    </script>
    
  
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/frontend/user/billing-address/index.blade.php ENDPATH**/ ?>