<?php $__env->startSection('content'); ?>
<style>
    .is-invalid {
        border-color: #dc3545;
    }
    .error-message {
        margin-top: 2px;
        font-size: 15px;
        color: #dc3545;
    }
    .day-row {
        margin-bottom: 15px;
    }
    .time-inputs {
        display: flex;
        align-items: center;
        gap: 10px;
    }
    .table-abcent-list table {
        width: 100%;
        border-collapse: collapse;
    }
    .table-abcent-list tr {
        border-bottom: 1px solid #eee;
    }
    .table-abcent-list td {
        padding: 10px;
        vertical-align: middle;
    }
    .abcent-name {
        font-weight: bold;
        width: 30%;
    }
    .abcent-date {
        width: 25%;
    }
    .abcent-total {
        width: 25%;
    }
    .delete-last {
        width: 20%;
        text-align: right;
    }
    .delete-ico, .edit-ico {
        color: #dc3545;
        cursor: pointer;
        display: inline-block;
        padding: 5px;
    }
    .edit-ico {
        color: #0d6efd;
    }
    .delete-ico:hover {
        color: #c82333;
    }
    .edit-ico:hover {
        color: #0b5ed7;
    }
    .add-holiday-modal .modal-content {
        border-radius: 10px;
    }
    .add-holiday-modal .modal-header {
        border-bottom: 1px solid #dee2e6;
        padding: 1rem;
    }
    .add-holiday-modal .modal-body {
        padding: 1.5rem;
    }
    .new_in_business {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .new_in_business label.form-label {
        margin: 0;
    }
    .password-toggle {
        position: absolute;
        right: 10px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
    }
    .password-input-container {
        position: relative;
    }
    .profile-pic {
        position: relative;
        width: 150px;
        height: 150px;
        margin: 0 auto 20px;
    }
    .profile-pic .-label {
        cursor: pointer;
        position: absolute;
        bottom: 10px;
        right: 10px;
        width: 40px;
        height: 40px;
        background: #0d6efd;
        color: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 2;
    }
    .profile-img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 50%;
        border: 3px solid #f1f1f1;
    }
    .comn-input-select {
        margin-bottom: 15px;
    }
    .new_in_business {
        pointer-events: none;   /* disables clicking */
        cursor: not-allowed;    /* shows the "disabled" cursor */
    }
</style>

<div class="col-9 main-dash-left">
    <div class="upper-main-user-navigation">
        <div class="user-manage">
            <a href="<?php echo e(route('vendor.profile')); ?>"><?php echo e(__('messages.my_profile')); ?></a>
            <a class="active"><?php echo e(__('messages.edit_profile')); ?></a>
        </div>
    </div>
    
    <div class="add-user-form sora-font SPO-mang sora-font">
        <form class="validation row g-3" id="editForm" method="POST" action="<?php echo e(route('vendor.update.profile', $vendor)); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            
            <div class="col-md-12">
                <h4 class="mb-3"><?php echo e(__('messages.basic_information')); ?></h4>
            </div>
            
            <div class="col-md-12">
                <div class="profile-pic">
                    <label class="-label" for="file">
                        <span class="glyphicon glyphicon-camera"><i class="fas fa-camera"></i></span>
                    </label>
                    <input name="profile_image" type="file" id="file" accept="image/*" class="form-control" onchange="previewImage(event)">
                    <figure class="profile-img">
                        <img id="preview" src="<?php echo e($vendor->profile_image ? asset('storage/' . $vendor->profile_image) : ''); ?>" alt="">
                    </figure>
                    <div id="profile_image_error" class="error-message"></div>
                </div>
            </div>
            
            <div class="col-md-1">
                <div class="comn-input-select">
                    <label for="title" class="form-label"><?php echo e(__('messages.title')); ?></label>
                    <select id="title" class="form-select required" name="title" disabled>
                        <option value="Mr." <?php echo e($vendor->title == 'Mr.' ? 'selected' : ''); ?>><?php echo e(__('messages.title_mr')); ?></option>
                        <option value="Mrs." <?php echo e($vendor->title == 'Mrs.' ? 'selected' : ''); ?>><?php echo e(__('messages.title_mrs')); ?></option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-5">
                <div class="comn-input-select">
                    <label for="first_name" class="form-label"><?php echo e(__('messages.first_name')); ?>*</label>
                    <input type="text" disabled class="form-control required" placeholder="<?php echo e(__('messages.first_name')); ?>" id="first_name" name="first_name" value="<?php echo e(old('first_name', $vendor->first_name)); ?>">
                    <div id="first_name_error" class="error-message"></div>
                    <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="last_name" class="form-label"><?php echo e(__('messages.last_name')); ?>*</label>
                    <input type="text" disabled class="form-control required" placeholder="<?php echo e(__('messages.last_name')); ?>"  id="last_name" name="last_name" value="<?php echo e(old('last_name', $vendor->last_name)); ?>">
                    <div id="last_name_error" class="error-message"></div>
                    <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6 password-input-container">
                <div class="comn-input-select">
                    <label for="password" class="form-label"><?php echo e(__('messages.password')); ?></label>
                    <input type="password"  class="form-control" id="password" name="password"  autocomplete="new-password">
                    <i class="fas fa-eye password-toggle" onclick="togglePassword('password')"></i>
                    <div id="password_error" class="error-message"></div>
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6 password-input-container">
                <div class="comn-input-select">
                    <label for="password_confirmation" class="form-label"><?php echo e(__('messages.confirm_password')); ?></label>
                    <input type="password"  class="form-control" id="password_confirmation" name="password_confirmation" autocomplete="new-password">
                    <i class="fas fa-eye password-toggle" onclick="togglePassword('password_confirmation')"></i>
                    <div id="password_confirmation_error" class="error-message"></div>
                </div>
            </div>
            <medium class="text-muted"><?php echo e(__('messages.password_security_note')); ?></medium>

            
            <div class="col-md-12 mt-4">
                <h4 class="mb-3"><?php echo e(__('messages.contact_information')); ?></h4>
                </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="street" class="form-label"><?php echo e(__('messages.street')); ?>*</label>
                    <input type="text" disabled class="form-control required" id="street" name="street" value="<?php echo e(old('street', $vendor->street)); ?>">
                    <div id="street_error" class="error-message"></div>
                    <?php $__errorArgs = ['street'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="zip_code" class="form-label"><?php echo e(__('messages.zip_code')); ?>*</label>
                    <input type="text" disabled class="form-control required" id="zip_code" name="zip_code" value="<?php echo e(old('zip_code', $vendor->zip_code)); ?>">
                    <div id="zip_code_error" class="error-message"></div>
                    <?php $__errorArgs = ['zip_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="city" class="form-label"><?php echo e(__('messages.city')); ?>*</label>
                    <input type="text" disabled class="form-control required" id="city" name="city" value="<?php echo e(old('city', $vendor->city)); ?>">
                    <div id="city_error" class="error-message"></div>
                    <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="country" class="form-label"><?php echo e(__('messages.country')); ?>*</label>
                   

                    <select id="country" class="form-select required" name="country" disabled>
                        <option value=""><?php echo e(__('messages.choose_country')); ?></option>

                        <?php $__currentLoopData = __('messages.countries'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($label); ?>" <?php echo e(($vendor->country ?? '') === $label ? 'selected' : ''); ?>>
                                <?php echo e($label); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="email" class="form-label"><?php echo e(__('messages.email')); ?>*</label>
                    <input type="email" disabled class="form-control required" id="email" name="email" value="<?php echo e(old('email', $vendor->email)); ?>">
                    <div id="email_error" class="error-message"></div>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="phone" class="form-label"><?php echo e(__('messages.phone_number')); ?>*</label>
                    <div class="numer-input d-flex">
                        <select name="country_code" class="form-select country_code_custom required" id="country_code" disabled>
                            <option value="+49" data-image="https://flagcdn.com/16x12/de.png" <?php echo e($vendor->country_code == '+49' ? 'selected' : ''); ?>>+49</option>
                            <option value="+43" data-image="https://flagcdn.com/16x12/at.png" <?php echo e($vendor->country_code == '+43' ? 'selected' : ''); ?>>+43</option>
                            <option value="+41" data-image="https://flagcdn.com/16x12/ch.png" <?php echo e($vendor->country_code == '+41' ? 'selected' : ''); ?>>+41</option>
                        </select>
                        <input type="text" disabled class="form-control required" id="phone" name="number" placeholder="Phone number" value="<?php echo e(old('number', $vendor->number)); ?>">
                    </div>
                    <div id="phone_error" class="error-message"></div>
                    <?php $__errorArgs = ['number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-12 mt-4">
                <h4 class="mb-3"><?php echo e(__('messages.business_information')); ?></h4>
            </div>
            <div class="col-md-12">
                <div class="comn-input-select new_in_business">
                    <input class="form-check-input" 
                           type="checkbox" 
                           name="new_in_business" 
                           id="new_in_business"
                           value="1"
                           
                           <?php echo e(old('new_in_business', $vendor->new_in_business) ? 'checked' : ''); ?>>
                           <label for="new_in_business" class="form-label"><?php echo e(__('messages.are_you_new_in_business')); ?></label>
                        </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="business_type" class="form-label"><?php echo e(__('messages.business_type')); ?></label>
                     <select id="business_type" class="form-select required" name="business_type" disabled>
                        <option value="Own Location" <?php echo e($vendor->business_type == 'Own Location' ? 'selected' : ''); ?>><?php echo e(__('messages.business_own_location')); ?></option>
                        <option value="Franchiser" <?php echo e($vendor->business_type == 'Franchiser' ? 'selected' : ''); ?>><?php echo e(__('messages.business_franchiser')); ?></option>
                        <option value="Partner" <?php echo e($vendor->business_type == 'Partner' ? 'selected' : ''); ?>> <?php echo e(__('messages.business_partner')); ?></option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="business_model" class="form-label"><?php echo e(__('messages.business_model')); ?></label>
                    <select id="business_model" class="form-select required" name="business_model" disabled>
                        <option value="Fulltimer" <?php echo e($vendor->business_model == 'Fulltimer' ? 'selected' : ''); ?>><?php echo e(__('messages.fulltimer')); ?></option>
                        <option value="Side Business" <?php echo e($vendor->business_model == 'Side Business' ? 'selected' : ''); ?>><?php echo e(__('messages.side_business')); ?></option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="contact_person" class="form-label"><?php echo e(__('messages.name_of_contract_type')); ?></label>
                     <select id="contact_person" class="form-select required" name="contact_person" disabled>
                        <option value="Franchiser" <?php echo e($vendor->contact_person == 'Franchiser' ? 'selected' : ''); ?>><?php echo e(__('messages.contact_franchiser')); ?></option>
                        <option value="Partner" <?php echo e($vendor->contact_person == 'Partner' ? 'selected' : ''); ?>><?php echo e(__('messages.contact_partner')); ?></option>
                        <option value="Test Location" <?php echo e($vendor->contact_person == 'Test Location' ? 'selected' : ''); ?>><?php echo e(__('messages.contact_test_location')); ?></option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="size_of_location" class="form-label"><?php echo e(__('messages.size_of_location')); ?></label>
                    <select id="size_of_location" disabled class="form-select required" name="size_of_location">
                        <option value="Beginner" <?php echo e($vendor->size_of_location == 'Beginner' ? 'selected' : ''); ?>><?php echo e(__('messages.beginner')); ?></option>
                        <option value="Small (< 5)" <?php echo e($vendor->size_of_location == 'Small (< 5)' ? 'selected' : ''); ?>><?php echo e(__('messages.small_business')); ?></option>
                        <option value="Middle (6 - 15)" <?php echo e($vendor->size_of_location == 'Middle (6 - 15)' ? 'selected' : ''); ?>><?php echo e(__('messages.middle_business')); ?></option>
                        <option value="Large (16-35)" <?php echo e($vendor->size_of_location == 'Large (16-35)' ? 'selected' : ''); ?>><?php echo e(__('messages.large_business')); ?></option>
                        <option value="XXL (>30)" <?php echo e($vendor->size_of_location == 'XXL (>30)' ? 'selected' : ''); ?>><?php echo e(__('messages.xxl_business')); ?></option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-12 mt-4">
                <h4 class="mb-3"><?php echo e(__('messages.tax_banking_information')); ?></h4>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="tax_number" class="form-label"><?php echo e(__('messages.edit_tax_number')); ?></label>
                    <input type="text" disabled class="form-control required" id="tax_number" name="tax_number"   
                    placeholder="Tax Number"  value="<?php echo e(old('tax_number', $vendor->tax_number)); ?>">
                    <div id="tax_number_error" class="error-message"></div>
                    <?php $__errorArgs = ['tax_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="tax_id" class="form-label"><?php echo e(__('messages.tax_id_vat')); ?></label>
                    <input type="text" disabled class="form-control required" id="tax_id" name="tax_id"   
                    placeholder="Tax ID / VAT ID" value="<?php echo e(old('tax_id', $vendor->tax_id)); ?>">
                    <div id="tax_id_error" class="error-message"></div>
                    <?php $__errorArgs = ['tax_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="bank_name" class="form-label"><?php echo e(__('messages.edit_bank_name')); ?></label>
                    <input type="text" disabled class="form-control required" id="bank_name" name="bank_name" value="<?php echo e(old('bank_name', $vendor->bank_name)); ?>">
                    <div id="bank_name_error" class="error-message"></div>
                    <?php $__errorArgs = ['bank_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="account_owner" class="form-label"><?php echo e(__('messages.edit_bank_account_owner')); ?></label>
                    <input type="text" disabled class="form-control required" id="account_owner" name="account_owner" value="<?php echo e(old('account_owner', $vendor->account_owner)); ?>">
                    <div id="account_owner_error" class="error-message"></div>
                    <?php $__errorArgs = ['account_owner'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="account_number" class="form-label"><?php echo e(__('messages.edit_bank_account_number')); ?></label>
                    <input type="text" disabled class="form-control required" id="account_number" name="account_number" value="<?php echo e(old('account_number', $vendor->account_number)); ?>">
                    <div id="account_number_error" class="error-message"></div>
                    <?php $__errorArgs = ['account_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="bic_number" class="form-label"><?php echo e(__('messages.edit_bic_number')); ?></label>
                    <input type="text" disabled class="form-control required" id="bic_number" name="bic_number" value="<?php echo e(old('bic_number', $vendor->bic_number)); ?>">
                    <div id="bic_number_error" class="error-message"></div>
                    <?php $__errorArgs = ['bic_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="comn-input-select">
                    <label for="iban_number" class="form-label"><?php echo e(__('messages.edit_iban_number')); ?></label>
                    <input type="text" disabled class="form-control required" id="iban_number"  
                    placeholder="IBAN Number"  name="iban_number" value="<?php echo e(old('iban_number', $vendor->iban_number)); ?>">
                    <div id="iban_number_error" class="error-message"></div>
                    <?php $__errorArgs = ['iban_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="backend-error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div class="col-md-12 mt-4">
                <h4 class="mb-3"><?php echo e(__('messages.working_hours')); ?></h4>
            </div>
            
            <?php
                  $days = [
                    'mo' => __('messages.monday'), 
                    'di' => __('messages.tuesday'), 
                    'mi' => __('messages.wednesday'),
                    'do' => __('messages.thursday'), 
                    'fr' => __('messages.friday'), 
                    'sa' => __('messages.saturday'), 
                    'so' => __('messages.sunday')
                ];
            ?>
            
            <?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $short => $full): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-12 day-row">
                <div class="d-flex align-items-center gap-3">
                    <div class="form-check">
                        <label class="form-check-label" for="closed_<?php echo e($short); ?>">
                            <?php echo e($full); ?>

                        </label>
                    </div>
                    
                    <?php
                        $workingHour = $vendor->workingHours->where('day', $short)->first();
                        $isClosed = $workingHour ? $workingHour->is_closed : false;
                        $openTime = ($workingHour && $workingHour->open_time && !$isClosed) ? \Carbon\Carbon::parse($workingHour->open_time)->format('H:i') : '';
                        $closeTime = ($workingHour && $workingHour->close_time && !$isClosed) ? \Carbon\Carbon::parse($workingHour->close_time)->format('H:i') : '';
                    ?>
                    
                    <div class="time-inputs">
                        <input type="time" class="form-control <?php echo e($short); ?>_from" name="<?php echo e($short); ?>_from" 
                            value="<?php echo e($openTime); ?>"
                            <?php echo e($isClosed ? 'disabled' : ''); ?>>
<span style="margin: 0 10px;"><?php echo e(__('messages.to')); ?></span>
                        <input type="time" class="form-control <?php echo e($short); ?>_to" name="<?php echo e($short); ?>_to" 
                            value="<?php echo e($closeTime); ?>"
                            <?php echo e($isClosed ? 'disabled' : ''); ?>>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input day-closed" type="checkbox" name="days_closed[]" 
                            value="<?php echo e($short); ?>" id="closed_<?php echo e($short); ?>" <?php echo e($isClosed ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="closed_<?php echo e($short); ?>">
                            <?php echo e(__('messages.closed')); ?>

                        </label>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            <div class="col-md-12 mt-4">
                <h4 class="mb-3"><?php echo e(__('messages.holidays_absent_days')); ?></h4>
                
                <div class="abcent-days">
                    <div class="head-abcent-days">
                        <button class="add-notification-btn" type="button" data-bs-toggle="modal"
                        data-bs-target="#holidayModal"><?php echo e(__('messages.add_holiday')); ?></button>
                    </div>
                    
                    <div class="table-abcent-list">
                        <table id="holidaysTable">
                            <?php if($vendor->holidays->count() > 0): ?>
                                <?php $__currentLoopData = $vendor->holidays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $holiday): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr data-id="<?php echo e($holiday->id); ?>">
                                    <td class="abcent-name"><?php echo e($holiday->name); ?></td>
                                    <td class="abcent-date" data-date="<?php echo e(\Carbon\Carbon::parse($holiday->date)->format('Y-m-d')); ?>">
                                        <?php echo e(\Carbon\Carbon::parse($holiday->date)->format('d.m.Y')); ?>

                                    </td>
                                    <td class="abcent-total">
                                        <?php
                                            $today = \Carbon\Carbon::today();
                                            $daysLeft = $today->diffInDays($holiday->date, false);
                                        ?>
                                        <?php if($daysLeft > 0): ?>
                                        <?php echo e(__('messages.in_days', ['days' => $daysLeft])); ?>

                                        <?php elseif($daysLeft === 0): ?>
                                        <?php echo e(__('messages.today')); ?>


                                        <?php else: ?>
                                        <?php echo e(__('messages.days_ago', ['days' => abs($daysLeft)])); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td class="delete-last">
                                        <div class="edit-ico" data-id="<?php echo e($holiday->id); ?>">
                                            <i class="fas fa-edit" data-id="<?php echo e($holiday->id); ?>"></i>
                                        </div>
                                        <div class="delete-ico" data-id="<?php echo e($holiday->id); ?>">
                                            <i class="fa-solid fa-trash" data-id="<?php echo e($holiday->id); ?>"></i>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr id="noHolidaysRow">
                                    <td colspan="4" class="text-center"><?php echo e(__('messages.no_holidays_available')); ?></td>
                                </tr>
                            <?php endif; ?>
                        </table>
                    </div>
                </div>
            </div>
            
            <div class="col-12 mt-4">
                <div class="upper-main-btn-last-comn d-flex">
                    <button type="submit" class="add-user"><?php echo e(__('messages.update_profile')); ?></button>
                    <button type="button" class="cancel-btn" onclick="window.location.href='<?php echo e(route('vendor.profile')); ?>'"><?php echo e(__('messages.cancel')); ?></button>

                </div>
            </div>
        </form>
    </div>
</div>

<!-- Holiday Modal -->
<div class="modal add-holiday-modal fade" id="holidayModal" tabindex="-1" aria-labelledby="holidayModalLabel"
    aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title" id="holidayModalLabel"><?php echo e(__('messages.add_holiday')); ?></h1>
            </div>
            <div class="modal-body">
                <form id="holidayForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" id="edit_holiday_id" value="">
                    <div class="mb-3 comn-input-select">
                        <label for="holiday_name" class="col-form-label"><?php echo e(__('messages.holiday_name')); ?></label>
                        <input type="text" class="form-control" id="holiday_name" name="holiday_name">
                        <div id="holiday_name_error" class="error-message"></div>
                    </div>
                    <div class="mb-3 comn-input-select">
                        <label for="holiday_date" class="col-form-label"><?php echo e(__('messages.date')); ?></label>
                        <input class="form-control" id="holiday_date" type="date" name="holiday_date">
                        <div id="holiday_date_error" class="error-message"></div>
                    </div>
                  
                    <div class="upper-main-btn-last-comn d-flex">
                        <button type="button" class="cancel-btn" data-bs-dismiss="modal"><?php echo e(__('messages.cancel')); ?></button>
                        <button type="button" class="add-user" id="saveHoliday"><?php echo e(__('messages.save')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php
    use Carbon\Carbon;
?>


<script>
    console.log('Script loaded successfully');

// Test jQuery
$(document).ready(function() {
    console.log('jQuery is working');
    
    // Test form selection
   
   
   
});

    const IBAN_PATTERNS = {
        "Germany": /^DE\d{20}$/,
        "Austria": /^AT\d{18}$/,
        "Switzerland": /^CH\d{19}$/
    };

    // Tax Number Patterns
    const TAX_NUMBER_PATTERNS = {
        "Germany": /^[\d\/]{10,11}$/,
        "Austria": /^\d{8,10}$/,
        "Switzerland": /^[\d\/\.]{7,12}$/
    };

    // VAT Number Patterns
    const VAT_NUMBER_PATTERNS = {
        "Austria": /^ATU\d{8}$/,
        "Switzerland": /^CHE-\d{3}\.\d{3}\.\d{3}( MWST)?$/
    };

    // Tax ID Pattern (Germany only)
    const TAX_ID_PATTERN = /^[A-Za-z0-9]{11}$/;


    function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function () {
        $('#country_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });

        // Initialize holidays array with existing holidays
        let holidays = <?php echo json_encode($vendor->holidays->map(function($item) {
            return [
                'id' => $item->id,
                'name' => $item->name,
                'date' => \Carbon\Carbon::parse($item->date)->format('Y-m-d'),
                'new' => 0
            ];
        })); ?>;

        var form = $('#editForm');
    console.log('Form element:', form);
    console.log('Form length:', form.length);

    form.on('submit', function(e) {
        e.preventDefault();

        let isValid = true;
        console.log(isValid)
        $('.required').each(function() {
            const fieldId = $(this).attr('id');
            const errorElement = $(`#${fieldId}_error`);
            
            if ($(this).val().trim() === '') {
                $(this).addClass('is-invalid');
                errorElement.text(`Please enter ${$(this).attr('placeholder') || fieldId.replace('_', ' ')}`);
                isValid = false;
            }
        });

        if ($('#password').val() && $('#password').val() !== $('#password_confirmation').val()) {
            $('#password_confirmation').addClass('is-invalid');
            $('#password_confirmation_error').text("<?php echo e(__('messages.passwords_do_not_match')); ?>");
            isValid = false;
        }

        if ($('#password').val() && $('#password').val().length < 8) {
            $('#password').addClass('is-invalid');
            $('#password_error').text("<?php echo e(__('messages.password_min_length')); ?>");
            isValid = false;
        }

       



        // const country = $('#country').val();
        // const iban = $('#iban_number').val().replace(/\s+/g, '').toUpperCase();
        // if (iban) {
        //     if (!IBAN_PATTERNS[country].test(iban)) {
        //         $('#iban_number').addClass('is-invalid');
        //         $('#iban_number_error').text(
        //             `${country} IBAN must start with ${country === "Germany" ? "DE" : (country === "Austria" ? "AT" : "CH")} and be ${country === "Germany" ? "22" : (country === "Austria" ? "20" : "21")} characters long`
        //         );
        //         isValid = false;
        //     }
        // }
        // const taxNumber = $('#tax_number').val().replace(/\s+/g, '');
        // if (taxNumber && TAX_NUMBER_PATTERNS[country] && !TAX_NUMBER_PATTERNS[country].test(taxNumber)) {
        //     $('#tax_number').addClass('is-invalid');
        //     $('#tax_number_error').text(
        //         `${country} tax number format is invalid.`
        //     );
        //     isValid = false;
        // }
        // if (country === "Austria" || country === "Switzerland") {
        //     const vatField = $('#tax_id');
        //     const vatValue = vatField.val().replace(/\s+/g, '').toUpperCase();
        //     if (vatValue && !VAT_NUMBER_PATTERNS[country].test(vatValue)) {
        //         vatField.addClass('is-invalid');
        //         $('#tax_id_error').text(
        //             `${country} VAT ID format is invalid (${country === "Austria" ? "Example: ATU12345678" : "Example: CHE-123.456.789 MWST"})`
        //         );
        //         isValid = false;
        //     }
        // }

        // if (country === "Germany") {
        //     const taxIdField = $('#tax_id');
        //     const taxIdValue = taxIdField.val().replace(/\s+/g, '');
        //     if (taxIdValue && !TAX_ID_PATTERN.test(taxIdValue)) {
        //         taxIdField.addClass('is-invalid');
        //         $('#tax_id_error').text('Tax ID must be exactly 11 digits (Germany)');
        //         isValid = false;
        //     }
        // }


        // if ($('#tax_id').val().length !== 11) {
        //     $('#tax_id').addClass('is-invalid');
        //     $('#tax_id_error').text('Tax ID must be exactly 11 characters');
        //     isValid = false;
        // }

        if (!isValid) {
            $('html, body').animate({
                scrollTop: $('.is-invalid').first().offset().top - 100
            }, 500);
        } else {
            // Add hidden inputs for holidays
            holidays.forEach((holiday, index) => {
                $(this).append(
                    `<input type="hidden" name="holidays[${index}][id]" value="${holiday.id}">` +
                    `<input type="hidden" name="holidays[${index}][name]" value="${holiday.name}">` +
                    `<input type="hidden" name="holidays[${index}][date]" value="${holiday.date}">`+
                    `<input type="hidden" name="holidays[${index}][new]" value="${holiday.new}">`
                );
            });
            this.submit();
        }
        });
    
        
        let editingHolidayId = null;

        $('.day-closed').change(function() {
            const dayPrefix = $(this).val();
            const isClosed = $(this).is(':checked');
            
            $(`.${dayPrefix}_from, .${dayPrefix}_to`).prop('disabled', isClosed);
            
            if (isClosed) {
                $(`.${dayPrefix}_from, .${dayPrefix}_to`).val('');
            }
        });

        $('#holidayModal').on('hidden.bs.modal', function() {
            $('#holidayForm')[0].reset();
            $('#edit_holiday_id').val('');
            editingHolidayId = null;
            clearHolidayErrors();
        });

        $(document).ready(function () {
            function validatePasswords() {
                const password = $('#password').val();
                const confirmPassword = $('#password_confirmation').val();

                if (password && confirmPassword && password !== confirmPassword) {
                    $('#password_confirmation').addClass('is-invalid');
                    $('#password_confirmation_error').text("<?php echo e(__('messages.passwords_do_not_match')); ?>");
                } else {
                    $('#password_confirmation').removeClass('is-invalid');
                    $('#password_confirmation_error').text('');
                }
            }

            // Run validation on input in both fields
            $('#password, #password_confirmation').on('input', validatePasswords);
        });

        $('#saveHoliday').click(function() {
            const holidayName = $('#holiday_name').val();
            const holidayDate = $('#holiday_date').val();
            
            clearHolidayErrors();
            
            if (!holidayName) {
                $('#holiday_name_error').text("<?php echo e(__('messages.please_enter_holiday_name')); ?>");
                return;
            }
            
            if (!holidayDate) {
                $('#holiday_date_error').text("<?php echo e(__('messages.please_select_holiday_date')); ?>");
                return;
            }

            if (editingHolidayId) {
                const index = holidays.findIndex(h => h.id == editingHolidayId);
                if (index !== -1) {
                    holidays[index] = {
                        id: editingHolidayId,
                        name: holidayName,
                        date: holidayDate,
                        new: 0 // Not new, it's an update
                    };
                }
            } else {
                holidays.push({
                    id: Date.now(), // Generate a temporary ID
                    name: holidayName,
                    date: holidayDate,
                    new: 1 // Mark as new
                });
            }

            updateHolidaysTable();
            $('#holidayModal').modal('hide');
        });

        $(document).on('click', '.delete-ico', function() {
            const holidayId = parseInt($(this).data('id'));
            holidays = holidays.filter(h => h.id !== holidayId);
            updateHolidaysTable();
        });
        
        $(document).on('click', '.edit-ico', function() {
            const holidayId = parseInt($(this).data('id'));
            const holiday = holidays.find(h => h.id === holidayId);
            
            if (holiday) {
                editingHolidayId = holidayId;
                $('#edit_holiday_id').val(holidayId);
                $('#holiday_name').val(holiday.name);
                $('#holiday_date').val(holiday.date);
                $('#holidayModalLabel').text('Edit Holiday');
                $('#holidayModal').modal('show');
            }
        });
        const lang_in_days = "<?php echo e(__('messages.in_days', ['days' => ':days'])); ?>";
        const lang_today = "<?php echo e(__('messages.today')); ?>";
        const lang_days_ago = "<?php echo e(__('messages.days_ago', ['days' => ':days'])); ?>";

        function updateHolidaysTable() {
            const table = $('#holidaysTable');
            const noHolidaysRow = $('#noHolidaysRow');
            
            table.find('tr:not(#noHolidaysRow)').remove();
            
            if (holidays.length === 0) {
                if (noHolidaysRow.length === 0) {
                    table.append('<tr id="noHolidaysRow"><td colspan="4" class="text-center"><?php echo e(__("messages.no_holidays_available")); ?></td></tr>');
                } else {
                    noHolidaysRow.show();
                }
                return;
            }
            
            noHolidaysRow.hide();

            holidays.sort((a, b) => new Date(a.date) - new Date(b.date));
            
            holidays.forEach(holiday => {
                const today = new Date();
                today.setHours(0, 0, 0, 0);
                
                const holidayDate = new Date(holiday.date + 'T00:00:00');
                holidayDate.setHours(0, 0, 0, 0);
                
                const timeDiff = holidayDate - today;
                const daysLeft = Math.ceil(timeDiff / (1000 * 60 * 60 * 24));
                
                const daysLeftText =
                    daysLeft > 0
                        ? lang_in_days.replace(':days', daysLeft)
                        : daysLeft === 0
                            ? lang_today
                            : lang_days_ago.replace(':days', Math.abs(daysLeft));
                              
                
                const formattedDate = holidayDate.toLocaleDateString('de-DE', {
                    day: '2-digit',
                    month: '2-digit',
                    year: 'numeric'
                }).replace(/\//g, '.');
                
                const row = $(`
                    <tr data-id="${holiday.id}">
                        <td class="abcent-name">${holiday.name}</td>
                        <td class="abcent-date" data-date="${holiday.date}">${formattedDate}</td>
                        <td class="abcent-total">${daysLeftText}</td>
                        <td class="delete-last">
                            <div class="edit-ico" data-id="${holiday.id}">
                                <i class="fas fa-edit" data-id="${holiday.id}"></i>
                            </div>
                            <div class="delete-ico" data-id="${holiday.id}">
                                <i class="fa-solid fa-trash" data-id="${holiday.id}"></i>
                            </div>
                        </td>
                    </tr>
                `);
                
                table.append(row);
            });
            
            
        }

        function clearHolidayErrors() {
            $('#holiday_name_error').text('');
            $('#holiday_date_error').text('');
        }

        if (typeof jQuery === 'undefined') {
            console.error('jQuery is not loaded!');
        } else {
            console.log('jQuery version:', jQuery.fn.jquery);
        }


 
        updateHolidaysTable();
    });

    function togglePassword(fieldId) {
        const field = document.getElementById(fieldId);
        const icon = field.nextElementSibling;
        
        if (field.type === 'password') {
            field.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            field.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    }

    function previewImage(event) {
        const input = event.target;
        const file = input.files[0];
        const preview = document.getElementById('preview');
        
        if (file) {
            const validTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp', 'image/jpg'];
            
            if (!validTypes.includes(file.type)) {
                $('#profile_image_error').text('Please select a valid image file (jpg, jpeg, png, gif, webp)');
                input.value = '';
                preview.src = "<?php echo e($vendor->profile_image ? asset('storage/' . $vendor->profile_image) : asset('admin/images/profile.png')); ?>";
                return;
            }
            
            $('#profile_image_error').text('');
            const reader = new FileReader();
            reader.onload = function(e) {
                preview.src = e.target.result;
            };
            reader.readAsDataURL(file);
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/dachboxmiete-phase-2/resources/views/vendor/auth/editProfile.blade.php ENDPATH**/ ?>